/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sf.gogui.go.InvalidKomiException;

public final class Komi {
    private final double m_value;

    public Komi(double komi) {
        this.m_value = komi;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Komi komi = (Komi)object;
        return komi.m_value == this.m_value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.m_value);
        return (int)(v ^ v >>> 32);
    }

    public boolean isMultipleOf(double multiple) {
        return Math.IEEEremainder(this.m_value, multiple) == 0.0;
    }

    public static Komi parseKomi(String s) throws InvalidKomiException {
        assert (s != null);
        if (s.trim().equals("")) {
            return null;
        }
        try {
            double komi = Double.parseDouble(s.replace(',', '.'));
            return new Komi(komi);
        }
        catch (NumberFormatException e) {
            throw new InvalidKomiException(s);
        }
    }

    public double toDouble() {
        return this.m_value;
    }

    public static String toString(Komi komi) {
        if (komi == null) {
            return "0";
        }
        return komi.toString();
    }

    public String toString() {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);
        format.setGroupingUsed(false);
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(this.m_value);
    }
}

