/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

public class Statistics {
    private int m_count;
    private double m_max = Double.NEGATIVE_INFINITY;
    private double m_min = Double.POSITIVE_INFINITY;
    private double m_sum;
    private double m_sumSq;

    public void add(double value) {
        this.m_min = Math.min(value, this.m_min);
        this.m_max = Math.max(value, this.m_max);
        this.m_sum += value;
        this.m_sumSq += value * value;
        ++this.m_count;
    }

    public int getCount() {
        return this.m_count;
    }

    public double getDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getError() {
        if (this.m_count == 0) {
            return 0.0;
        }
        return this.getDeviation() / Math.sqrt(this.m_count);
    }

    public double getMean() {
        if (this.m_count == 0) {
            return 0.0;
        }
        return this.m_sum / (double)this.m_count;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getMaxError(int n) {
        if (this.m_count == 0) {
            return 0.0;
        }
        return this.getDeviation() / Math.sqrt((double)this.m_count / (double)n);
    }

    public double getMin() {
        return this.m_min;
    }

    public double getSum() {
        return this.m_sum;
    }

    public double getVariance() {
        if (this.m_count == 0) {
            return 0.0;
        }
        double mean = this.getMean();
        return this.m_sumSq / (double)this.m_count - mean * mean;
    }
}

