/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.util.ArrayList;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;

public class BoardUpdater {
    private final ArrayList<ConstNode> m_nodes = new ArrayList(400);

    public void update(ConstGameTree tree, ConstNode currentNode, Board board) {
        board.init(tree.getBoardSize());
        int handicap = tree.getGameInfoConst(currentNode).getHandicap();
        NodeUtil.getPathToRoot(currentNode, this.m_nodes);
        int nuMoves = 0;
        boolean isFirstPlacement = true;
        boolean isHandicapSetupDone = false;
        boolean isInInitialBlackMoveSequence = true;
        for (int i = this.m_nodes.size() - 1; i >= 0; --i) {
            ConstNode node = this.m_nodes.get(i);
            GoColor player = node.getPlayer();
            if (node.hasSetup()) {
                ConstPointList setupBlack = node.getSetup(GoColor.BLACK);
                ConstPointList setupWhite = node.getSetup(GoColor.WHITE);
                ConstPointList setupEmpty = node.getSetup(GoColor.EMPTY);
                if (handicap > 0 && isFirstPlacement && setupBlack.size() == handicap && setupWhite.isEmpty() && setupEmpty.isEmpty()) {
                    board.setupHandicap(setupBlack);
                    isHandicapSetupDone = true;
                } else {
                    this.newSetup(board, setupBlack, setupWhite, setupEmpty, player);
                }
                isFirstPlacement = false;
                isInInitialBlackMoveSequence = false;
            } else if (player != null) {
                board.setToMove(player);
            }
            Move move = node.getMove();
            if (move == null) continue;
            board.play(move);
            ++nuMoves;
            isFirstPlacement = false;
            if (move.getColor() != GoColor.BLACK) {
                isInInitialBlackMoveSequence = false;
            }
            if (handicap <= 0 || isHandicapSetupDone || !isInInitialBlackMoveSequence || nuMoves != handicap) continue;
            this.setupMovesAsHandicap(board);
            isHandicapSetupDone = true;
        }
    }

    private void newSetup(Board board, ConstPointList setupBlack, ConstPointList setupWhite, ConstPointList setupEmpty, GoColor player) {
        PointList black = new PointList();
        PointList white = new PointList();
        for (GoPoint p : board) {
            GoColor c = board.getColor(p);
            if (c == GoColor.BLACK) {
                black.add(p);
                continue;
            }
            if (c != GoColor.WHITE) continue;
            white.add(p);
        }
        for (GoPoint p : setupBlack) {
            white.remove(p);
            if (black.contains(p)) continue;
            black.add(p);
        }
        for (GoPoint p : setupWhite) {
            black.remove(p);
            if (white.contains(p)) continue;
            white.add(p);
        }
        for (GoPoint p : setupEmpty) {
            black.remove(p);
            white.remove(p);
        }
        board.setup(black, white, player);
    }

    void setupMovesAsHandicap(Board board) {
        PointList black = new PointList();
        for (GoPoint p : board) {
            GoColor c = board.getColor(p);
            assert (c != GoColor.WHITE);
            if (c != GoColor.BLACK) continue;
            black.add(p);
        }
        board.setupHandicap(black);
    }
}

