/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.sgf;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.SgfProperties;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.sgf.SgfUtil;
import net.sf.gogui.util.StringUtil;

public class SgfWriter {
    public static final String ENCODING = "UTF-8";
    private static final int STRINGBUF_CAPACITY = 128;
    private static final int MAX_CHARS_PER_LINE = 78;
    private final StringBuilder m_buffer;
    private final int m_size;
    private PrintStream m_out;

    public SgfWriter(OutputStream out, ConstGameTree tree, String application, String version) {
        block2: {
            this.m_buffer = new StringBuilder(128);
            try {
                this.m_out = new PrintStream(out, false, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.print("(");
        this.m_size = tree.getBoardSize();
        this.printHeader(application, version);
        this.printNewLine();
        this.printNode(tree.getRootConst(), true);
        this.print(")");
        this.m_out.println(this.m_buffer.toString());
        this.m_out.close();
    }

    public SgfWriter(OutputStream out, ConstBoard board, String application, String version) {
        this.m_buffer = new StringBuilder(128);
        this.m_size = board.getSize();
        this.m_out = new PrintStream(out);
        this.print("(");
        this.printHeader(application, version);
        this.printNewLine();
        this.printPosition(board);
        this.print(")");
        this.m_out.println(this.m_buffer.toString());
        this.m_out.close();
    }

    private String getEscaped(String text) {
        return this.getEscaped(text, false);
    }

    private String getEscaped(String text, boolean escapeColon) {
        StringBuilder result = new StringBuilder(2 * text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c;
            String specialCharacters = escapeColon ? "]:\\" : "]\\";
            if (specialCharacters.indexOf(c = text.charAt(i)) >= 0) {
                result.append('\\');
                result.append(c);
                continue;
            }
            if (c != '\n' && Character.isWhitespace(c)) {
                result.append(' ');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static int getMoveNumberInVariation(ConstNode node) {
        int moveNumber = 0;
        while (node != null) {
            if (node.getMove() != null) {
                ++moveNumber;
            }
            if ((node = node.getFatherConst()) == null || node.getNumberChildren() <= 1) continue;
            break;
        }
        return moveNumber;
    }

    private String getPoint(GoPoint p) {
        if (p == null) {
            return "";
        }
        int x = 97 + p.getX();
        int y = 97 + (this.m_size - p.getY() - 1);
        return "" + (char)x + (char)y;
    }

    private String getPointValue(GoPoint point) {
        return "[" + this.getPoint(point) + "]";
    }

    private String getPointList(ConstPointList v) {
        StringBuilder buffer = new StringBuilder(128);
        for (int i = 0; i < v.size(); ++i) {
            buffer.append(this.getPointValue(v.get(i)));
        }
        return buffer.toString();
    }

    private boolean hasByoyomiInformation(ConstNode node) {
        ConstGameInfo info = node.getGameInfoConst();
        if (info == null) {
            return false;
        }
        TimeSettings settings = info.getTimeSettings();
        return settings != null && settings.getUseByoyomi();
    }

    private void print(String text) {
        if (text.indexOf(10) > 0) {
            this.printNewLine();
            this.m_buffer.append(text);
            this.printNewLine();
            return;
        }
        if (this.m_buffer.length() + text.length() > 78) {
            this.printNewLine();
        }
        this.m_buffer.append(text);
    }

    private void printNewLine() {
        if (this.m_buffer.length() > 0) {
            this.m_out.println(this.m_buffer.toString());
            this.m_buffer.replace(0, this.m_buffer.length(), "");
        }
    }

    private void printHeader(String application, String version) {
        StringBuilder header = new StringBuilder(128);
        header.append(";FF[4]CA[");
        header.append(this.getEscaped(ENCODING));
        header.append(']');
        if (application != null && !application.equals("")) {
            String appName = application;
            if (version != null && !version.equals("")) {
                appName = appName + ":" + version;
            }
            header.append("AP[");
            header.append(this.getEscaped(appName));
            header.append(']');
        }
        if (this.m_size != 19) {
            header.append("SZ[");
            header.append(this.m_size);
            header.append(']');
        }
        this.print(header.toString());
    }

    private void printGameInfo(ConstGameInfo info) {
        TimeSettings timeSettings;
        int handicap = info.getHandicap();
        Komi komi = info.getKomi();
        if (handicap > 0) {
            this.print("HA[" + handicap + "]");
        }
        if (!(komi == null || handicap > 0 && komi.equals(new Komi(0.0)))) {
            this.print("KM[" + komi + "]");
        }
        if ((timeSettings = info.getTimeSettings()) != null) {
            this.print("TM[" + timeSettings.getPreByoyomi() / 1000L + "]");
            String overtime = SgfUtil.getOvertime(timeSettings);
            if (overtime != null) {
                this.print("OT[" + overtime + "]");
            }
        }
        this.printInfo("PB", info.get(StringInfoColor.NAME, GoColor.BLACK));
        this.printInfo("PW", info.get(StringInfoColor.NAME, GoColor.WHITE));
        this.printInfo("BR", info.get(StringInfoColor.RANK, GoColor.BLACK));
        this.printInfo("WR", info.get(StringInfoColor.RANK, GoColor.WHITE));
        this.printInfo("BT", info.get(StringInfoColor.TEAM, GoColor.BLACK));
        this.printInfo("WT", info.get(StringInfoColor.TEAM, GoColor.WHITE));
        this.printInfo("DT", info.get(StringInfo.DATE));
        this.printInfo("RE", info.get(StringInfo.RESULT));
        this.printInfo("RU", info.get(StringInfo.RULES));
        this.printInfo("US", info.get(StringInfo.USER));
        this.printInfo("CP", info.get(StringInfo.COPYRIGHT));
        this.printInfo("AN", info.get(StringInfo.ANNOTATION));
        this.printInfo("RO", info.get(StringInfo.ROUND));
        this.printInfo("SO", info.get(StringInfo.SOURCE));
        this.printNewLine();
    }

    private void printInfo(String label, String value) {
        if (value == null || value.equals("")) {
            return;
        }
        this.print(label + "[" + this.getEscaped(value) + "]");
    }

    private void printLabels(ConstNode node) {
        Map<GoPoint, String> labels = node.getLabelsUnmodifiable();
        if (labels == null || labels.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("LB");
        for (Map.Entry<GoPoint, String> entry : labels.entrySet()) {
            GoPoint point = entry.getKey();
            String value = entry.getValue();
            buffer.append('[');
            buffer.append(this.getPoint(point));
            buffer.append(':');
            buffer.append(this.getEscaped(value, true));
            buffer.append(']');
        }
        this.print(buffer.toString());
    }

    private void printMarked(ConstNode node, String property, MarkType type) {
        ConstPointList marked = node.getMarkedConst(type);
        if (marked != null && !marked.isEmpty()) {
            this.print(property + this.getPointList(marked));
        }
    }

    private void printNode(ConstNode node, boolean isRoot) {
        int numberChildren;
        SgfProperties sgfProps;
        ConstGameInfo info;
        Move move = node.getMove();
        if (!isRoot) {
            int moveNumber;
            if (move != null && (moveNumber = SgfWriter.getMoveNumberInVariation(node)) != 1 && moveNumber % 10 == 1) {
                this.printNewLine();
            }
            this.print(";");
        }
        if ((info = node.getGameInfoConst()) != null) {
            this.printGameInfo(info);
        }
        if (move != null) {
            String point = this.getPointValue(move.getPoint());
            if (move.getColor() == GoColor.BLACK) {
                this.print("B" + point);
            } else {
                this.print("W" + point);
            }
        }
        for (GoColor c : GoColor.BLACK_WHITE_EMPTY) {
            ConstPointList points = node.getSetup(c);
            if (points.size() == 0) continue;
            StringBuilder buffer = new StringBuilder(128);
            if (c == GoColor.BLACK) {
                buffer.append("AB");
            } else if (c == GoColor.WHITE) {
                buffer.append("AW");
            } else {
                buffer.append("AE");
            }
            for (GoPoint p : points) {
                buffer.append(this.getPointValue(p));
            }
            this.print(buffer.toString());
        }
        String comment = node.getComment();
        if (!StringUtil.isEmpty(comment)) {
            this.print("C[" + this.getEscaped(comment) + "]");
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.BLACK))) {
            this.print("BL[" + node.getTimeLeft(GoColor.BLACK) + "]");
        }
        if (node.getMovesLeft(GoColor.BLACK) >= 0) {
            this.print("OB[" + node.getMovesLeft(GoColor.BLACK) + "]");
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.WHITE))) {
            this.print("WL[" + node.getTimeLeft(GoColor.WHITE) + "]");
        }
        if (node.getMovesLeft(GoColor.WHITE) >= 0) {
            this.print("OW[" + node.getMovesLeft(GoColor.WHITE) + "]");
        }
        if (node.getPlayer() != null) {
            this.printToPlay(node.getPlayer());
        }
        this.printMarked(node, "MA", MarkType.MARK);
        this.printMarked(node, "CR", MarkType.CIRCLE);
        this.printMarked(node, "SQ", MarkType.SQUARE);
        this.printMarked(node, "TR", MarkType.TRIANGLE);
        this.printMarked(node, "SL", MarkType.SELECT);
        this.printMarked(node, "TB", MarkType.TERRITORY_BLACK);
        this.printMarked(node, "TW", MarkType.TERRITORY_WHITE);
        this.printLabels(node);
        if (!Double.isNaN(node.getValue())) {
            this.print("V[" + node.getValue() + "]");
        }
        if ((sgfProps = NodeUtil.cleanSgfProps(node)) != null) {
            for (String key : sgfProps.getKeys()) {
                if (key.equals("OT") && this.hasByoyomiInformation(node)) continue;
                this.print(key);
                for (int i = 0; i < sgfProps.getNumberValues(key); ++i) {
                    this.print("[" + sgfProps.getValue(key, i) + "]");
                }
            }
        }
        if ((numberChildren = node.getNumberChildren()) == 0) {
            return;
        }
        if (numberChildren == 1) {
            this.printNode(node.getChildConst(), false);
            return;
        }
        for (int i = 0; i < numberChildren; ++i) {
            this.printNewLine();
            this.print("(");
            this.printNode(node.getChildConst(i), false);
            this.print(")");
        }
    }

    private void printPosition(ConstBoard board) {
        PointList black = new PointList();
        PointList white = new PointList();
        for (GoPoint p : board) {
            GoColor c = board.getColor(p);
            if (c == GoColor.BLACK) {
                black.add(p);
                continue;
            }
            if (c != GoColor.WHITE) continue;
            white.add(p);
        }
        this.printSetup(black, white);
        this.printNewLine();
        this.printToPlay(board.getToMove());
    }

    private void printSetup(ConstPointList black, ConstPointList white) {
        if (black.size() > 0 || white.size() > 0) {
            if (black.size() > 0) {
                this.print("AB" + this.getPointList(black));
            }
            this.printNewLine();
            if (white.size() > 0) {
                this.print("AW" + this.getPointList(white));
            }
        }
    }

    private void printToPlay(GoColor color) {
        if (color == GoColor.BLACK) {
            this.print("PL[B]");
        } else {
            this.print("PL[W]");
        }
    }
}

