/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

public final class XmlUtil {
    public static String escapeAttr(String text) {
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (XmlUtil.isInvalidXml(c)) continue;
            switch (c) {
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeText(String text) {
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (XmlUtil.isInvalidXml(c)) continue;
            switch (c) {
                case '>': {
                    result.append("&gt;");
                    continue block5;
                }
                case '<': {
                    result.append("&lt;");
                    continue block5;
                }
                case '&': {
                    result.append("&amp;");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private XmlUtil() {
    }

    private static boolean isInvalidXml(char c) {
        return !(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff');
    }
}

