/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.sgf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidKomiException;
import net.sf.gogui.go.InvalidPointException;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.sgf.SgfUtil;
import net.sf.gogui.util.ByteCountInputStream;
import net.sf.gogui.util.ProgressShow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfReader {
    private final boolean m_isFile;
    private boolean m_ignoreOvertime;
    private int m_lastPercent;
    private int m_boardSize;
    private int m_byoyomiMoves;
    private final long m_size;
    private long m_byoyomi;
    private long m_preByoyomi;
    private ByteCountInputStream m_byteCountInputStream;
    private Reader m_reader;
    private GameTree m_tree;
    private final ProgressShow m_progressShow;
    private final Set<String> m_warnings = new TreeSet<String>();
    private StreamTokenizer m_tokenizer;
    private final File m_file;
    private String m_newCharset;
    private final StringBuilder m_buffer = new StringBuilder(512);
    private final PointList m_pointList = new PointList();
    private final Map<String, ArrayList<String>> m_props = new TreeMap<String, ArrayList<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SgfReader(InputStream in, File file, ProgressShow progressShow, long size) throws SgfError {
        this.m_file = file;
        this.m_progressShow = progressShow;
        this.m_size = size;
        boolean bl = this.m_isFile = in instanceof FileInputStream && file != null;
        if (progressShow != null) {
            progressShow.showProgress(0);
        }
        try {
            this.readSgf(in, "ISO-8859-1");
        }
        catch (SgfCharsetChanged e1) {
            try {
                in.close();
                in = new FileInputStream(file);
            }
            catch (IOException e2) {
                throw new SgfError("Could not reset SGF stream after charset change.");
            }
            try {
                this.readSgf(in, this.m_newCharset);
            }
            catch (SgfCharsetChanged e3) {
                assert (false);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                System.err.println("Could not close SGF stream");
            }
        }
    }

    public GameTree getTree() {
        return this.m_tree;
    }

    public String getWarnings() {
        if (this.m_warnings.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder(this.m_warnings.size() * 80);
        for (String s : this.m_warnings) {
            result.append(s);
            result.append('\n');
        }
        return result.toString();
    }

    private void applyFixes() {
        Node root = this.m_tree.getRoot();
        GameInfo info = this.m_tree.getGameInfo(root);
        if (root.hasSetup() && root.getPlayer() == null) {
            if (info.getHandicap() > 0) {
                root.setPlayer(GoColor.WHITE);
            } else {
                boolean hasBlackChildMoves = false;
                boolean hasWhiteChildMoves = false;
                for (int i = 0; i < root.getNumberChildren(); ++i) {
                    Move move = root.getChild(i).getMove();
                    if (move == null) continue;
                    if (move.getColor() == GoColor.BLACK) {
                        hasBlackChildMoves = true;
                    }
                    if (move.getColor() != GoColor.WHITE) continue;
                    hasWhiteChildMoves = true;
                }
                if (hasBlackChildMoves && !hasWhiteChildMoves) {
                    root.setPlayer(GoColor.BLACK);
                }
                if (hasWhiteChildMoves && !hasBlackChildMoves) {
                    root.setPlayer(GoColor.WHITE);
                }
            }
        }
    }

    private void checkEndOfFile() throws SgfError, IOException {
        int t;
        do {
            this.m_tokenizer.nextToken();
            t = this.m_tokenizer.ttype;
            if (t == 40) {
                throw this.getError("Multiple SGF trees not supported");
            }
            if (t != -1) continue;
            return;
        } while (t == 32 || t == 9 || t == 10 || t == 13);
        this.setWarning("Extra text after SGF tree");
    }

    private String checkForObsoleteLongProps(String property) {
        if (property.length() <= 2) {
            return property;
        }
        property = property.intern();
        String shortName = null;
        if (property == "ADDBLACK") {
            shortName = "AB";
        } else if (property == "ADDEMPTY") {
            shortName = "AE";
        } else if (property == "ADDWHITE") {
            shortName = "AW";
        } else if (property == "BLACK") {
            shortName = "B";
        } else if (property == "BLACKRANK") {
            shortName = "BR";
        } else if (property == "COMMENT") {
            shortName = "C";
        } else if (property == "COPYRIGHT") {
            shortName = "CP";
        } else if (property == "DATE") {
            shortName = "DT";
        } else if (property == "EVENT") {
            shortName = "EV";
        } else if (property == "GAME") {
            shortName = "GM";
        } else if (property == "HANDICAP") {
            shortName = "HA";
        } else if (property == "KOMI") {
            shortName = "KM";
        } else if (property == "PLACE") {
            shortName = "PC";
        } else if (property == "PLAYERBLACK") {
            shortName = "PB";
        } else if (property == "PLAYERWHITE") {
            shortName = "PW";
        } else if (property == "PLAYER") {
            shortName = "PL";
        } else if (property == "RESULT") {
            shortName = "RE";
        } else if (property == "ROUND") {
            shortName = "RO";
        } else if (property == "RULES") {
            shortName = "RU";
        } else if (property == "SIZE") {
            shortName = "SZ";
        } else if (property == "WHITE") {
            shortName = "W";
        } else if (property == "WHITERANK") {
            shortName = "WR";
        }
        if (shortName != null) {
            return shortName;
        }
        return property;
    }

    private GameInfo createGameInfo(Node node) {
        return node.createGameInfo();
    }

    private void findRoot() throws SgfError, IOException {
        while (true) {
            this.m_tokenizer.nextToken();
            int t = this.m_tokenizer.ttype;
            if (t == 40) {
                this.m_tokenizer.nextToken();
                t = this.m_tokenizer.ttype;
                if (t == 59) {
                    this.m_tokenizer.pushBack();
                    return;
                }
                this.setWarning("Extra text before SGF tree");
                continue;
            }
            if (t == -1) {
                throw this.getError("No root tree found");
            }
            this.setWarning("Extra text before SGF tree");
        }
    }

    private int getBoardSize() {
        if (this.m_boardSize == -1) {
            this.m_boardSize = 19;
        }
        return this.m_boardSize;
    }

    private SgfError getError(String message) {
        int lineNumber = this.m_tokenizer.lineno();
        if (this.m_file == null) {
            return new SgfError(lineNumber + ": " + message);
        }
        String s = this.m_file.getName() + ":" + lineNumber + ": " + message;
        return new SgfError(s);
    }

    private void handleProps(Node node, boolean isRoot) throws IOException, SgfError, SgfCharsetChanged {
        if (this.m_props.containsKey("SZ")) {
            ArrayList<String> values = this.m_props.get("SZ");
            this.m_props.remove("SZ");
            if (!isRoot) {
                this.setWarning("Size property not in root node ignored");
            } else {
                try {
                    int size = this.parseInt(values.get(0));
                    if (size <= 0 || size > 25) {
                        this.setWarning("Invalid board size value");
                    }
                    assert (this.m_boardSize == -1);
                    this.m_boardSize = size;
                }
                catch (NumberFormatException e) {
                    this.setWarning("Invalid board size value");
                }
            }
        }
        for (Map.Entry<String, ArrayList<String>> entry : this.m_props.entrySet()) {
            String p = entry.getKey();
            ArrayList<String> values = entry.getValue();
            String v = values.get(0);
            if (p == "AB") {
                this.parsePointList(values);
                node.addStones(GoColor.BLACK, this.m_pointList);
                continue;
            }
            if (p == "AE") {
                this.parsePointList(values);
                node.addStones(GoColor.EMPTY, this.m_pointList);
                continue;
            }
            if (p == "AN") {
                this.set(node, StringInfo.ANNOTATION, v);
                continue;
            }
            if (p == "AW") {
                this.parsePointList(values);
                node.addStones(GoColor.WHITE, this.m_pointList);
                continue;
            }
            if (p == "B") {
                node.setMove(Move.get(GoColor.BLACK, this.parsePoint(v)));
                continue;
            }
            if (p == "BL") {
                try {
                    node.setTimeLeft(GoColor.BLACK, Double.parseDouble(v));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (p == "BR") {
                this.set(node, StringInfoColor.RANK, GoColor.BLACK, v);
                continue;
            }
            if (p == "BT") {
                this.set(node, StringInfoColor.TEAM, GoColor.BLACK, v);
                continue;
            }
            if (p == "C") {
                node.setComment(v);
                continue;
            }
            if (p == "CA") {
                if (!isRoot || !this.m_isFile || this.m_newCharset != null) continue;
                this.m_newCharset = v.trim();
                if (Charset.isSupported(this.m_newCharset)) {
                    throw new SgfCharsetChanged();
                }
                this.setWarning("Unknown character set \"" + this.m_newCharset + "\"");
                continue;
            }
            if (p == "CP") {
                this.set(node, StringInfo.COPYRIGHT, v);
                continue;
            }
            if (p == "CR") {
                this.parseMarked(node, MarkType.CIRCLE, values);
                continue;
            }
            if (p == "DT") {
                this.set(node, StringInfo.DATE, v);
                continue;
            }
            if (p == "FF") {
                int format = -1;
                try {
                    format = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (format >= 1 && format <= 4) continue;
                this.setWarning("Unknown SGF file format version");
                continue;
            }
            if (p == "GM") {
                if ((v = v.trim()).equals("") || v.equals("1")) continue;
                throw this.getError("Not a Go game");
            }
            if (p == "HA") {
                if ((v = v.trim()).equals("")) continue;
                try {
                    int handicap = Integer.parseInt(v);
                    if (handicap == 1 || handicap < 0) {
                        this.setWarning("Invalid handicap value");
                        continue;
                    }
                    this.createGameInfo(node).setHandicap(handicap);
                }
                catch (NumberFormatException e) {
                    this.setWarning("Invalid handicap value");
                }
                continue;
            }
            if (p == "KM") {
                this.parseKomi(node, v);
                continue;
            }
            if (p == "LB") {
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    int pos = value.indexOf(58);
                    if (pos <= 0) continue;
                    GoPoint point = this.parsePoint(value.substring(0, pos));
                    String text = value.substring(pos + 1);
                    node.setLabel(point, text);
                }
                continue;
            }
            if (p == "MA" || p == "M") {
                this.parseMarked(node, MarkType.MARK, values);
                continue;
            }
            if (p == "OB") {
                try {
                    node.setMovesLeft(GoColor.BLACK, Integer.parseInt(v));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (p == "OM") {
                this.parseOvertimeMoves(v);
                continue;
            }
            if (p == "OP") {
                this.parseOvertimePeriod(v);
                continue;
            }
            if (p == "OT") {
                this.parseOvertime(node, v);
                continue;
            }
            if (p == "OW") {
                try {
                    node.setMovesLeft(GoColor.WHITE, Integer.parseInt(v));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (p == "PB") {
                this.set(node, StringInfoColor.NAME, GoColor.BLACK, v);
                continue;
            }
            if (p == "PW") {
                this.set(node, StringInfoColor.NAME, GoColor.WHITE, v);
                continue;
            }
            if (p == "PL") {
                node.setPlayer(this.parseColor(v));
                continue;
            }
            if (p == "RE") {
                this.set(node, StringInfo.RESULT, v);
                continue;
            }
            if (p == "RO") {
                this.set(node, StringInfo.ROUND, v);
                continue;
            }
            if (p == "RU") {
                this.set(node, StringInfo.RULES, v);
                continue;
            }
            if (p == "SO") {
                this.set(node, StringInfo.SOURCE, v);
                continue;
            }
            if (p == "SQ") {
                this.parseMarked(node, MarkType.SQUARE, values);
                continue;
            }
            if (p == "SL") {
                this.parseMarked(node, MarkType.SELECT, values);
                continue;
            }
            if (p == "TB") {
                this.parseMarked(node, MarkType.TERRITORY_BLACK, values);
                continue;
            }
            if (p == "TM") {
                this.parseTime(node, v);
                continue;
            }
            if (p == "TR") {
                this.parseMarked(node, MarkType.TRIANGLE, values);
                continue;
            }
            if (p == "US") {
                this.set(node, StringInfo.USER, v);
                continue;
            }
            if (p == "W") {
                node.setMove(Move.get(GoColor.WHITE, this.parsePoint(v)));
                continue;
            }
            if (p == "TW") {
                this.parseMarked(node, MarkType.TERRITORY_WHITE, values);
                continue;
            }
            if (p == "V") {
                try {
                    node.setValue(Float.parseFloat(v));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (p == "WL") {
                try {
                    node.setTimeLeft(GoColor.WHITE, Double.parseDouble(v));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (p == "WR") {
                this.set(node, StringInfoColor.RANK, GoColor.WHITE, v);
                continue;
            }
            if (p == "WT") {
                this.set(node, StringInfoColor.TEAM, GoColor.WHITE, v);
                continue;
            }
            if (p == "FF" || p == "GN" || p == "AP") continue;
            node.addSgfProperty(p, values);
        }
    }

    private GoColor parseColor(String s) throws SgfError {
        GoColor color;
        if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("b") || s.equals("1")) {
            color = GoColor.BLACK;
        } else if (s.equals("w") || s.equals("2")) {
            color = GoColor.WHITE;
        } else {
            throw this.getError("Invalid color value");
        }
        return color;
    }

    private int parseInt(String s) throws SgfError {
        int i = -1;
        try {
            i = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            throw this.getError("Number expected");
        }
        return i;
    }

    private void parseKomi(Node node, String value) throws SgfError {
        try {
            Komi komi = Komi.parseKomi(value);
            this.createGameInfo(node).setKomi(komi);
            if (komi != null && !komi.isMultipleOf(0.5)) {
                this.setWarning("Komi is not a multiple of 0.5");
            }
        }
        catch (InvalidKomiException e) {
            this.setWarning("Invalid value for komi");
        }
    }

    private void parseMarked(Node node, MarkType type, ArrayList<String> values) throws SgfError {
        this.parsePointList(values);
        for (GoPoint p : this.m_pointList) {
            node.addMarked(p, type);
        }
    }

    private void parseOvertime(Node node, String value) {
        SgfUtil.Overtime overtime = SgfUtil.parseOvertime(value);
        if (overtime == null) {
            node.addSgfProperty("OT", value);
        } else {
            this.m_byoyomi = overtime.m_byoyomi;
            this.m_byoyomiMoves = overtime.m_byoyomiMoves;
        }
    }

    private void parseOvertimeMoves(String value) {
        try {
            this.m_byoyomiMoves = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.setWarning("Invalid value for byoyomi moves");
            this.m_ignoreOvertime = true;
        }
    }

    private void parseOvertimePeriod(String value) {
        try {
            this.m_byoyomi = (long)(Double.parseDouble(value) * 1000.0);
        }
        catch (NumberFormatException e) {
            this.setWarning("Invalid value for byoyomi time");
            this.m_ignoreOvertime = true;
        }
    }

    private GoPoint parsePoint(String s) throws SgfError {
        if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("")) {
            return null;
        }
        if (s.length() > 2 || s.length() == 2 && s.charAt(1) < 'a' || s.charAt(1) > 'z') {
            try {
                return GoPoint.parsePoint(s, 25);
            }
            catch (InvalidPointException e) {
                this.throwInvalidCoordinates(s);
            }
        } else if (s.length() != 2) {
            this.throwInvalidCoordinates(s);
        }
        int boardSize = this.getBoardSize();
        if (s.equals("tt") && boardSize <= 19) {
            return null;
        }
        int x = s.charAt(0) - 97;
        int y = boardSize - (s.charAt(1) - 97) - 1;
        if (x < 0 || x >= boardSize || y < 0 || y >= boardSize) {
            if (x == boardSize && y == -1) {
                this.setWarning("Non-standard pass move encoding");
                return null;
            }
            throw this.getError("Coordinates \"" + s + "\" outside board size " + boardSize);
        }
        return GoPoint.get(x, y);
    }

    private void parsePointList(ArrayList<String> values) throws SgfError {
        this.m_pointList.clear();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            int pos = value.indexOf(58);
            if (pos < 0) {
                GoPoint point = this.parsePoint(value);
                if (point == null) {
                    this.setWarning("Point list argument contains PASS");
                    continue;
                }
                this.m_pointList.add(point);
                continue;
            }
            GoPoint point1 = this.parsePoint(value.substring(0, pos));
            GoPoint point2 = this.parsePoint(value.substring(pos + 1));
            if (point1 == null || point2 == null) {
                this.setWarning("Compressed point list contains PASS");
                continue;
            }
            int xMin = Math.min(point1.getX(), point2.getX());
            int xMax = Math.max(point1.getX(), point2.getX());
            int yMin = Math.min(point1.getY(), point2.getY());
            int yMax = Math.max(point1.getY(), point2.getY());
            for (int x = xMin; x <= xMax; ++x) {
                for (int y = yMin; y <= yMax; ++y) {
                    this.m_pointList.add(GoPoint.get(x, y));
                }
            }
        }
    }

    private void parseTime(Node node, String value) {
        if ((value = value.trim()).equals("") || value.equals("-")) {
            return;
        }
        long preByoyomi = SgfUtil.parseTime(value);
        if (preByoyomi < 0L) {
            this.setWarning("Unknown format in time property");
            node.addSgfProperty("TM", value);
        } else {
            this.m_preByoyomi = preByoyomi;
        }
    }

    private Node readNext(Node father, boolean isRoot) throws IOException, SgfError, SgfCharsetChanged {
        if (this.m_progressShow != null) {
            int percent;
            if (this.m_size > 0L) {
                long count = this.m_byteCountInputStream.getCount();
                percent = (int)(count * 100L / this.m_size);
            } else {
                percent = 100;
            }
            if (percent != this.m_lastPercent) {
                this.m_progressShow.showProgress(percent);
            }
            this.m_lastPercent = percent;
        }
        this.m_tokenizer.nextToken();
        int ttype = this.m_tokenizer.ttype;
        if (ttype == 40) {
            Node node = father;
            while (node != null) {
                node = this.readNext(node, false);
            }
            return father;
        }
        if (ttype == 41) {
            return null;
        }
        if (ttype == -1) {
            this.setWarning("Game tree not closed");
            return null;
        }
        if (ttype != 59) {
            throw this.getError("Next node expected");
        }
        Node son = new Node();
        if (father != null) {
            father.append(son);
        }
        this.m_ignoreOvertime = false;
        this.m_byoyomiMoves = -1;
        this.m_byoyomi = -1L;
        this.m_preByoyomi = -1L;
        this.m_props.clear();
        while (this.readProp()) {
        }
        this.handleProps(son, isRoot);
        this.setTimeSettings(son);
        return son;
    }

    private boolean readProp() throws IOException, SgfError {
        this.m_tokenizer.nextToken();
        int ttype = this.m_tokenizer.ttype;
        if (ttype == -3) {
            String s;
            String p = this.m_tokenizer.sval.toUpperCase(Locale.ENGLISH).intern();
            ArrayList<String> values = new ArrayList<String>();
            while ((s = this.readValue()) != null) {
                values.add(s);
            }
            if (values.isEmpty()) {
                this.setWarning("Property \"" + p + "\" has no value");
                return true;
            }
            if (this.m_props.containsKey(p = this.checkForObsoleteLongProps(p)) && (this.m_props.get(p).size() > 1 || values.size() > 1 || !((String)values.get(0)).equals(this.m_props.get(p).get(0)))) {
                this.setWarning("Duplicate property " + p + " in node");
            }
            this.m_props.put(p, values);
            return true;
        }
        if (ttype != 10) {
            this.m_tokenizer.pushBack();
        }
        return false;
    }

    private void readSgf(InputStream in, String charset) throws SgfError, SgfCharsetChanged {
        try {
            Node root;
            InputStreamReader reader;
            this.m_boardSize = -1;
            if (this.m_progressShow != null) {
                this.m_byteCountInputStream = new ByteCountInputStream(in);
                in = this.m_byteCountInputStream;
            }
            try {
                reader = new InputStreamReader(in, charset);
            }
            catch (UnsupportedEncodingException e) {
                this.setWarning("Character set \"" + charset + "\" not supported");
                reader = new InputStreamReader(in);
            }
            this.m_reader = new BufferedReader(reader);
            this.m_tokenizer = new StreamTokenizer(this.m_reader);
            this.findRoot();
            Node node = root = this.readNext(null, true);
            while (node != null) {
                node = this.readNext(node, false);
            }
            this.checkEndOfFile();
            this.getBoardSize();
            this.m_tree = new GameTree(this.m_boardSize, root);
            this.applyFixes();
        }
        catch (FileNotFoundException e) {
            throw new SgfError("File not found.");
        }
        catch (IOException e) {
            throw new SgfError("IO error");
        }
        catch (OutOfMemoryError e) {
            throw new SgfError("Out of memory");
        }
    }

    private String readValue() throws IOException, SgfError {
        this.m_tokenizer.nextToken();
        int ttype = this.m_tokenizer.ttype;
        if (ttype != 91) {
            if (ttype != 10) {
                this.m_tokenizer.pushBack();
            }
            return null;
        }
        this.m_buffer.setLength(0);
        boolean quoted = false;
        Character last = null;
        while (true) {
            boolean filterSecondLinebreak;
            int c;
            if ((c = this.m_reader.read()) < 0) {
                throw this.getError("Property value incomplete");
            }
            if (quoted) {
                if (c != 10 && c != 13) {
                    this.m_buffer.append((char)c);
                }
                last = Character.valueOf((char)c);
                quoted = false;
                continue;
            }
            if (c == 93) break;
            quoted = c == 92;
            if (quoted) continue;
            boolean isLinebreak = c == 10 || c == 13;
            boolean lastLinebreak = last != null && (last.charValue() == '\n' || last.charValue() == '\r');
            boolean bl = filterSecondLinebreak = isLinebreak && lastLinebreak && c != last.charValue();
            if (filterSecondLinebreak) {
                last = null;
                continue;
            }
            if (isLinebreak) {
                this.m_buffer.append('\n');
            } else {
                this.m_buffer.append((char)c);
            }
            last = Character.valueOf((char)c);
        }
        return this.m_buffer.toString();
    }

    private void set(Node node, StringInfo type, String value) {
        GameInfo info = this.createGameInfo(node);
        info.set(type, value);
    }

    private void set(Node node, StringInfoColor type, GoColor c, String value) {
        GameInfo info = this.createGameInfo(node);
        info.set(type, c, value);
    }

    private void setTimeSettings(Node node) {
        TimeSettings s = null;
        if (this.m_preByoyomi > 0L && (this.m_ignoreOvertime || this.m_byoyomi <= 0L || this.m_byoyomiMoves <= 0)) {
            s = new TimeSettings(this.m_preByoyomi);
        } else if (this.m_preByoyomi <= 0L && !this.m_ignoreOvertime && this.m_byoyomi > 0L && this.m_byoyomiMoves > 0) {
            s = new TimeSettings(0L, this.m_byoyomi, this.m_byoyomiMoves);
        } else if (this.m_preByoyomi > 0L && !this.m_ignoreOvertime && this.m_byoyomi > 0L && this.m_byoyomiMoves > 0) {
            s = new TimeSettings(this.m_preByoyomi, this.m_byoyomi, this.m_byoyomiMoves);
        }
        if (s != null) {
            node.createGameInfo().setTimeSettings(s);
        }
    }

    private void setWarning(String message) {
        this.m_warnings.add(message);
    }

    private void throwInvalidCoordinates(String s) throws SgfError {
        throw this.getError("Invalid coordinates \"" + s + "\"");
    }

    private static class SgfCharsetChanged
    extends Exception {
        private SgfCharsetChanged() {
        }
    }
}

