/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.twogtp;

import java.io.File;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sf.gogui.tools.twogtp.Entry;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;
import net.sf.gogui.util.Histogram;
import net.sf.gogui.util.HtmlUtil;
import net.sf.gogui.util.Statistics;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.util.Table;

public class Analyze {
    private int m_duplicates;
    private int m_errors;
    private int m_games;
    private int m_gamesUsed;
    private static final String COLOR_HEADER = "#91aee8";
    private static final String COLOR_INFO = "#e0e0e0";
    private final ArrayList<Entry> m_entries = new ArrayList(128);
    private final Statistics m_length = new Statistics();
    private final ResultStatistics m_statisticsBlack = new ResultStatistics();
    private final ResultStatistics m_statisticsReferee = new ResultStatistics();
    private final ResultStatistics m_statisticsWhite = new ResultStatistics();
    private final Statistics m_cpuBlack = new Statistics();
    private final Statistics m_cpuWhite = new Statistics();
    private final Statistics m_timeBlack = new Statistics();
    private final Statistics m_timeWhite = new Statistics();
    private Table m_table;

    public Analyze(String filename, boolean force) throws Exception {
        File file = new File(filename);
        this.readTable(file);
        File htmlFile = new File(FileUtil.replaceExtension(file, "dat", "html"));
        File dataFile = new File(FileUtil.replaceExtension(file, "dat", "summary.dat"));
        if (!force) {
            if (htmlFile.exists()) {
                throw new ErrorMessage("File " + htmlFile + " exists");
            }
            if (dataFile.exists()) {
                throw new ErrorMessage("File " + dataFile + " exists");
            }
        }
        this.calcStatistics();
        this.writeHtml(htmlFile);
        this.writeData(dataFile);
    }

    private void calcStatistics() {
        for (Entry e : this.m_entries) {
            ++this.m_games;
            if (e.m_error) {
                ++this.m_errors;
                continue;
            }
            if (!e.m_duplicate.equals("") && !e.m_duplicate.equals("-")) {
                ++this.m_duplicates;
                continue;
            }
            ++this.m_gamesUsed;
            this.parseResult(e.m_resultBlack, this.m_statisticsBlack);
            this.parseResult(e.m_resultWhite, this.m_statisticsWhite);
            this.parseResult(e.m_resultReferee, this.m_statisticsReferee);
            this.m_timeBlack.add(e.m_timeBlack);
            this.m_timeWhite.add(e.m_timeWhite);
            this.m_cpuBlack.add(e.m_cpuBlack);
            this.m_cpuWhite.add(e.m_cpuWhite);
            this.m_length.add(e.m_length);
        }
    }

    private void parseResult(String result, ResultStatistics statistics) {
        boolean hasResult = false;
        boolean hasScore = false;
        boolean win = false;
        double score = 0.0;
        String s = result.trim();
        try {
            if (!s.equals("?")) {
                if (s.startsWith("B+")) {
                    hasResult = true;
                    win = true;
                    String scoreString = s.substring(2);
                    if (!scoreString.equals("") && !scoreString.equals("R")) {
                        score = Double.parseDouble(scoreString);
                        hasScore = true;
                    }
                } else if (s.startsWith("W+")) {
                    hasResult = true;
                    win = false;
                    String scoreString = s.substring(2);
                    if (!scoreString.equals("") && !scoreString.equals("R")) {
                        score = -Double.parseDouble(scoreString);
                        hasScore = true;
                    }
                } else if (!s.equals("")) {
                    System.err.println("Ignored invalid result: " + result);
                }
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Ignored invalid score: " + result);
        }
        if (hasScore && (score < statistics.m_histo.getHistoMin() || score > statistics.m_histo.getHistoMax())) {
            System.err.println("Ignored invalid score: " + result);
            hasScore = false;
        }
        statistics.m_unknownResult.add(hasResult ? 0.0 : 1.0);
        if (hasResult) {
            statistics.m_win.add(win ? 1.0 : 0.0);
        }
        statistics.m_unknownScore.add(hasScore ? 0.0 : 1.0);
        if (hasScore) {
            statistics.m_histo.add(score);
        }
    }

    private void readTable(File file) throws Exception {
        this.m_table = new Table();
        this.m_table.read(file);
        try {
            for (int i = 0; i < this.m_table.getNumberRows(); ++i) {
                int gameIndex = this.m_table.getInt("GAME", i);
                String resultBlack = this.m_table.get("RES_B", i);
                String resultWhite = this.m_table.get("RES_W", i);
                String resultReferee = this.m_table.get("RES_R", i);
                boolean alternated = this.m_table.getInt("ALT", i) != 0;
                String duplicate = this.m_table.get("DUP", i);
                int length = this.m_table.getInt("LEN", i);
                double timeBlack = 0.0;
                double timeWhite = 0.0;
                try {
                    timeBlack = this.m_table.getDouble("TIME_B", i);
                    timeWhite = this.m_table.getDouble("TIME_W", i);
                }
                catch (Table.InvalidLocation e) {
                    // empty catch block
                }
                double cpuBlack = this.m_table.getDouble("CPU_B", i);
                double cpuWhite = this.m_table.getDouble("CPU_W", i);
                boolean error = this.m_table.getInt("ERR", i) != 0;
                String errorMessage = this.m_table.get("ERR_MSG", i);
                this.m_entries.add(new Entry(gameIndex, resultBlack, resultWhite, resultReferee, alternated, duplicate, length, timeBlack, timeWhite, cpuBlack, cpuWhite, error, errorMessage));
            }
        }
        catch (NumberFormatException e) {
            throw new ErrorMessage("Wrong file format");
        }
    }

    private void writeHtml(File file) throws Exception {
        String gamePrefix = "game";
        if (file.getName().endsWith(".html")) {
            String name = file.getName();
            gamePrefix = name.substring(0, name.length() - 5);
        }
        PrintStream out = new PrintStream(file);
        NumberFormat format = StringUtil.getNumberFormat(1);
        String black = this.m_table.hasProperty("BlackLabel") ? this.m_table.getProperty("BlackLabel") : (this.m_table.hasProperty("Black") ? this.m_table.getProperty("Black") : "Black");
        String white = this.m_table.hasProperty("WhiteLabel") ? this.m_table.getProperty("WhiteLabel") : (this.m_table.hasProperty("White") ? this.m_table.getProperty("White") : "Black");
        boolean useXml = !this.m_table.getProperty("Xml", "0").equals("0");
        out.print("<html>\n<head>\n<title>" + black + " - " + white + "</title>\n" + HtmlUtil.getMeta("TwoGtp") + "<style type=\"text/css\">\n" + "<!--\n" + "body { margin:0; }\n" + "-->\n" + "</style>\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\" link=\"#0000ee\"" + " vlink=\"#551a8b\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>" + black + " - " + white + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + COLOR_INFO + "\">\n");
        String referee = this.m_table.getProperty("Referee", "");
        if (referee.equals("-") || referee.equals("")) {
            referee = null;
        }
        this.writePropertyHtmlRow(out, "Black", "Black");
        this.writePropertyHtmlRow(out, "White", "White");
        this.writePropertyHtmlRow(out, "Size", "Size");
        this.writePropertyHtmlRow(out, "Komi", "Komi");
        if (this.m_table.hasProperty("Openings")) {
            this.writePropertyHtmlRow(out, "Openings", "Openings");
        }
        this.writePropertyHtmlRow(out, "Date", "Date");
        this.writePropertyHtmlRow(out, "Host", "Host");
        this.writePropertyHtmlRow(out, "Referee", "Referee");
        this.writePropertyHtmlRow(out, "BlackVersion", "Black version");
        this.writePropertyHtmlRow(out, "BlackCommand", "Black command");
        this.writePropertyHtmlRow(out, "WhiteVersion", "White version");
        this.writePropertyHtmlRow(out, "WhiteCommand", "White command");
        if (referee != null) {
            this.writePropertyHtmlRow(out, "RefereeVersion", "Referee version");
            this.writePropertyHtmlRow(out, "RefereeCommand", "Referee command");
        }
        this.writeHtmlRow(out, "Games", this.m_games);
        this.writeHtmlRow(out, "Errors", this.m_errors);
        this.writeHtmlRow(out, "Duplicates", this.m_duplicates);
        this.writeHtmlRow(out, "Games used", this.m_gamesUsed);
        this.writeHtmlRow(out, "Game length", this.m_length, format);
        this.writeHtmlRow(out, "Time Black", this.m_timeBlack, format);
        this.writeHtmlRow(out, "Time White", this.m_timeWhite, format);
        this.writeHtmlRow(out, "CPU Time Black", this.m_cpuBlack, format);
        this.writeHtmlRow(out, "CPU Time White", this.m_cpuWhite, format);
        out.print("</table>\n<hr>\n");
        if (referee != null) {
            this.writeHtmlResults(out, referee, this.m_statisticsReferee);
            out.println("<hr>");
        }
        this.writeHtmlResults(out, black, this.m_statisticsBlack);
        out.println("<hr>");
        this.writeHtmlResults(out, white, this.m_statisticsWhite);
        out.println("<hr>");
        out.print("<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"1\">\n<thead>\n<tr bgcolor=\"#91aee8\">\n<th>Game</th>\n");
        if (referee != null) {
            out.print("<th>Result " + referee + "</th>\n");
        }
        out.print("<th>Result " + black + "</th>\n" + "<th>Result " + white + "</th>\n");
        out.print("<th>Colors Exchanged</th>\n<th>Duplicate</th>\n<th>Length</th>\n<th>Time " + black + "</th>\n" + "<th>Time " + white + "</th>\n" + "<th>CPU Time " + black + "</th>\n" + "<th>CPU Time " + white + "</th>\n" + "<th>Error</th>\n" + "<th>Error Message</th>\n" + "</tr>\n" + "</thead>\n");
        String gameSuffix = useXml ? ".xml" : ".sgf";
        for (Entry e : this.m_entries) {
            String name = gamePrefix + "-" + e.m_gameIndex + gameSuffix;
            out.print("<tr align=\"center\" bgcolor=\"#e0e0e0\"><td><a href=\"" + name + "\">" + name + "</a></td>\n");
            if (referee != null) {
                out.print("<td>" + e.m_resultReferee + "</td>");
            }
            out.print("<td>" + e.m_resultBlack + "</td>" + "<td>" + e.m_resultWhite + "</td>");
            out.print("<td>" + (e.m_alternated ? "1" : "0") + "</td>" + "<td>" + e.m_duplicate + "</td>" + "<td>" + e.m_length + "</td>" + "<td>" + e.m_timeBlack + "</td>" + "<td>" + e.m_timeWhite + "</td>" + "<td>" + e.m_cpuBlack + "</td>" + "<td>" + e.m_cpuWhite + "</td>" + "<td>" + (e.m_error ? "1" : "") + "</td>" + "<td>" + e.m_errorMessage + "</td>" + "</tr>\n");
        }
        out.print("</table>\n" + HtmlUtil.getFooter("TwoGtp") + "</body>\n" + "</html>\n");
        out.close();
    }

    private void writeHtmlResults(PrintStream out, String name, ResultStatistics statistics) throws Exception {
        NumberFormat format = StringUtil.getNumberFormat(1);
        out.print("<div style=\"margin:1em\">\n<h2>Result " + name + "</h2>\n" + "<p>\n" + "<table border=\"0\">\n");
        if (statistics.m_histo.getCount() > 0) {
            this.writeHtmlRow(out, "Black score", statistics.m_histo, format);
        }
        if (statistics.m_win.getCount() > 0) {
            this.writeHtmlRowPercentData(out, "Black wins", statistics.m_win, format);
        }
        out.print("<tr><th align=\"left\">Unknown result:</th><td align=\"left\">" + format.format(statistics.m_unknownResult.getMean() * 100.0) + "%" + "</td></tr>\n" + "<tr><th align=\"left\">Unknown score" + ":</th><td align=\"left\">" + format.format(statistics.m_unknownScore.getMean() * 100.0) + "%" + "</td></tr>\n" + "</table>\n" + "</p>\n");
        statistics.m_histo.printHtml(out);
        out.print("</div>\n");
    }

    private void writePropertyHtmlRow(PrintStream out, String key, String keyLabel) throws Exception {
        String value = this.m_table.getProperty(key, "");
        this.writeHtmlRow(out, keyLabel, value);
    }

    private void writeHtmlRow(PrintStream out, String label, String value) throws Exception {
        out.print("<tr><th align=\"left\" valign=\"top\" nowrap>" + label + ":</th><td align=\"left\">" + value + "</td></tr>\n");
    }

    private void writeHtmlRow(PrintStream out, String label, int value) throws Exception {
        this.writeHtmlRow(out, label, Integer.toString(value));
    }

    private void writeHtmlRow(PrintStream out, String label, Statistics statistics, NumberFormat format) throws Exception {
        String value = statistics.getCount() == 0 ? "" : format.format(statistics.getMean()) + " (&plusmn;" + format.format(statistics.getError()) + ") <small>min=" + format.format(statistics.getMin()) + " max=" + format.format(statistics.getMax()) + " deviation=" + format.format(statistics.getDeviation()) + "</small>";
        this.writeHtmlRow(out, label, value);
    }

    private void writeHtmlRowPercentData(PrintStream out, String label, Statistics statistics, NumberFormat format) throws Exception {
        String value = statistics.getCount() == 0 ? "" : format.format(statistics.getMean() * 100.0) + "% (&plusmn;" + format.format(statistics.getError() * 100.0) + ")";
        this.writeHtmlRow(out, label, value);
    }

    private void writeData(File file) throws Exception {
        PrintStream out = new PrintStream(file);
        NumberFormat format1 = StringUtil.getNumberFormat(1);
        NumberFormat format2 = StringUtil.getNumberFormat(3);
        Histogram histoBlack = this.m_statisticsBlack.m_histo;
        Histogram histoWhite = this.m_statisticsWhite.m_histo;
        Histogram histoReferee = this.m_statisticsReferee.m_histo;
        Statistics winBlack = this.m_statisticsBlack.m_win;
        Statistics winWhite = this.m_statisticsWhite.m_win;
        Statistics winReferee = this.m_statisticsReferee.m_win;
        Statistics unknownBlack = this.m_statisticsBlack.m_unknownScore;
        Statistics unknownWhite = this.m_statisticsWhite.m_unknownScore;
        Statistics unknownReferee = this.m_statisticsReferee.m_unknownScore;
        out.print("#GAMES\tERR\tDUP\tUSED\tRES_B\tERR_B\tWIN_B\tERRW_B\tUNKN_B\tRES_W\tERR_W\tWIN_W\tERRW_W\tUNKN_W\tRES_R\tERR_R\tWIN_R\tERRW_R\tUNKN_R\n" + this.m_games + "\t" + this.m_errors + "\t" + this.m_duplicates + "\t" + this.m_gamesUsed + "\t" + format1.format(histoBlack.getMean()) + "\t" + format1.format(histoBlack.getError()) + "\t" + format2.format(winBlack.getMean()) + "\t" + format2.format(winBlack.getError()) + "\t" + format2.format(unknownBlack.getMean()) + "\t" + format1.format(histoWhite.getMean()) + "\t" + format1.format(histoWhite.getError()) + "\t" + format2.format(winWhite.getMean()) + "\t" + format2.format(winWhite.getError()) + "\t" + format2.format(unknownWhite.getMean()) + "\t" + format1.format(histoReferee.getMean()) + "\t" + format1.format(histoReferee.getError()) + "\t" + format2.format(winReferee.getMean()) + "\t" + format2.format(winReferee.getError()) + "\t" + format2.format(unknownReferee.getMean()) + "\n");
        out.close();
    }

    private static final class ResultStatistics {
        public Statistics m_unknownResult = new Statistics();
        public Statistics m_unknownScore = new Statistics();
        public Statistics m_win = new Statistics();
        public Histogram m_histo = new Histogram(-1000.0, 1000.0, 10.0);

        private ResultStatistics() {
        }
    }
}

