/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.twogtp;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtil;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.sgf.SgfReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Compare {
    public static String checkDuplicate(ConstBoard board, ArrayList<Placement> moves, Map<Integer, ArrayList<Placement>> games, boolean useAlternate, boolean isAlternated) {
        String result = "-";
        int size = board.getSize();
        for (Map.Entry<Integer, ArrayList<Placement>> entry : games.entrySet()) {
            int numberGame = entry.getKey();
            if (useAlternate && numberGame % 2 != 0 != isAlternated) continue;
            ArrayList<Placement> gameMoves = entry.getValue();
            for (int rot = 0; rot < 8; ++rot) {
                int numberDifferent = 0;
                int moveNumber = moves.size();
                int maxDifferent = moveNumber / 5;
                if (gameMoves.size() != moveNumber) {
                    numberDifferent = Math.abs(gameMoves.size() - moveNumber);
                    moveNumber = Math.min(gameMoves.size(), moveNumber);
                }
                for (int i = 0; numberDifferent <= maxDifferent && i < moveNumber; ++i) {
                    Placement move = moves.get(i);
                    Placement gameMove = gameMoves.get(i);
                    GoPoint gameRotatedPoint = BoardUtil.rotate(rot, gameMove.m_point, size);
                    if (move.m_isSetup == gameMove.m_isSetup && move.m_color.equals((Object)gameMove.m_color) && GoPoint.equals(move.m_point, gameRotatedPoint)) continue;
                    ++numberDifferent;
                }
                if (numberDifferent == 0) {
                    return Integer.toString(numberGame);
                }
                if (numberDifferent >= maxDifferent) continue;
                result = Integer.toString(numberGame) + "?";
            }
        }
        return result;
    }

    public static void compare(ArrayList<String> filenames) throws Exception {
        Board board = null;
        TreeMap<Integer, ArrayList<Placement>> games = new TreeMap<Integer, ArrayList<Placement>>();
        for (int gameNumber = 0; gameNumber < filenames.size(); ++gameNumber) {
            String filename = filenames.get(gameNumber);
            File file = new File(filename);
            FileInputStream fileStream = new FileInputStream(file);
            SgfReader reader = new SgfReader(fileStream, file, null, 0L);
            GameTree tree = reader.getTree();
            int size = tree.getBoardSize();
            if (board == null) {
                board = new Board(size);
            } else if (size != board.getSize()) {
                throw new Exception("Board size in " + filename + " does not match other games");
            }
            ArrayList<Placement> moves = Compare.getPlacements(tree.getRoot());
            String duplicate = Compare.checkDuplicate(board, moves, games, false, false);
            System.out.println(Integer.toString(gameNumber) + " " + filename + " " + duplicate);
            games.put(gameNumber, moves);
        }
    }

    public static ArrayList<Placement> getPlacements(ConstNode node) {
        ArrayList<Placement> result = new ArrayList<Placement>(512);
        while (node != null) {
            for (GoColor c : GoColor.BLACK_WHITE_EMPTY) {
                PointList list = new PointList(node.getSetup(c));
                Collections.sort(list);
                for (GoPoint p : list) {
                    result.add(new Placement(true, c, p));
                }
            }
            Move move = node.getMove();
            if (move != null) {
                result.add(new Placement(move));
            }
            node = node.getChildConst();
        }
        return result;
    }

    private Compare() {
    }

    public static final class Placement {
        public boolean m_isSetup;
        public GoColor m_color;
        public GoPoint m_point;

        public Placement(boolean isSetup, GoColor color, GoPoint point) {
            this.m_isSetup = isSetup;
            this.m_color = color;
            this.m_point = point;
        }

        public Placement(Move move) {
            this(false, move.getColor(), move.getPoint());
        }
    }
}

