/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.BlackWhiteSet;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Score;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.StringUtil;

public class GameInfo
implements ConstGameInfo {
    private int m_handicap;
    private Komi m_komi;
    private TimeSettings m_timeSettings;
    private Map<StringInfo, String> m_stringInfo = new TreeMap<StringInfo, String>();
    private Map<StringInfoColor, BlackWhiteSet<String>> m_stringInfoColor = new TreeMap<StringInfoColor, BlackWhiteSet<String>>();

    public GameInfo() {
    }

    public GameInfo(ConstGameInfo info) {
        this.copyFrom(info);
    }

    public final void copyFrom(ConstGameInfo info) {
        GameInfo infoNonConst = (GameInfo)info;
        this.m_handicap = infoNonConst.m_handicap;
        this.m_komi = infoNonConst.m_komi;
        this.m_timeSettings = infoNonConst.m_timeSettings;
        this.m_stringInfo.clear();
        this.m_stringInfo.putAll(infoNonConst.m_stringInfo);
        this.m_stringInfoColor.clear();
        for (Map.Entry<StringInfoColor, BlackWhiteSet<String>> entry : infoNonConst.m_stringInfoColor.entrySet()) {
            StringInfoColor type = entry.getKey();
            BlackWhiteSet<String> set = entry.getValue();
            assert (set != null);
            BlackWhiteSet<String> newSet = new BlackWhiteSet<String>();
            newSet.set(GoColor.BLACK, set.get(GoColor.BLACK));
            newSet.set(GoColor.WHITE, set.get(GoColor.WHITE));
            this.m_stringInfoColor.put(type, newSet);
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        GameInfo info = (GameInfo)object;
        return this.m_handicap == info.getHandicap() && ObjectUtil.equals((Object)this.m_komi, (Object)info.getKomi()) && ObjectUtil.equals((Object)this.m_timeSettings, (Object)info.getTimeSettings()) && this.m_stringInfo.equals(info.m_stringInfo) && this.m_stringInfoColor.equals(info.m_stringInfoColor);
    }

    public String get(StringInfo type) {
        return this.m_stringInfo.get((Object)type);
    }

    public String get(StringInfoColor type, GoColor c) {
        BlackWhiteSet<String> set = this.m_stringInfoColor.get((Object)type);
        if (set == null) {
            return null;
        }
        return set.get(c);
    }

    public int getHandicap() {
        return this.m_handicap;
    }

    public Komi getKomi() {
        return this.m_komi;
    }

    public TimeSettings getTimeSettings() {
        return this.m_timeSettings;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean isEmpty() {
        return this.m_handicap == 0 && this.m_komi == null && this.m_stringInfo.isEmpty() && this.m_stringInfoColor.isEmpty() && this.m_timeSettings == null;
    }

    public Score.ScoringMethod parseRules() {
        Score.ScoringMethod result = Score.ScoringMethod.AREA;
        String rules = this.get(StringInfo.RULES);
        if (rules != null && (rules = rules.trim().toLowerCase(Locale.ENGLISH)).equals("japanese")) {
            result = Score.ScoringMethod.TERRITORY;
        }
        return result;
    }

    public void set(StringInfo type, String value) {
        if ((value = this.checkEmpty(value)) == null) {
            this.m_stringInfo.remove((Object)type);
        } else {
            this.m_stringInfo.put(type, value);
        }
    }

    public void set(StringInfoColor type, GoColor c, String value) {
        value = this.checkEmpty(value);
        BlackWhiteSet<String> set = this.m_stringInfoColor.get((Object)type);
        if (set == null) {
            set = new BlackWhiteSet();
            this.m_stringInfoColor.put(type, set);
        }
        set.set(c, value);
        if (set.get(GoColor.BLACK) == null && set.get(GoColor.WHITE) == null) {
            this.m_stringInfoColor.remove((Object)type);
        }
    }

    public void setHandicap(int handicap) {
        this.m_handicap = handicap;
    }

    public void setKomi(Komi komi) {
        this.m_komi = komi;
    }

    public void setTimeSettings(TimeSettings timeSettings) {
        this.m_timeSettings = timeSettings;
    }

    public String suggestGameName() {
        boolean playerWhiteKnown;
        String playerBlack = this.get(StringInfoColor.NAME, GoColor.BLACK);
        String playerWhite = this.get(StringInfoColor.NAME, GoColor.WHITE);
        boolean playerBlackKnown = !StringUtil.isEmpty(playerBlack);
        boolean bl = playerWhiteKnown = !StringUtil.isEmpty(playerWhite);
        if (!playerBlackKnown && !playerWhiteKnown) {
            return null;
        }
        playerBlack = playerBlackKnown ? StringUtil.capitalize(playerBlack) : "Unknown";
        playerWhite = playerWhiteKnown ? StringUtil.capitalize(playerWhite) : "Unknown";
        return playerWhite + " vs. " + playerBlack + " (B)";
    }

    private String checkEmpty(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        return s;
    }
}

