/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.terminal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtil;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpResponseFormatError;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.sgf.SgfWriter;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.version.Version;

public class Terminal
implements GtpClient.IOCallback {
    private final boolean m_verbose;
    private boolean m_color;
    private Board m_board;
    private GameTree m_tree;
    private final GtpClient m_gtp;
    private Node m_currentNode;

    public Terminal(String program, int size, boolean verbose) throws Exception {
        if (program.equals("")) {
            throw new Exception("No program set");
        }
        this.m_verbose = verbose;
        this.m_gtp = new GtpClient(program, null, verbose, (GtpClient.IOCallback)this);
        this.m_gtp.queryProtocolVersion();
        this.m_gtp.querySupportedCommands();
        this.initGame(size);
    }

    public void close() {
        this.m_gtp.close();
        this.m_gtp.waitForExit();
    }

    public void mainLoop() throws IOException {
        this.newGame(this.m_board.getSize());
        this.printBoard();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            do {
                System.out.print("> ");
                line = reader.readLine();
                if (line != null) continue;
                break;
            } while ((line = line.trim()).equals("") || !this.handleCommand(line));
        }
        finally {
            System.out.println();
        }
    }

    public void receivedInvalidResponse(String s) {
        System.out.print(s);
    }

    public void receivedResponse(boolean error, String s) {
    }

    public void receivedStdErr(String s) {
        if (!this.m_verbose) {
            System.err.print(s);
        }
    }

    public void sentCommand(String s) {
    }

    public void setColor(boolean enable) {
        this.m_color = enable;
    }

    private void cmdPlay(GoPoint point) {
        if (!this.cmdPlay(this.m_board.getToMove(), point)) {
            return;
        }
        this.printBoard();
        this.genmove();
    }

    private boolean cmdPlay(GoColor color, GoPoint point) {
        StringBuilder response;
        String command = this.m_gtp.getCommandPlay(Move.get(color, point));
        if (!this.send(command, response = new StringBuilder())) {
            System.out.println(response);
            return false;
        }
        this.play(Move.get(color, point));
        return true;
    }

    private void genmove() {
        StringBuilder response;
        GoColor toMove = this.m_board.getToMove();
        String command = this.m_gtp.getCommandGenmove(toMove);
        if (!this.send(command, response = new StringBuilder())) {
            System.out.println(response);
            return;
        }
        try {
            GoPoint point = GtpUtil.parsePoint(response.toString(), this.m_board.getSize());
            System.out.println("Computer move: " + GoPoint.toString(point));
            this.play(Move.get(toMove, point));
            this.printBoard();
        }
        catch (GtpResponseFormatError e) {
            System.out.println(response);
        }
    }

    private boolean handleCommand(String cmdLine) {
        String[] cmdArray = StringUtil.splitArguments(cmdLine);
        String cmd = cmdArray[0];
        if (cmd.equals("quit")) {
            this.send("quit");
            return true;
        }
        if (cmd.equals("genmove")) {
            this.genmove();
        } else if (cmd.equals("help")) {
            this.help();
        } else if (cmd.equals("list")) {
            this.listCommands();
        } else if (cmd.equals("load")) {
            this.load(cmdArray);
        } else if (cmd.equals("newgame")) {
            this.newGame(cmdArray);
        } else if (cmd.equals("save")) {
            this.save(cmdArray);
        } else if (cmd.equals("undo")) {
            this.undo(cmdArray);
        } else if (GtpUtil.isStateChangingCommand(cmd)) {
            System.out.println("Command not allowed");
        } else {
            try {
                GoPoint point = GtpUtil.parsePoint(cmdLine, this.m_board.getSize());
                this.cmdPlay(point);
            }
            catch (GtpResponseFormatError e) {
                StringBuilder response = new StringBuilder();
                this.send(cmdLine, response);
                System.out.println(response);
            }
        }
        return false;
    }

    private void help() {
        String text = "Enter a move or one of the following commands:\ngenmove, help, load, list, newgame, save, undo, quit.\nGTP commands that change the board state are not allowed.\nOther GTP commands are forwarded to the program.\n";
        System.out.print(text);
    }

    private void initGame(int size) {
        this.m_board = new Board(size);
        this.m_tree = new GameTree(size, null, null, null, null);
        this.setCurrentNode(this.m_tree.getRoot());
    }

    private void listCommands() {
        try {
            this.m_gtp.querySupportedCommands();
        }
        catch (GtpError error) {
            System.out.println(error.getMessage());
            return;
        }
        ArrayList<String> commands = this.m_gtp.getSupportedCommands();
        for (int i = 0; i < commands.size(); ++i) {
            System.out.println(commands.get(i));
        }
    }

    private void load(String[] cmdArray) {
        if (cmdArray.length < 2) {
            System.out.println("Need filename argument");
            return;
        }
        File file = new File(cmdArray[1]);
        try {
            GameTree tree;
            GameInfo info;
            FileInputStream fileStream = new FileInputStream(file);
            SgfReader reader = new SgfReader(fileStream, file, null, 0L);
            String warnings = reader.getWarnings();
            if (warnings != null) {
                System.out.print(warnings);
            }
            if ((info = (tree = reader.getTree()).getGameInfo(tree.getRoot())).getHandicap() > 0) {
                System.out.println("Handicap games not supported");
                return;
            }
            if (!this.newGame(tree.getBoardSize())) {
                return;
            }
            this.send("komi " + info.getKomi());
            for (ConstNode node = tree.getRoot(); node != null; node = node.getChildConst()) {
                for (GoColor c : GoColor.BLACK_WHITE) {
                    for (GoPoint stone : node.getSetup(c)) {
                        if (this.cmdPlay(c, stone)) continue;
                        return;
                    }
                }
                Move move = node.getMove();
                if (move == null || this.cmdPlay(move.getColor(), move.getPoint())) continue;
                return;
            }
            this.printBoard();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + file);
        }
        catch (SgfError e) {
            System.out.println("Could not read file " + file + ": " + e.getMessage());
        }
    }

    private boolean newGame(int size) {
        StringBuilder response = new StringBuilder();
        String command = this.m_gtp.getCommandBoardsize(size);
        if (command != null && !this.send(command, response)) {
            System.out.println(response);
            return false;
        }
        command = this.m_gtp.getCommandClearBoard(size);
        if (!this.send(command, response)) {
            System.out.println(response);
            return false;
        }
        this.initGame(size);
        return true;
    }

    private void newGame(String[] cmdArray) {
        int size = this.m_board.getSize();
        if (cmdArray.length > 1) {
            try {
                size = Integer.parseInt(cmdArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.newGame(size);
        this.printBoard();
    }

    private void play(Move move) {
        this.m_board.play(move);
        Node node = new Node(move);
        this.m_currentNode.append(node);
        this.m_currentNode = node;
    }

    private void printBoard() {
        System.out.print(BoardUtil.toString(this.m_board, true, this.m_color));
    }

    private void save(String[] cmdArray) {
        if (cmdArray.length < 2) {
            System.out.println("Need filename argument");
            return;
        }
        File file = new File(cmdArray[1]);
        try {
            FileOutputStream out = new FileOutputStream(file);
            new SgfWriter((OutputStream)out, this.m_tree, "gogui-terminal", Version.get());
        }
        catch (FileNotFoundException e) {
            System.out.println("Write error");
            return;
        }
    }

    private String send(String cmd) {
        StringBuilder response = new StringBuilder();
        this.send(cmd, response);
        return response.toString();
    }

    private boolean send(String cmd, StringBuilder response) {
        try {
            response.append(this.m_gtp.send(cmd));
            return true;
        }
        catch (GtpError error) {
            response.append(error.getMessage());
            return false;
        }
    }

    private void setCurrentNode(ConstNode node) {
        this.m_currentNode = this.m_tree.getNode(node);
    }

    private void undo(String[] cmdArray) {
        if (cmdArray.length > 1) {
            System.out.println("undo command takes no arguments");
            return;
        }
        StringBuilder response = new StringBuilder();
        if (!this.send("undo", response)) {
            System.out.println(response);
            return;
        }
        this.m_board.undo();
        this.m_currentNode = this.m_currentNode.getFather();
        this.printBoard();
    }
}

