/*
 * Decompiled with CFR 0.152.
 */
package Common;

import Common.animMatrix;
import Common.loc;
import Common.matrix;

public class boardInfo {
    public static int COL_COUNT;
    public static int EMPTY;
    public static int GAME_OVER;
    public static int MAX_MOVES;
    public static int NO_GAME;
    public static int PLAYER_BLACK;
    public static int PLAYER_WHITE;
    public static int ROW_COUNT;
    public int[][] b = new int[ROW_COUNT][COL_COUNT];
    public int[][][] boardHistory;
    public int moveCount;
    public loc[] moveHistory = new loc[MAX_MOVES];
    public int turn;
    public int[] turnHistory = new int[MAX_MOVES];
    public int validMoveCount;

    static {
        ROW_COUNT = 8;
        COL_COUNT = 8;
        PLAYER_BLACK = 1;
        PLAYER_WHITE = 31;
        EMPTY = 0;
        NO_GAME = -1;
        GAME_OVER = -2;
        MAX_MOVES = ROW_COUNT * COL_COUNT - 4;
    }

    public boardInfo(boardInfo src) {
        this();
        boardInfo.copyBoard(src.b, this.b);
        this.turn = src.turn;
        int i = 0;
        while (i < MAX_MOVES) {
            this.moveHistory[i].set(src.moveHistory[i]);
            this.turnHistory[i] = src.turnHistory[i];
            boardInfo.copyBoard(src.boardHistory[i], this.boardHistory[i]);
            ++i;
        }
        this.moveCount = src.moveCount;
        this.validMoveCount = src.validMoveCount;
    }

    public boardInfo() {
        this.boardHistory = new int[MAX_MOVES][ROW_COUNT][COL_COUNT];
        int i = 0;
        while (i < MAX_MOVES) {
            this.moveHistory[i] = new loc();
            ++i;
        }
        this.makeEmpty();
    }

    public animMatrix calculateMoveAnimation(int r, int c) {
        animMatrix anim = new animMatrix();
        int dCount = 0;
        if (this.turn == NO_GAME || this.turn == GAME_OVER || this.b[r][c] != EMPTY) {
            return anim;
        }
        this.copyBoardToHistory(this.moveCount);
        this.b[r][c] = this.turn;
        int iD = -1;
        while (iD <= 1) {
            int jD = -1;
            while (jD <= 1) {
                if ((iD != 0 || jD != 0) && this.checkInADir(r, c, iD, jD)) {
                    ++dCount;
                    this.goInADir(anim, r, c, iD, jD);
                }
                ++jD;
            }
            ++iD;
        }
        if (dCount == 0) {
            this.b[r][c] = EMPTY;
            return new animMatrix();
        }
        this.moveHistory[this.moveCount].c = c;
        this.moveHistory[this.moveCount].r = r;
        this.turnHistory[this.moveCount] = this.turn;
        ++this.moveCount;
        this.validMoveCount = this.moveCount;
        this.changeTurn();
        return anim;
    }

    public void changeTurn() {
        this.turn = this.turn == PLAYER_BLACK ? PLAYER_WHITE : PLAYER_BLACK;
    }

    private boolean checkInADir(int rS, int cS, int rD, int cD) {
        int rN = rS + rD;
        int cN = cS + cD;
        if (rN < 0 || rN >= ROW_COUNT || cN < 0 || cN >= COL_COUNT || this.b[rN][cN] == EMPTY) {
            return false;
        }
        if (this.b[rN][cN] == this.turn && this.b[rS][cS] == this.turn) {
            return false;
        }
        if (this.b[rN][cN] == this.turn) {
            return true;
        }
        return this.checkInADir(rN, cN, rD, cD);
    }

    public static void copyBoard(int[][] src, int[][] dest) {
        int i = 0;
        while (i < ROW_COUNT) {
            int j = 0;
            while (j < COL_COUNT) {
                dest[i][j] = src[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void copyBoardToHistory(int k) {
        boardInfo.copyBoard(this.b, this.boardHistory[k]);
    }

    public void copyHistoryToBoard(int k) {
        boardInfo.copyBoard(this.boardHistory[k], this.b);
    }

    public int correctTurn() {
        matrix m = this.getGainMatrix();
        if (m.getMax() > 0) {
            return 0;
        }
        this.changeTurn();
        m = this.getGainMatrix();
        if (m.getMax() > 0) {
            return 1;
        }
        this.turn = GAME_OVER;
        return 2;
    }

    public int countCornerStablePieces(int player, loc corner, int rMAx, int cMax) {
        int c = 0;
        int rm = 0;
        int cm = 0;
        int rec = 0;
        loc dir = new loc(corner.r <= ROW_COUNT / 2 ? 1 : -1, corner.c <= COL_COUNT / 2 ? 1 : -1);
        if (this.b[corner.r][corner.c] == player) {
            ++c;
            int i = corner.r + dir.r;
            boolean e = false;
            while (!e) {
                if (dir.r == 1 && i >= rMAx || dir.r == -1 && i <= rMAx) break;
                if (this.b[i][corner.c] == player) {
                    ++c;
                    rec = 1;
                    rm = i;
                } else {
                    e = true;
                }
                i += dir.r;
            }
            int j = corner.c + dir.c;
            e = false;
            while (!e) {
                if (dir.c == 1 && j >= cMax || dir.c == -1 && j <= cMax) break;
                if (this.b[corner.r][j] == player) {
                    ++c;
                    ++rec;
                    cm = j;
                } else {
                    e = true;
                }
                j += dir.c;
            }
            if (rec > 1) {
                loc newCorner = new loc();
                newCorner.r = corner.r + dir.r;
                newCorner.c = corner.c + dir.c;
                c += this.countCornerStablePieces(player, newCorner, rm, cm);
            }
        }
        return c;
    }

    public int countFrontier(int player) {
        int f = 0;
        int i = 0;
        while (i < ROW_COUNT) {
            int j = 0;
            while (j < COL_COUNT) {
                if (this.b[i][j] == player) {
                    if (this.isEmpty(i + 1, j)) {
                        ++f;
                    }
                    if (this.isEmpty(i - 1, j)) {
                        ++f;
                    }
                    if (this.isEmpty(i, j + 1)) {
                        ++f;
                    }
                    if (this.isEmpty(i, j - 1)) {
                        ++f;
                    }
                    if (this.isEmpty(i + 1, j + 1)) {
                        ++f;
                    }
                    if (this.isEmpty(i + 1, j - 1)) {
                        ++f;
                    }
                    if (this.isEmpty(i - 1, j + 1)) {
                        ++f;
                    }
                    if (this.isEmpty(i - 1, j - 1)) {
                        ++f;
                    }
                }
                ++j;
            }
            ++i;
        }
        return f;
    }

    private int countInADir(int rS, int cS, int rD, int cD) {
        int rN = rS + rD;
        int cN = cS + cD;
        if (rN < 0 || rN >= ROW_COUNT || cN < 0 || cN >= COL_COUNT || this.b[rN][cN] == EMPTY) {
            return 0;
        }
        if (this.b[rN][cN] == this.turn && this.b[rS][cS] == this.turn) {
            return 0;
        }
        if (this.b[rN][cN] == this.turn) {
            return 0;
        }
        return 1 + this.countInADir(rN, cN, rD, cD);
    }

    private int countRepetitions(int player, loc corner1, loc corner2, int n) {
        int c = 0;
        loc dir = new loc();
        loc iter = new loc();
        if (corner1.r == corner2.r) {
            dir.set(0, 1);
        } else {
            dir.set(1, 0);
        }
        iter.set(corner1);
        while (iter.r <= corner2.r && iter.c <= corner2.c) {
            if (this.b[iter.r][iter.c] == player) {
                ++c;
            } else {
                return 0;
            }
            iter = loc.add(iter, dir);
        }
        if (n < 3) {
            int tmp = dir.r;
            dir.r = dir.c;
            dir.c = tmp;
            if (corner2.r == 7 && corner2.c == 7) {
                dir.r = -dir.r;
                dir.c = -dir.c;
            }
            if ((tmp = this.countRepetitions(player, loc.add(corner1, dir), loc.add(corner2, dir), n + 1)) > 0) {
                c += tmp - 2 * n;
            }
        }
        return c;
    }

    public int countStablePieces(int player) {
        int sum = 0;
        sum += this.countCornerStablePieces(player, new loc(0, 0), ROW_COUNT, COL_COUNT);
        sum += this.countCornerStablePieces(player, new loc(0, 7), ROW_COUNT, -1);
        sum += this.countCornerStablePieces(player, new loc(7, 0), -1, COL_COUNT);
        sum += this.countCornerStablePieces(player, new loc(7, 7), -1, -1);
        sum -= this.countRepetitions(player, new loc(0, 0), new loc(0, 7), 1);
        sum -= this.countRepetitions(player, new loc(0, 0), new loc(7, 0), 1);
        sum -= this.countRepetitions(player, new loc(0, 7), new loc(7, 7), 1);
        return sum -= this.countRepetitions(player, new loc(7, 0), new loc(7, 7), 1);
    }

    public matrix getGainMatrix() {
        matrix m = new matrix();
        if (this.turn == NO_GAME || this.turn == GAME_OVER) {
            return m;
        }
        int r = 0;
        while (r < ROW_COUNT) {
            int c = 0;
            while (c < COL_COUNT) {
                if (this.b[r][c] != EMPTY) {
                    m.set(r, c, -1);
                } else {
                    this.b[r][c] = this.turn;
                    int iD = -1;
                    while (iD <= 1) {
                        int jD = -1;
                        while (jD <= 1) {
                            if ((iD != 0 || jD != 0) && this.checkInADir(r, c, iD, jD)) {
                                m.set(r, c, m.get(r, c) + this.countInADir(r, c, iD, jD));
                            }
                            ++jD;
                        }
                        ++iD;
                    }
                    this.b[r][c] = EMPTY;
                }
                ++c;
            }
            ++r;
        }
        return m;
    }

    public static int getOpponent(int player) {
        if (player == PLAYER_BLACK) {
            return PLAYER_WHITE;
        }
        return PLAYER_BLACK;
    }

    public int getPieceCount(int player) {
        int c = 0;
        int i = 0;
        while (i < ROW_COUNT) {
            int j = 0;
            while (j < COL_COUNT) {
                if (this.b[i][j] == player) {
                    ++c;
                }
                ++j;
            }
            ++i;
        }
        return c;
    }

    public String getPossibleMoves() {
        String s = "";
        matrix m = this.getGainMatrix();
        int i = 0;
        while (i < ROW_COUNT) {
            int j = 0;
            while (j < COL_COUNT) {
                if (m.get(i, j) > 0) {
                    loc l = new loc(i, j);
                    s = s + l.getStandardForm() + ",";
                }
                ++j;
            }
            ++i;
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    /*
     * Enabled aggressive block sorting
     */
    public matrix getPossibleMovesMatrix() {
        matrix m = this.getGainMatrix();
        int i = 0;
        while (i < matrix.nr) {
            int j = 0;
            while (j < matrix.nc) {
                if (m.get(i, j) > 0) {
                    m.set(i, j, 1);
                } else {
                    m.set(i, j, 0);
                }
                ++j;
            }
            ++i;
        }
        return m;
    }

    public String getStandardFormGame() {
        String s = "";
        int i = 0;
        while (i < this.moveCount) {
            s = s + this.moveHistory[i].getStandardForm();
            s = s + " ";
            ++i;
        }
        return s;
    }

    public String getTurnString() {
        if (this.turn == PLAYER_BLACK) {
            return "Black's Turn";
        }
        if (this.turn == PLAYER_WHITE) {
            return "White's Turn";
        }
        if (this.turn == NO_GAME) {
            return "";
        }
        if (this.turn == GAME_OVER) {
            return "Game Over !!";
        }
        return "";
    }

    private void goInADir(animMatrix am, int rS, int cS, int rD, int cD) {
        int a = this.turn == PLAYER_BLACK ? -1 : 1;
        int rN = rS + rD;
        int cN = cS + cD;
        if (rN < 0 || rN >= ROW_COUNT || cN < 0 || cN >= COL_COUNT || this.b[rN][cN] == this.turn || this.b[rN][cN] == EMPTY) {
            return;
        }
        am.set(rN, cN, a);
        this.goInADir(am, rN, cN, rD, cD);
    }

    public void initBoard() {
        this.makeEmpty();
        this.b[3][3] = PLAYER_WHITE;
        this.b[3][4] = PLAYER_BLACK;
        this.b[4][4] = PLAYER_WHITE;
        this.b[4][3] = PLAYER_BLACK;
        this.turn = PLAYER_BLACK;
    }

    private boolean isEmpty(int i, int j) {
        if (i < 0 || i >= ROW_COUNT || j < 0 || j >= COL_COUNT) {
            return false;
        }
        return this.b[i][j] == EMPTY;
    }

    public boolean isValidMove(int r, int c) {
        int dCount = 0;
        if (this.turn == NO_GAME || this.turn == GAME_OVER || this.b[r][c] != EMPTY) {
            return false;
        }
        this.b[r][c] = this.turn;
        int iD = -1;
        while (iD <= 1) {
            int jD = -1;
            while (jD <= 1) {
                if ((iD != 0 || jD != 0) && this.checkInADir(r, c, iD, jD)) {
                    ++dCount;
                }
                ++jD;
            }
            ++iD;
        }
        this.b[r][c] = EMPTY;
        return dCount != 0;
    }

    public void makeEmpty() {
        int i = 0;
        while (i < ROW_COUNT) {
            int j = 0;
            while (j < COL_COUNT) {
                this.b[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.moveCount = 0;
        this.validMoveCount = 0;
        this.turn = NO_GAME;
    }

    public int performMove(loc l) {
        return this.performMove(l.r, l.c);
    }

    public int performMove(int r, int c) {
        animMatrix am = this.calculateMoveAnimation(r, c);
        am.perform(this, 30);
        return this.correctTurn();
    }

    public void redoAllMoves() {
        if (this.validMoveCount <= 0) {
            return;
        }
        this.moveCount = this.validMoveCount - 1;
        this.copyHistoryToBoard(this.moveCount);
        this.turn = this.turnHistory[this.moveCount];
        this.redoOneMove();
    }

    public boolean redoOneMove() {
        if (this.validMoveCount <= 0) {
            return false;
        }
        if (this.moveCount == this.validMoveCount) {
            return false;
        }
        if (this.moveCount == this.validMoveCount - 1) {
            this.performMove(this.moveHistory[this.moveCount].r, this.moveHistory[this.moveCount].c);
        } else {
            ++this.moveCount;
            this.copyHistoryToBoard(this.moveCount);
            this.turn = this.turnHistory[this.moveCount];
        }
        return true;
    }

    public void setStandardFormGame(String s) {
        String[] sa = s.split(" ");
        this.initBoard();
        int i = 0;
        while (i < sa.length) {
            if (sa[i].length() == 2) {
                this.performMove(new loc(sa[i].toUpperCase()));
            }
            ++i;
        }
    }

    public void showBoard() {
        System.out.println("Current Board Position :");
        System.out.println("  A B C D E F G H");
        int i = 0;
        while (i < ROW_COUNT) {
            System.out.print(i + 1 + " ");
            int j = 0;
            while (j < COL_COUNT) {
                if (this.b[i][j] == EMPTY) {
                    System.out.print("- ");
                } else if (this.b[i][j] == PLAYER_BLACK) {
                    System.out.print("X ");
                } else if (this.b[i][j] == PLAYER_WHITE) {
                    System.out.print("O ");
                } else {
                    System.out.print("? ");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void takeBackAllMoves() {
        if (this.validMoveCount <= 0) {
            return;
        }
        this.moveCount = 0;
        this.copyHistoryToBoard(this.moveCount);
        this.turn = this.turnHistory[this.moveCount];
    }

    public boolean takeBackOneMove() {
        if (this.moveCount <= 0) {
            return false;
        }
        --this.moveCount;
        this.copyHistoryToBoard(this.moveCount);
        this.turn = this.turnHistory[this.moveCount];
        return true;
    }
}

