/*
 * Decompiled with CFR 0.152.
 */
package megamek;

import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import megamek.ConnectDialog;
import megamek.HostDialog;
import megamek.ScenarioDialog;
import megamek.client.AlertDialog;
import megamek.client.BoardEditor;
import megamek.client.BoardView1;
import megamek.client.Client;
import megamek.client.bot.BotClientWrapper;
import megamek.client.bot.BotFactory;
import megamek.common.Compute;
import megamek.common.Game;
import megamek.common.Player;
import megamek.common.Settings;
import megamek.server.ScenarioLoader;
import megamek.server.Server;

public class MegaMek
implements WindowListener,
ActionListener {
    public static String VERSION = "0.28.0";
    public static long TIMESTAMP = new File("timestamp").lastModified();
    public Frame frame;
    public Client client;
    public Server server;

    public MegaMek(Frame frame) {
        this.frame = frame;
        frame.addWindowListener(this);
        if (Settings.windowSizeHeight != 0) {
            ((Component)frame).setLocation(Settings.windowPosX, Settings.windowPosY);
            ((Component)frame).setSize(Settings.windowSizeWidth, Settings.windowSizeHeight);
        } else {
            ((Component)frame).setSize(800, 600);
        }
        ((Component)frame).setBackground(SystemColor.menu);
        frame.setForeground(SystemColor.menuText);
        this.showMainMenu();
        ((Component)frame).setVisible(true);
    }

    public void showMainMenu() {
        Label label = new Label();
        this.frame.removeAll();
        label.setText("MegaMek version " + VERSION);
        Button button = new Button("Host a New Game...");
        button.setActionCommand("game_host");
        button.addActionListener(this);
        Button button2 = new Button("Host a Scenario...");
        button2.setActionCommand("game_scen");
        button2.addActionListener(this);
        Button button3 = new Button("Load a Saved Game...");
        button3.setActionCommand("game_load");
        button3.addActionListener(this);
        Button button4 = new Button("Connect to a Game...");
        button4.setActionCommand("game_connect");
        button4.addActionListener(this);
        Button button5 = new Button("Connect as a Bot...");
        button5.setActionCommand("game_botconnect");
        button5.addActionListener(this);
        Button button6 = new Button("Map Editor");
        button6.setActionCommand("editor");
        button6.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.frame.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        this.addBag(label, gridBagLayout, gridBagConstraints);
        this.addBag(button, gridBagLayout, gridBagConstraints);
        this.addBag(button2, gridBagLayout, gridBagConstraints);
        this.addBag(button4, gridBagLayout, gridBagConstraints);
        this.addBag(button5, gridBagLayout, gridBagConstraints);
        this.addBag(button3, gridBagLayout, gridBagConstraints);
        this.addBag(button6, gridBagLayout, gridBagConstraints);
        this.frame.validate();
    }

    public void showEditor() {
        Game game = new Game();
        this.frame.removeAll();
        BoardView1 boardView1 = new BoardView1(game, this.frame);
        BoardEditor boardEditor = new BoardEditor(this.frame, game.board, boardView1);
        game.board.addBoardListener(boardEditor);
        boardEditor.setSize(120, 120);
        boardEditor.addKeyListener(boardView1);
        boardView1.addKeyListener(boardEditor);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.frame.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.addBag(boardView1, gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(boardEditor, gridBagLayout, gridBagConstraints);
        this.frame.validate();
        new AlertDialog(this.frame, "Please read the editor-readme.txt", "Instructions for using the editor may be found in editor-readme.txt.").show();
    }

    public void host() {
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.show();
        if (hostDialog.name == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        this.server = new Server(hostDialog.serverPass, hostDialog.port);
        this.client = new Client(this.frame, hostDialog.name);
        if (!this.client.connect("localhost", hostDialog.port)) {
            this.server = null;
            this.client = null;
            new AlertDialog(this.frame, "Host a Game", "Error: could not connect to local server.").show();
            return;
        }
        this.client.retrieveServerInfo();
    }

    public void loadGame() {
        FileDialog fileDialog = new FileDialog(this.frame, "Select saved game...", 0);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.show();
        if (hostDialog.name == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        this.server = new Server(hostDialog.serverPass, hostDialog.port);
        if (!this.server.loadGame(new File(fileDialog.getDirectory(), fileDialog.getFile()))) {
            new AlertDialog(this.frame, "Load a Game", "Error: unable to load game file.").show();
            this.server = null;
            return;
        }
        this.client = new Client(this.frame, hostDialog.name);
        if (!this.client.connect("localhost", hostDialog.port)) {
            this.server = null;
            this.client = null;
            new AlertDialog(this.frame, "Load a Game", "Error: could not connect to local server.").show();
            return;
        }
        this.client.retrieveServerInfo();
    }

    public void scenario() {
        FileDialog fileDialog = new FileDialog(this.frame, "Select a scenario file...", 0);
        fileDialog.setDirectory("data" + File.separatorChar + "scenarios");
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".mms");
            }
        };
        fileDialog.setFilenameFilter(filenameFilter);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        ScenarioLoader scenarioLoader = new ScenarioLoader(new File(fileDialog.getDirectory(), fileDialog.getFile()));
        Game game = null;
        try {
            game = scenarioLoader.createGame();
        }
        catch (Exception exception) {
            new AlertDialog(this.frame, "Host Scenario", "Error: " + exception.getMessage()).show();
            return;
        }
        Object[] objectArray = new Player[game.getPlayersVector().size()];
        game.getPlayersVector().copyInto(objectArray);
        ScenarioDialog scenarioDialog = new ScenarioDialog(this.frame, (Player[])objectArray);
        scenarioDialog.show();
        if (!scenarioDialog.bSet) {
            return;
        }
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.yourNameF.setText(scenarioDialog.localName);
        hostDialog.show();
        if (hostDialog.name == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        this.server = new Server(hostDialog.serverPass, hostDialog.port);
        this.server.setGame(game);
        if (scenarioDialog.localName != "") {
            this.client = new Client(this.frame, hostDialog.name);
            if (!this.client.connect("localhost", hostDialog.port)) {
                this.server = null;
                this.client = null;
                new AlertDialog(this.frame, "Host a Game", "Error: could not connect to local server.").show();
                return;
            }
            this.client.retrieveServerInfo();
        }
        int n = 0;
        while (n < objectArray.length) {
            if (scenarioDialog.playerTypes[n] == 2) {
                Frame frame = new Frame("MegaMek Bot");
                Client client = BotFactory.getBot(1, frame, ((Player)objectArray[n]).getName());
                client.connect("localhost", hostDialog.port);
                client.retrieveServerInfo();
                ((BotClientWrapper)client).initialize();
            }
            ++n;
        }
    }

    public void connect() {
        ConnectDialog connectDialog = new ConnectDialog(this.frame);
        connectDialog.show();
        if (connectDialog.name == null || connectDialog.serverAddr == null || connectDialog.port == 0) {
            return;
        }
        this.client = new Client(this.frame, connectDialog.name);
        if (!this.client.connect(connectDialog.serverAddr, connectDialog.port)) {
            this.server = null;
            this.client = null;
            new AlertDialog(this.frame, "Connect to a Game", "Error: could not connect.").show();
            return;
        }
        this.client.retrieveServerInfo();
    }

    public void connectBot() {
        ConnectDialog connectDialog = new ConnectDialog(this.frame);
        connectDialog.show();
        if (connectDialog.name == null || connectDialog.serverAddr == null || connectDialog.port == 0) {
            return;
        }
        this.client = BotFactory.getBot(1, this.frame, connectDialog.name);
        if (!this.client.connect(connectDialog.serverAddr, connectDialog.port)) {
            this.server = null;
            this.client = null;
            new AlertDialog(this.frame, "Connect to a Game", "Error: could not connect.").show();
            return;
        }
        this.client.retrieveServerInfo();
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.frame.add(component);
    }

    private static void testDice() {
        long l = 100000000L;
        int n = 14;
        long[] lArray = new long[n];
        System.out.println("testing dice, " + l + " rolls...");
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        while (l3 < l) {
            int n2 = Compute.d6(2);
            lArray[n2] = lArray[n2] + 1L;
            ++l3;
        }
        long l4 = System.currentTimeMillis();
        System.out.println("done testing dice in " + (l4 - l2) + " ms.");
        int n3 = 0;
        while (n3 < n) {
            System.out.println("hits on " + n3 + " : " + lArray[n3] + "; probability = " + (double)lArray[n3] / (double)l);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = "MegaMek.log";
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-testdice")) {
                MegaMek.testDice();
                return;
            }
            if (stringArray[n].equals("-dedicated")) {
                new Server(Settings.lastServerPass, Settings.lastServerPort);
                return;
            }
            if (stringArray[n].equals("-log")) {
                string = ++n >= stringArray.length || stringArray[n].equals("none") || stringArray[n].equals("off") ? null : stringArray[n];
            }
            ++n;
        }
        if (string != null) {
            try {
                System.out.println("Redirecting output to " + string);
                object = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
                System.setOut((PrintStream)object);
                System.setErr((PrintStream)object);
            }
            catch (Exception exception) {
                System.err.println("Unable to redirect output to " + string);
                exception.printStackTrace();
            }
        }
        Settings.load();
        object = new Frame("MegaMek");
        MegaMek megaMek = new MegaMek((Frame)object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("editor")) {
            this.showEditor();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("game_host")) {
            this.host();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("game_scen")) {
            this.scenario();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("game_connect")) {
            this.connect();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("game_botconnect")) {
            this.connectBot();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("game_load")) {
            this.loadGame();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        Settings.windowPosX = this.frame.getLocation().x;
        Settings.windowPosY = this.frame.getLocation().y;
        Settings.windowSizeWidth = this.frame.getSize().width;
        Settings.windowSizeHeight = this.frame.getSize().height;
        if (this.client != null && this.client.minimapW != null && this.client.minimapW.getSize().width != 0 && this.client.minimapW.getSize().height != 0) {
            Settings.minimapPosX = this.client.minimapW.getLocation().x;
            Settings.minimapPosY = this.client.minimapW.getLocation().y;
            Settings.minimapSizeWidth = this.client.minimapW.getSize().width;
            Settings.minimapSizeHeight = this.client.minimapW.getSize().height;
        }
        Settings.save();
        if (this.client != null) {
            this.client.die();
        } else {
            System.exit(0);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

