/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import megamek.client.AlertDialog;
import megamek.client.Client;
import megamek.common.MapSettings;

public class BoardSelectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    private Client client;
    private MapSettings mapSettings;
    private Panel panMapSize = new Panel();
    private Label labBoardSize = new Label("Board Size (hexes):", 2);
    private Label labBoardDivider = new Label("x", 1);
    private TextField texBoardWidth = new TextField(2);
    private TextField texBoardHeight = new TextField(2);
    private Label labMapSize = new Label("Map Size (boards):", 2);
    private Label labMapDivider = new Label("x", 1);
    private TextField texMapWidth = new TextField(2);
    private TextField texMapHeight = new TextField(2);
    private ScrollPane scrMapButtons = new ScrollPane(0);
    private Panel panMapButtons = new Panel();
    private Panel panBoardsSelected = new Panel();
    private Label labBoardsSelected = new Label("Maps Selected:", 1);
    private List lisBoardsSelected = new List(10, true);
    private Checkbox chkSelectAll = new Checkbox("Select All");
    private Button butChange = new Button("<<");
    private Panel panBoardsAvailable = new Panel();
    private Label labBoardsAvailable = new Label("Maps Available :", 1);
    private List lisBoardsAvailable = new List(12);
    private Panel panButtons = new Panel();
    private Button butUpdate = new Button("Update Size Settings");
    private Label labButtonSpace = new Label("", 1);
    private Button butOkay = new Button("Okay");
    private Button butCancel = new Button("Cancel");

    public BoardSelectionDialog(Client client) {
        super(client.frame, "Edit Board Layout...", true);
        this.client = client;
        this.mapSettings = (MapSettings)client.getMapSettings().clone();
        this.setResizable(true);
        this.setupMapSize();
        this.setupSelected();
        this.setupAvailable();
        this.setupButtons();
        this.butChange.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panMapSize, gridBagConstraints);
        this.add(this.panMapSize);
        gridBagLayout.setConstraints(this.panBoardsSelected, gridBagConstraints);
        this.add(this.panBoardsSelected);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.butChange, gridBagConstraints);
        this.add(this.butChange);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.panBoardsAvailable, gridBagConstraints);
        this.add(this.panBoardsAvailable);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)BoardSelectionDialog.this).setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        ((Component)this).setLocation(client.frame.getLocation().x + client.frame.getSize().width / 2 - this.getSize().width / 2, client.frame.getLocation().y + client.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupMapSize() {
        this.refreshMapSize();
        this.refreshMapButtons();
        this.scrMapButtons.add(this.panMapButtons);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panMapSize.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labBoardSize, gridBagConstraints);
        this.panMapSize.add(this.labBoardSize);
        gridBagLayout.setConstraints(this.texBoardWidth, gridBagConstraints);
        this.panMapSize.add(this.texBoardWidth);
        gridBagLayout.setConstraints(this.labBoardDivider, gridBagConstraints);
        this.panMapSize.add(this.labBoardDivider);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.texBoardHeight, gridBagConstraints);
        this.panMapSize.add(this.texBoardHeight);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labMapSize, gridBagConstraints);
        this.panMapSize.add(this.labMapSize);
        gridBagLayout.setConstraints(this.texMapWidth, gridBagConstraints);
        this.panMapSize.add(this.texMapWidth);
        gridBagLayout.setConstraints(this.labMapDivider, gridBagConstraints);
        this.panMapSize.add(this.labMapDivider);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.texMapHeight, gridBagConstraints);
        this.panMapSize.add(this.texMapHeight);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.scrMapButtons, gridBagConstraints);
        this.panMapSize.add(this.scrMapButtons);
    }

    private void setupSelected() {
        this.refreshBoardsSelected();
        this.lisBoardsSelected.addItemListener(this);
        this.chkSelectAll.addItemListener(this);
        this.panBoardsSelected.setLayout(new BorderLayout());
        this.panBoardsSelected.add((Component)this.labBoardsSelected, "North");
        this.panBoardsSelected.add((Component)this.lisBoardsSelected, "Center");
        this.panBoardsSelected.add((Component)this.chkSelectAll, "South");
    }

    private void setupAvailable() {
        this.refreshBoardsAvailable();
        this.lisBoardsAvailable.addActionListener(this);
        this.panBoardsAvailable.setLayout(new BorderLayout());
        this.panBoardsAvailable.add((Component)this.labBoardsAvailable, "North");
        this.panBoardsAvailable.add((Component)this.lisBoardsAvailable, "Center");
    }

    private void setupButtons() {
        this.butUpdate.addActionListener(this);
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butUpdate, gridBagConstraints);
        this.panButtons.add(this.butUpdate);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.labButtonSpace, gridBagConstraints);
        this.panButtons.add(this.labButtonSpace);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void refreshMapSize() {
        this.texBoardWidth.setText(new Integer(this.mapSettings.getBoardWidth()).toString());
        this.texBoardHeight.setText(new Integer(this.mapSettings.getBoardHeight()).toString());
        this.texMapWidth.setText(new Integer(this.mapSettings.getMapWidth()).toString());
        this.texMapHeight.setText(new Integer(this.mapSettings.getMapHeight()).toString());
    }

    private void refreshMapButtons() {
        this.panMapButtons.removeAll();
        this.panMapButtons.setLayout(new GridLayout(this.mapSettings.getMapHeight(), this.mapSettings.getMapWidth()));
        int n = 0;
        while (n < this.mapSettings.getMapHeight()) {
            int n2 = 0;
            while (n2 < this.mapSettings.getMapWidth()) {
                Button button = new Button(new Integer(n * this.mapSettings.getMapWidth() + n2).toString());
                button.addActionListener(this);
                this.panMapButtons.add(button);
                ++n2;
            }
            ++n;
        }
        this.scrMapButtons.validate();
    }

    private void refreshBoardsSelected() {
        this.lisBoardsSelected.removeAll();
        int n = 0;
        Enumeration enumeration = this.mapSettings.getBoardsSelected();
        while (enumeration.hasMoreElements()) {
            this.lisBoardsSelected.add(n++ + ": " + (String)enumeration.nextElement());
        }
        this.lisBoardsSelected.select(0);
        this.refreshSelectAllCheck();
    }

    private void refreshSelectAllCheck() {
        this.chkSelectAll.setState(this.lisBoardsSelected.getSelectedIndexes().length == this.lisBoardsSelected.getItemCount());
    }

    private void refreshBoardsAvailable() {
        this.lisBoardsAvailable.removeAll();
        Enumeration enumeration = this.mapSettings.getBoardsAvailable();
        while (enumeration.hasMoreElements()) {
            this.lisBoardsAvailable.add((String)enumeration.nextElement());
        }
    }

    private void change(String string) {
        int[] nArray = this.lisBoardsSelected.getSelectedIndexes();
        int n = 0;
        while (n < nArray.length) {
            this.lisBoardsSelected.replaceItem(nArray[n] + ": " + string, nArray[n]);
            this.mapSettings.getBoardsSelectedVector().setElementAt(string, nArray[n]);
            this.lisBoardsSelected.select(nArray[n]);
            ++n;
        }
    }

    private void apply() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = Integer.parseInt(this.texBoardWidth.getText());
            n3 = Integer.parseInt(this.texBoardHeight.getText());
            n2 = Integer.parseInt(this.texMapWidth.getText());
            n = Integer.parseInt(this.texMapHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            new AlertDialog(this.client.frame, "Invalid Map Size", "Invalid number in map size settings.").show();
            return;
        }
        if (n3 <= 0 || n3 <= 0 || n2 <= 0 || n <= 0) {
            new AlertDialog(this.client.frame, "Invalid Map Size", "All map size settings must be greater than 0.").show();
            return;
        }
        this.butOkay.setEnabled(false);
        this.mapSettings.setBoardSize(n4, n3);
        this.mapSettings.setMapSize(n2, n);
        this.refreshMapSize();
        this.refreshMapButtons();
        this.lisBoardsSelected.removeAll();
        this.lisBoardsSelected.add("Updating...");
        this.lisBoardsAvailable.removeAll();
        this.lisBoardsAvailable.add("Updating...");
        this.client.sendMapQuery(this.mapSettings);
    }

    public void update(MapSettings mapSettings, boolean bl) {
        this.mapSettings = (MapSettings)mapSettings.clone();
        if (bl) {
            this.refreshMapSize();
            this.refreshMapButtons();
        }
        this.refreshBoardsSelected();
        this.refreshBoardsAvailable();
        this.butOkay.setEnabled(true);
    }

    public void send() {
        if (!(this.texBoardWidth.getText().equals(Integer.toString(this.mapSettings.getBoardWidth())) && this.texBoardHeight.getText().equals(Integer.toString(this.mapSettings.getBoardHeight())) && this.texMapWidth.getText().equals(Integer.toString(this.mapSettings.getMapWidth())) && this.texMapHeight.getText().equals(Integer.toString(this.mapSettings.getMapHeight())))) {
            new AlertDialog(this.client.frame, "Please Update Map Size", "Please hit the Update Map Size button after changing map size settings.").show();
            return;
        }
        if (this.mapSettings.getBoardsAvailableVector().size() <= 0) {
            new AlertDialog(this.client.frame, "No Boards of Selected Size", "There are no boards of the selected size.  Please select a valid size.").show();
            return;
        }
        this.client.sendMapSettings(this.mapSettings);
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butChange || actionEvent.getSource() == this.lisBoardsAvailable) {
            if (this.lisBoardsAvailable.getSelectedIndex() != -1) {
                this.change(this.lisBoardsAvailable.getSelectedItem());
            }
        } else if (actionEvent.getSource() == this.butUpdate) {
            this.apply();
        } else if (actionEvent.getSource() == this.butOkay) {
            this.send();
        } else if (actionEvent.getSource() == this.butCancel) {
            ((Component)this).setVisible(false);
        } else {
            try {
                if (actionEvent.getModifiers() == 0) {
                    int[] nArray = this.lisBoardsSelected.getSelectedIndexes();
                    int n = 0;
                    while (n < nArray.length) {
                        this.lisBoardsSelected.deselect(nArray[n]);
                        ++n;
                    }
                }
                this.lisBoardsSelected.select(Integer.parseInt(actionEvent.getActionCommand()));
                this.refreshSelectAllCheck();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chkSelectAll) {
            int n = 0;
            while (n < this.lisBoardsSelected.getItemCount()) {
                if (this.chkSelectAll.getState()) {
                    this.lisBoardsSelected.select(n);
                } else {
                    this.lisBoardsSelected.deselect(n);
                }
                ++n;
            }
        } else if (itemEvent.getSource() == this.lisBoardsSelected) {
            this.refreshSelectAllCheck();
        }
    }
}

