/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.TreeSet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.AbstractPhaseDisplay;
import megamek.client.Client;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.WeaponAttackAction;

public class FiringDisplay
extends AbstractPhaseDisplay
implements BoardListener,
GameListener,
ActionListener,
KeyListener,
ComponentListener,
MouseListener,
ItemListener {
    private static final int NUM_BUTTON_LAYOUTS = 2;
    public Client client;
    private Label labStatus;
    private Container panButtons;
    private Button butFire;
    private Button butTwist;
    private Button butSkip;
    private Button butAim;
    private Button butFindClub;
    private Button butNextTarg;
    private Button butFlipArms;
    private Button butSpace;
    private Button butSpace1;
    private Button butFireMode;
    private Button butNext;
    private Button butDone;
    private Button butMore;
    private int buttonLayout;
    private int cen;
    private int ten;
    private int selectedWeapon;
    private Vector attacks;
    private boolean shiftheld;
    private boolean twisting;
    private Entity[] visibleTargets = null;
    private int lastTargetID = -1;
    private int turnInfMoved = 0;

    public FiringDisplay(Client client) {
        this.client = client;
        client.addGameListener(this);
        client.game.board.addBoardListener(this);
        this.shiftheld = false;
        this.attacks = new Vector();
        this.labStatus = new Label("Waiting to begin Weapon Attack phase...", 1);
        this.butFire = new Button("Fire");
        this.butFire.addActionListener(this);
        this.butFire.setEnabled(false);
        this.butSkip = new Button("Skip");
        this.butSkip.addActionListener(this);
        this.butSkip.setEnabled(false);
        this.butTwist = new Button("Twist");
        this.butTwist.addActionListener(this);
        this.butTwist.setEnabled(false);
        this.butFindClub = new Button("Find Club");
        this.butFindClub.addActionListener(this);
        this.butFindClub.setEnabled(false);
        this.butAim = new Button("Aim");
        this.butAim.addActionListener(this);
        this.butAim.setEnabled(false);
        this.butNextTarg = new Button("Next Target");
        this.butNextTarg.addActionListener(this);
        this.butNextTarg.setEnabled(false);
        this.butFlipArms = new Button("Flip Arms");
        this.butFlipArms.addActionListener(this);
        this.butFlipArms.setEnabled(false);
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butSpace1 = new Button(".");
        this.butSpace1.setEnabled(false);
        this.butFireMode = new Button("Mode");
        this.butFireMode.addActionListener(this);
        this.butFireMode.setEnabled(false);
        this.butDone = new Button("Done");
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butNext = new Button(" Next Unit ");
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butMore = new Button("More...");
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(client.bv, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.labStatus, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(client.cb.getComponent(), gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
        client.mechD.addMouseListener(this);
        client.mechD.wPan.weaponList.addItemListener(this);
        client.mechD.wPan.weaponList.addKeyListener(this);
        client.frame.addComponentListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(2, 4));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butFire);
                this.panButtons.add(this.butSkip);
                this.panButtons.add(this.butNextTarg);
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butTwist);
                this.panButtons.add(this.butFlipArms);
                this.panButtons.add(this.butMore);
                this.panButtons.add(this.butDone);
                break;
            }
            case 1: {
                this.panButtons.add(this.butAim);
                this.panButtons.add(this.butFindClub);
                this.panButtons.add(this.butSpace);
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butSpace1);
                this.panButtons.add(this.butFireMode);
                this.panButtons.add(this.butMore);
                this.panButtons.add(this.butDone);
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        boolean bl = this.client.game.getOptions().booleanOption("inf_move_last");
        boolean bl2 = this.client.game.getOptions().booleanOption("inf_move_multi");
        if (this.client.game.getEntity(n) != null) {
            this.cen = n;
            boolean bl3 = this.ce() instanceof Infantry;
            if (!bl3 && bl2 && this.turnInfMoved % 3 > 0) {
                int n2 = this.client.getNextEntityNum(n);
                while (n2 != n) {
                    if (this.client.game.getEntity(n2) instanceof Infantry) {
                        this.cen = n2;
                        bl3 = true;
                        break;
                    }
                    n2 = this.client.getNextEntityNum(n2);
                }
                if (!bl3) {
                    this.turnInfMoved = 0;
                }
            }
            this.target(-1);
            this.client.game.board.highlight(this.ce().getPosition());
            this.client.game.board.select(null);
            this.client.game.board.cursor(null);
            this.refreshAll();
            this.cacheVisibleTargets();
            this.client.bv.centerOnHex(this.ce().getPosition());
            this.butTwist.setEnabled(this.ce().canChangeSecondaryFacing());
            this.butFindClub.setEnabled(Compute.canMechFindClub(this.client.game, n));
            this.butFlipArms.setEnabled(this.ce().canFlipArms());
        } else {
            System.err.println("FiringDisplay: tried to select non-existant entity: " + n);
            System.err.println("FiringDisplay: sending ready signal...");
            this.client.sendReady(true);
        }
    }

    private void beginMyTurn() {
        this.ten = -1;
        this.butNext.setEnabled(true);
        this.butDone.setEnabled(true);
        this.butMore.setEnabled(true);
        this.butFireMode.setEnabled(true);
        ((Component)this.client.mechW).setVisible(true);
        this.moveMechDisplay();
        this.client.game.board.select(null);
        this.client.game.board.highlight(null);
        this.selectEntity(this.client.getFirstEntityNum());
    }

    private void endMyTurn() {
        this.cen = -1;
        this.ten = -1;
        this.target(-1);
        this.client.game.board.select(null);
        this.client.game.board.highlight(null);
        this.client.game.board.cursor(null);
        ((Component)this.client.mechW).setVisible(false);
        this.client.bv.clearMovementData();
        this.disableButtons();
        this.clearVisibleTargets();
    }

    private void disableButtons() {
        this.butFire.setEnabled(false);
        this.butSkip.setEnabled(false);
        this.butTwist.setEnabled(false);
        this.butAim.setEnabled(false);
        this.butFindClub.setEnabled(false);
        this.butMore.setEnabled(false);
        this.butNext.setEnabled(false);
        this.butDone.setEnabled(false);
        this.butNextTarg.setEnabled(false);
        this.butFlipArms.setEnabled(false);
        this.butFireMode.setEnabled(false);
    }

    private void changeMode() {
        int n = this.client.mechD.wPan.getSelectedWeaponNum();
        Mounted mounted = this.ce().getEquipment(n);
        int n2 = mounted.switchMode();
        this.client.sendModeChange(this.ce().getId(), n, n2);
        if (mounted.getType().hasInstantModeSwitch()) {
            this.client.cb.systemMessage("Switched " + mounted.getName() + " to " + mounted.curMode());
        } else {
            this.client.cb.systemMessage(mounted.getName() + " will switch to " + mounted.pendingMode() + " at end of turn.");
        }
        this.client.mechD.wPan.displayMech(this.ce());
        this.client.mechD.wPan.selectWeapon(n);
    }

    private void cacheVisibleTargets() {
        this.clearVisibleTargets();
        Vector vector = this.client.game.getValidTargets(this.ce());
        Coords coords = this.ce().getPosition();
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Entity entity = (Entity)object;
                Entity entity2 = (Entity)object2;
                int n2 = FiringDisplay.this.ce().getPosition().distance(entity.getPosition());
                if (n2 == (n = FiringDisplay.this.ce().getPosition().distance(entity2.getPosition()))) {
                    return entity.getId() < entity2.getId() ? -1 : 1;
                }
                return n2 < n ? -1 : 1;
            }
        };
        TreeSet treeSet = new TreeSet(comparator);
        this.visibleTargets = new Entity[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            treeSet.add((Object)((Entity)vector.elementAt(n)));
            ++n;
        }
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.visibleTargets[n2++] = (Entity)iterator.next();
        }
        this.butNextTarg.setEnabled(this.visibleTargets.length > 0);
    }

    private void clearVisibleTargets() {
        this.visibleTargets = null;
        this.lastTargetID = -1;
        this.butNextTarg.setEnabled(false);
    }

    private Entity getNextTarget() {
        if (null == this.visibleTargets) {
            return null;
        }
        ++this.lastTargetID;
        if (this.lastTargetID >= this.visibleTargets.length) {
            this.lastTargetID = 0;
        }
        return this.visibleTargets[this.lastTargetID];
    }

    private void jumpToNextTarget() {
        Entity entity = this.getNextTarget();
        if (null == entity) {
            return;
        }
        this.client.bv.centerOnHex(entity.getPosition());
        this.client.game.board.select(entity.getPosition());
        this.target(entity.getId());
    }

    private void ready() {
        if (this.cen == -1) {
            return;
        }
        this.disableButtons();
        this.client.sendAttackData(this.cen, this.attacks);
        this.attacks.removeAllElements();
        if (this.ce() instanceof Infantry) {
            ++this.turnInfMoved;
        }
        this.client.sendEntityReady(this.cen);
        this.client.sendReady(true);
    }

    private void fire() {
        int n = this.client.mechD.wPan.getSelectedWeaponNum();
        if (this.ce() == null || this.te() == null || this.ce().getEquipment(n) == null || !(this.ce().getEquipment(n).getType() instanceof WeaponType)) {
            throw new IllegalArgumentException("current fire parameters are invalid");
        }
        Mounted mounted = this.ce().getEquipment(n);
        WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.cen, this.ten, n);
        if (((WeaponType)mounted.getType()).getAmmoType() != -1) {
            weaponAttackAction.setAmmoId(this.ce().getEquipmentNum(mounted.getLinked()));
        }
        this.attacks.addElement(weaponAttackAction);
        this.ce().getEquipment(n).setUsedThisRound(true);
        this.selectedWeapon = this.ce().getNextWeapon(n);
        if (this.selectedWeapon == -1) {
            this.ready();
            return;
        }
        this.client.mechD.wPan.displayMech(this.ce());
        this.client.mechD.wPan.selectWeapon(this.selectedWeapon);
        this.updateTarget();
        this.butNext.setEnabled(false);
    }

    private void nextWeapon() {
        this.selectedWeapon = this.ce().getNextWeapon(this.client.mechD.wPan.getSelectedWeaponNum());
        if (this.selectedWeapon == -1) {
            return;
        }
        this.client.mechD.wPan.displayMech(this.ce());
        this.client.mechD.wPan.selectWeapon(this.selectedWeapon);
        this.updateTarget();
    }

    private void findClub() {
        if (this.ce() == null) {
            return;
        }
        this.attacks.removeAllElements();
        this.attacks.addElement(new FindClubAction(this.cen));
        this.ready();
    }

    private void clearAttacks() {
        if (this.attacks.size() > 0) {
            Enumeration enumeration = this.attacks.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof WeaponAttackAction)) continue;
                WeaponAttackAction weaponAttackAction = (WeaponAttackAction)e;
                this.ce().getEquipment(weaponAttackAction.getWeaponId()).setUsedThisRound(false);
            }
            this.attacks.removeAllElements();
        }
        this.ce().setSecondaryFacing(this.ce().getFacing());
        this.ce().setArmsFlipped(false);
    }

    private void refreshAll() {
        this.client.bv.redrawEntity(this.ce());
        this.client.mechD.displayEntity(this.ce());
        this.client.mechD.showPanel("weapons");
        this.selectedWeapon = this.ce().getFirstWeapon();
        this.client.mechD.wPan.selectWeapon(this.selectedWeapon);
        this.updateTarget();
    }

    void target(int n) {
        this.ten = n;
        this.updateTarget();
    }

    private void updateTarget() {
        this.butFire.setEnabled(false);
        if (this.ce() != null && !this.ce().equals(this.client.mechD.getCurrentEntity())) {
            this.client.mechD.displayEntity(this.ce());
        }
        int n = this.client.mechD.wPan.getSelectedWeaponNum();
        if (this.ten != -1 && n != -1) {
            ToHitData toHitData = Compute.toHitWeapon(this.client.game, this.cen, this.ten, n, this.attacks);
            this.client.mechD.wPan.wTargetR.setText(this.te().getDisplayName());
            this.client.mechD.wPan.wRangeR.setText("" + this.ce().getPosition().distance(this.te().getPosition()));
            Mounted mounted = this.ce().getEquipment(n);
            if (mounted.isUsedThisRound()) {
                this.client.mechD.wPan.wToHitR.setText("Already fired");
                this.butFire.setEnabled(false);
            } else if (mounted.getType().hasFlag(16)) {
                this.client.mechD.wPan.wToHitR.setText("Auto-firing weapon");
                this.butFire.setEnabled(false);
            } else if (toHitData.getValue() == Integer.MAX_VALUE) {
                this.client.mechD.wPan.wToHitR.setText(toHitData.getValueAsString());
                this.butFire.setEnabled(false);
            } else if (toHitData.getValue() == 0x7FFFFFFE) {
                this.client.mechD.wPan.wToHitR.setText(toHitData.getValueAsString());
                this.butFire.setEnabled(true);
            } else {
                this.client.mechD.wPan.wToHitR.setText(toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)");
                this.butFire.setEnabled(true);
            }
            this.client.mechD.wPan.toHitText.setText(toHitData.getDesc());
            this.butSkip.setEnabled(true);
        } else {
            this.client.mechD.wPan.wTargetR.setText("---");
            this.client.mechD.wPan.wRangeR.setText("---");
            this.client.mechD.wPan.wToHitR.setText("---");
            this.client.mechD.wPan.toHitText.setText("");
        }
    }

    private void torsoTwist(Coords coords) {
        int n = this.ce().getFacing();
        if (null != coords) {
            n = this.ce().clipSecondaryFacing(this.ce().getPosition().direction(coords));
        }
        if (n != this.ce().getSecondaryFacing()) {
            this.clearAttacks();
            this.attacks.addElement(new TorsoTwistAction(this.cen, n));
            this.ce().setSecondaryFacing(n);
            this.refreshAll();
        }
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    private Entity te() {
        return this.client.game.getEntity(this.ten);
    }

    private void moveMechDisplay() {
        if (this.client.bv.isShowing()) {
            ((Component)this.client.mechW).setLocation(this.client.bv.getLocationOnScreen().x + this.client.bv.getSize().width - this.client.mechD.getSize().width - 20, this.client.bv.getLocationOnScreen().y + 20);
        }
    }

    public void boardHexMoused(BoardEvent boardEvent) {
        if (!this.client.isMyTurn() || (boardEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.shiftheld != ((boardEvent.getModifiers() & 1) != 0)) {
            boolean bl = this.shiftheld = (boardEvent.getModifiers() & 1) != 0;
        }
        if (boardEvent.getType() == 2) {
            if (this.shiftheld || this.twisting) {
                this.updateFlipArms(false);
                this.torsoTwist(boardEvent.getCoords());
            }
            this.client.game.board.cursor(boardEvent.getCoords());
        } else if (boardEvent.getType() == 0) {
            this.twisting = false;
            this.client.game.board.select(boardEvent.getCoords());
        }
    }

    public void boardHexSelected(BoardEvent boardEvent) {
        if (this.client.isMyTurn() && boardEvent.getCoords() != null && this.ce() != null && !boardEvent.getCoords().equals(this.ce().getPosition())) {
            if (this.shiftheld) {
                this.updateFlipArms(false);
                this.torsoTwist(boardEvent.getCoords());
            } else if (this.client.game.getFirstEntity(boardEvent.getCoords()) != null) {
                this.target(this.client.game.getFirstEntity(boardEvent.getCoords()).getId());
            } else {
                this.target(Game.CoordsToId(boardEvent.getCoords()));
            }
        }
    }

    public void gameTurnChange(GameEvent gameEvent) {
        if (this.client.game.phase == 7) {
            this.endMyTurn();
            if (this.client.isMyTurn()) {
                this.beginMyTurn();
                this.labStatus.setText("It's your turn to fire.");
            } else {
                this.labStatus.setText("It's " + gameEvent.getPlayer().getName() + "'s turn to fire.");
            }
        }
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        if (this.client.isMyTurn() && this.client.game.phase != 7) {
            this.endMyTurn();
        }
        if (this.client.game.phase != 7) {
            this.client.bv.clearAllAttacks();
            this.client.removeGameListener(this);
            this.client.game.board.removeBoardListener(this);
            this.client.mechD.removeMouseListener(this);
            this.client.mechD.wPan.weaponList.removeItemListener(this);
            this.client.mechD.wPan.weaponList.removeKeyListener(this);
            this.client.frame.removeComponentListener(this);
            this.client.bv.removeKeyListener(this);
            this.client.cb.getComponent().removeKeyListener(this);
            this.turnInfMoved = 0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.ready();
        } else if (actionEvent.getSource() == this.butFire) {
            this.fire();
        } else if (actionEvent.getSource() == this.butSkip) {
            this.nextWeapon();
        } else if (actionEvent.getSource() == this.butTwist) {
            this.twisting = true;
        } else if (actionEvent.getSource() == this.butNext) {
            this.clearAttacks();
            this.refreshAll();
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getSource() == this.butMore) {
            ++this.buttonLayout;
            this.buttonLayout %= 2;
            this.setupButtonPanel();
        } else if (actionEvent.getSource() == this.butFindClub) {
            this.findClub();
        } else if (actionEvent.getSource() == this.butNextTarg) {
            this.jumpToNextTarget();
        } else if (actionEvent.getSource() == this.butFlipArms) {
            this.updateFlipArms(!this.ce().getArmsFlipped());
        } else if (actionEvent.getSource() == this.butFireMode) {
            this.changeMode();
        }
    }

    private void updateFlipArms(boolean bl) {
        if (bl == this.ce().getArmsFlipped()) {
            return;
        }
        this.twisting = false;
        this.torsoTwist(null);
        this.clearAttacks();
        this.ce().setArmsFlipped(bl);
        this.attacks.addElement(new FlipArmsAction(this.cen, bl));
        this.updateTarget();
        this.refreshAll();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.clearAttacks();
            this.client.game.board.select(null);
            this.client.game.board.cursor(null);
            this.refreshAll();
        }
        if (keyEvent.getKeyCode() != 10 || !keyEvent.isControlDown() || this.client.isMyTurn()) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 16 && !this.shiftheld) {
            this.shiftheld = true;
            if (this.client.isMyTurn() && this.client.game.board.lastCursor != null) {
                this.updateFlipArms(false);
                this.torsoTwist(this.client.game.board.lastCursor);
            }
        }
        if (keyEvent.getKeyCode() == 77) {
            this.changeMode();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16 && this.shiftheld) {
            this.shiftheld = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentShown(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
        this.moveMechDisplay();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.client.mechD.wPan.weaponList) {
            this.updateTarget();
        }
    }
}

