/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import megamek.client.ArmorPanel;
import megamek.client.Client;
import megamek.client.MovementPanel;
import megamek.client.SystemPanel;
import megamek.client.WeaponPanel;
import megamek.common.Entity;

public class MechDisplay
extends Panel
implements ActionListener {
    public Button movBut;
    public Button armBut;
    public Button weaBut;
    public Button criBut;
    public Panel displayP;
    public MovementPanel mPan;
    public ArmorPanel aPan;
    public WeaponPanel wPan;
    public SystemPanel sPan;
    private Client client;
    private Entity currentlyDisplaying = null;

    public MechDisplay(Client client) {
        super(new GridBagLayout());
        this.client = client;
        this.movBut = new Button("Movement");
        this.movBut.addActionListener(this);
        this.armBut = new Button("Armor");
        this.armBut.addActionListener(this);
        this.weaBut = new Button("Weapons");
        this.weaBut.addActionListener(this);
        this.criBut = new Button("Systems");
        this.criBut.addActionListener(this);
        this.displayP = new Panel(new CardLayout());
        this.mPan = new MovementPanel();
        this.displayP.add("movement", this.mPan);
        this.aPan = new ArmorPanel();
        this.displayP.add("armor", this.aPan);
        this.wPan = new WeaponPanel(client);
        this.displayP.add("weapons", this.wPan);
        this.sPan = new SystemPanel(client);
        this.displayP.add("systems", this.sPan);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.movBut, gridBagConstraints);
        this.addBag(this.armBut, gridBagConstraints);
        this.addBag(this.weaBut, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.criBut, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.displayP, gridBagConstraints);
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, "movement");
    }

    public void addBag(Component component, GridBagConstraints gridBagConstraints) {
        ((GridBagLayout)this.getLayout()).setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void displayMech(Entity entity) {
        this.displayEntity(entity);
    }

    public void displayEntity(Entity entity) {
        this.currentlyDisplaying = entity;
        boolean bl = entity.getOwner() == this.client.getLocalPlayer();
        this.mPan.displayMech(entity);
        this.aPan.displayMech(entity);
        this.wPan.displayMech(entity);
        this.sPan.displayMech(entity);
    }

    public Entity getCurrentEntity() {
        return this.currentlyDisplaying;
    }

    public void showPanel(String string) {
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("movement")) {
            this.showPanel("movement");
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("armor")) {
            this.showPanel("armor");
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("weapons")) {
            this.showPanel("weapons");
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("systems")) {
            this.showPanel("systems");
        }
    }
}

