/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import megamek.client.Client;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.TechConstants;

public class MechSelectorDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener {
    private static final int KEY_TIMEOUT = 1000;
    private String[] m_saSorts = new String[]{"Name", "Ref", "Weight", "BV", "Year"};
    private MechSummary[] m_mechsCurrent;
    private Client m_client;
    private StringBuffer m_sbSearch = new StringBuffer();
    private long m_nLastSearch = 0L;
    private Label m_labelWeightClass = new Label("Weight Class: ", 2);
    private Choice m_chWeightClass = new Choice();
    private Label m_labelType = new Label("Type: ", 2);
    private Choice m_chType = new Choice();
    private Label m_labelSort = new Label("Sort: ", 2);
    private Choice m_chSort = new Choice();
    private Panel m_pParams = new Panel();
    List m_mechList = new List(10);
    private Button m_bPick = new Button("Select Mech");
    private Button m_bCancel = new Button("Cancel");
    private Panel m_pButtons = new Panel();
    private static final String SPACES = "                        ";

    public MechSelectorDialog(Client client) {
        super(client.frame, "Select Mech...", true);
        this.m_client = client;
        int n = 0;
        while (n < this.m_saSorts.length) {
            this.m_chSort.addItem(this.m_saSorts[n]);
            ++n;
        }
        this.m_pParams.setLayout(new GridLayout(3, 2));
        this.m_pParams.add(this.m_labelWeightClass);
        this.m_pParams.add(this.m_chWeightClass);
        this.m_pParams.add(this.m_labelType);
        this.m_pParams.add(this.m_chType);
        this.m_pParams.add(this.m_labelSort);
        this.m_pParams.add(this.m_chSort);
        this.m_pButtons.setLayout(new FlowLayout(1));
        this.m_pButtons.add(this.m_bPick);
        this.m_pButtons.add(this.m_bCancel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_pParams, "North");
        this.m_mechList.setFont(new Font("Courier", 0, 12));
        this.m_mechList.addKeyListener(this);
        this.add((Component)this.m_mechList, "Center");
        this.add((Component)this.m_pButtons, "South");
        this.m_chWeightClass.addItemListener(this);
        this.m_chType.addItemListener(this);
        this.m_chSort.addItemListener(this);
        this.m_bPick.addActionListener(this);
        this.m_bCancel.addActionListener(this);
        ((Component)this).setSize(360, 320);
        ((Component)this).setLocation(this.m_client.frame.getLocation().x + this.m_client.frame.getSize().width / 2 - this.getSize().width / 2, this.m_client.frame.getLocation().y + this.m_client.frame.getSize().height / 2 - this.getSize().height / 2);
        this.populateChoices(MechSummaryCache.getInstance().getAllMechs());
        this.filterMechs();
    }

    private void populateChoices(MechSummary[] mechSummaryArray) {
        this.m_chWeightClass.addItem("Light");
        this.m_chWeightClass.addItem("Medium");
        this.m_chWeightClass.addItem("Heavy");
        this.m_chWeightClass.addItem("Assault");
        int n = 0;
        while (n < TechConstants.T_NAMES.length) {
            this.m_chType.addItem(TechConstants.T_NAMES[n]);
            ++n;
        }
    }

    private void filterMechs() {
        Vector<MechSummary> vector = new Vector<MechSummary>();
        String string = this.m_chWeightClass.getSelectedItem();
        int n = string.equals("Light") ? 35 : (string.equals("Medium") ? 55 : (string.equals("Heavy") ? 75 : 100));
        int n2 = this.m_chType.getSelectedIndex();
        MechSummary[] mechSummaryArray = MechSummaryCache.getInstance().getAllMechs();
        int n3 = 0;
        while (n3 < mechSummaryArray.length) {
            if (mechSummaryArray[n3].getWeightClass() == n && mechSummaryArray[n3].getType() == n2) {
                vector.addElement(mechSummaryArray[n3]);
            }
            ++n3;
        }
        this.m_mechsCurrent = new MechSummary[vector.size()];
        vector.copyInto(this.m_mechsCurrent);
        this.sortMechs();
    }

    private void sortMechs() {
        Arrays.sort((Object[])this.m_mechsCurrent, (Comparator)new MechSummaryComparator(this.m_chSort.getSelectedIndex()));
        this.m_mechList.removeAll();
        int n = 0;
        while (n < this.m_mechsCurrent.length) {
            this.m_mechList.add(this.formatMech(this.m_mechsCurrent[n]));
            ++n;
        }
        this.repaint();
    }

    private void searchFor(String string) {
        int n = 0;
        while (n < this.m_mechsCurrent.length) {
            if (this.m_mechsCurrent[n].getName().toLowerCase().startsWith(string)) {
                this.m_mechList.select(n);
                break;
            }
            ++n;
        }
    }

    public void show() {
        ((Component)this).setLocation(this.m_client.frame.getLocation().x + this.m_client.frame.getSize().width / 2 - this.getSize().width / 2, this.m_client.frame.getLocation().y + this.m_client.frame.getSize().height / 2 - this.getSize().height / 2);
        super.show();
    }

    private String formatMech(MechSummary mechSummary) {
        return this.makeLength(mechSummary.getModel(), 10) + " " + this.makeLength(mechSummary.getChassis(), 20) + " " + this.makeLength("" + mechSummary.getTons(), 3) + " " + this.makeLength("" + mechSummary.getBV(), 5) + "" + mechSummary.getYear();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_bCancel) {
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.m_bPick) {
            int n = this.m_mechList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            MechSummary mechSummary = this.m_mechsCurrent[this.m_mechList.getSelectedIndex()];
            try {
                Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                entity.setOwner(this.m_client.getLocalPlayer());
                this.m_client.sendAddEntity(entity);
            }
            catch (EntityLoadingException entityLoadingException) {
                System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName());
                entityLoadingException.printStackTrace();
                return;
            }
            ((Component)this).setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_chSort) {
            this.sortMechs();
        } else if (itemEvent.getSource() == this.m_chWeightClass || itemEvent.getSource() == this.m_chType) {
            this.filterMechs();
        }
    }

    private String makeLength(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n - 2) + "..";
        }
        return string + SPACES.substring(0, n - string.length());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        long l = System.currentTimeMillis();
        if (l - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuffer();
        }
        this.m_nLastSearch = l;
        this.m_sbSearch.append(keyEvent.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

