/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.util.Enumeration;
import megamek.client.HexTileset;
import megamek.client.MechTileset;
import megamek.client.util.RotateFilter;
import megamek.client.util.TintFilter;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.Settings;

public class TilesetManager {
    private Component comp;
    private MediaTracker tracker;
    private boolean started = false;
    private boolean loaded = false;
    private MechTileset mechTileset = new MechTileset();
    private ArrayList mechImageList = new ArrayList();
    private HashMap mechImages = new HashMap();
    private HexTileset hexTileset = new HexTileset();

    public TilesetManager(Component component) {
        this.comp = component;
        this.tracker = new MediaTracker(component);
        this.mechTileset.loadFromFile("mechset.txt");
        this.hexTileset.loadFromFile(Settings.mapTileset);
    }

    public Image imageFor(Entity entity) {
        EntityImage entityImage = (EntityImage)this.mechImages.get((Object)new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortName() + " on the fly.");
            this.loadImage(entity);
            entityImage = (EntityImage)this.mechImages.get((Object)new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortName());
            }
        }
        if (entity.canChangeSecondaryFacing()) {
            return entityImage.getFacing(entity.getSecondaryFacing());
        }
        return entityImage.getFacing(entity.getFacing());
    }

    public Image baseFor(Hex hex) {
        if (hex.getBase() == null) {
            this.hexTileset.assignMatch(hex, this.comp);
        }
        return hex.getBase();
    }

    public List supersFor(Hex hex) {
        return hex.getSupers();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isLoaded() {
        if (!this.loaded) {
            this.loaded = this.tracker.checkAll(true);
        }
        return this.started && this.loaded;
    }

    public void loadAllImages(Game game) {
        this.loaded = false;
        this.hexTileset.loadAllImages(this.comp, this.tracker);
        int n = 0;
        while (n < game.board.height) {
            int n2 = 0;
            while (n2 < game.board.width) {
                Hex hex = game.board.getHex(n2, n);
                this.hexTileset.assignMatch(hex, this.comp);
                ++n2;
            }
            ++n;
        }
        Enumeration enumeration = game.getEntities();
        while (enumeration.hasMoreElements()) {
            this.loadImage((Entity)enumeration.nextElement());
        }
        this.started = true;
    }

    public void loadImage(Entity entity) {
        Image image = this.mechTileset.imageFor(entity, this.comp);
        int n = entity.getOwner().getColorRGB();
        EntityImage entityImage = null;
        Iterator iterator = this.mechImageList.iterator();
        while (iterator.hasNext()) {
            EntityImage entityImage2 = (EntityImage)iterator.next();
            if (entityImage2.getBase() != image || entityImage2.tint != n) continue;
            entityImage = entityImage2;
            break;
        }
        if (entityImage == null) {
            entityImage = new EntityImage(image, n);
            this.mechImageList.add((Object)entityImage);
            entityImage.loadFacings();
            int n2 = 0;
            while (n2 < 6) {
                this.tracker.addImage(entityImage.getFacing(n2), 1);
                ++n2;
            }
        }
        this.mechImages.put((Object)new Integer(entity.getId()), (Object)entityImage);
    }

    public void reset() {
        this.loaded = false;
        this.started = false;
    }

    private class EntityImage {
        private Image base;
        private int tint;
        private Image[] facings = new Image[6];

        public EntityImage(Image image, int n) {
            this.base = image;
            this.tint = n;
        }

        public void loadFacings() {
            int n = 0;
            while (n < 6) {
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.base.getSource(), new RotateFilter(1.0471975511965976 * (double)(6 - n)));
                this.facings[n] = TilesetManager.this.comp.createImage(new FilteredImageSource(filteredImageSource, new TintFilter(this.tint)));
                ++n;
            }
        }

        public Image getFacing(int n) {
            return this.facings[n];
        }

        public Image getBase() {
            return this.base;
        }

        public int getTint() {
            return this.tint;
        }
    }
}

