/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.EquipmentType;

public class AmmoType
extends EquipmentType {
    public static final int T_NA = -1;
    public static final int T_AC = 1;
    public static final int T_VEHICLE_FLAMER = 2;
    public static final int T_MG = 3;
    public static final int T_MG_HEAVY = 4;
    public static final int T_MG_LIGHT = 5;
    public static final int T_GAUSS = 6;
    public static final int T_LRM = 7;
    public static final int T_LRM_TORPEDO = 8;
    public static final int T_SRM = 9;
    public static final int T_SRM_TORPEDO = 10;
    public static final int T_SRM_STREAK = 11;
    public static final int T_MRM = 12;
    public static final int T_NARC = 13;
    public static final int T_AMS = 14;
    public static final int T_ARROW_IV = 15;
    public static final int T_LONG_TOM = 16;
    public static final int T_SNIPER = 17;
    public static final int T_THUMPER = 18;
    public static final int T_AC_LBX = 19;
    public static final int T_AC_ULTRA = 20;
    public static final int T_GAUSS_LIGHT = 21;
    public static final int T_GAUSS_HEAVY = 22;
    public static final int T_AC_ROTARY = 23;
    public static final int F_CLUSTER = 1;
    public static final int F_FLARE = 2;
    public static final int F_FRAGMENTATION = 4;
    public static final int F_INCENDIARY = 8;
    public static final int F_SEMIGUIDED = 16;
    public static final int F_SWARM = 32;
    public static final int F_SWARM_I = 64;
    public static final int F_THUNDER = 128;
    public static final int F_INFERNO = 256;
    public static final int F_EXPLOSIVE = 512;
    public static final int F_MG = 1024;
    private int damagePerShot;
    private int rackSize;
    private int ammoType;
    private int shots;

    public AmmoType() {
        this.criticals = 1;
        this.tonnage = 1.0f;
        this.explosive = true;
    }

    public int getAmmoType() {
        return this.ammoType;
    }

    public int getDamagePerShot() {
        return this.damagePerShot;
    }

    public int getRackSize() {
        return this.rackSize;
    }

    public int getShots() {
        return this.shots;
    }

    public static void initializeTypes() {
        EquipmentType.addType(AmmoType.createISAC2Ammo());
        EquipmentType.addType(AmmoType.createISAC5Ammo());
        EquipmentType.addType(AmmoType.createISAC10Ammo());
        EquipmentType.addType(AmmoType.createISAC20Ammo());
        EquipmentType.addType(AmmoType.createISMGAmmo());
        EquipmentType.addType(AmmoType.createISMGAmmoHalf());
        EquipmentType.addType(AmmoType.createISLRM5Ammo());
        EquipmentType.addType(AmmoType.createISLRM10Ammo());
        EquipmentType.addType(AmmoType.createISLRM15Ammo());
        EquipmentType.addType(AmmoType.createISLRM20Ammo());
        EquipmentType.addType(AmmoType.createISSRM2Ammo());
        EquipmentType.addType(AmmoType.createISSRM4Ammo());
        EquipmentType.addType(AmmoType.createISSRM6Ammo());
        EquipmentType.addType(AmmoType.createISLB2XAmmo());
        EquipmentType.addType(AmmoType.createISLB5XAmmo());
        EquipmentType.addType(AmmoType.createISLB10XAmmo());
        EquipmentType.addType(AmmoType.createISLB20XAmmo());
        EquipmentType.addType(AmmoType.createISLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB10XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createISUltra2Ammo());
        EquipmentType.addType(AmmoType.createISUltra5Ammo());
        EquipmentType.addType(AmmoType.createISUltra10Ammo());
        EquipmentType.addType(AmmoType.createISUltra20Ammo());
        EquipmentType.addType(AmmoType.createISRotary2Ammo());
        EquipmentType.addType(AmmoType.createISRotary5Ammo());
        EquipmentType.addType(AmmoType.createISGaussAmmo());
        EquipmentType.addType(AmmoType.createISLTGaussAmmo());
        EquipmentType.addType(AmmoType.createISHVGaussAmmo());
        EquipmentType.addType(AmmoType.createISStreakSRM2Ammo());
        EquipmentType.addType(AmmoType.createISStreakSRM4Ammo());
        EquipmentType.addType(AmmoType.createISStreakSRM6Ammo());
        EquipmentType.addType(AmmoType.createISMRM10Ammo());
        EquipmentType.addType(AmmoType.createISMRM20Ammo());
        EquipmentType.addType(AmmoType.createISMRM30Ammo());
        EquipmentType.addType(AmmoType.createISMRM40Ammo());
        EquipmentType.addType(AmmoType.createISAMSAmmo());
        EquipmentType.addType(AmmoType.createISNarcAmmo());
        EquipmentType.addType(AmmoType.createCLLB2XAmmo());
        EquipmentType.addType(AmmoType.createCLLB5XAmmo());
        EquipmentType.addType(AmmoType.createCLLB10XAmmo());
        EquipmentType.addType(AmmoType.createCLLB20XAmmo());
        EquipmentType.addType(AmmoType.createCLLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB10XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLUltra2Ammo());
        EquipmentType.addType(AmmoType.createCLUltra5Ammo());
        EquipmentType.addType(AmmoType.createCLUltra10Ammo());
        EquipmentType.addType(AmmoType.createCLUltra20Ammo());
        EquipmentType.addType(AmmoType.createCLGaussAmmo());
        EquipmentType.addType(AmmoType.createCLStreakSRM2Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM4Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM6Ammo());
        EquipmentType.addType(AmmoType.createCLMGAmmo());
        EquipmentType.addType(AmmoType.createCLMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLHeavyMGAmmo());
        EquipmentType.addType(AmmoType.createCLLightMGAmmo());
        EquipmentType.addType(AmmoType.createCLLRM5Ammo());
        EquipmentType.addType(AmmoType.createCLLRM10Ammo());
        EquipmentType.addType(AmmoType.createCLLRM15Ammo());
        EquipmentType.addType(AmmoType.createCLLRM20Ammo());
        EquipmentType.addType(AmmoType.createCLSRM2Ammo());
        EquipmentType.addType(AmmoType.createCLSRM4Ammo());
        EquipmentType.addType(AmmoType.createCLSRM6Ammo());
        EquipmentType.addType(AmmoType.createCLAMSAmmo());
        EquipmentType.addType(AmmoType.createCLNarcAmmo());
    }

    public static AmmoType createISAC2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "AC/2 Ammo";
        ammoType.internalName = "IS Ammo AC/2";
        ammoType.mepName = "IS Ammo AC/2";
        ammoType.mtfName = "ISAC2 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 1;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createISAC5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "AC/5 Ammo";
        ammoType.internalName = "IS Ammo AC/5";
        ammoType.mepName = "IS Ammo AC/5";
        ammoType.mtfName = "ISAC5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 1;
        ammoType.shots = 20;
        ammoType.bv = 9.0;
        return ammoType;
    }

    public static AmmoType createISAC10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "AC/10 Ammo";
        ammoType.internalName = "IS Ammo AC/10";
        ammoType.mepName = "IS Ammo AC/10";
        ammoType.mtfName = "ISAC10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 1;
        ammoType.shots = 10;
        ammoType.bv = 15.0;
        return ammoType;
    }

    public static AmmoType createISAC20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "AC/20 Ammo";
        ammoType.internalName = "IS Ammo AC/20";
        ammoType.mepName = "IS Ammo AC/20";
        ammoType.mtfName = "ISAC20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 1;
        ammoType.shots = 5;
        ammoType.bv = 20.0;
        return ammoType;
    }

    public static AmmoType createISMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Machine Gun Ammo";
        ammoType.internalName = "IS Ammo MG - Full";
        ammoType.mepName = "IS Ammo MG - Full";
        ammoType.mtfName = "ISMG Ammo (200)";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 0x400;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createISMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Half Machine Gun Ammo";
        ammoType.internalName = "IS Machine Gun Ammo - Half";
        ammoType.mepName = "IS Ammo MG - Half";
        ammoType.mtfName = "ISMG Ammo (100)";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 0x400;
        ammoType.shots = 100;
        ammoType.bv = 0.5;
        ammoType.tonnage = 0.5f;
        return ammoType;
    }

    public static AmmoType createISLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 5 Ammo";
        ammoType.internalName = "IS Ammo LRM-5";
        ammoType.mepName = "IS Ammo LRM-5";
        ammoType.mtfName = "ISLRM5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 6.0;
        return ammoType;
    }

    public static AmmoType createISLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 10 Ammo";
        ammoType.internalName = "IS Ammo LRM-10";
        ammoType.mepName = "IS Ammo LRM-10";
        ammoType.mtfName = "ISLRM10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 7;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        return ammoType;
    }

    public static AmmoType createISLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 15 Ammo";
        ammoType.internalName = "IS Ammo LRM-15";
        ammoType.mepName = "IS Ammo LRM-15";
        ammoType.mtfName = "ISLRM15 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 7;
        ammoType.shots = 8;
        ammoType.bv = 17.0;
        return ammoType;
    }

    public static AmmoType createISLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 20 Ammo";
        ammoType.internalName = "IS Ammo LRM-20";
        ammoType.mepName = "IS Ammo LRM-20";
        ammoType.mtfName = "ISLRM20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 7;
        ammoType.shots = 6;
        ammoType.bv = 23.0;
        return ammoType;
    }

    public static AmmoType createISSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "SRM 2 Ammo";
        ammoType.internalName = "IS Ammo SRM-2";
        ammoType.mepName = "IS Ammo SRM-2";
        ammoType.mtfName = "ISSRM2 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        return ammoType;
    }

    public static AmmoType createISSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "SRM 4 Ammo";
        ammoType.internalName = "IS Ammo SRM-4";
        ammoType.mepName = "IS Ammo SRM-4";
        ammoType.mtfName = "ISSRM4 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createISSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "SRM 6 Ammo";
        ammoType.internalName = "IS Ammo SRM-6";
        ammoType.mepName = "IS Ammo SRM-6";
        ammoType.mtfName = "ISSRM6 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        return ammoType;
    }

    public static AmmoType createISLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 2-X AC Ammo";
        ammoType.internalName = "IS LB 2-X AC Ammo";
        ammoType.mepName = "IS Ammo 2-X";
        ammoType.mtfName = "ISLBXAC2 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createISLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 5-X AC Ammo";
        ammoType.internalName = "IS LB 5-X AC Ammo";
        ammoType.mepName = "IS Ammo 5-X";
        ammoType.mtfName = "ISLBXAC5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.shots = 20;
        ammoType.bv = 10.0;
        return ammoType;
    }

    public static AmmoType createISLB10XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 10-X AC Ammo";
        ammoType.internalName = "IS LB 10-X AC Ammo";
        ammoType.mepName = "IS Ammo 10-X";
        ammoType.mtfName = "ISLBXAC10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        return ammoType;
    }

    public static AmmoType createISLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 20-X AC Ammo";
        ammoType.internalName = "IS LB 20-X AC Ammo";
        ammoType.mepName = "IS Ammo 20-X";
        ammoType.mtfName = "ISLBXAC20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.shots = 5;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createISLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 2-X Cluster Ammo";
        ammoType.internalName = "IS LB 2-X Cluster Ammo";
        ammoType.mepName = "IS Ammo 2-X (CL)";
        ammoType.mtfName = "ISLBXAC2 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createISLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 5-X Cluster Ammo";
        ammoType.internalName = "IS LB 5-X Cluster Ammo";
        ammoType.mepName = "IS Ammo 5-X (CL)";
        ammoType.mtfName = "ISLBXAC5 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 20;
        ammoType.bv = 10.0;
        return ammoType;
    }

    public static AmmoType createISLB10XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 10-X Cluster Ammo";
        ammoType.internalName = "IS LB 10-X Cluster Ammo";
        ammoType.mepName = "IS Ammo 10-X (CL)";
        ammoType.mtfName = "ISLBXAC10 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        return ammoType;
    }

    public static AmmoType createISLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 20-X Cluster Ammo";
        ammoType.internalName = "IS LB 20-X Cluster Ammo";
        ammoType.mepName = "IS Ammo 20-X (CL)";
        ammoType.mtfName = "ISLBXAC20 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 5;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createISUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/2 Ammo";
        ammoType.internalName = "IS Ultra AC/2 Ammo";
        ammoType.mepName = "IS Ammo Ultra AC/2";
        ammoType.mtfName = "ISUltraAC2 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 20;
        ammoType.shots = 45;
        ammoType.bv = 7.0;
        return ammoType;
    }

    public static AmmoType createISUltra5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/5 Ammo";
        ammoType.internalName = "IS Ultra AC/5 Ammo";
        ammoType.mepName = "IS Ammo Ultra AC/5";
        ammoType.mtfName = "ISUltraAC5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 20;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        return ammoType;
    }

    public static AmmoType createISUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/10 Ammo";
        ammoType.internalName = "IS Ultra AC/10 Ammo";
        ammoType.mepName = "IS Ammo Ultra AC/10";
        ammoType.mtfName = "ISUltraAC10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 20;
        ammoType.shots = 10;
        ammoType.bv = 29.0;
        return ammoType;
    }

    public static AmmoType createISUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/20 Ammo";
        ammoType.internalName = "IS Ultra AC/20 Ammo";
        ammoType.mepName = "IS Ammo Ultra AC/20";
        ammoType.mtfName = "ISUltraAC20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 20;
        ammoType.shots = 5;
        ammoType.bv = 32.0;
        return ammoType;
    }

    public static AmmoType createISRotary2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Rotary AC/2 Ammo";
        ammoType.mepName = ammoType.internalName = "ISRotaryAC2 Ammo";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 23;
        ammoType.shots = 45;
        ammoType.bv = 15.0;
        return ammoType;
    }

    public static AmmoType createISRotary5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Rotary AC/5 Ammo";
        ammoType.mepName = ammoType.internalName = "ISRotaryAC5 Ammo";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 23;
        ammoType.shots = 20;
        ammoType.bv = 31.0;
        return ammoType;
    }

    public static AmmoType createISGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Gauss Ammo";
        ammoType.internalName = "IS Gauss Ammo";
        ammoType.mepName = "IS Ammo Gauss";
        ammoType.mtfName = "ISGauss Ammo";
        ammoType.damagePerShot = 15;
        ammoType.explosive = false;
        ammoType.ammoType = 6;
        ammoType.shots = 8;
        ammoType.bv = 37.0;
        return ammoType;
    }

    public static AmmoType createISLTGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Light Gauss Ammo";
        ammoType.internalName = "IS Light Gauss Ammo";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "ISLightGauss Ammo";
        ammoType.damagePerShot = 8;
        ammoType.explosive = false;
        ammoType.ammoType = 21;
        ammoType.shots = 16;
        ammoType.bv = 20.0;
        return ammoType;
    }

    public static AmmoType createISHVGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Heavy Gauss Ammo";
        ammoType.mepName = ammoType.internalName = "ISHeavyGauss Ammo";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 25;
        ammoType.explosive = false;
        ammoType.ammoType = 22;
        ammoType.shots = 4;
        ammoType.bv = 43.0;
        return ammoType;
    }

    public static AmmoType createISStreakSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Streak SRM 2 Ammo";
        ammoType.internalName = "IS Streak SRM 2 Ammo";
        ammoType.mepName = "IS Ammo Streak-2";
        ammoType.mtfName = "ISStreakSRM2 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 11;
        ammoType.shots = 50;
        ammoType.bv = 4.0;
        return ammoType;
    }

    public static AmmoType createISStreakSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Streak SRM 4 Ammo";
        ammoType.internalName = "IS Streak SRM 4 Ammo";
        ammoType.mepName = "IS Ammo Streak-4";
        ammoType.mtfName = "ISStreakSRM4 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 11;
        ammoType.shots = 25;
        ammoType.bv = 7.0;
        return ammoType;
    }

    public static AmmoType createISStreakSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Streak SRM 6 Ammo";
        ammoType.internalName = "IS Streak SRM 6 Ammo";
        ammoType.mepName = "IS Ammo Streak-6";
        ammoType.mtfName = "ISStreakSRM6 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 11;
        ammoType.shots = 15;
        ammoType.bv = 11.0;
        return ammoType;
    }

    public static AmmoType createISMRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "MRM 10 Ammo";
        ammoType.internalName = "IS MRM 10 Ammo";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "ISMRM10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 12;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        return ammoType;
    }

    public static AmmoType createISMRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "MRM 20 Ammo";
        ammoType.internalName = "IS MRM 20 Ammo";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "ISMRM20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 12;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        return ammoType;
    }

    public static AmmoType createISMRM30Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "MRM 30 Ammo";
        ammoType.internalName = "IS MRM 30 Ammo";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "ISMRM30 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 30;
        ammoType.ammoType = 12;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        return ammoType;
    }

    public static AmmoType createISMRM40Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "MRM 40 Ammo";
        ammoType.internalName = "IS MRM 40 Ammo";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "ISMRM40 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 40;
        ammoType.ammoType = 12;
        ammoType.shots = 6;
        ammoType.bv = 28.0;
        return ammoType;
    }

    public static AmmoType createISAMSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "AMS Ammo";
        ammoType.internalName = "ISAMS Ammo";
        ammoType.mepName = "IS Ammo AMS";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 14;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        return ammoType;
    }

    public static AmmoType createISNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Narc Pods";
        ammoType.internalName = "ISNarc Pods";
        ammoType.mepName = "IS Ammo Narc";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createCLGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Gauss Ammo";
        ammoType.internalName = "Clan Gauss Ammo";
        ammoType.mepName = "Clan Ammo Gauss";
        ammoType.mtfName = "CLGauss Ammo";
        ammoType.damagePerShot = 15;
        ammoType.explosive = false;
        ammoType.ammoType = 6;
        ammoType.shots = 8;
        ammoType.bv = 33.0;
        return ammoType;
    }

    public static AmmoType createCLLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 2-X AC Ammo";
        ammoType.internalName = "Clan LB 2-X AC Ammo";
        ammoType.mepName = "Clan Ammo 2-X";
        ammoType.mtfName = "CLLBXAC2 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        return ammoType;
    }

    public static AmmoType createCLLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 5-X AC Ammo";
        ammoType.internalName = "Clan LB 5-X AC Ammo";
        ammoType.mepName = "Clan Ammo 5-X";
        ammoType.mtfName = "CLLBXAC5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.shots = 20;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLB10XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 10-X AC Ammo";
        ammoType.internalName = "Clan LB 10-X AC Ammo";
        ammoType.mepName = "Clan Ammo 10-X";
        ammoType.mtfName = "CLLBXAC10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        return ammoType;
    }

    public static AmmoType createCLLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 20-X AC Ammo";
        ammoType.internalName = "Clan LB 20-X AC Ammo";
        ammoType.mepName = "Clan Ammo 20-X";
        ammoType.mtfName = "CLLBXAC20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.shots = 5;
        ammoType.bv = 33.0;
        return ammoType;
    }

    public static AmmoType createCLLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 2-X Cluster Ammo";
        ammoType.internalName = "Clan LB 2-X Cluster Ammo";
        ammoType.mepName = "Clan Ammo 2-X (CL)";
        ammoType.mtfName = "CLLBXAC2 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        return ammoType;
    }

    public static AmmoType createCLLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 5-X Cluster Ammo";
        ammoType.internalName = "Clan LB 5-X Cluster Ammo";
        ammoType.mepName = "Clan Ammo 5-X (CL)";
        ammoType.mtfName = "CLLBXAC5 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 20;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLB10XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 10-X Cluster Ammo";
        ammoType.internalName = "Clan LB 10-X Cluster Ammo";
        ammoType.mepName = "Clan Ammo 10-X (CL)";
        ammoType.mtfName = "CLLBXAC10 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        return ammoType;
    }

    public static AmmoType createCLLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LB 20-X Cluster Ammo";
        ammoType.internalName = "Clan LB 20-X Cluster Ammo";
        ammoType.mepName = "Clan Ammo 20-X (CL)";
        ammoType.mtfName = "CLLBXAC20 CL Ammo";
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.flags |= 1;
        ammoType.shots = 5;
        ammoType.bv = 33.0;
        return ammoType;
    }

    public static AmmoType createCLHeavyMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Heavy Machine Gun Ammo";
        ammoType.internalName = "Clan Heavy Machine Gun Ammo - Full";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "CLHeavyMG Ammo (100)";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 0x400;
        ammoType.shots = 100;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createCLMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Machine Gun Ammo";
        ammoType.internalName = "Clan Machine Gun Ammo - Full";
        ammoType.mepName = "Clan Ammo MG - Full";
        ammoType.mtfName = "CLMG Ammo (200)";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 0x400;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createCLMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Half Machine Gun Ammo";
        ammoType.internalName = "Clan Machine Gun Ammo - Half";
        ammoType.mepName = "Clan Ammo MG - Half";
        ammoType.mtfName = "CLMG Ammo (100)";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 0x400;
        ammoType.shots = 100;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createCLLightMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Light Machine Gun Ammo";
        ammoType.internalName = "Clan Light Machine Gun Ammo - Full";
        ammoType.mepName = "N/A";
        ammoType.mtfName = "CLLightMG Ammo (200)";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 0x400;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createCLUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/2 Ammo";
        ammoType.internalName = "Clan Ultra AC/2 Ammo";
        ammoType.mepName = "Clan Ammo Ultra AC/2";
        ammoType.mtfName = "CLUltraAC2 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 20;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        return ammoType;
    }

    public static AmmoType createCLUltra5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/5 Ammo";
        ammoType.internalName = "Clan Ultra AC/5 Ammo";
        ammoType.mepName = "Clan Ammo Ultra AC/5";
        ammoType.mtfName = "CLUltraAC5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 20;
        ammoType.shots = 20;
        ammoType.bv = 15.0;
        return ammoType;
    }

    public static AmmoType createCLUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/10 Ammo";
        ammoType.internalName = "Clan Ultra AC/10 Ammo";
        ammoType.mepName = "Clan Ammo Ultra AC/10";
        ammoType.mtfName = "CLUltraAC10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 20;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        return ammoType;
    }

    public static AmmoType createCLUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Ultra AC/20 Ammo";
        ammoType.internalName = "Clan Ultra AC/20 Ammo";
        ammoType.mepName = "Clan Ammo Ultra AC/20";
        ammoType.mtfName = "CLUltraAC20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 20;
        ammoType.shots = 5;
        ammoType.bv = 35.0;
        return ammoType;
    }

    public static AmmoType createCLLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 5 Ammo";
        ammoType.internalName = "Clan Ammo LRM-5";
        ammoType.mepName = "Clan Ammo LRM-5";
        ammoType.mtfName = "CLLRM5 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        return ammoType;
    }

    public static AmmoType createCLLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 10 Ammo";
        ammoType.internalName = "Clan Ammo LRM-10";
        ammoType.mepName = "Clan Ammo LRM-10";
        ammoType.mtfName = "CLLRM10 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 7;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        return ammoType;
    }

    public static AmmoType createCLLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 15 Ammo";
        ammoType.internalName = "Clan Ammo LRM-15";
        ammoType.mepName = "Clan Ammo LRM-15";
        ammoType.mtfName = "CLLRM15 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 7;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        return ammoType;
    }

    public static AmmoType createCLLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "LRM 20 Ammo";
        ammoType.internalName = "Clan Ammo LRM-20";
        ammoType.mepName = "Clan Ammo LRM-20";
        ammoType.mtfName = "CLLRM20 Ammo";
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 7;
        ammoType.shots = 6;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "SRM 2 Ammo";
        ammoType.internalName = "Clan Ammo SRM-2";
        ammoType.mepName = "Clan Ammo SRM-2";
        ammoType.mtfName = "CLSRM2 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        return ammoType;
    }

    public static AmmoType createCLSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "SRM 4 Ammo";
        ammoType.internalName = "Clan Ammo SRM-4";
        ammoType.mepName = "Clan Ammo SRM-4";
        ammoType.mtfName = "CLSRM4 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createCLSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "SRM 6 Ammo";
        ammoType.internalName = "Clan Ammo SRM-6";
        ammoType.mepName = "Clan Ammo SRM-6";
        ammoType.mtfName = "CLSRM6 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Streak SRM 2 Ammo";
        ammoType.internalName = "Clan Streak SRM 2 Ammo";
        ammoType.mepName = "Clan Ammo Streak-2";
        ammoType.mtfName = "CLStreakSRM2 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 11;
        ammoType.shots = 50;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Streak SRM 4 Ammo";
        ammoType.internalName = "Clan Streak SRM 4 Ammo";
        ammoType.mepName = "Clan Ammo Streak-4";
        ammoType.mtfName = "CLStreakSRM4 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 11;
        ammoType.shots = 25;
        ammoType.bv = 10.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Streak SRM 6 Ammo";
        ammoType.internalName = "Clan Streak SRM 6 Ammo";
        ammoType.mepName = "Clan Ammo Streak-6";
        ammoType.mtfName = "CLStreakSRM6 Ammo";
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 11;
        ammoType.shots = 15;
        ammoType.bv = 15.0;
        return ammoType;
    }

    public static AmmoType createCLAMSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "AMS Ammo";
        ammoType.internalName = "CLAMS Ammo";
        ammoType.mepName = "Clan Ammo AMS";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 14;
        ammoType.shots = 24;
        ammoType.bv = 21.0;
        return ammoType;
    }

    public static AmmoType createCLNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.name = "Narc Pods";
        ammoType.internalName = "CLNarc Pods";
        ammoType.mepName = "Clan Ammo Narc";
        ammoType.mtfName = ammoType.internalName;
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public String toString() {
        return "Ammo: " + this.name;
    }
}

