/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.CriticalSlot;
import megamek.common.Mech;
import megamek.common.PilotingRollData;

public class BipedMech
extends Mech {
    private static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Right Arm", "Left Arm", "Right Leg", "Left Leg"};
    private static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "RA", "LA", "RL", "LL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 12, 12, 6, 6};

    public BipedMech() {
        this.movementType = 1;
        this.setCritical(4, 0, new CriticalSlot(0, 7));
        this.setCritical(4, 1, new CriticalSlot(0, 8));
        this.setCritical(4, 2, new CriticalSlot(0, 9));
        this.setCritical(4, 3, new CriticalSlot(0, 10));
        this.setCritical(5, 0, new CriticalSlot(0, 7));
        this.setCritical(5, 1, new CriticalSlot(0, 8));
        this.setCritical(5, 2, new CriticalSlot(0, 9));
        this.setCritical(5, 3, new CriticalSlot(0, 10));
    }

    public boolean canFlipArms() {
        boolean bl;
        boolean bl2 = bl = !this.isProne();
        if (this.hasSystem(10, 5)) {
            bl = false;
        } else if (this.hasSystem(9, 5)) {
            bl = false;
        } else if (this.hasSystem(10, 4)) {
            bl = false;
        } else if (this.hasSystem(9, 4)) {
            bl = false;
        }
        return bl;
    }

    public int getWalkMP() {
        int n = this.getOriginalWalkMP();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.locations()) {
            if (this.locationIsLeg(n5)) {
                if (!this.isLocationDestroyed(n5)) {
                    if (this.legHasHipCrit(n5)) {
                        ++n3;
                    } else {
                        n4 += this.countLegActuatorCrits(n5);
                    }
                } else {
                    ++n2;
                }
            }
            ++n5;
        }
        n = n2 > 0 ? (n2 == 1 ? 1 : 0) : (n3 > 0 ? (n3 == 1 ? (int)Math.ceil((double)n / 2.0) : 0) : (n -= n4));
        n = Math.max(0, n);
        n = Math.max(n - this.heat / 5, 0);
        if (this.heat >= 9 && this.hasTSM()) {
            n = this.heat == 9 ? (n += 2) : ++n;
        }
        return n;
    }

    public int getRunMP() {
        int n = this.countDestroyedLegs();
        if (this.countDestroyedLegs() == 0) {
            return super.getRunMP();
        }
        return this.getWalkMP();
    }

    public boolean locationIsLeg(int n) {
        return n == 6 || n == 7;
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n4, 4);
        this.initializeInternal(n4, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[2];
        boolean bl = false;
        nArray[0] = 6;
        nArray[1] = 7;
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (this.isLocationDestroyed(n2)) {
                pilotingRollData.addModifier(5, this.getLocationName(n2) + " destroyed");
            } else if (this.getDestroyedCriticals(0, 11, n2) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n2) + " Hip Actuator destroyed");
            } else {
                if (this.getDestroyedCriticals(0, 12, n2) > 0) {
                    pilotingRollData.addModifier(1, this.getLocationName(n2) + " Upper Leg Actuator destroyed");
                }
                if (this.getDestroyedCriticals(0, 13, n2) > 0) {
                    pilotingRollData.addModifier(1, this.getLocationName(n2) + " Lower Leg Actuator destroyed");
                }
                if (this.getDestroyedCriticals(0, 14, n2) > 0) {
                    pilotingRollData.addModifier(1, this.getLocationName(n2) + " Foot Actuator destroyed");
                }
            }
            ++n;
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }
}

