/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Hex;
import megamek.common.HitData;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.WeaponType;

public abstract class Mech
extends Entity
implements Serializable {
    private static final int NUM_MECH_LOCATIONS = 8;
    public static final int WEIGHT_LIGHT = 35;
    public static final int WEIGHT_MEDIUM = 55;
    public static final int WEIGHT_HEAVY = 75;
    public static final int WEIGHT_ASSAULT = 100;
    public static final int SYSTEM_LIFE_SUPPORT = 0;
    public static final int SYSTEM_SENSORS = 1;
    public static final int SYSTEM_COCKPIT = 2;
    public static final int SYSTEM_ENGINE = 3;
    public static final int SYSTEM_GYRO = 4;
    public static final int ACTUATOR_SHOULDER = 7;
    public static final int ACTUATOR_UPPER_ARM = 8;
    public static final int ACTUATOR_LOWER_ARM = 9;
    public static final int ACTUATOR_HAND = 10;
    public static final int ACTUATOR_HIP = 11;
    public static final int ACTUATOR_UPPER_LEG = 12;
    public static final int ACTUATOR_LOWER_LEG = 13;
    public static final int ACTUATOR_FOOT = 14;
    public static final String[] systemNames = new String[]{"Life Support", "Sensors", "Cockpit", "Engine", "Gyro", "x", "x", "Shoulder", "Upper Arm", "Lower Arm", "Hand", "Hip", "Upper Leg", "Lower Leg", "Foot"};
    public static final int LOC_HEAD = 0;
    public static final int LOC_CT = 1;
    public static final int LOC_RT = 2;
    public static final int LOC_LT = 3;
    public static final int LOC_RARM = 4;
    public static final int LOC_LARM = 5;
    public static final int LOC_RLEG = 6;
    public static final int LOC_LLEG = 7;
    private int[] rearArmor = new int[this.locations()];
    private int[] orig_rearArmor = new int[this.locations()];
    private int nMASCLevel = 0;
    private static int[] MASC_FAILURE = new int[]{0, 2, 4, 6, 10, 12, 12, 12};

    public Mech() {
        int n = 0;
        while (n < this.locations()) {
            if (!this.hasRearArmor(n)) {
                this.initializeRearArmor(-1, n);
            }
            ++n;
        }
        this.setCritical(0, 0, new CriticalSlot(0, 0));
        this.setCritical(0, 1, new CriticalSlot(0, 1));
        this.setCritical(0, 2, new CriticalSlot(0, 2));
        this.setCritical(0, 4, new CriticalSlot(0, 1));
        this.setCritical(0, 5, new CriticalSlot(0, 0));
        this.setCritical(1, 0, new CriticalSlot(0, 3));
        this.setCritical(1, 1, new CriticalSlot(0, 3));
        this.setCritical(1, 2, new CriticalSlot(0, 3));
        this.setCritical(1, 3, new CriticalSlot(0, 4));
        this.setCritical(1, 4, new CriticalSlot(0, 4));
        this.setCritical(1, 5, new CriticalSlot(0, 4));
        this.setCritical(1, 6, new CriticalSlot(0, 4));
        this.setCritical(1, 7, new CriticalSlot(0, 3));
        this.setCritical(1, 8, new CriticalSlot(0, 3));
        this.setCritical(1, 9, new CriticalSlot(0, 3));
        this.setCritical(6, 0, new CriticalSlot(0, 11));
        this.setCritical(6, 1, new CriticalSlot(0, 12));
        this.setCritical(6, 2, new CriticalSlot(0, 13));
        this.setCritical(6, 3, new CriticalSlot(0, 14));
        this.setCritical(7, 0, new CriticalSlot(0, 11));
        this.setCritical(7, 1, new CriticalSlot(0, 12));
        this.setCritical(7, 2, new CriticalSlot(0, 13));
        this.setCritical(7, 3, new CriticalSlot(0, 14));
    }

    public boolean checkForMASCFailure(StringBuffer stringBuffer) {
        if (this.hasActiveMASC()) {
            boolean bl = false;
            ++this.nMASCLevel;
            int n = Compute.d6(2);
            stringBuffer.append("\n" + this.getDisplayName() + " checking for MASC failure.\n");
            stringBuffer.append("Needs " + (MASC_FAILURE[this.nMASCLevel] + 1) + ", rolls " + n + " : ");
            if (n <= MASC_FAILURE[this.nMASCLevel]) {
                bl = true;
                stringBuffer.append("MASC fails!.\n");
                this.getCritical(6, 0).setDestroyed(true);
                this.getCritical(7, 0).setDestroyed(true);
                Enumeration enumeration = this.getEquipment();
                while (enumeration.hasMoreElements()) {
                    Mounted mounted = (Mounted)enumeration.nextElement();
                    if (!mounted.getType().hasFlag(128)) continue;
                    mounted.setDestroyed(true);
                }
            } else {
                stringBuffer.append("succeeds.\n");
            }
            ++this.nMASCLevel;
            return bl;
        }
        return false;
    }

    public int locations() {
        return 8;
    }

    public void newRound() {
        Object object;
        super.newRound();
        this.nMASCLevel = Math.max(0, this.nMASCLevel - 1);
        this.setSecondaryFacing(this.getFacing());
        Enumeration enumeration = this.getAmmo();
        while (enumeration.hasMoreElements()) {
            object = (Mounted)enumeration.nextElement();
            if (((Mounted)object).isPendingDump()) {
                ((Mounted)object).setPendingDump(false);
                ((Mounted)object).setDumping(true);
                continue;
            }
            if (!((Mounted)object).isDumping()) continue;
            ((Mounted)object).setDumping(false);
            ((Mounted)object).setShotsLeft(0);
        }
        object = this.getEquipment();
        while (object.hasMoreElements()) {
            Mounted mounted = (Mounted)object.nextElement();
            if (!mounted.getType().hasFlag(128)) continue;
            mounted.setMode("Off");
        }
    }

    public boolean locationIsTorso(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public int countDestroyedLegs() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.locations()) {
            n += this.locationIsLeg(n2) && this.isLocationDestroyed(n2) ? 1 : 0;
            ++n2;
        }
        return n;
    }

    public boolean legHasHipCrit(int n) {
        if (this.isLocationDestroyed(n)) {
            return false;
        }
        if (this.locationIsLeg(n)) {
            return this.getGoodCriticals(0, 11, n) == 0;
        }
        return false;
    }

    public int countLegActuatorCrits(int n) {
        if (this.isLocationDestroyed(n)) {
            return 0;
        }
        int n2 = 0;
        if (this.locationIsLeg(n)) {
            if (this.getGoodCriticals(0, 12, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 13, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 14, n) == 0) {
                ++n2;
            }
        }
        return n2;
    }

    public boolean hasXL() {
        return this.getNumberOfCriticals(0, 3, 2) > 0;
    }

    public void giveXL() {
        this.giveXL(this.isClan());
    }

    public void giveXL(boolean bl) {
        int n = bl ? 2 : 3;
        int n2 = 0;
        while (n2 < n) {
            this.setCritical(2, n2, new CriticalSlot(0, 3));
            this.setCritical(3, n2, new CriticalSlot(0, 3));
            ++n2;
        }
    }

    public boolean hasActiveMASC() {
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(128) || !mounted.curMode().equals("On")) continue;
            return true;
        }
        return false;
    }

    public boolean hasTSM() {
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(256)) continue;
            return true;
        }
        return false;
    }

    public int getRunMP() {
        if (this.hasActiveMASC()) {
            return this.getWalkMP() * 2;
        }
        return super.getRunMP();
    }

    public int getJumpMP() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(4) || mounted.isDestroyed()) continue;
            ++n;
        }
        return n;
    }

    public int getJumpMPWithTerrain() {
        if (this.getPosition() == null) {
            return this.getJumpMP();
        }
        int n = this.game.board.getHex(this.getPosition()).levelOf(4);
        if (n <= 0) {
            return this.getJumpMP();
        }
        if (n > 1) {
            return 0;
        }
        return this.torsoJumpJets();
    }

    public int torsoJumpJets() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(4) || mounted.isDestroyed() || !this.locationIsTorso(mounted.getLocation())) continue;
            ++n;
        }
        return n;
    }

    public int elevation() {
        int n = super.elevation();
        if (!this.isMakingDfa()) {
            return n;
        }
        int n2 = this.game.board.getHex(this.displacementAttack.getTargetPos()).floor();
        return Math.max(n, n2) + 1;
    }

    public int height() {
        return this.isProne() ? 0 : 1;
    }

    public void addEngineSinks(int n, boolean bl) {
        this.addEngineSinks(n, bl, this.isClan());
    }

    public void addEngineSinks(int n, boolean bl, boolean bl2) {
        int n2;
        EquipmentType equipmentType = bl ? EquipmentType.getByInternalName(bl2 ? "CLDoubleHeatSink" : "ISDoubleHeatSink") : EquipmentType.getByInternalName("Heat Sink");
        if (equipmentType == null) {
            System.out.println("Mech: can't find heat sink to add to engine");
        }
        if ((n2 = Math.min(n, this.integralSinkCapacity())) == 0) {
            System.out.println("Mech: not putting any heat sinks in the engine?!?!");
        }
        int n3 = 0;
        while (n3 < n2) {
            try {
                this.addEquipment(new Mounted(this, equipmentType), -1, false);
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
            ++n3;
        }
    }

    private int integralSinkCapacity() {
        return this.engineRating() / 25;
    }

    public int engineRating() {
        return Math.round((float)this.walkMP * this.weight);
    }

    public int heatSinks() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            EquipmentType equipmentType = mounted.getType();
            if (!equipmentType.hasFlag(1) && !equipmentType.hasFlag(2)) continue;
            ++n;
        }
        return n;
    }

    public int getHeatCapacity() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed()) continue;
            if (mounted.getType().hasFlag(1)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2)) continue;
            n += 2;
        }
        return n;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity() + Math.min(this.sinksUnderwater(), 6);
    }

    private int sinksUnderwater() {
        if (this.getPosition() == null) {
            return 0;
        }
        Hex hex = this.game.board.getHex(this.getPosition());
        if (hex.levelOf(4) <= 0) {
            return 0;
        }
        if (this.isProne() || hex.levelOf(4) >= 2) {
            return this.getHeatCapacity();
        }
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed() || !this.locationIsLeg(mounted.getLocation())) continue;
            if (mounted.getType().hasFlag(1)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2)) continue;
            n += 2;
        }
        return n;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Walked";
            }
            case 2: {
                return "Ran";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public boolean canChangeSecondaryFacing() {
        return !this.isProne();
    }

    public boolean isValidSecondaryFacing(int n) {
        int n2 = n - this.getFacing();
        if (this.canChangeSecondaryFacing()) {
            return n2 == 0 || n2 == 1 || n2 == -1 || n2 == -5;
        }
        return n2 == 0;
    }

    public int clipSecondaryFacing(int n) {
        if (this.isValidSecondaryFacing(n)) {
            return n;
        }
        if (!this.canChangeSecondaryFacing()) {
            return this.getFacing();
        }
        int n2 = (n + (6 - this.getFacing())) % 6;
        return n2 >= 3 ? (this.getFacing() + 5) % 6 : (this.getFacing() + 1) % 6;
    }

    public boolean hasRearArmor(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public int getArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.rearArmor[n];
        }
        return super.getArmor(n, bl);
    }

    public int getOArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.orig_rearArmor[n];
        }
        return super.getOArmor(n, bl);
    }

    public void setArmor(int n, int n2, boolean bl) {
        if (bl && this.hasRearArmor(n2)) {
            this.rearArmor[n2] = n;
        } else {
            super.setArmor(n, n2, bl);
        }
    }

    public void initializeRearArmor(int n, int n2) {
        this.orig_rearArmor[n2] = n;
        this.setArmor(n, n2, true);
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 1;
            }
            case 4: {
                return this.getArmsFlipped() ? 4 : 3;
            }
            case 5: {
                return this.getArmsFlipped() ? 4 : 2;
            }
        }
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() != 6 && this.getEquipment(n).getLocation() != 7;
    }

    public HitData rollHitLocation(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                switch (Compute.d6(2)) {
                    case 2: {
                        return this.tac(n, n2, 1, false);
                    }
                    case 3: 
                    case 4: {
                        return new HitData(4);
                    }
                    case 5: {
                        return new HitData(6);
                    }
                    case 6: {
                        return new HitData(2);
                    }
                    case 7: {
                        return new HitData(1);
                    }
                    case 8: {
                        return new HitData(3);
                    }
                    case 9: {
                        return new HitData(7);
                    }
                    case 10: 
                    case 11: {
                        return new HitData(5);
                    }
                    case 12: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 2) {
                switch (Compute.d6(2)) {
                    case 2: {
                        return this.tac(n, n2, 3, false);
                    }
                    case 3: {
                        return new HitData(7);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(7);
                    }
                    case 7: {
                        return new HitData(3);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: {
                        return new HitData(2);
                    }
                    case 10: {
                        return new HitData(4);
                    }
                    case 11: {
                        return new HitData(6);
                    }
                    case 12: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 3) {
                switch (Compute.d6(2)) {
                    case 2: {
                        return this.tac(n, n2, 2, false);
                    }
                    case 3: {
                        return new HitData(6);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(6);
                    }
                    case 7: {
                        return new HitData(2);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: {
                        return new HitData(3);
                    }
                    case 10: {
                        return new HitData(5);
                    }
                    case 11: {
                        return new HitData(7);
                    }
                    case 12: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 1) {
                switch (Compute.d6(2)) {
                    case 2: {
                        return this.tac(n, n2, 1, true);
                    }
                    case 3: 
                    case 4: {
                        return new HitData(4, true);
                    }
                    case 5: {
                        return new HitData(6, true);
                    }
                    case 6: {
                        return new HitData(2, true);
                    }
                    case 7: {
                        return new HitData(1, true);
                    }
                    case 8: {
                        return new HitData(3, true);
                    }
                    case 9: {
                        return new HitData(7, true);
                    }
                    case 10: 
                    case 11: {
                        return new HitData(5, true);
                    }
                    case 12: {
                        return new HitData(0, true);
                    }
                }
            }
        }
        if (n == 1) {
            if (n2 == 0) {
                switch (Compute.d6(1)) {
                    case 1: {
                        return new HitData(5);
                    }
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(2);
                    }
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 2) {
                switch (Compute.d6(1)) {
                    case 1: 
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 3) {
                switch (Compute.d6(1)) {
                    case 1: 
                    case 2: {
                        return new HitData(2);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 1) {
                switch (Compute.d6(1)) {
                    case 1: {
                        return new HitData(5, true);
                    }
                    case 2: {
                        return new HitData(3, true);
                    }
                    case 3: {
                        return new HitData(1, true);
                    }
                    case 4: {
                        return new HitData(2, true);
                    }
                    case 5: {
                        return new HitData(4, true);
                    }
                    case 6: {
                        return new HitData(0, true);
                    }
                }
            }
        }
        if (n == 2) {
            if (n2 == 0 || n2 == 1) {
                switch (Compute.d6(1)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return new HitData(6);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        return new HitData(7);
                    }
                }
            }
            if (n2 == 2) {
                return new HitData(7);
            }
            if (n2 == 3) {
                return new HitData(6);
            }
        }
        return null;
    }

    private HitData tac(int n, int n2, int n3, boolean bl) {
        if (this.game.getOptions().booleanOption("no_tac")) {
            return new HitData(n3, bl);
        }
        if (this.game.getOptions().booleanOption("floating_crits")) {
            HitData hitData = this.rollHitLocation(n, n2);
            return new HitData(hitData.getLocation(), hitData.isRear(), 1);
        }
        return new HitData(n3, bl, 1);
    }

    public HitData getTransferLocation(HitData hitData) {
        switch (hitData.getLocation()) {
            case 2: 
            case 3: {
                return new HitData(1, hitData.isRear());
            }
            case 5: 
            case 7: {
                return new HitData(3, hitData.isRear());
            }
            case 4: 
            case 6: {
                return new HitData(2, hitData.isRear());
            }
        }
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        switch (n) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    public abstract void setInternal(int var1, int var2, int var3, int var4, int var5);

    public void autoSetInternal() {
        switch ((int)this.weight) {
            case 20: {
                this.setInternal(3, 6, 5, 3, 4);
                break;
            }
            case 25: {
                this.setInternal(3, 8, 6, 4, 6);
                break;
            }
            case 30: {
                this.setInternal(3, 10, 7, 5, 7);
                break;
            }
            case 35: {
                this.setInternal(3, 11, 8, 6, 8);
                break;
            }
            case 40: {
                this.setInternal(3, 12, 10, 6, 10);
                break;
            }
            case 45: {
                this.setInternal(3, 14, 11, 7, 11);
                break;
            }
            case 50: {
                this.setInternal(3, 16, 12, 8, 12);
                break;
            }
            case 55: {
                this.setInternal(3, 18, 13, 9, 13);
                break;
            }
            case 60: {
                this.setInternal(3, 20, 14, 10, 14);
                break;
            }
            case 65: {
                this.setInternal(3, 21, 15, 10, 15);
                break;
            }
            case 70: {
                this.setInternal(3, 22, 15, 11, 15);
                break;
            }
            case 75: {
                this.setInternal(3, 23, 16, 12, 16);
                break;
            }
            case 80: {
                this.setInternal(3, 25, 17, 13, 17);
                break;
            }
            case 85: {
                this.setInternal(3, 27, 18, 14, 18);
                break;
            }
            case 90: {
                this.setInternal(3, 29, 19, 15, 19);
                break;
            }
            case 95: {
                this.setInternal(3, 30, 20, 16, 20);
                break;
            }
            case 100: {
                this.setInternal(3, 31, 21, 17, 21);
            }
        }
    }

    public void addClanCase() {
        EquipmentType equipmentType = EquipmentType.getByInternalName("CLCASE");
        int n = 0;
        while (n < this.locations()) {
            try {
                this.addEquipment(new Mounted(this, equipmentType), n, false);
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
            ++n;
        }
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        if (n == -1) {
            super.addEquipment(mounted, n, bl);
            return;
        }
        int n2 = mounted.getType().getCriticals(this);
        if (mounted.getType().isSpreadable() || mounted.isSplit()) {
            n2 = 1;
        }
        if (this.getEmptyCriticals(n) < n2) {
            throw new LocationFullException(mounted.getName() + " does not fit in " + this.getLocationAbbr(n) + " on " + this.getDisplayName());
        }
        super.addEquipment(mounted, n, bl);
        int n3 = this.getEquipmentNum(mounted);
        int n4 = 0;
        while (n4 < n2) {
            this.addCritical(n, new CriticalSlot(1, n3, mounted.getType().isHittable()));
            ++n4;
        }
    }

    public int calculateBattleValue() {
        Object object;
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        d2 += (double)this.getTotalArmor() * 2.0;
        double d4 = this.hasXL() ? (this.isClan() ? 1.125 : 0.75) : 1.5;
        d2 += (double)this.getTotalInternal() * d4;
        d2 += (double)this.getWeight();
        double d5 = 0.0;
        Enumeration enumeration = this.equipmentList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            EquipmentType equipmentType = mounted.getType();
            if (!(equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 14 || equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 14) && !equipmentType.hasFlag(8192)) continue;
            d5 += equipmentType.getBV(this);
        }
        d2 += d5;
        double d6 = 0.0;
        Enumeration enumeration2 = this.equipmentList.elements();
        while (enumeration2.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration2.nextElement();
            int n = mounted.getLocation();
            EquipmentType equipmentType = mounted.getType();
            if (!equipmentType.isExplosive() || (this.isClan() ? n != 1 && n != 6 && n != 7 && n != 0 : !this.hasXL() && ((n == 2 || n == 3) && this.locationHasCase(n) || n == 5 && (this.locationHasCase(n) || this.locationHasCase(3)) || n == 4 && (this.locationHasCase(n) || this.locationHasCase(2))))) continue;
            float f = equipmentType.getTonnage(this);
            if (equipmentType instanceof WeaponType && equipmentType.getName().indexOf("Gauss") != -1) {
                f = 1.0f;
            }
            if (equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 23) {
                f = 0.0f;
            }
            d6 += 20.0 * (double)f;
        }
        d2 = Math.max(1.0, d2 - d6);
        double d7 = 0.0;
        double d8 = 0.0;
        Enumeration enumeration3 = this.weaponList.elements();
        while (enumeration3.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration3.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            d = weaponType.getHeat();
            if (weaponType.getAmmoType() == 20) {
                d *= 2.0;
            }
            if (weaponType.getAmmoType() == 11) {
                d *= 0.5;
            }
            if (mounted.isRearMounted()) {
                d8 += d;
                continue;
            }
            d7 += d;
        }
        double d9 = Math.max(d7, d8);
        d9 = this.getJumpMP() > 0 ? (d9 += (double)Math.max(3, this.getJumpMP())) : (d9 += 2.0);
        if (d9 > (double)this.getHeatCapacity()) {
            d = (d9 - (double)this.getHeatCapacity()) * 5.0;
            d2 = Math.max(1.0, d2 - d);
        }
        int n = this.getRunMP();
        Enumeration enumeration4 = this.miscList.elements();
        while (enumeration4.hasMoreElements()) {
            MiscType miscType = (MiscType)((Mounted)enumeration4.nextElement()).getType();
            if (miscType.hasFlag(128)) {
                n = this.getWalkMP() * 2;
                break;
            }
            if (!miscType.hasFlag(256)) continue;
            n = (int)Math.ceil((double)(this.getWalkMP() + 1) * 1.5);
        }
        int n2 = Compute.getTargetMovementModifier(n, false).getValue();
        int n3 = Compute.getTargetMovementModifier(this.getJumpMP(), true).getValue();
        int n4 = Math.max(n2, n3);
        if (n4 > 5) {
            n4 = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d2 *= dArray[n4];
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        boolean bl = this.hasTargComp();
        Enumeration enumeration5 = this.weaponList.elements();
        while (enumeration5.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration5.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            double d13 = weaponType.getBV(this);
            if (weaponType.getAmmoType() == 14) continue;
            if (mounted.getLinkedBy() != null && ((Mounted)(object = mounted.getLinkedBy())).getType() instanceof MiscType && ((Mounted)object).getType().hasFlag(4096)) {
                d13 *= 1.2;
            }
            if (weaponType.hasFlag(1) && bl) {
                d13 *= 1.2;
            }
            if (mounted.isRearMounted()) {
                d12 += d13;
                continue;
            }
            d11 += d13;
        }
        if (d11 > d12) {
            d10 += d11;
            d10 += d12 * 0.5;
        } else {
            d10 += d12;
            d10 += d11 * 0.5;
        }
        double d14 = 0.0;
        Enumeration enumeration6 = this.miscList.elements();
        while (enumeration6.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration6.nextElement();
            object = (MiscType)mounted.getType();
            if (!((EquipmentType)object).hasFlag(16)) continue;
            d14 += ((MiscType)object).getBV(this);
        }
        d10 += d14;
        double d15 = 0.0;
        Enumeration enumeration7 = this.ammoList.elements();
        while (enumeration7.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration7.nextElement();
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (ammoType.getAmmoType() == 14) continue;
            d15 += ammoType.getBV(this);
        }
        d10 += d15;
        if (d9 > (double)this.getHeatCapacity()) {
            double d16 = (double)this.getHeatCapacity() * d10 / d9;
            double d17 = (d10 - d16) / 2.0;
            d10 = d16 + d17;
        }
        double d18 = this.getRunMP() + this.getJumpMP() - 5;
        Enumeration enumeration8 = this.miscList.elements();
        while (enumeration8.hasMoreElements()) {
            MiscType miscType = (MiscType)((Mounted)enumeration8.nextElement()).getType();
            if (!miscType.hasFlag(128) && !miscType.hasFlag(256)) continue;
            d18 += 1.0;
            break;
        }
        d18 /= 10.0;
        d18 += 1.0;
        d18 = Math.pow(d18, 1.2);
        d18 = (double)Math.round(d18 * 100.0) / 100.0;
        d3 = d10 * d18;
        double d19 = 0.0;
        if (this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) {
            d19 = Math.round(0.35 * d11 + 0.5 * d12);
        }
        double d20 = this.crew.getBVSkillMultiplier();
        return (int)Math.round((d2 + d3 + d19) * d20);
    }

    public String victoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append('\n');
        stringBuffer.append("Pilot : " + this.crew.getDesc());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.getDestroyedCriticals(0, 4, 1) > 0) {
            pilotingRollData.addModifier(3, "Gyro damaged");
        }
        return pilotingRollData;
    }

    public int getMaxElevationChange() {
        return 2;
    }
}

