/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.WeaponType;

public class MiscType
extends EquipmentType {
    public static final int F_HEAT_SINK = 1;
    public static final int F_DOUBLE_HEAT_SINK = 2;
    public static final int F_JUMP_JET = 4;
    public static final int F_CLUB = 8;
    public static final int F_HATCHET = 16;
    public static final int F_TREE_CLUB = 32;
    public static final int F_CASE = 64;
    public static final int F_MASC = 128;
    public static final int F_TSM = 256;
    public static final int F_C3M = 512;
    public static final int F_C3S = 1024;
    public static final int F_C3I = 2048;
    public static final int F_ARTEMIS = 4096;
    public static final int F_ECM = 8192;
    public static final int F_TARGCOMP = 16384;

    public float getTonnage(Entity entity) {
        if (this.tonnage != Float.MIN_VALUE) {
            return this.tonnage;
        }
        if (this.hasFlag(4)) {
            if ((double)entity.getWeight() >= 55.0) {
                return 0.5f;
            }
            if ((double)entity.getWeight() >= 85.0) {
                return 1.0f;
            }
            return 2.0f;
        }
        if (this.hasFlag(16)) {
            return (float)Math.ceil((double)entity.getWeight() / 15.0);
        }
        if (this.hasFlag(128)) {
            if (entity.getTechLevel() == 2) {
                return Math.round(entity.getWeight() / 25.0f);
            }
            return Math.round(entity.getWeight() / 20.0f);
        }
        if (this.hasFlag(16384)) {
            double d = 0.0;
            Enumeration enumeration = entity.getWeapons();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1)) continue;
                d += (double)weaponType.getTonnage(entity);
            }
            if (entity.getTechLevel() == 2) {
                return (float)Math.ceil(d / 5.0);
            }
            return (float)Math.ceil(d / 4.0);
        }
        return 1.0f;
    }

    public int getCriticals(Entity entity) {
        if (this.criticals != Integer.MIN_VALUE) {
            return this.criticals;
        }
        if (this.hasFlag(16)) {
            return (int)Math.ceil((double)entity.getWeight() / 15.0);
        }
        if (this.hasFlag(2) && entity.getTechLevel() != 2) {
            return 3;
        }
        if (this.hasFlag(2) && entity.getTechLevel() == 2) {
            return 2;
        }
        if (this.hasFlag(128)) {
            if (entity.getTechLevel() == 2) {
                return Math.round(entity.getWeight() / 25.0f);
            }
            return Math.round(entity.getWeight() / 20.0f);
        }
        if (this.hasFlag(16384)) {
            double d = 0.0;
            Enumeration enumeration = entity.getWeapons();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1)) continue;
                d += (double)weaponType.getTonnage(entity);
            }
            if (entity.getTechLevel() == 2) {
                return (int)Math.ceil(d / 5.0);
            }
            return (int)Math.ceil(d / 4.0);
        }
        return 1;
    }

    public double getBV(Entity entity) {
        if (this.bv != -2.147483648E9) {
            return this.bv;
        }
        if (this.hasFlag(16)) {
            return (float)Math.ceil((double)entity.getWeight() / 5.0) * 1.5f;
        }
        if (this.hasFlag(16384)) {
            double d = 0.0;
            double d2 = 0.0;
            Enumeration enumeration = entity.getWeapons();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1)) continue;
                if (mounted.isRearMounted()) {
                    d2 += weaponType.getBV(entity);
                    continue;
                }
                d += weaponType.getBV(entity);
            }
            if (d > d2) {
                return (float)(d * 0.2 + d2 * 0.1);
            }
            return (float)(d2 * 0.2 + d * 0.1);
        }
        return 0.0;
    }

    public static void initializeTypes() {
        EquipmentType.addType(MiscType.createHeatSink());
        EquipmentType.addType(MiscType.createJumpJet());
        EquipmentType.addType(MiscType.createTreeClub());
        EquipmentType.addType(MiscType.createGirderClub());
        EquipmentType.addType(MiscType.createLimbClub());
        EquipmentType.addType(MiscType.createHatchet());
        EquipmentType.addType(MiscType.createDoubleHeatSink());
        EquipmentType.addType(MiscType.createISDoubleHeatSink());
        EquipmentType.addType(MiscType.createCLDoubleHeatSink());
        EquipmentType.addType(MiscType.createISCASE());
        EquipmentType.addType(MiscType.createCLCASE());
        EquipmentType.addType(MiscType.createISMASC());
        EquipmentType.addType(MiscType.createCLMASC());
        EquipmentType.addType(MiscType.createTSM());
        EquipmentType.addType(MiscType.createC3S());
        EquipmentType.addType(MiscType.createC3M());
        EquipmentType.addType(MiscType.createC3I());
        EquipmentType.addType(MiscType.createISArtemis());
        EquipmentType.addType(MiscType.createCLArtemis());
        EquipmentType.addType(MiscType.createGECM());
        EquipmentType.addType(MiscType.createCLECM());
        EquipmentType.addType(MiscType.createISTargComp());
        EquipmentType.addType(MiscType.createCLTargComp());
    }

    public static MiscType createHeatSink() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Heat Sink";
        miscType.mepName = miscType.name;
        miscType.mtfName = miscType.name;
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.flags |= 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createJumpJet() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Jump Jet";
        miscType.mepName = miscType.name;
        miscType.mtfName = miscType.name;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.flags |= 4;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createTreeClub() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Tree Club";
        miscType.mtfName = miscType.mepName = "N/A";
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x28;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createGirderClub() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Girder Club";
        miscType.mtfName = miscType.mepName = "N/A";
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 8;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createLimbClub() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Limb Club";
        miscType.mtfName = miscType.mepName = "N/A";
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 8;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createHatchet() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Hatchet";
        miscType.mepName = miscType.name;
        miscType.mtfName = miscType.name;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.flags |= 0x10;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "Double Heat Sink";
        miscType.internalName = "REMOVE MEEE!!";
        miscType.mepName = "REMOVE ME!";
        miscType.mtfName = "Double Heat Sink";
        miscType.tonnage = 1.0f;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.flags |= 2;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "Double Heat Sink";
        miscType.internalName = "ISDoubleHeatSink";
        miscType.mepName = "IS Double Heat Sink";
        miscType.mtfName = "ISDouble Heat Sink";
        miscType.tonnage = 1.0f;
        miscType.criticals = 3;
        miscType.flags |= 2;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "Double Heat Sink";
        miscType.internalName = "CLDoubleHeatSink";
        miscType.mepName = "Clan Double Heat Sink";
        miscType.mtfName = "CLDouble Heat Sink";
        miscType.tonnage = 1.0f;
        miscType.criticals = 2;
        miscType.flags |= 2;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISCASE() {
        MiscType miscType = new MiscType();
        miscType.name = "CASE";
        miscType.internalName = "ISCASE";
        miscType.mepName = "IS CASE";
        miscType.mtfName = "ISCASE";
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = false;
        miscType.flags |= 0x40;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLCASE() {
        MiscType miscType = new MiscType();
        miscType.name = "CASE";
        miscType.internalName = "CLCASE";
        miscType.mepName = "Clan CASE";
        miscType.mtfName = "CLCASE";
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x40;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISMASC() {
        MiscType miscType = new MiscType();
        miscType.name = "MASC";
        miscType.internalName = "ISMASC";
        miscType.mepName = "IS MASC";
        miscType.mtfName = miscType.internalName;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x80;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createCLMASC() {
        MiscType miscType = new MiscType();
        miscType.name = "MASC";
        miscType.internalName = "CLMASC";
        miscType.mepName = "Clan MASC";
        miscType.mtfName = miscType.internalName;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x80;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createTSM() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "TSM";
        miscType.mepName = "IS TSM";
        miscType.mtfName = "Triple Strength Myomer";
        miscType.tonnage = 0.0f;
        miscType.criticals = 6;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x100;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3S() {
        MiscType miscType = new MiscType();
        miscType.name = "C3 Slave";
        miscType.internalName = "ISC3SlaveUnit";
        miscType.mepName = "IS C3 Slave";
        miscType.mtfName = "ISC3SlaveUnit";
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x400;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3M() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "C3 Master";
        miscType.mepName = "IS C3 Computer";
        miscType.mtfName = "ISC3MasterComputer";
        miscType.tonnage = 5.0f;
        miscType.criticals = 5;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x200;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3I() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "C3i Computer";
        miscType.mepName = miscType.name;
        miscType.mtfName = "ISImprovedC3CPU";
        miscType.tonnage = 2.5f;
        miscType.criticals = 2;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x800;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISArtemis() {
        MiscType miscType = new MiscType();
        miscType.name = "Artemis IV FCS";
        miscType.mtfName = "ISArtemisIV";
        miscType.mepName = "IS Artemis IV FCS";
        miscType.internalName = miscType.mtfName;
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.flags |= 0x1000;
        return miscType;
    }

    public static MiscType createCLArtemis() {
        MiscType miscType = new MiscType();
        miscType.name = "Artemis IV FCS";
        miscType.mtfName = "CLArtemisIV";
        miscType.mepName = "Clan Artemis IV FCS";
        miscType.internalName = miscType.mtfName;
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.flags |= 0x1000;
        return miscType;
    }

    public static MiscType createGECM() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "Guardian ECM Suite";
        miscType.mepName = "IS Guardian ECM";
        miscType.mtfName = "ISGuardianECM";
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x2000;
        miscType.bv = 61.0;
        return miscType;
    }

    public static MiscType createCLECM() {
        MiscType miscType = new MiscType();
        miscType.internalName = miscType.name = "ECM Suite";
        miscType.mepName = "Clan ECM Suite";
        miscType.mtfName = "CLECMSuite";
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.hittable = true;
        miscType.spreadable = false;
        miscType.flags |= 0x2000;
        miscType.bv = 61.0;
        return miscType;
    }

    public static MiscType createISTargComp() {
        MiscType miscType = new MiscType();
        miscType.name = "Targeting Computer";
        miscType.mepName = miscType.internalName = "ISTargeting Computer";
        miscType.mtfName = miscType.internalName;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.bv = -2.147483648E9;
        miscType.flags |= 0x4000;
        miscType.spreadable = true;
        return miscType;
    }

    public static MiscType createCLTargComp() {
        MiscType miscType = new MiscType();
        miscType.name = "Targeting Computer";
        miscType.mepName = miscType.internalName = "CLTargeting Computer";
        miscType.mtfName = miscType.internalName;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.bv = -2.147483648E9;
        miscType.flags |= 0x4000;
        miscType.spreadable = true;
        return miscType;
    }
}

