/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Coords;

public class MovementData
implements Serializable {
    public static final int STEP_FORWARDS = 1;
    public static final int STEP_BACKWARDS = 2;
    public static final int STEP_TURN_LEFT = 3;
    public static final int STEP_TURN_RIGHT = 4;
    public static final int STEP_GET_UP = 5;
    public static final int STEP_GO_PRONE = 6;
    public static final int STEP_START_JUMP = 7;
    public static final int STEP_CHARGE = 8;
    public static final int STEP_DFA = 9;
    public static final int STEP_FLEE = 10;
    public static final int STEP_LATERAL_LEFT = 11;
    public static final int STEP_LATERAL_RIGHT = 12;
    public static final int STEP_LATERAL_LEFT_BACKWARDS = 13;
    public static final int STEP_LATERAL_RIGHT_BACKWARDS = 14;
    public static final int STEP_UNJAM_RAC = 15;
    private Vector steps = new Vector();
    private boolean compiled = false;

    public MovementData() {
    }

    public MovementData(MovementData movementData) {
        this();
        this.append(movementData);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.steps.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((Step)enumeration.nextElement());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.steps.size();
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public void setCompiled(boolean bl) {
        this.compiled = bl;
    }

    public void addStep(int n) {
        this.steps.addElement(new Step(n));
    }

    public Enumeration getSteps() {
        return this.steps.elements();
    }

    public Step getStep(int n) {
        return (Step)this.steps.elementAt(n);
    }

    public void append(MovementData movementData) {
        Enumeration enumeration = movementData.getSteps();
        while (enumeration.hasMoreElements()) {
            this.steps.addElement(enumeration.nextElement());
        }
        this.compiled = false;
    }

    public MovementData getAppended(MovementData movementData) {
        MovementData movementData2 = new MovementData(this);
        movementData2.append(movementData);
        return movementData2;
    }

    public boolean contains(int n) {
        Enumeration enumeration = this.getSteps();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            if (step.getType() != n) continue;
            return true;
        }
        return false;
    }

    public void clearAllFlags() {
        Enumeration enumeration = this.getSteps();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            step.clearAllFlags();
        }
    }

    public Coords getFinalCoords(Coords coords, int n) {
        int n2 = n;
        Coords coords2 = new Coords(coords);
        Enumeration enumeration = this.getSteps();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            switch (step.getType()) {
                case 3: 
                case 4: {
                    n2 = MovementData.getAdjustedFacing(n2, step.getType());
                    break;
                }
                case 1: 
                case 8: 
                case 9: {
                    coords2 = coords2.translated(n2);
                    break;
                }
                case 2: {
                    coords2 = coords2.translated((n2 + 3) % 6);
                    break;
                }
                case 11: {
                    coords2 = coords2.translated((n2 + 5) % 6);
                    break;
                }
                case 12: {
                    coords2 = coords2.translated((n2 + 1) % 6);
                    break;
                }
                case 13: {
                    coords2 = coords2.translated((n2 + 4) % 6);
                    break;
                }
                case 14: {
                    coords2 = coords2.translated((n2 + 2) % 6);
                }
            }
        }
        return coords2;
    }

    public int getFinalFacing(int n) {
        Enumeration enumeration = this.getSteps();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            if (step.getType() != 3 && step.getType() != 4) continue;
            n = MovementData.getAdjustedFacing(n, step.getType());
        }
        return n;
    }

    public void clipToPossible() {
        if (!this.compiled) {
            return;
        }
        Vector<Step> vector = new Vector<Step>();
        Enumeration enumeration = this.steps.elements();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            if (step.getMovementType() == -1) continue;
            vector.addElement(step);
        }
        this.steps = vector;
    }

    public void transformLateralShifts() {
        int n;
        while ((n = this.firstLateralShift()) != -1) {
            int n2 = this.getStep(n).getType();
            this.steps.removeElementAt(n);
            this.steps.removeElementAt(n);
            this.steps.removeElementAt(n);
            this.steps.insertElementAt(new Step(MovementData.lateralShiftForTurn(n2)), n);
        }
    }

    public void transformLateralShiftsBackwards() {
        int n;
        while ((n = this.firstLateralShiftBackwards()) != -1) {
            int n2 = this.getStep(n).getType();
            this.steps.removeElementAt(n);
            this.steps.removeElementAt(n);
            this.steps.removeElementAt(n);
            this.steps.insertElementAt(new Step(MovementData.lateralShiftBackwardsForTurn(n2)), n);
        }
    }

    private int firstLateralShift() {
        int n = 0;
        while (n < this.length() - 2) {
            int n2 = this.getStep(n).getType();
            int n3 = this.getStep(n + 1).getType();
            int n4 = this.getStep(n + 2).getType();
            if (MovementData.oppositeTurn(n2, n4) && n3 == 1) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int firstLateralShiftBackwards() {
        int n = 0;
        while (n < this.length() - 2) {
            int n2 = this.getStep(n).getType();
            int n3 = this.getStep(n + 1).getType();
            int n4 = this.getStep(n + 2).getType();
            if (MovementData.oppositeTurn(n2, n4) && n3 == 2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean oppositeTurn(int n, int n2) {
        switch (n) {
            case 3: {
                return n2 == 4;
            }
            case 4: {
                return n2 == 3;
            }
        }
        return false;
    }

    public static int lateralShiftForTurn(int n) {
        switch (n) {
            case 3: {
                return 11;
            }
            case 4: {
                return 12;
            }
        }
        return n;
    }

    public static int lateralShiftBackwardsForTurn(int n) {
        switch (n) {
            case 3: {
                return 14;
            }
            case 4: {
                return 13;
            }
        }
        return n;
    }

    public static int turnForLateralShift(int n) {
        switch (n) {
            case 11: {
                return 3;
            }
            case 12: {
                return 4;
            }
        }
        return n;
    }

    public static int turnForLateralShiftBackwards(int n) {
        switch (n) {
            case 13: {
                return 4;
            }
            case 14: {
                return 3;
            }
        }
        return n;
    }

    public static int getDirection(int n, int n2) {
        int n3 = (n2 + (6 - n)) % 6;
        return n3 >= 3 ? 3 : 4;
    }

    public static int getAdjustedFacing(int n, int n2) {
        if (n2 == 4) {
            return (n + 1) % 6;
        }
        if (n2 == 3) {
            return (n + 5) % 6;
        }
        return n;
    }

    public int getMpUsed() {
        int n = 0;
        Enumeration enumeration = this.steps.elements();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            n = step.getMpUsed();
        }
        return n;
    }

    public int getHexesMoved() {
        int n = 0;
        Enumeration enumeration = this.steps.elements();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            if (step.getType() != 1 && step.getType() != 2 && step.getType() != 8 && step.getType() != 12 && step.getType() != 11 && step.getType() != 14 && step.getType() != 13) continue;
            ++n;
        }
        return n;
    }

    public class Step
    implements Serializable {
        private int type;
        private transient Coords position;
        private transient int facing;
        private transient int mpUsed;
        private transient int distance;
        private transient int movementType;
        private transient boolean danger;
        private transient boolean pastDanger;

        public Step(int n) {
            this.type = n;
        }

        public Step(Step step) {
            this.type = step.type;
            this.position = new Coords(step.position);
            this.facing = step.facing;
            this.mpUsed = step.mpUsed;
            this.distance = step.distance;
            this.movementType = step.movementType;
            this.danger = step.danger;
            this.pastDanger = step.pastDanger;
        }

        public String toString() {
            switch (this.type) {
                case 2: {
                    return "B";
                }
                case 8: {
                    return "Ch";
                }
                case 9: {
                    return "DFA";
                }
                case 1: {
                    return "F";
                }
                case 5: {
                    return "Up";
                }
                case 6: {
                    return "Prone";
                }
                case 7: {
                    return "StrJump";
                }
                case 3: {
                    return "L";
                }
                case 4: {
                    return "R";
                }
                case 11: {
                    return "ShL";
                }
                case 12: {
                    return "ShR";
                }
                case 13: {
                    return "ShLB";
                }
                case 14: {
                    return "ShRB";
                }
                case 15: {
                    return "Unjam";
                }
            }
            return "";
        }

        public int getType() {
            return this.type;
        }

        public Coords getPosition() {
            return this.position;
        }

        public void setPosition(Coords coords) {
            this.position = coords;
        }

        public int getFacing() {
            return this.facing;
        }

        public void setFacing(int n) {
            this.facing = n;
        }

        public int getMpUsed() {
            return this.mpUsed;
        }

        public void setMpUsed(int n) {
            this.mpUsed = n;
        }

        public int getDistance() {
            return this.distance;
        }

        public void setDistance(int n) {
            this.distance = n;
        }

        public int getMovementType() {
            return this.movementType;
        }

        public void setMovementType(int n) {
            this.movementType = n;
        }

        public boolean isDanger() {
            return this.danger;
        }

        public void setDanger(boolean bl) {
            this.danger = bl;
        }

        public boolean isPastDanger() {
            return this.pastDanger;
        }

        public void setPastDanger(boolean bl) {
            this.pastDanger = bl;
        }

        public void clearAllFlags() {
            Object var1_1 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
        }

        public Object clone() {
            return new Step(this);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Step step = (Step)object;
            return step.type == this.type && step.position.equals(this.position) && step.facing == this.facing && step.mpUsed == this.mpUsed && step.distance == this.distance && step.movementType == this.movementType && step.danger == this.danger && step.pastDanger == this.pastDanger;
        }
    }
}

