/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Packet
implements Serializable {
    public static final int COMMAND_SERVER_GREETING = 1;
    public static final int COMMAND_CLIENT_NAME = 2;
    public static final int COMMAND_LOCAL_PN = 3;
    public static final int COMMAND_PLAYER_ADD = 4;
    public static final int COMMAND_PLAYER_REMOVE = 5;
    public static final int COMMAND_PLAYER_UPDATE = 6;
    public static final int COMMAND_PLAYER_READY = 7;
    public static final int COMMAND_CHAT = 8;
    public static final int COMMAND_ENTITY_ADD = 9;
    public static final int COMMAND_ENTITY_REMOVE = 10;
    public static final int COMMAND_ENTITY_MOVE = 11;
    public static final int COMMAND_ENTITY_DEPLOY = 27;
    public static final int COMMAND_ENTITY_ATTACK = 12;
    public static final int COMMAND_ENTITY_READY = 13;
    public static final int COMMAND_ENTITY_UPDATE = 14;
    public static final int COMMAND_ENTITY_MODECHANGE = 26;
    public static final int COMMAND_CHANGE_HEX = 25;
    public static final int COMMAND_PHASE_CHANGE = 15;
    public static final int COMMAND_TURN = 16;
    public static final int COMMAND_SENDING_BOARD = 17;
    public static final int COMMAND_SENDING_ENTITIES = 18;
    public static final int COMMAND_SENDING_PLAYERS = 19;
    public static final int COMMAND_SENDING_REPORT = 20;
    public static final int COMMAND_SENDING_GAME_SETTINGS = 21;
    public static final int COMMAND_SENDING_MAP_SETTINGS = 22;
    public static final int COMMAND_QUERY_MAP_SETTINGS = 23;
    public static final int COMMAND_END_OF_GAME = 24;
    private int command;
    private Object[] data;
    private boolean zipped = false;

    public Packet(int n) {
        this(n, null);
    }

    public Packet(int n, Object object) {
        this.command = n;
        this.data = new Object[1];
        this.data[0] = object;
    }

    public Packet(int n, Object[] objectArray) {
        this.command = n;
        this.data = objectArray;
    }

    public int getCommand() {
        return this.command;
    }

    public Object[] getData() {
        if (this.zipped) {
            this.unzipData();
        }
        return this.data;
    }

    public Object getObject(int n) {
        if (this.zipped) {
            this.unzipData();
        }
        return this.data[n];
    }

    public void zipData() {
        if (this.zipped) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this.data);
            objectOutputStream.close();
            this.data = new Object[1];
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.data[0] = byArray;
            this.zipped = true;
        }
        catch (IOException iOException) {
            System.err.println("error zipping data");
            System.err.println(iOException);
        }
    }

    public void unzipData() {
        if (!this.zipped) {
            return;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])this.data[0]);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            this.data = (Object[])objectInputStream.readObject();
            objectInputStream.close();
            this.zipped = false;
        }
        catch (IOException iOException) {
            System.err.println("error unzipping data");
            System.err.println(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public int getIntValue(int n) {
        return (Integer)this.getObject(n);
    }

    public boolean getBooleanValue(int n) {
        return (Boolean)this.getObject(n);
    }
}

