/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;

public class Pilot
implements Serializable {
    private String name;
    private int gunnery;
    private int piloting;
    private int hits;
    private boolean unconcious;
    private boolean dead;
    private int rollsNeeded;
    private boolean koThisRound;

    public Pilot() {
        this("Unnamed", 4, 5);
    }

    public Pilot(String string, int n, int n2) {
        this.name = string;
        this.gunnery = n;
        this.piloting = n2;
        this.hits = 0;
        this.unconcious = false;
        this.dead = false;
        this.rollsNeeded = 0;
        this.koThisRound = false;
    }

    public String getName() {
        return this.name;
    }

    public int getGunnery() {
        return this.gunnery;
    }

    public int getPiloting() {
        return this.piloting;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int n) {
        this.hits = n;
    }

    public boolean isUnconcious() {
        return this.unconcious;
    }

    public void setUnconcious(boolean bl) {
        this.unconcious = bl;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean bl) {
        this.dead = bl;
    }

    public boolean isActive() {
        return !this.unconcious && !this.dead;
    }

    public int getRollsNeeded() {
        return this.rollsNeeded;
    }

    public void setRollsNeeded(int n) {
        this.rollsNeeded = n;
    }

    public boolean isKoThisRound() {
        return this.koThisRound;
    }

    public void setKoThisRound(boolean bl) {
        this.koThisRound = bl;
    }

    public String getDesc() {
        String string = new String(this.name);
        if (this.hits > 0) {
            string = string + " (" + this.hits + " hit(s)";
            if (this.isUnconcious()) {
                string = string + " [ko]";
            } else if (this.isDead()) {
                string = string + " [dead]";
            }
            string = string + ")";
        }
        return string;
    }

    public boolean isCustom() {
        return this.gunnery != 4 || this.piloting != 5;
    }

    public double getBVSkillMultiplier() {
        double d = 1.0;
        d = this.gunnery < 4 ? (d += 0.2 * (double)(4 - this.gunnery)) : (d += 0.1 * (double)(4 - this.gunnery));
        return d += 0.05 * (double)(5 - this.piloting);
    }
}

