/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;

public class TargetRoll {
    public static final int IMPOSSIBLE = Integer.MAX_VALUE;
    public static final int AUTOMATIC_FAIL = 0x7FFFFFFE;
    public static final int AUTOMATIC_SUCCESS = Integer.MIN_VALUE;
    private ArrayList modifiers = new ArrayList();
    private int total;

    public TargetRoll() {
    }

    public TargetRoll(int n, String string) {
        this.addModifier(n, string);
    }

    public int getValue() {
        return this.total;
    }

    public String getValueAsString() {
        switch (this.total) {
            case 0x7FFFFFFF: {
                return "Impossible";
            }
            case 0x7FFFFFFE: {
                return "Automatic Failure";
            }
            case -2147483648: {
                return "Automatic Success";
            }
        }
        return Integer.toString(this.total);
    }

    public String getDesc() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            Modifier modifier = (Modifier)iterator.next();
            if (modifier.value == Integer.MAX_VALUE || modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE) {
                return modifier.desc;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(modifier.value < 0 ? " - " : " + ");
            }
            stringBuffer.append(Math.abs(modifier.value));
            stringBuffer.append(" (");
            stringBuffer.append(modifier.desc);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getPlainDesc() {
        Iterator iterator = this.getModifiers();
        if (iterator.hasNext()) {
            return ((Modifier)iterator.next()).desc;
        }
        return "";
    }

    public Iterator getModifiers() {
        return this.modifiers.iterator();
    }

    public void addModifier(int n, String string) {
        this.addModifier(new Modifier(n, string));
    }

    public void addModifier(Modifier modifier) {
        this.modifiers.add((Object)modifier);
        this.recalculate();
    }

    public void append(TargetRoll targetRoll) {
        Iterator iterator = targetRoll.getModifiers();
        while (iterator.hasNext()) {
            this.addModifier((Modifier)iterator.next());
        }
    }

    public void removeAutos() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            Modifier modifier = (Modifier)iterator.next();
            if (modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE) continue;
            arrayList.add((Object)modifier);
        }
        this.modifiers = arrayList;
        this.recalculate();
    }

    private void recalculate() {
        this.total = 0;
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            Modifier modifier = (Modifier)iterator.next();
            if (modifier.value == Integer.MAX_VALUE || modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE) {
                this.total = modifier.value;
                break;
            }
            this.total += modifier.value;
        }
    }

    private class Modifier {
        int value;
        String desc;

        public Modifier(int n, String string) {
            this.value = n;
            this.desc = string;
        }
    }
}

