/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;

public abstract class UnitStatusFormatter {
    private static final String SPACES = "                                   ";

    public static String format(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("=============================================================\n");
        stringBuffer.append(UnitStatusFormatter.formatHeader(entity));
        stringBuffer.append("-------------------------------------------------------------\n");
        stringBuffer.append(UnitStatusFormatter.formatArmor(entity));
        stringBuffer.append("-------------------------------------------------------------\n");
        stringBuffer.append("=============================================================\n");
        return stringBuffer.toString();
    }

    private static String formatHeader(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Model: ").append(entity.getModel()).append("\n");
        stringBuffer.append("Pilot: ").append(entity.crew.getName());
        stringBuffer.append(" (").append(entity.crew.getGunnery()).append("/");
        stringBuffer.append(entity.crew.getPiloting()).append(")\n");
        return stringBuffer.toString();
    }

    private static String formatCrits(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < entity.locations()) {
            stringBuffer.append(UnitStatusFormatter.makeLength(entity.getLocationName(n), 12)).append(": ");
            int n2 = 0;
            int n3 = 0;
            while (n3 < entity.getNumberOfCriticals(n)) {
                CriticalSlot criticalSlot = entity.getCritical(n, n3);
                if (criticalSlot != null) {
                    if (++n2 == 7) {
                        stringBuffer.append("\n              ");
                    } else if (n2 > 1) {
                        stringBuffer.append(",");
                    }
                    if (criticalSlot.getType() == 0) {
                        if (criticalSlot.isHit() || criticalSlot.isDestroyed() || criticalSlot.isMissing()) {
                            stringBuffer.append("*");
                        }
                        if (entity instanceof Mech) {
                            Mech cfr_ignored_0 = (Mech)entity;
                            stringBuffer.append(Mech.systemNames[criticalSlot.getIndex()]);
                        }
                    } else if (criticalSlot.getType() == 1) {
                        Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
                        if (mounted.isHit()) {
                            stringBuffer.append("*");
                        }
                        stringBuffer.append(mounted.getName());
                    }
                }
                ++n3;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String formatArmor(Entity entity) {
        if (entity instanceof Mech) {
            return UnitStatusFormatter.formatArmorMech((Mech)entity);
        }
        return "";
    }

    private static String formatArmorMech(Mech mech) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("         FRONT                REAR                INTERNAL\n");
        if (mech.getWeight() < 70.0f) {
            stringBuffer.append("         (").append(UnitStatusFormatter.renderArmor(mech.getArmor(0))).append(")                 (**)                  (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(0))).append(")\n");
            stringBuffer.append("      /").append(UnitStatusFormatter.renderArmor(mech.getArmor(3))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2))).append("\\           /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(3, true))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1, true))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2, true))).append("\\            /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(3))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(1))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(2))).append("\\\n");
            stringBuffer.append("     (").append(UnitStatusFormatter.renderArmor(mech.getArmor(5)));
            stringBuffer.append("/ || \\").append(UnitStatusFormatter.renderArmor(mech.getArmor(4)));
            stringBuffer.append(")         (   |  |   )          (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(5))).append("/ || \\");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(4))).append(")\n");
            stringBuffer.append("       /  /\\  \\               /  \\                /  /\\  \\\n");
            stringBuffer.append("      (").append(UnitStatusFormatter.renderArmor(mech.getArmor(7)));
            stringBuffer.append("/  \\").append(UnitStatusFormatter.renderArmor(mech.getArmor(6)));
            stringBuffer.append(")             /    \\              (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(7)));
            stringBuffer.append("/  \\").append(UnitStatusFormatter.renderArmor(mech.getInternal(6))).append(")\n");
        } else {
            stringBuffer.append("      .../").append(UnitStatusFormatter.renderArmor(mech.getArmor(0))).append("\\...           .../**\\...            .../");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(0))).append("\\...\n");
            stringBuffer.append("     /").append(UnitStatusFormatter.renderArmor(mech.getArmor(3))).append("| ");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1))).append(" |");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2))).append("\\         /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(3, true))).append("| ");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1, true))).append(" |");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2, true))).append("\\          /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(3))).append("| ");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(1))).append(" |");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(2))).append("\\\n");
            stringBuffer.append("    (").append(UnitStatusFormatter.renderArmor(mech.getArmor(5)));
            stringBuffer.append("). -- .(").append(UnitStatusFormatter.renderArmor(mech.getArmor(4)));
            stringBuffer.append(")       (   |    |   )        (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(5))).append("). -- .(");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(4))).append(")\n");
            stringBuffer.append("       /  /\\  \\             /      \\              /  /\\  \\\n");
            stringBuffer.append("      /").append(UnitStatusFormatter.renderArmor(mech.getArmor(7)));
            stringBuffer.append(".\\/.").append(UnitStatusFormatter.renderArmor(mech.getArmor(6)));
            stringBuffer.append("\\           /        \\            /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(7)));
            stringBuffer.append(".\\/.").append(UnitStatusFormatter.renderArmor(mech.getInternal(6))).append("\\\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static String renderArmor(int n) {
        if (n <= 0) {
            return "xx";
        }
        return UnitStatusFormatter.makeLength(String.valueOf(n), 2, true);
    }

    private static String makeLength(String string, int n) {
        return UnitStatusFormatter.makeLength(string, n, false);
    }

    private static String makeLength(String string, int n, boolean bl) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 < n) {
            if (bl) {
                return SPACES.substring(0, n - n2) + string;
            }
            return string + SPACES.substring(0, n - n2);
        }
        return string.substring(0, n - 2) + "..";
    }

    public static void main(String[] stringArray) throws Exception {
        MechSummary mechSummary = MechSummaryCache.getInstance().getMech(stringArray[0]);
        Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
        System.out.println(UnitStatusFormatter.format(entity));
    }
}

