/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.os.Shortcut;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class ShortcutPanelAutomationHelper
implements PanelAutomation {
    public void makeXMLData(AutomatedInstallData idata, XMLElement panelRoot) {
        Debug.log(this.getClass().getName() + "::entering makeXMLData()");
    }

    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        ShortcutData data;
        int i;
        Shortcut shortcut;
        Vector<ShortcutData> shortcuts = new Vector<ShortcutData>();
        Vector<ExecutableFile> execFiles = new Vector<ExecutableFile>();
        Vector<String> files = new Vector<String>();
        Debug.log(this.getClass().getName() + " Entered runAutomated()");
        try {
            shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            shortcut.initialize(1, "-");
        }
        catch (Throwable exception) {
            Debug.log("Could not create shortcut instance");
            exception.printStackTrace();
            return true;
        }
        if (!shortcut.supported()) {
            Debug.log("shortcuts not supported here");
            return true;
        }
        if (!OsConstraint.oneMatchesCurrentSystem(panelRoot)) {
            Debug.log("Shortcuts Not oneMatchesCurrentSystem");
            return true;
        }
        shortcuts = new Vector();
        XMLElement dataElement = panelRoot.getFirstChildNamed("programGroup");
        String groupName = null;
        if (dataElement != null) {
            groupName = dataElement.getAttribute("name");
        }
        if (groupName == null) {
            groupName = "";
        }
        Vector<XMLElement> shortcutElements = panelRoot.getChildrenNamed("shortcut");
        for (i = 0; i < shortcutElements.size(); ++i) {
            Debug.log(this.getClass().getName() + "runAutomated:shortcutElements " + i);
            data = new ShortcutData();
            dataElement = shortcutElements.elementAt(i);
            data.name = dataElement.getAttribute("name");
            data.addToGroup = Boolean.valueOf(dataElement.getAttribute("group"));
            if (OsVersion.IS_WINDOWS) {
                data.type = Integer.valueOf(dataElement.getAttribute("type"));
            } else {
                Debug.log("WARN: On Linux data.type is NOT an int. Ignored.");
            }
            data.commandLine = dataElement.getAttribute("commandLine");
            data.description = dataElement.getAttribute("description");
            data.iconFile = dataElement.getAttribute("icon");
            data.iconIndex = Integer.valueOf(dataElement.getAttribute("iconIndex"));
            data.initialState = Integer.valueOf(dataElement.getAttribute("initialState"));
            data.target = dataElement.getAttribute("target");
            data.workingDirectory = dataElement.getAttribute("workingDirectory");
            data.deskTopEntryLinux_Encoding = dataElement.getAttribute("encoding", "");
            data.deskTopEntryLinux_MimeType = dataElement.getAttribute("mimetype", "");
            data.deskTopEntryLinux_Terminal = dataElement.getAttribute("terminal", "");
            data.deskTopEntryLinux_TerminalOptions = dataElement.getAttribute("terminalOptions", "");
            data.deskTopEntryLinux_Type = dataElement.getAttribute("type", "");
            data.deskTopEntryLinux_URL = dataElement.getAttribute("url", "");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = dataElement.getAttribute("KdeSubstUID", "false");
            data.deskTopEntryLinux_X_KDE_UserName = dataElement.getAttribute("KdeUsername", "root");
            data.Categories = dataElement.getAttribute("categories", "Application;Development");
            data.TryExec = dataElement.getAttribute("tryexec", "");
            data.createForAll = Boolean.valueOf(dataElement.getAttribute("createForAll", "false"));
            data.userType = Integer.valueOf(dataElement.getAttribute("usertype", Integer.toString(1)));
            shortcuts.add(data);
        }
        System.out.print("[ Creating shortcuts ");
        for (i = 0; i < shortcuts.size(); ++i) {
            data = (ShortcutData)shortcuts.elementAt(i);
            try {
                if (data.subgroup != null) {
                    groupName = groupName + data.subgroup;
                }
                shortcut.setUserType(data.userType);
                shortcut.setLinkName(data.name);
                if (OsVersion.IS_WINDOWS) {
                    shortcut.setLinkType(data.type);
                }
                shortcut.setArguments(data.commandLine);
                shortcut.setDescription(data.description);
                shortcut.setIconLocation(data.iconFile, data.iconIndex);
                shortcut.setShowCommand(data.initialState);
                shortcut.setTargetPath(data.target);
                shortcut.setWorkingDirectory(data.workingDirectory);
                shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                if (!OsVersion.IS_WINDOWS) {
                    shortcut.setType(data.deskTopEntryLinux_Type);
                }
                shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                shortcut.setURL(data.deskTopEntryLinux_URL);
                shortcut.setCreateForAll(data.createForAll);
                if (data.addToGroup) {
                    shortcut.setProgramGroup(groupName);
                } else {
                    shortcut.setProgramGroup("");
                }
                try {
                    System.out.print(".");
                    System.out.flush();
                    shortcut.save();
                    String fileName = shortcut.getFileName();
                    files.add(0, fileName);
                    File file = new File(fileName);
                    File base = new File(shortcut.getBasePath());
                    Vector<File> intermediates = new Vector<File>();
                    execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList<OsConstraint>(), false));
                    files.add(fileName);
                    while ((file = file.getParentFile()) != null && !file.equals(base)) {
                        intermediates.add(file);
                    }
                    if (file == null) continue;
                    Enumeration filesEnum = intermediates.elements();
                    while (filesEnum.hasMoreElements()) {
                        files.add(0, ((File)filesEnum.nextElement()).toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        try {
            if (execFiles != null) {
                FileExecutor executor = new FileExecutor(execFiles);
            }
        }
        catch (NullPointerException nep) {
            nep.printStackTrace();
        }
        catch (RuntimeException cannot) {
            cannot.printStackTrace();
        }
        System.out.println(" done. ]");
        System.out.print("[ Add shortcuts to uninstaller ");
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i2 = 0; i2 < files.size(); ++i2) {
            uninstallData.addFile((String)files.elementAt(i2), true);
            System.out.print(".");
            System.out.flush();
        }
        System.out.println(" done. ]");
        return true;
    }
}

