/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLValidationException;

class XMLUtil {
    XMLUtil() {
    }

    static void skipComment(IXMLReader reader, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        if (reader.read() != '-') {
            XMLUtil.skipTag(reader, '\u0000', entityResolver);
            return;
        }
        int dashesRead = 0;
        block4: while (true) {
            char ch = reader.read();
            switch (ch) {
                case '-': {
                    ++dashesRead;
                    continue block4;
                }
                case '>': {
                    if (dashesRead != 2) break;
                    return;
                }
            }
            dashesRead = 0;
        }
    }

    static void skipTag(IXMLReader reader, char escapeChar, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        int level = 1;
        while (level > 0) {
            char ch = XMLUtil.read(reader, null, escapeChar, entityResolver);
            switch (ch) {
                case '<': {
                    ++level;
                    break;
                }
                case '>': {
                    --level;
                }
            }
        }
    }

    static String scanPublicID(StringBuffer publicID, IXMLReader reader, char escapeChar, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(reader, escapeChar, entityResolver, "UBLIC")) {
            return null;
        }
        XMLUtil.skipWhitespace(reader, escapeChar, null, null);
        publicID.append(XMLUtil.scanString(reader, escapeChar, false, entityResolver));
        XMLUtil.skipWhitespace(reader, escapeChar, null, null);
        return XMLUtil.scanString(reader, escapeChar, false, entityResolver);
    }

    static String scanSystemID(IXMLReader reader, char escapeChar, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(reader, escapeChar, entityResolver, "YSTEM")) {
            return null;
        }
        XMLUtil.skipWhitespace(reader, escapeChar, null, null);
        return XMLUtil.scanString(reader, escapeChar, false, entityResolver);
    }

    static String scanIdentifier(IXMLReader reader, char escapeChar, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        char ch;
        StringBuffer result = new StringBuffer();
        while ((ch = XMLUtil.read(reader, null, escapeChar, entityResolver)) == '_' || ch == ':' || ch == '-' || ch == '.' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch > '~') {
            result.append(ch);
        }
        reader.unread(ch);
        return result.toString();
    }

    static String scanString(IXMLReader reader, char escapeChar, boolean normalizeWhitespace, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        StringBuffer result = new StringBuffer();
        boolean[] isEntity = new boolean[1];
        char delim = XMLUtil.read(reader, null, escapeChar, entityResolver);
        if (delim != '\'' && delim != '\"') {
            XMLUtil.errorExpectedInput(reader.getSystemID(), reader.getLineNr(), "delimited string");
        }
        while (true) {
            char ch = XMLUtil.read(reader, isEntity, escapeChar, entityResolver);
            if (!isEntity[0] && ch == escapeChar) {
                reader.startNewStream(XMLUtil.scanEntity(isEntity, reader, escapeChar, entityResolver));
                ch = reader.read();
            }
            if (!isEntity[0] && ch == delim) break;
            if (normalizeWhitespace && ch < ' ') {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    static Reader scanEntity(boolean[] isCharLiteral, IXMLReader reader, char escapeChar, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        char ch = reader.read();
        StringBuffer keyBuf = new StringBuffer();
        while (ch != ';') {
            keyBuf.append(ch);
            ch = reader.read();
        }
        String key = keyBuf.toString();
        if (key.charAt(0) == '#') {
            if (isCharLiteral != null) {
                isCharLiteral[0] = true;
            }
            char[] chArr = new char[]{key.charAt(1) == 'x' ? (char)Integer.parseInt(key.substring(2), 16) : (char)Integer.parseInt(key.substring(1), 10)};
            return new CharArrayReader(chArr);
        }
        Reader entityReader = entityResolver.getEntity(reader, key);
        if (entityReader == null) {
            XMLUtil.errorInvalidEntity(reader.getSystemID(), reader.getLineNr(), key);
        }
        return entityReader;
    }

    static void skipWhitespace(IXMLReader reader, char escapeChar, StringBuffer buffer, boolean[] isEntity) throws IOException {
        char ch;
        if (buffer == null) {
            while ((ch = reader.read()) == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
            }
        } else {
            while ((ch = reader.read()) == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
                buffer.append(ch);
            }
        }
        reader.unread(ch);
        if (isEntity != null) {
            isEntity[0] = ch == escapeChar;
        }
    }

    static char read(IXMLReader reader, boolean[] isEntityValue, char escapeChar, IXMLEntityResolver entityResolver) throws IOException, XMLParseException {
        char ch = reader.read();
        if (isEntityValue != null) {
            isEntityValue[0] = false;
        }
        if (ch == escapeChar) {
            boolean[] charLiteral = new boolean[1];
            reader.startNewStream(XMLUtil.scanEntity(charLiteral, reader, escapeChar, entityResolver));
            if (charLiteral[0]) {
                ch = reader.read();
                if (isEntityValue != null) {
                    isEntityValue[0] = true;
                }
            } else {
                ch = XMLUtil.read(reader, null, escapeChar, entityResolver);
            }
        }
        return ch;
    }

    static boolean checkLiteral(IXMLReader reader, char escapeChar, IXMLEntityResolver entityResolver, String literal) throws IOException, XMLParseException {
        for (int i = 0; i < literal.length(); ++i) {
            char ch = XMLUtil.read(reader, null, escapeChar, entityResolver);
            if (ch == literal.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static void errorExpectedInput(String systemID, int lineNr, String expectedString) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Expected: " + expectedString);
    }

    static void errorInvalidEntity(String systemID, int lineNr, String key) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Invalid entity: `&" + key + ";'");
    }

    static void errorInvalidInput(String systemID, int lineNr, String unexpectedString) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Invalid input: " + unexpectedString);
    }

    static void errorWrongClosingTag(String systemID, int lineNr, String expectedName, String wrongName) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Closing tag does not match opening tag: `" + wrongName + "' != `" + expectedName + "'");
    }

    static void errorClosingTagNotEmpty(String systemID, int lineNr) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Closing tag must be empty");
    }

    static void errorMissingElement(String systemID, int lineNr, String parentElementName, String missingElementName) throws XMLValidationException {
        throw new XMLValidationException(1, systemID, lineNr, missingElementName, null, null, "Element " + parentElementName + " expects to have a " + missingElementName);
    }

    static void errorUnexpectedElement(String systemID, int lineNr, String parentElementName, String unexpectedElementName) throws XMLValidationException {
        throw new XMLValidationException(2, systemID, lineNr, unexpectedElementName, null, null, "Unexpected " + unexpectedElementName + " in a " + parentElementName);
    }

    static void errorMissingAttribute(String systemID, int lineNr, String elementName, String attributeName) throws XMLValidationException {
        throw new XMLValidationException(3, systemID, lineNr, elementName, attributeName, null, "Element " + elementName + " expects an attribute named " + attributeName);
    }

    static void errorUnexpectedAttribute(String systemID, int lineNr, String elementName, String attributeName) throws XMLValidationException {
        throw new XMLValidationException(4, systemID, lineNr, elementName, attributeName, null, "Element " + elementName + " did not expect an attribute " + "named " + attributeName);
    }

    static void errorInvalidAttributeValue(String systemID, int lineNr, String elementName, String attributeName, String attributeValue) throws XMLValidationException {
        throw new XMLValidationException(5, systemID, lineNr, elementName, attributeName, attributeValue, "Invalid value for attribute " + attributeName);
    }

    static void errorMissingPCData(String systemID, int lineNr, String parentElementName) throws XMLValidationException {
        throw new XMLValidationException(6, systemID, lineNr, null, null, null, "Missing #PCDATA in element " + parentElementName);
    }

    static void errorUnexpectedPCData(String systemID, int lineNr, String parentElementName) throws XMLValidationException {
        throw new XMLValidationException(7, systemID, lineNr, null, null, null, "Unexpected #PCDATA in element " + parentElementName);
    }

    static void validationError(String systemID, int lineNr, String message, String elementName, String attributeName, String attributeValue) throws XMLValidationException {
        throw new XMLValidationException(0, systemID, lineNr, elementName, attributeName, attributeValue, message);
    }
}

