/*
 * Decompiled with CFR 0.152.
 */
package blackjack;

import blackjack.BlackjackProgram;
import blackjack.Card;
import blackjack.Dealer;
import blackjack.GamePanel;
import blackjack.MsgBox;
import blackjack.Player;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;

public class Game
implements Runnable {
    public static final int MIN_TIME = 30;
    public static final long STEP_TIME = 500L;
    public static Image background_tile;
    public static Image table_image;
    public static Image continue_image;
    public static final int MIN_BET = 10;
    public static final int MAX_BET = 1000;
    public static Image chip_image_100;
    public static Image chip_image_50;
    public static Image chip_image_10;
    public static Image chip_image_500;
    public static Image chip_image_1000;
    public static Image chip_image_100_inactive;
    public static Image chip_image_50_inactive;
    public static Image chip_image_10_inactive;
    public static Image chip_image_500_inactive;
    public static Image chip_image_1000_inactive;
    public static Image clear_image;
    public static Image clear_image_inactive;
    public static Image insurance_image;
    public static Image arrow_image;
    public static Font card_value_font;
    public static Font win_font;
    public static Font bet_font;
    private Thread thread = null;
    private BlackjackProgram program;
    private Random rand;
    private AListener a_listener;
    Panel panel;
    GamePanel game_panel;
    public Panel control_panel;
    private Button hit_button;
    private Button stay_button;
    private Button split_button;
    private Button double_button;
    private Card[] card = null;
    private Player player = null;
    private Dealer dealer = null;
    public int continue_x;
    public int continue_y;
    public int chip_x;
    public int chip_y_100;
    public int chip_y_10;
    public int chip_y_50;
    public int chip_y_500;
    public int chip_y_1000;
    public int clear_y;
    public long time_r = 0L;
    public long last_tick = 0L;
    public GameMode game_mode;
    public int won;
    public int left_won;
    public int right_won;
    public int capital;
    public int bet;
    public boolean _double;
    private boolean insurance_possible;
    private boolean insurance;

    public static void LoadImages() throws IOException {
        background_tile = ImageIO.read(new File("data/bg.png"));
        table_image = ImageIO.read(new File("data/table.png"));
        continue_image = ImageIO.read(new File("data/continue.png"));
        chip_image_100 = ImageIO.read(new File("data/100.png"));
        chip_image_10 = ImageIO.read(new File("data/10.png"));
        chip_image_50 = ImageIO.read(new File("data/50.png"));
        chip_image_500 = ImageIO.read(new File("data/500.png"));
        chip_image_1000 = ImageIO.read(new File("data/1000.png"));
        chip_image_100_inactive = ImageIO.read(new File("data/100_inactive.png"));
        chip_image_10_inactive = ImageIO.read(new File("data/10_inactive.png"));
        chip_image_50_inactive = ImageIO.read(new File("data/50_inactive.png"));
        chip_image_500_inactive = ImageIO.read(new File("data/500_inactive.png"));
        chip_image_1000_inactive = ImageIO.read(new File("data/1000_inactive.png"));
        clear_image = ImageIO.read(new File("data/clear.png"));
        clear_image_inactive = ImageIO.read(new File("data/clear_inactive.png"));
        insurance_image = ImageIO.read(new File("data/insurance.png"));
        arrow_image = ImageIO.read(new File("data/arrow.png"));
        card_value_font = new Font("Arial", 0, 16);
        win_font = new Font("Arial", 1, 40);
        bet_font = new Font("Arial", 0, 16);
        Card.LoadImages();
    }

    public Game(BlackjackProgram blackjackProgram) {
        this.program = blackjackProgram;
        this.rand = new Random();
        this.capital = 1000;
        this.bet = 0;
        this.a_listener = new AListener(this);
        this.panel = new Panel();
        this.game_panel = new GamePanel(this);
        this.game_panel.setLayout(null);
        this.game_panel.setBackground(new Color(255, 255, 255));
        this.control_panel = new Panel();
        this.control_panel.setLayout(new GridLayout(1, 2));
        this.control_panel.setMaximumSize(new Dimension(800, 30));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panel.setLayout(gridBagLayout);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.game_panel, gridBagConstraints);
        this.panel.add(this.game_panel);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.control_panel, gridBagConstraints);
        this.panel.add(this.control_panel);
        this.hit_button = new Button("Hit");
        this.stay_button = new Button("Stay");
        this.split_button = new Button("Split");
        this.double_button = new Button("Double");
        this.hit_button.setActionCommand("hit");
        this.stay_button.setActionCommand("stay");
        this.split_button.setActionCommand("split");
        this.double_button.setActionCommand("double");
        this.hit_button.addActionListener(this.a_listener);
        this.stay_button.addActionListener(this.a_listener);
        this.split_button.addActionListener(this.a_listener);
        this.double_button.addActionListener(this.a_listener);
        Font font = new Font("Arial", 1, 15);
        this.hit_button.setForeground(new Color(0, 75, 0));
        this.hit_button.setFont(font);
        this.hit_button.setBackground(new Color(255, 255, 0));
        this.stay_button.setForeground(new Color(0, 75, 0));
        this.stay_button.setFont(font);
        this.stay_button.setBackground(new Color(255, 255, 0));
        this.split_button.setForeground(new Color(0, 75, 0));
        this.split_button.setFont(font);
        this.split_button.setBackground(new Color(255, 255, 0));
        this.double_button.setForeground(new Color(0, 75, 0));
        this.double_button.setFont(font);
        this.double_button.setBackground(new Color(255, 255, 0));
        this.control_panel.add(this.split_button);
        this.control_panel.add(this.double_button);
        this.control_panel.add(this.stay_button);
        this.control_panel.add(this.hit_button);
        this.panel.setBackground(Color.white);
        this.panel.setVisible(true);
        this.card = new Card[312];
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 13; ++k) {
                    this.card[n] = new Card(Card.SuitByID(j), Card.RankByID(k));
                    ++n;
                }
            }
        }
        this.player = new Player(this);
        this.dealer = new Dealer(this);
    }

    public void Start() {
        this.thread = new Thread(this);
        this.thread.start();
        this.NewRound();
    }

    public void NewRound() {
        this.player.NewRound();
        this.dealer.NewRound();
        this.game_mode = GameMode.BET;
        this._double = false;
        this.insurance = false;
    }

    public void PaintGame(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.game_panel.getWidth();
        int n4 = this.game_panel.getHeight();
        this.player.SetPos(n3 / 2 - 100, n4 - 150);
        this.dealer.SetPos(n3 / 2 - 100, 30);
        graphics.setColor(new Color(25, 100, 25));
        graphics.fillRect(0, 0, n3, n4);
        int n5 = background_tile.getWidth(this.program);
        int n6 = (int)Math.ceil((double)n3 / (double)n5);
        int n7 = (int)Math.ceil((double)n4 / (double)n5);
        for (n2 = 0; n2 < n6; ++n2) {
            for (n = 0; n < n7; ++n) {
                graphics.drawImage(background_tile, n2 * n5, n * n5, this.program);
            }
        }
        n2 = n3 / 2 - table_image.getWidth(this.program) / 2;
        n = n4 / 2 - table_image.getHeight(this.program) / 2;
        graphics.drawImage(table_image, n2, n, this.program);
        if (this.game_mode == GameMode.FINISHED || this.game_mode == GameMode.BET) {
            n2 = this.continue_x = n3 - 10 - continue_image.getWidth(this.program);
            n = this.continue_y = n4 - 10 - continue_image.getHeight(this.program);
            graphics.drawImage(continue_image, n2, n, this.program);
        }
        this.player.Paint(graphics);
        this.dealer.Paint(graphics);
        n2 = 5;
        this.chip_x = 5;
        this.clear_y = n4 - 5 - clear_image.getHeight(this.program);
        this.chip_y_10 = this.clear_y - 5 - chip_image_10.getHeight(this.program);
        this.chip_y_50 = this.chip_y_10 - 5 - chip_image_50.getHeight(this.program);
        this.chip_y_100 = this.chip_y_50 - 5 - chip_image_100.getHeight(this.program);
        this.chip_y_500 = this.chip_y_100 - 5 - chip_image_500.getHeight(this.program);
        this.chip_y_1000 = this.chip_y_500 - 5 - chip_image_1000.getHeight(this.program);
        if (this.game_mode == GameMode.BET) {
            graphics.drawImage(chip_image_10, n2, this.chip_y_10, this.program);
            graphics.drawImage(chip_image_50, n2, this.chip_y_50, this.program);
            graphics.drawImage(chip_image_100, n2, this.chip_y_100, this.program);
            graphics.drawImage(chip_image_500, n2, this.chip_y_500, this.program);
            graphics.drawImage(chip_image_1000, n2, this.chip_y_1000, this.program);
            graphics.drawImage(clear_image, n2, this.clear_y, this.program);
        } else {
            graphics.drawImage(chip_image_10_inactive, n2, this.chip_y_10, this.program);
            graphics.drawImage(chip_image_50_inactive, n2, this.chip_y_50, this.program);
            graphics.drawImage(chip_image_100_inactive, n2, this.chip_y_100, this.program);
            graphics.drawImage(chip_image_500_inactive, n2, this.chip_y_500, this.program);
            graphics.drawImage(chip_image_1000_inactive, n2, this.chip_y_1000, this.program);
            graphics.drawImage(clear_image_inactive, n2, this.clear_y, this.program);
        }
        if (this.game_mode == GameMode.PLAY && !this.insurance && this.dealer.card.length >= 1 && this.player.card.length == 2 && this.dealer.card[0].rank == Card.Rank.ACE) {
            graphics.drawImage(insurance_image, 10, 10, this.program);
        }
        String string = String.valueOf(this.capital) + "$ Bet: " + String.valueOf(this.bet) + "$";
        graphics.setFont(bet_font);
        Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string, graphics.getFontMetrics().getFontRenderContext());
        n2 = chip_image_100.getWidth(this.program) + 10;
        n = n4 - 5 - (int)rectangle2D.getHeight();
        graphics.setColor(new Color(255, 255, 100));
        graphics.drawString(string, n2, n);
        if (this.game_mode == GameMode.FINISHED) {
            if (!this.player.split) {
                string = this.won == 1 && this.dealer.busted ? "Dealer busted" : (this.won == 1 ? "You win" : (this.won == 0 ? "Push" : (this.won == -1 && !this.player.busted ? "Dealer wins" : (this.won == -1 ? "Player busted" : ""))));
            } else {
                string = this.left_won == 1 && this.dealer.busted ? "Dealer busted" : (this.left_won == 1 ? "You win" : (this.left_won == 0 ? "Push" : (this.left_won == -1 && this.player.CardsValue(Player.SplitStack.LEFT) <= 21 ? "Dealer wins" : (this.left_won == -1 ? "Player busted" : ""))));
                string = string + "  -------  ";
                string = this.right_won == 1 && this.dealer.busted ? "Dealer busted" : (this.right_won == 1 ? string + "You win" : (this.right_won == 0 ? string + "Push" : (this.right_won == -1 && this.player.CardsValue(Player.SplitStack.LEFT) <= 21 ? string + "Dealer wins" : (this.right_won == -1 ? string + "Player busted" : string + ""))));
                if (this.dealer.busted && this.player.CardsValue(Player.SplitStack.LEFT) <= 21 && this.player.CardsValue(Player.SplitStack.RIGHT) <= 21) {
                    string = "Dealer Busted";
                }
            }
            graphics.setFont(win_font);
            graphics.setColor(new Color(255, 255, 50));
            rectangle2D = graphics.getFont().getStringBounds(string, graphics.getFontMetrics().getFontRenderContext());
            n2 = n3 / 2 - (int)rectangle2D.getWidth() / 2;
            n = n4 / 2 - (int)rectangle2D.getHeight() / 2;
            graphics.drawString(string, n2, n);
        }
        string = "Min: 10$ Max: 1000$";
        graphics.setFont(bet_font);
        graphics.setColor(new Color(255, 255, 50));
        rectangle2D = graphics.getFont().getStringBounds(string, graphics.getFontMetrics().getFontRenderContext());
        n2 = n3 - (int)rectangle2D.getWidth() - 7;
        n = 20;
        graphics.drawString(string, n2, n);
    }

    private void Stay() {
        if (!this.player.split || this.player.split_stack == Player.SplitStack.LEFT) {
            this.game_mode = GameMode.SHOW_DOWN;
        } else {
            this.player.split_stack = Player.SplitStack.LEFT;
            this._double = false;
        }
    }

    public void Action(String string) {
        if (this.game_mode == GameMode.PLAY) {
            if (string.compareTo("hit") == 0) {
                this.player.TakeCard();
            }
            if (string.compareTo("stay") == 0) {
                this.Stay();
            }
            if (string.compareTo("double") == 0 && this.capital >= this.bet) {
                this.RaiseBet(this.bet);
                if (this.player.split) {
                    this.capital -= this.bet;
                }
                this._double = true;
            }
            if (string.compareTo("split") == 0) {
                this.player.Split();
            }
        }
    }

    public static void Sleep(long l) throws InterruptedException {
        Thread.sleep(l);
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this.thread) {
            long l = System.currentTimeMillis();
            this.Run();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 < 30L) {
                long l4 = 30L - l3;
                this.last_tick = 30L;
                try {
                    Game.Sleep(l4);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.last_tick = l3;
        }
    }

    public void Continue() {
        if (this.game_mode == GameMode.FINISHED) {
            if (this.capital + this.bet >= 10) {
                this.NewRound();
            } else {
                MsgBox msgBox = new MsgBox(this.program, "You cannot reach the table minimum! Haha! You've lost the game.", false);
                System.exit(0);
            }
        } else if (this.game_mode == GameMode.BET) {
            if (this.bet >= 10) {
                this.game_mode = GameMode.PLAY;
            } else if (this.capital + this.bet >= 10) {
                MsgBox msgBox = new MsgBox(this.program, "You have to bet at least 10$. Do you want to raist the bet by " + (10 - this.bet) + "$?", true);
                if (msgBox.isOk) {
                    this.RaiseBet(10 - this.bet);
                    this.game_mode = GameMode.PLAY;
                }
            } else {
                MsgBox msgBox = new MsgBox(this.program, "You cannot reach the table minimum! Haha!", false);
            }
        }
    }

    public void Insurance() {
        if (!this.insurance_possible) {
            return;
        }
        if (this.dealer.CardsValue() == 21) {
            MsgBox msgBox = new MsgBox(this.program, "Dealer has Blackjack!", false);
            this.capital += this.bet * 2;
            this.NewRound();
        } else {
            MsgBox msgBox = new MsgBox(this.program, "Dealer has no Blackjack", false);
            this.capital -= this.bet;
        }
        this.insurance = true;
    }

    public void RaiseBet(int n) {
        if (this.capital < n) {
            return;
        }
        this.capital -= n;
        this.bet += n;
    }

    public void ClearBet() {
        this.capital += this.bet;
        this.bet = 0;
    }

    public void Finished() {
        if (!this.player.split) {
            boolean bl;
            int n = this.player.CardsValue();
            int n2 = this.dealer.CardsValue();
            int n3 = 21 - n;
            int n4 = 21 - n2;
            boolean bl2 = n > 21;
            boolean bl3 = bl = n2 > 21;
            this.won = bl2 ? -1 : (!bl2 && bl ? 1 : (this.player.blackjack && !this.dealer.blackjack ? 1 : (this.player.blackjack && this.dealer.blackjack ? 0 : (!this.player.blackjack && this.dealer.blackjack ? -1 : (n3 == n4 ? 0 : (n3 < n4 ? 1 : (n3 > n4 ? -1 : 0)))))));
            int n5 = this.bet;
            if (this.won == 1) {
                this.capital = this.player.blackjack ? (this.capital += this.bet / 2 * 6) : (this.capital += 2 * this.bet);
            } else if (this.won == 0) {
                this.capital += this.bet;
            }
            this.bet = 0;
            this.RaiseBet(n5);
        } else {
            boolean bl;
            int n = this.dealer.CardsValue();
            int n6 = this.player.CardsValue(Player.SplitStack.LEFT);
            int n7 = 21 - n6;
            int n8 = 21 - n;
            boolean bl4 = n6 > 21;
            boolean bl5 = bl = n > 21;
            this.left_won = bl4 ? -1 : (!bl4 && bl ? 1 : (this.dealer.blackjack ? -1 : (n7 == n8 ? 0 : (n7 < n8 ? 1 : (n7 > n8 ? -1 : 0)))));
            if (this.left_won == 1) {
                this.capital += this.bet;
            }
            n6 = this.player.CardsValue(Player.SplitStack.RIGHT);
            n7 = 21 - n6;
            n8 = 21 - n;
            bl4 = n6 > 21;
            boolean bl6 = bl = n > 21;
            this.right_won = bl4 ? -1 : (!bl4 && bl ? 1 : (this.dealer.blackjack ? -1 : (n7 == n8 ? 0 : (n7 < n8 ? 1 : (n7 > n8 ? -1 : 0)))));
            int n9 = this.bet;
            if (this.right_won == 1) {
                this.capital += this.bet;
            }
        }
        this.game_mode = GameMode.FINISHED;
    }

    public void Step() {
        this.insurance_possible = false;
        switch (this.game_mode) {
            case PLAY: {
                if (this.game_mode == GameMode.PLAY && !this.insurance && this.dealer.card.length >= 1 && this.player.card.length == 2) {
                    boolean bl = this.insurance_possible = this.dealer.card[0].rank == Card.Rank.ACE;
                }
                if (this._double) {
                    if (this.player.split) {
                        this.player.TakeCard();
                        this.Stay();
                    }
                    this.player.TakeCard();
                    this.Stay();
                }
                if (!this.player.split) {
                    if (this.player.CardsValue() >= 21) {
                        this.game_mode = GameMode.SHOW_DOWN;
                    }
                    if (this.player.CardsValue() <= 21) break;
                    this.player.busted = true;
                    break;
                }
                if (this.player.CardsValue(this.player.split_stack) >= 21) {
                    this.Stay();
                }
                if (this.player.CardsValue(Player.SplitStack.LEFT) <= 21 || this.player.CardsValue(Player.SplitStack.RIGHT) <= 21) break;
                this.player.busted = true;
                break;
            }
            case SHOW_DOWN: {
                this.ShowDownStep();
                break;
            }
        }
        if (this.game_mode == GameMode.PLAY) {
            this.hit_button.setEnabled(true);
            this.stay_button.setEnabled(true);
            this.split_button.setEnabled(this.player.card.length == 2 && this.player.card[0].Value() == this.player.card[1].Value());
            if (!this.player.split) {
                this.double_button.setEnabled(this.player.card.length == 2 && this.capital >= this.bet);
            } else {
                this.double_button.setEnabled(this.player.right.length == 1 && this.player.split_stack == Player.SplitStack.RIGHT && this.capital >= 2 * this.bet);
            }
        } else {
            this.hit_button.setEnabled(false);
            this.stay_button.setEnabled(false);
            this.split_button.setEnabled(false);
            this.double_button.setEnabled(false);
        }
    }

    public void ShowDownStep() {
        if (!this.player.blackjack && !this.player.busted) {
            if (this.time_r == 0L) {
                this.dealer.ShowDownStep();
                this.time_r = 500L;
            }
        } else {
            this.Finished();
        }
    }

    public void Run() {
        switch (this.game_mode) {
            case PLAY: {
                break;
            }
            case SHOW_DOWN: {
                this.time_r = Math.max(this.time_r - this.last_tick, 0L);
                break;
            }
        }
        this.Step();
        this.panel.repaint();
        this.game_panel.repaint();
    }

    public Card RandomFreeCard() {
        Card card;
        do {
            card = this.card[this.rand.nextInt(312)];
        } while (card.given_away);
        return card;
    }

    class AListener
    implements ActionListener {
        Game game;

        AListener(Game game2) {
            this.game = game2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getID() == 1001) {
                this.game.Action(actionEvent.getActionCommand());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameMode {
        BET,
        PLAY,
        SHOW_DOWN,
        FINISHED;

    }
}

