/*
 * Decompiled with CFR 0.152.
 */
package blackjack;

import blackjack.Card;
import blackjack.Game;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Player {
    public Card[] card;
    public Card[] left;
    public Card[] right;
    public Point pos = new Point();
    public static final int CARD_DIST = 30;
    public static final int PLAYER_WIDTH = 200;
    public static final int PLAYER_HEIGHT = 150;
    public boolean blackjack = false;
    public boolean busted = false;
    public Game game = null;
    public boolean split;
    public SplitStack split_stack;

    Player(Game game) {
        this.game = game;
        this.card = new Card[0];
        this.left = new Card[0];
        this.right = new Card[0];
        this.split = false;
    }

    void AddCard(Card card) {
        if (!this.split) {
            Card[] cardArray = this.card;
            this.card = new Card[cardArray.length + 1];
            System.arraycopy(cardArray, 0, this.card, 0, cardArray.length);
            this.card[cardArray.length] = card;
        } else if (this.split_stack == SplitStack.LEFT) {
            Card[] cardArray = this.left;
            this.left = new Card[cardArray.length + 1];
            System.arraycopy(cardArray, 0, this.left, 0, cardArray.length);
            this.left[cardArray.length] = card;
        } else if (this.split_stack == SplitStack.RIGHT) {
            Card[] cardArray = this.right;
            this.right = new Card[cardArray.length + 1];
            System.arraycopy(cardArray, 0, this.right, 0, cardArray.length);
            this.right[cardArray.length] = card;
        }
    }

    void TakeCard() {
        this.AddCard(this.game.RandomFreeCard());
    }

    void RemoveAllCards() {
        int n;
        for (n = 0; n < this.card.length; ++n) {
            this.card[n].given_away = false;
        }
        if (this.split) {
            for (n = 0; n < this.left.length; ++n) {
                this.left[n].given_away = false;
            }
            for (n = 0; n < this.right.length; ++n) {
                this.right[n].given_away = false;
            }
        }
        this.left = new Card[0];
        this.right = new Card[0];
        this.card = new Card[0];
    }

    public void NewRound() {
        this.RemoveAllCards();
        this.split = false;
        this.TakeCard();
        this.TakeCard();
        this.busted = false;
        this.blackjack = this.CardsValue() == 21;
    }

    void SetPos(int n, int n2) {
        this.pos.setLocation(n, n2);
    }

    int CardsValue() {
        return Player.CardsValue(this.card);
    }

    int CardsValue(SplitStack splitStack) {
        return splitStack == SplitStack.LEFT ? Player.CardsValue(this.left) : Player.CardsValue(this.right);
    }

    public static int CardsValue(Card[] cardArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < cardArray.length; ++n) {
            n2 += cardArray[n].Value();
        }
        int n3 = 0;
        if (n2 > 21) {
            for (n = 0; n < cardArray.length; ++n) {
                if (cardArray[n].rank == Card.Rank.ACE) {
                    ++n3;
                    continue;
                }
                n3 += cardArray[n].Value();
            }
            for (n = 0; n < cardArray.length && cardArray[n].rank == Card.Rank.ACE && n3 + 10 <= 21; ++n) {
                n3 += 10;
            }
            if (n3 <= 21) {
                n2 = n3;
            }
        }
        return n2;
    }

    void Split() {
        this.split = true;
        this.left = new Card[1];
        this.right = new Card[1];
        this.left[0] = this.card[0];
        this.right[0] = this.card[1];
        this.card = new Card[0];
        this.game.capital -= this.game.bet;
        this.split_stack = SplitStack.RIGHT;
    }

    void Paint(Graphics graphics) {
        if (!this.split) {
            if (this.card.length > 0) {
                this.PaintCards(graphics, this.card, 100, 0);
            }
        } else {
            this.PaintCards(graphics, this.left, 0, 0);
            this.PaintCards(graphics, this.right, 200, 0);
            if (this.game.game_mode == Game.GameMode.PLAY) {
                int n = this.pos.x + 100 + (this.split_stack == SplitStack.LEFT ? -100 : 100) - Game.arrow_image.getWidth(null) / 2;
                graphics.drawImage(Game.arrow_image, n, this.pos.y - (Game.arrow_image.getHeight(null) + 10), null);
            }
        }
    }

    void PaintCards(Graphics graphics, Card[] cardArray, int n, int n2) {
        int n3 = n - (30 * (cardArray.length - 1) + 69) / 2;
        int n4 = Player.CardsValue(cardArray);
        for (int i = 0; i < cardArray.length; ++i) {
            if (this.game.game_mode == Game.GameMode.BET) {
                graphics.drawImage(Card.card_back, n3 + i * 30 + this.pos.x, this.pos.y, null);
                continue;
            }
            graphics.drawImage(cardArray[i].CardImage(), n3 + i * 30 + this.pos.x, this.pos.y, null);
        }
        if (this.game.game_mode != Game.GameMode.BET) {
            String string = String.valueOf(n4);
            graphics.setColor(new Color(255, 255, 100));
            graphics.setFont(Game.card_value_font);
            graphics.drawString(string, this.pos.x + n, this.pos.y + 150 - 30);
            if (n4 > 21) {
                graphics.drawImage(Card.busted_image, n - Card.busted_image.getWidth(null) / 2 + this.pos.x, this.pos.y, null);
            }
            if (n4 == 21 && this.blackjack) {
                graphics.drawImage(Card.blackjack_image, n - Card.blackjack_image.getWidth(null) / 2 + this.pos.x, this.pos.y, null);
            } else if (n4 == 21) {
                graphics.drawImage(Card.twenty_one_image, n - Card.twenty_one_image.getWidth(null) / 2 + this.pos.x, this.pos.y, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SplitStack {
        LEFT,
        RIGHT;

    }
}

