/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditorFramePanel;
import edu.xtec.jclic.ActivityEditorMsgPanel;
import edu.xtec.jclic.ActivityEditorOptionsPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.media.EventSoundsEditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.TripleString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ActivityEditor
extends Editor {
    protected static ImageIcon icon;
    protected static final int COMMON_PANELS = 3;
    static final BasicStroke dashedStroke;
    public static final String SYSTEM_LIST = "activities.listactivities";

    public ActivityEditor(Activity act) {
        super(act);
    }

    @Override
    protected void createChildren() {
        Activity act = this.getActivity();
        if (act.acp != null) {
            act.acp.getEditor(this);
        }
    }

    public AutoContentProviderEditor getAutoContentProviderEditor() {
        return (AutoContentProviderEditor)this.getFirstChild(AutoContentProviderEditor.class);
    }

    @Override
    public Class getEditorPanelClass() {
        return ActivityEditorPanel.class;
    }

    @Override
    public synchronized EditorPanel createEditorPanel(Options options) {
        ActivityEditorPanel panel = new ActivityEditorPanel(options);
        panel.addInternalPanel(new ActivityEditorOptionsPanel(panel), null, null);
        panel.addInternalPanel(new ActivityEditorFramePanel(panel), null, null);
        panel.addInternalPanel(new ActivityEditorMsgPanel(panel), null, null);
        this.createPanels(panel);
        return panel;
    }

    @Override
    public String getTitleKey() {
        return "edit_act";
    }

    protected void createPanels(ActivityEditorPanel panel) {
    }

    public Activity getActivity() {
        return (Activity)this.getFirstObject(Activity.class);
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public MediaBagEditor getMediaBagEditor() {
        JClicProjectEditor jcpe = this.getProjectEditor();
        return jcpe == null ? null : jcpe.getMediaBagEditor();
    }

    public Options getOptions() {
        return this.getActivity().getProject().getBridge().getOptions();
    }

    public ActivityBagElementEditor getActivityBagElementEditor() {
        return (ActivityBagElementEditor)this.getFirstParent(ActivityBagElementEditor.class);
    }

    public ActivityBagEditor getActivityBagEditor() {
        return (ActivityBagEditor)this.getFirstParent(ActivityBagEditor.class);
    }

    public boolean rename(String newName, Component parent, Messages msg) {
        String oldName = this.getActivity().name;
        String errMsg = null;
        newName = newName.trim();
        boolean result = false;
        if (!oldName.equals(newName)) {
            if (newName.length() < 1) {
                errMsg = "edit_media_rename_invalid";
            } else if (this.getActivityBagEditor().getActivityBag().getElementByName(newName) != null) {
                errMsg = "edit_media_rename_exists";
            } else {
                result = this.getProjectEditor().nameChanged(1, oldName, newName);
            }
        }
        if (errMsg != null && msg != null && parent != null) {
            msg.showAlert(parent, errMsg);
        }
        return result;
    }

    public synchronized void saveData() {
        ActivityBagElementEditor abee = this.getActivityBagElementEditor();
        if (abee != null) {
            ActivityBagElement abe = abee.getActivityBagElement();
            String name = abe.getName();
            abe.setData(this.getActivity().getJDomElement());
            if (!abe.getName().equals(name)) {
                // empty if block
            }
            if (this.isModified()) {
                abee.setModified(true);
            }
        }
    }

    @Override
    public String toString() {
        return this.getActivity().name;
    }

    @Override
    public void setActionsOwner() {
        if (this.getEditorParent() != null) {
            this.getEditorParent().setActionsOwner();
        }
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/miniclic.png");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return ActivityEditor.getIcon();
    }

    public void drawPreview(Graphics2D g2, Rectangle bounds, int margin) {
        Rectangle r = new Rectangle(bounds.x + margin, bounds.y + margin, bounds.width - 2 * margin, bounds.height - 2 * margin);
        g2.setXORMode(Color.white);
        Stroke str = g2.getStroke();
        g2.setStroke(dashedStroke);
        g2.draw(r);
        g2.setPaintMode();
        g2.setStroke(str);
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        int i;
        boolean result = false;
        Activity act = this.getActivity();
        if ((type & 1) != 0 && oldName.equals(act.name)) {
            act.name = newName;
            result = true;
        }
        for (i = 0; i < act.messages.length; ++i) {
            if (act.messages[i] == null) continue;
            result |= ActiveBoxContentEditor.nameChanged(act.messages[i], type, oldName, newName);
        }
        if ((type & 0x10) != 0 && oldName.equals(act.bgImageFile)) {
            act.bgImageFile = newName;
            result = true;
        }
        if (act.eventSounds != null && (type & 0x60) != 0) {
            result |= EventSoundsEditorPanel.nameChanged(act.eventSounds, type, oldName, newName);
        }
        if ((type & 0x200) != 0 && oldName.equals(act.skinFileName) && !oldName.startsWith("@")) {
            act.skinFileName = newName;
            result = true;
        }
        if (act.abc != null) {
            for (i = 0; i < act.abc.length; ++i) {
                if (act.abc[i] == null) continue;
                result |= ActiveBagContentEditor.nameChanged(act.abc[i], type, oldName, newName);
            }
        }
        if (result) {
            this.setModified(true);
        }
        return result;
    }

    public static List<TripleString> getSystemActivityList(Options options) {
        List<TripleString> result;
        try {
            result = TripleString.getTripleList(SYSTEM_LIST, options, false, true, true);
        }
        catch (Exception ex) {
            System.err.println("Error reading list of activities!\n" + ex);
            result = new ArrayList<TripleString>();
        }
        return result;
    }

    static {
        dashedStroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f}, 0.0f);
    }
}

