/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.AuthorSettingsDlg;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceBridge;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public class AuthorSettings
implements Constants {
    public ResourceBridge rb;
    public String language;
    public String country;
    public String variant;
    public String lookAndFeel;
    public String preferredBrowser;
    public String rootPath;
    public String rootExportPath;
    public String rootScormPath;
    public String mediaSystem;
    public FileSystem fileSystem;
    public String appletCodeBase;
    public String appletWidth;
    public String appletHeight;
    public String jsCodeBase;
    public Color appletBgColor;
    public int imgMaxWidth;
    public int imgMaxHeight;
    public Map<String, Object> misc;
    public static final int MAX_RECENT = 8;
    public String[] recentFiles;
    public String cfgFile;
    public boolean readOnly;
    protected static String defaultCfgFile = null;
    public static final String PROJECTS_PATH = "projects";
    public static final String EXPORT_PATH = "export";
    public static final String SCORM_PATH = "scorm";
    public static final String CFG_FILE = "jclic_author.cfg";
    public static final String DEFAULT_APPLET_CODEBASE = "http://clic.xtec.cat/dist/jclic";
    public static final String DEFAULT_APPLET_WIDTH = "700";
    public static final String DEFAULT_APPLET_HEIGHT = "450";
    public static final Color DEFAULT_APPLET_BGCOLOR = Color.white;
    public static final String DEFAULT_JS_CODEBASE = "https://cdn.jsdelivr.net/jclic.js/latest/jclic.min.js";
    public static final String ELEMENT_NAME = "JClicAuthorSettings";
    public static final String APPLET = "applet";
    public static final String CODEBASE = "codebase";
    public static final String JSCODEBASE = "JScodebase";
    public static final String BGCOLOR = "bgcolor";
    public static final String IMGMAXSIZE = "imgMaxSize";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SOUND = "sound";
    public static final String SYSTEM = "system";
    public static final String MISC = "misc";
    public static final String PATHS = "paths";
    public static final String PATH = "path";
    public static final String ROOT = "root";
    public static final String EXPORT = "export";
    public static final String SCORM = "scorm";
    public static final String RECENT_FILES = "recentFiles";
    public static final String FILE = "file";

    public AuthorSettings(ResourceBridge rb, String fromPath) {
        File f;
        this.rb = rb;
        this.misc = new HashMap<String, Object>();
        this.lookAndFeel = SYSTEM;
        this.preferredBrowser = "";
        this.recentFiles = new String[8];
        this.mediaSystem = "default";
        this.readOnly = false;
        this.rootScormPath = this.rootPath = System.getProperty("user.home");
        this.rootExportPath = this.rootPath;
        this.cfgFile = fromPath == null ? AuthorSettings.getDefaultCfgFile(rb.getOptions()) : fromPath;
        this.fileSystem = new FileSystem(rb);
        this.readOnly = FileSystem.isStrUrl(this.cfgFile) ? true : !(f = new File(this.cfgFile)).canWrite();
        this.appletCodeBase = DEFAULT_APPLET_CODEBASE;
        this.appletWidth = DEFAULT_APPLET_WIDTH;
        this.appletHeight = DEFAULT_APPLET_HEIGHT;
        this.appletBgColor = DEFAULT_APPLET_BGCOLOR;
        this.jsCodeBase = DEFAULT_JS_CODEBASE;
        this.imgMaxWidth = 800;
        this.imgMaxHeight = 600;
    }

    public static String getDefaultCfgFile(Options options) {
        if (defaultCfgFile == null) {
            defaultCfgFile = PersistentSettings.getFilePath("JClic", CFG_FILE, options, true);
        }
        return defaultCfgFile;
    }

    public static AuthorSettings loadAuthorSettings(ResourceBridge rb) {
        AuthorSettings result = null;
        String cfgFile = rb.getOptions().getString(ELEMENT_NAME);
        if (cfgFile != null) {
            try {
                result = new AuthorSettings(rb, cfgFile);
                result.loadSettings(result.fileSystem.getXMLDocument(cfgFile).getRootElement());
            }
            catch (Exception ex) {
                result = null;
                System.err.println("Unable to read settings from " + cfgFile + "\n" + ex);
            }
        }
        if (result == null) {
            cfgFile = AuthorSettings.getDefaultCfgFile(rb.getOptions());
            result = new AuthorSettings(rb, cfgFile);
            try {
                result.loadSettings(result.fileSystem.getXMLDocument(cfgFile).getRootElement());
            }
            catch (Exception ex) {
                result.initNewSettings();
            }
        }
        Options options = rb.getOptions();
        options.syncProperties(result.getProperties(), true);
        if (!options.getBoolean("languageByParam") && result.language != null) {
            options.put("language", result.language);
            if (result.country != null) {
                options.put("country", result.country);
            }
            if (result.variant != null) {
                options.put("variant", result.variant);
            }
        }
        return result;
    }

    private void initNewSettings() {
        try {
            Messages msg = this.rb.getOptions().getMessages();
            if (this.language == null) {
                this.language = msg.getLocale().getLanguage();
                this.country = msg.getLocale().getCountry();
                this.variant = msg.getLocale().getVariant();
            }
            this.readOnly = false;
            File f = new File(new File(this.cfgFile).getParentFile(), PROJECTS_PATH);
            f.mkdirs();
            this.rootPath = f.getAbsolutePath();
            f = new File(new File(this.cfgFile).getParentFile(), "export");
            this.rootExportPath = f.getAbsolutePath();
            f = new File(new File(this.cfgFile).getParentFile(), "scorm");
            this.rootScormPath = f.getAbsolutePath();
            this.fileSystem = new FileSystem(this.rootPath, this.rb);
            this.imgMaxWidth = MediaBagEditor.getImgMaxWidth();
            this.imgMaxHeight = MediaBagEditor.getImgMaxHeight();
        }
        catch (Exception ex) {
            System.err.println("Unable to create new settings!\n" + ex);
        }
    }

    public void save() {
        if (!this.readOnly) {
            try {
                FileOutputStream fos = this.fileSystem.createSecureFileOutputStream(this.cfgFile);
                JDomUtility.saveDocument((OutputStream)fos, this.getJDomElement());
                fos.close();
            }
            catch (Exception ex) {
                System.err.println("unable to save settings in " + this.cfgFile + ": " + ex.getMessage());
            }
        }
    }

    public Element getJDomElement() {
        Element child;
        Element e = new Element(ELEMENT_NAME);
        if (this.language != null) {
            child = new Element("language");
            child.setAttribute("id", this.language);
            if (this.country != null) {
                child.setAttribute("country", this.country);
            }
            if (this.variant != null) {
                child.setAttribute("variant", this.variant);
            }
            e.addContent(child);
        }
        child = new Element(PATHS);
        Element child2 = new Element(PATH);
        child2.setAttribute("id", ROOT);
        child2.setAttribute(PATH, this.rootPath);
        child.addContent(child2);
        child2 = new Element(PATH);
        child2.setAttribute("id", "export");
        child2.setAttribute(PATH, this.rootExportPath);
        child.addContent(child2);
        child2 = new Element(PATH);
        child2.setAttribute("id", "scorm");
        child2.setAttribute(PATH, this.rootScormPath);
        child.addContent(child2);
        e.addContent(child);
        child = new Element(APPLET);
        child.setAttribute(CODEBASE, this.appletCodeBase);
        child.setAttribute(WIDTH, this.appletWidth);
        child.setAttribute(HEIGHT, this.appletHeight);
        child.setAttribute(BGCOLOR, JDomUtility.colorToString(this.appletBgColor));
        child.setAttribute(JSCODEBASE, this.jsCodeBase);
        e.addContent(child);
        child = new Element(SOUND);
        child.setAttribute("mediaSystem", this.mediaSystem);
        e.addContent(child);
        child = new Element("lookAndFeel");
        child.setAttribute("id", this.lookAndFeel);
        e.addContent(child);
        child = new Element("browser");
        child.setAttribute("id", this.preferredBrowser);
        e.addContent(child);
        child = new Element(IMGMAXSIZE);
        child.setAttribute(WIDTH, Integer.toString(this.imgMaxWidth));
        child.setAttribute(HEIGHT, Integer.toString(this.imgMaxHeight));
        e.addContent(child);
        if (!this.misc.isEmpty()) {
            child = new Element(MISC);
            for (Map.Entry<String, Object> me : this.misc.entrySet()) {
                String k = me.getKey();
                Object v = me.getValue();
                if (k == null || v == null || !(v instanceof String)) continue;
                child.setAttribute(k, (String)v);
            }
            e.addContent(child);
        }
        child = new Element(RECENT_FILES);
        for (int i = 0; i < 8; ++i) {
            if (this.recentFiles[i] == null) continue;
            child2 = new Element(FILE);
            child2.setAttribute(PATH, this.recentFiles[i]);
            child.addContent(child2);
        }
        e.addContent(child);
        return e;
    }

    protected void loadSettings(Element e) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        Element child = e.getChild(PATHS);
        if (child != null) {
            File f;
            String rp = null;
            String rpx = null;
            String rps = null;
            for (Element child2 : child.getChildren(PATH)) {
                if (ROOT.equals(child2.getAttributeValue("id"))) {
                    rp = JDomUtility.getStringAttr(child2, PATH, this.rootPath, false);
                    continue;
                }
                if ("export".equals(child2.getAttributeValue("id"))) {
                    rpx = JDomUtility.getStringAttr(child2, PATH, this.rootExportPath, false);
                    continue;
                }
                if (!"scorm".equals(child2.getAttributeValue("id"))) continue;
                rps = JDomUtility.getStringAttr(child2, PATH, this.rootScormPath, false);
            }
            if (rp != null) {
                this.rootPath = rp;
                if (!FileSystem.isStrUrl(this.rootPath)) {
                    this.fileSystem = new FileSystem(this.rootPath, this.rb);
                }
            }
            if (rpx != null) {
                this.rootExportPath = rpx;
            } else if (!FileSystem.isStrUrl(this.rootPath)) {
                f = new File(this.rootPath);
                this.rootExportPath = f.getName().compareToIgnoreCase(PROJECTS_PATH) == 0 && f.getParent() != null ? new File(f.getParentFile(), "export").getPath() : new File(f, "export").getPath();
            }
            if (rps != null) {
                this.rootScormPath = rps;
            } else if (!FileSystem.isStrUrl(this.rootPath)) {
                f = new File(this.rootPath);
                this.rootScormPath = f.getName().compareToIgnoreCase(PROJECTS_PATH) == 0 && f.getParent() != null ? new File(f.getParentFile(), "scorm").getPath() : new File(f, "scorm").getPath();
            }
        }
        if ((child = e.getChild(APPLET)) != null) {
            this.appletCodeBase = JDomUtility.getStringAttr(child, CODEBASE, DEFAULT_APPLET_CODEBASE, false);
            this.appletWidth = JDomUtility.getStringAttr(child, WIDTH, DEFAULT_APPLET_WIDTH, false);
            this.appletHeight = JDomUtility.getStringAttr(child, HEIGHT, DEFAULT_APPLET_HEIGHT, false);
            this.appletBgColor = JDomUtility.getColorAttr(child, BGCOLOR, DEFAULT_APPLET_BGCOLOR);
            this.jsCodeBase = JDomUtility.getStringAttr(child, JSCODEBASE, DEFAULT_JS_CODEBASE, false);
        }
        if ((child = e.getChild("language")) != null) {
            this.language = JDomUtility.getStringAttr(child, "id", this.language, false);
            this.country = JDomUtility.getStringAttr(child, "country", this.country, false);
            this.variant = JDomUtility.getStringAttr(child, "variant", this.variant, false);
        }
        if ((child = e.getChild(SOUND)) != null) {
            this.mediaSystem = JDomUtility.getStringAttr(child, "mediaSystem", this.mediaSystem, false);
        }
        if ((child = e.getChild("lookAndFeel")) != null) {
            this.lookAndFeel = JDomUtility.getStringAttr(child, "id", this.lookAndFeel, false);
        }
        if ((child = e.getChild("browser")) != null) {
            this.preferredBrowser = JDomUtility.getStringAttr(child, "id", this.preferredBrowser, false);
            BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
        }
        if ((child = e.getChild(IMGMAXSIZE)) != null) {
            this.imgMaxWidth = JDomUtility.getIntAttr(child, WIDTH, 800);
            this.imgMaxHeight = JDomUtility.getIntAttr(child, HEIGHT, 600);
            MediaBagEditor.setImgMaxWidth(this.imgMaxWidth);
            MediaBagEditor.setImgMaxHeight(this.imgMaxHeight);
        }
        if ((child = e.getChild(MISC)) != null) {
            for (Attribute a : child.getAttributes()) {
                this.misc.put(a.getName(), a.getValue());
            }
        }
        if ((child = e.getChild(RECENT_FILES)) != null) {
            Iterator it = child.getChildren(FILE).iterator();
            for (int i = 0; i < 8; ++i) {
                this.recentFiles[i] = it.hasNext() ? JDomUtility.getStringAttr((Element)it.next(), PATH, null, false) : null;
            }
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        String t = "true";
        String f = "false";
        if (this.language != null) {
            prop.put("language", this.language);
            prop.put("country", this.country);
            prop.put("variant", this.variant);
        }
        prop.put("lookAndFeel", this.lookAndFeel);
        prop.put("mediaSystem", this.mediaSystem);
        prop.putAll(this.misc);
        return prop;
    }

    public boolean edit(Component parent) {
        AuthorSettingsDlg dlg = new AuthorSettingsDlg(this, parent);
        dlg.setVisible(true);
        if (dlg.result) {
            BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
            MediaBagEditor.setImgMaxWidth(this.imgMaxWidth);
            MediaBagEditor.setImgMaxHeight(this.imgMaxHeight);
        }
        return dlg.result;
    }

    public void addRecentFile(String fName) {
        String[] recentBak = this.recentFiles;
        this.recentFiles = new String[8];
        this.recentFiles[0] = fName;
        int j = 1;
        for (int i = 0; i < 8 && j < 8; ++i) {
            if (recentBak[i] == null || recentBak[i].equals(fName)) continue;
            this.recentFiles[j++] = recentBak[i];
        }
    }
}

