/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceElementEditorPanel;
import edu.xtec.jclic.bags.ActivitySequenceTable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ActivitySequenceEditorPanel
extends EditorPanel
implements ListSelectionListener,
ListDataListener {
    public static final int ICON_WIDTH = 20;
    public ActivitySequenceElementEditor currentItem;
    protected SeqTableModel tableModel;
    private TableCellRenderer headerIcoCellRenderer = new TableCellRenderer(){
        JLabel lb;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.lb == null) {
                this.lb = new JLabel();
                Object o = UIManager.get("TableHeader.background");
                if (o instanceof Color) {
                    this.lb.setBackground((Color)o);
                }
                if ((o = UIManager.get("TableHeader.cellBorder")) instanceof Border) {
                    this.lb.setBorder((Border)o);
                }
                if ((o = UIManager.get("TableHeader.font")) instanceof Font) {
                    this.lb.setFont((Font)o);
                }
                if ((o = UIManager.get("TableHeader.foreground")) instanceof Color) {
                    this.lb.setForeground((Color)o);
                }
            }
            if ("prev".equals(value)) {
                this.lb.setText("");
                this.lb.setIcon(ResourceManager.getImageIcon("icons/prev.gif"));
                this.lb.setToolTipText(ActivitySequenceEditorPanel.this.options.getMsg("action_prev_tooltip"));
            } else if ("next".equals(value)) {
                this.lb.setText("");
                this.lb.setIcon(ResourceManager.getImageIcon("icons/next.gif"));
                this.lb.setToolTipText(ActivitySequenceEditorPanel.this.options.getMsg("action_next_tooltip"));
            }
            return this.lb;
        }
    };
    private JPanel edit;
    protected JTable seqTable;
    private JSplitPane split;

    public ActivitySequenceEditorPanel(Options options) {
        super(options);
        this.tableModel = new SeqTableModel();
        ActivitySequenceEditor.createActions(options);
        ActivitySequenceElementEditor.createActions(options);
        this.initComponents();
        this.initTable();
        this.postInit(250, false, true);
        this.setEnabled(false);
    }

    private void initTable() {
        for (int i = 2; i < 4; ++i) {
            TableColumn column = this.seqTable.getColumnModel().getColumn(i);
            column.setMaxWidth(20);
            column.setPreferredWidth(20);
            column.setWidth(20);
            column.setHeaderRenderer(this.headerIcoCellRenderer);
        }
        this.seqTable.getSelectionModel().setSelectionMode(0);
        this.seqTable.getSelectionModel().addListSelectionListener(this);
    }

    protected void currentItemChanged() {
        if (!this.isInitializing()) {
            ActivitySequenceElementEditorPanel asep = (ActivitySequenceElementEditorPanel)this.edit;
            asep.attachEditor(this.currentItem, true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (ev.getValueIsAdjusting() || this.getActivitySequenceEditor() == null) {
            return;
        }
        ActivitySequenceElementEditorPanel asep = (ActivitySequenceElementEditorPanel)this.edit;
        int row = this.seqTable.getSelectionModel().getAnchorSelectionIndex();
        this.currentItem = row >= 0 && row < this.getActivitySequenceEditor().getChildCount() ? (ActivitySequenceElementEditor)this.getActivitySequenceEditor().getChildAt(row) : null;
        this.currentItemChanged();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        ((ActivitySequenceElementEditorPanel)this.edit).focusGained(focusEvent);
    }

    private void initComponents() {
        this.split = new JSplitPane();
        JScrollPane scroll = new JScrollPane();
        this.seqTable = new ActivitySequenceTable(this.tableModel);
        this.edit = new ActivitySequenceElementEditorPanel(this.options);
        this.setLayout(new BorderLayout());
        scroll.setMinimumSize(new Dimension(300, 50));
        scroll.setViewportView(this.seqTable);
        this.split.setLeftComponent(scroll);
        this.split.setRightComponent(this.edit);
        this.add((Component)this.split, "Center");
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ActivitySequenceEditor;
    }

    protected ActivitySequence getActivitySequence() {
        if (this.editor == null) {
            return null;
        }
        return ((ActivitySequenceEditor)this.editor).getActivitySequence();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.seqTable.setEnabled(enabled);
    }

    @Override
    public void fillData() {
        ActivitySequenceEditor ased = this.getActivitySequenceEditor();
        if (ased == null) {
            ActivitySequenceElementEditorPanel asep = (ActivitySequenceElementEditorPanel)this.edit;
            asep.removeEditor(true);
        } else {
            ased.setListSelectionModel(this.seqTable.getSelectionModel());
            if (ased.getChildCount() > 0) {
                this.seqTable.getSelectionModel().setSelectionInterval(0, 0);
                ActivitySequenceElementEditorPanel asep = (ActivitySequenceElementEditorPanel)this.edit;
                asep.attachEditor((Editor)ased.getChildAt(0), true);
            }
            this.tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void saveData() {
        ActivitySequence as = this.getActivitySequence();
        if (as != null) {
            // empty if block
        }
    }

    @Override
    protected Icon getIcon() {
        return ActivitySequenceEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return "Activity sequence";
    }

    public ActivitySequenceEditor getActivitySequenceEditor() {
        return (ActivitySequenceEditor)this.getEditor();
    }

    @Override
    protected void setEditor(Editor e) {
        if (this.getEditor() != null) {
            this.getEditor().getListModel().removeListDataListener(this);
        }
        super.setEditor(e);
        if (this.getEditor() != null) {
            this.getEditor().getListModel().addListDataListener(this);
        }
    }

    @Override
    protected void addActionsTo(Container cnt) {
        cnt.add(new SmallButton(ActivitySequenceEditor.newActivitySequenceElementAction));
        cnt.add(new SmallButton(ActivityBagElementEditor.testActivityAction));
        cnt.add(new SmallButton(Editor.moveUpAction));
        cnt.add(new SmallButton(Editor.moveDownAction));
        cnt.add(new SmallButton(Editor.copyAction));
        cnt.add(new SmallButton(Editor.cutAction));
        cnt.add(new SmallButton(Editor.pasteAction));
        cnt.add(new SmallButton(Editor.deleteAction));
    }

    class SeqTableModel
    extends AbstractTableModel {
        SeqTableModel() {
        }

        public boolean drawDivider(int row) {
            boolean result = false;
            ActivitySequenceEditor ase = ActivitySequenceEditorPanel.this.getActivitySequenceEditor();
            if (ase != null) {
                ActivitySequenceElementEditor ased1 = (ActivitySequenceElementEditor)ase.getChildAt(row);
                ActivitySequenceElementEditor ased2 = row == ase.getChildCount() - 1 ? null : (ActivitySequenceElementEditor)ase.getChildAt(row + 1);
                result = ased1 != null && ased1.getActivitySequenceElement().fwdJump != null || ased2 != null && ased2.getActivitySequenceElement().backJump != null;
            }
            return result;
        }

        @Override
        public int getRowCount() {
            Editor e = ActivitySequenceEditorPanel.this.getEditor();
            return e == null ? 0 : e.getChildCount();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 2 || columnIndex == 3) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ActivitySequenceElementEditor ased;
            Object result = null;
            ActivitySequenceEditor ase = ActivitySequenceEditorPanel.this.getActivitySequenceEditor();
            if (ase != null && (ased = (ActivitySequenceElementEditor)ase.getChildAt(row)) != null) {
                switch (column) {
                    case 0: {
                        result = ased.getTag();
                        break;
                    }
                    case 1: {
                        result = ased.getActivitySequenceElement().getActivityName();
                        break;
                    }
                    case 2: 
                    case 3: {
                        result = ActivitySequenceElementEditor.getElementIcon(ased.getActivitySequenceElement(), column == 3);
                    }
                }
            }
            return result;
        }

        @Override
        public String getColumnName(int column) {
            String result = "";
            switch (column) {
                case 0: {
                    result = ActivitySequenceEditorPanel.this.options.getMsg("edit_seq_tag_header");
                    break;
                }
                case 1: {
                    result = ActivitySequenceEditorPanel.this.options.getMsg("edit_seq_activity_header");
                    break;
                }
                case 2: {
                    result = "prev";
                    break;
                }
                case 3: {
                    result = "next";
                }
            }
            return result;
        }
    }
}

