/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.activities.textGrid.CrossWord;
import edu.xtec.jclic.activities.textGrid.WordSearch;
import edu.xtec.jclic.beans.BoxBaseButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TextGridContentControlPanel
extends CtrlPanel {
    ActiveBagContentEditor parent;
    TextGridContent tgc;
    Options options;
    boolean isWordSearch;
    int index;
    private JCheckBox borderChk;
    private BoxBaseButton boxBaseButton;
    private SmallIntEditor heightEdit;
    private SmallIntEditor nColsEdit;
    private SmallIntEditor nRowsEdit;
    private JCheckBox useGridBChk;
    private SmallIntEditor widthEdit;
    private JCheckBox wildTransparentChk;
    private TextListEditor wordListEditor;
    private JLabel wordListLb;
    private JPanel wordSearchPanel;

    public TextGridContentControlPanel(ActiveBagContentEditor parent, int index, boolean isWordSearch) {
        this.setInitializing(true);
        this.isWordSearch = isWordSearch;
        this.parent = parent;
        this.options = parent.getOptions();
        this.index = index;
        this.initComponents();
        if (!isWordSearch) {
            this.wordListLb.setVisible(false);
            this.wordListEditor.setEnabled(false);
            this.wordListEditor.setVisible(false);
            this.useGridBChk.setEnabled(false);
            this.useGridBChk.setVisible(false);
        } else {
            this.wildTransparentChk.setEnabled(false);
            this.wildTransparentChk.setVisible(false);
        }
        this.setInitializing(false);
    }

    private void initComponents() {
        JPanel leftPanel = new JPanel();
        JLabel spacer = new JLabel();
        this.useGridBChk = new JCheckBox();
        JLabel nRowsLb = new JLabel();
        this.nRowsEdit = new SmallIntEditor();
        JLabel nColsLb = new JLabel();
        this.nColsEdit = new SmallIntEditor();
        this.wildTransparentChk = new JCheckBox();
        JLabel spacer2 = new JLabel();
        JLabel widthLb = new JLabel();
        this.widthEdit = new SmallIntEditor();
        JLabel heightLb = new JLabel();
        this.heightEdit = new SmallIntEditor();
        JLabel styleLb = new JLabel();
        this.boxBaseButton = new BoxBaseButton();
        this.boxBaseButton.setOptions(this.options);
        this.borderChk = new JCheckBox();
        this.wordSearchPanel = new JPanel();
        this.wordListLb = new JLabel();
        this.wordListEditor = new TextListEditor(this.options);
        this.setLayout(new GridBagLayout());
        leftPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        leftPanel.add((Component)spacer, gridBagConstraints);
        this.useGridBChk.setToolTipText(this.options.getMsg("edit_act_wordSearch_panelB_tooltip"));
        this.useGridBChk.setText(this.options.getMsg("edit_act_wordSearch_panelB"));
        this.useGridBChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.useGridBChk, gridBagConstraints);
        nRowsLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_rows.gif")));
        nRowsLb.setText(":");
        nRowsLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)nRowsLb, gridBagConstraints);
        this.nRowsEdit.setToolTipText(this.options.getMsg("edit_act_num_rows_tooltip"));
        this.nRowsEdit.setMax(30);
        this.nRowsEdit.setMin(1);
        this.nRowsEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.nRowsEdit, gridBagConstraints);
        nColsLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_cols.gif")));
        nColsLb.setText(":");
        nColsLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)nColsLb, gridBagConstraints);
        this.nColsEdit.setToolTipText(this.options.getMsg("edit_act_num_cols_tooltip"));
        this.nColsEdit.setMax(30);
        this.nColsEdit.setMin(1);
        this.nColsEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.nColsEdit, gridBagConstraints);
        this.wildTransparentChk.setToolTipText(this.options.getMsg("edit_act_wildTransparent_tooltip"));
        this.wildTransparentChk.setText(this.options.getMsg("edit_act_wildTransparent"));
        this.wildTransparentChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.wildTransparentChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        leftPanel.add((Component)spacer2, gridBagConstraints);
        widthLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_width.gif")));
        widthLb.setLabelFor(this.widthEdit);
        widthLb.setText(":");
        widthLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)widthLb, gridBagConstraints);
        this.widthEdit.setToolTipText(this.options.getMsg("edit_act_cell_width_tooltip"));
        this.widthEdit.setMax(999);
        this.widthEdit.setMin(10);
        this.widthEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.widthEdit, gridBagConstraints);
        heightLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_height.gif")));
        heightLb.setLabelFor(this.heightEdit);
        heightLb.setText(":");
        heightLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)heightLb, gridBagConstraints);
        this.heightEdit.setToolTipText(this.options.getMsg("edit_act_cell_height_tooltip"));
        this.heightEdit.setMax(999);
        this.heightEdit.setMin(10);
        this.heightEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.heightEdit, gridBagConstraints);
        styleLb.setText(this.options.getMsg("edit_act_style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)styleLb, gridBagConstraints);
        this.boxBaseButton.setToolTipText(this.options.getMsg("edit_style_tooltip"));
        this.boxBaseButton.addPropertyChangeListener("boxBase", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.boxBaseButton, gridBagConstraints);
        this.borderChk.setText(this.options.getMsg("edit_act_border"));
        this.borderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        leftPanel.add((Component)this.borderChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)leftPanel, gridBagConstraints);
        this.wordSearchPanel.setLayout(new GridBagLayout());
        this.wordListLb.setText(this.options.getMsg("edit_act_hiddenWords"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.wordSearchPanel.add((Component)this.wordListLb, gridBagConstraints);
        this.wordListEditor.setToolTipText(this.options.getMsg("edit_act_hiddenWords_tooltip"));
        this.wordListEditor.setPreferredSize(new Dimension(160, 80));
        this.wordListEditor.setUpperCase(true);
        this.wordListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.wordSearchPanel.add((Component)this.wordListEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.wordSearchPanel, gridBagConstraints);
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        boolean result = true;
        if (this.tgc != null && ev != null && ev.getSource() != null) {
            Object src = ev.getSource();
            if (src == this.boxBaseButton) {
                this.boxBaseButtonActionPerformed();
            } else if (src == this.borderChk) {
                this.borderChkActionPerformed();
            } else if (src == this.useGridBChk && this.isWordSearch) {
                this.parent.enableGridB(this.useGridBChk.isSelected());
                return result;
            }
            if (src == this.widthEdit || src == this.heightEdit) {
                this.parent.abcpp.doResize(this.index, this.widthEdit.getValue(), this.heightEdit.getValue(), true);
            } else {
                if (src == this.nColsEdit || src == this.nRowsEdit) {
                    this.tgc.ncw = this.nColsEdit.getValue();
                    this.tgc.nch = this.nRowsEdit.getValue();
                    this.tgc.completeText();
                }
                this.parent.abcpp.setActiveBagContent(this.index, null, null, this.tgc);
                AbstractBox abx = this.parent.abcpp.getAbstractBox(this.index);
                if (abx != null) {
                    this.boxBaseButton.setPreview(abx);
                }
            }
        }
        return result;
    }

    protected void resized() {
        if (this.tgc != null) {
            this.widthEdit.setValue((int)this.tgc.w);
            this.heightEdit.setValue((int)this.tgc.h);
        }
    }

    public void fillData(Activity act) {
        this.tgc = act != null ? act.tgc : null;
        this.boxBaseButton.setBoxBase(this.tgc != null ? this.tgc.bb : null);
        this.parent.abcpp.setActiveBagContent(this.index, null, null, this.tgc);
        this.boxBaseButton.setPreview(this.parent.abcpp.getAbstractBox(this.index));
        this.boxBaseButton.setEnabled(this.tgc != null);
        this.nColsEdit.setValue(this.tgc != null ? this.tgc.ncw : 1);
        this.nColsEdit.setEnabled(this.tgc != null);
        this.nRowsEdit.setValue(this.tgc != null ? this.tgc.nch : 1);
        this.nRowsEdit.setEnabled(this.tgc != null);
        this.widthEdit.setValue(this.tgc != null ? (int)this.tgc.w : 20);
        this.widthEdit.setEnabled(this.tgc != null);
        this.heightEdit.setValue(this.tgc != null ? (int)this.tgc.h : 20);
        this.heightEdit.setEnabled(this.tgc != null);
        this.borderChk.setSelected(this.tgc != null ? this.tgc.border : true);
        this.borderChk.setEnabled(this.tgc != null);
        if (this.isWordSearch && act instanceof WordSearch) {
            this.useGridBChk.setSelected(act.abc != null && act.abc[0] != null);
            this.wordListEditor.setTextList(((WordSearch)act).getClues());
        } else {
            this.wordListEditor.setTextList(null);
            this.wordListEditor.setEnabled(false);
        }
        if (!this.isWordSearch && act instanceof CrossWord) {
            this.wildTransparentChk.setSelected(((CrossWord)act).wildTransparent);
        } else {
            this.wildTransparentChk.setSelected(false);
        }
    }

    public void saveData(Activity act) {
        if (act != null) {
            act.tgc = this.tgc;
            if (this.isWordSearch && act instanceof WordSearch) {
                ((WordSearch)act).setClues(this.wordListEditor.getTextList(), null);
            } else if (!this.isWordSearch && act instanceof CrossWord) {
                ((CrossWord)act).wildTransparent = this.wildTransparentChk.isSelected();
            }
        }
    }

    private void boxBaseButtonActionPerformed() {
        BoxBase bb = this.boxBaseButton.getBoxBase();
        if (bb != null && this.tgc != null) {
            this.tgc.bb = bb;
        }
    }

    private void borderChkActionPerformed() {
        if (this.tgc != null) {
            this.tgc.border = this.borderChk.isSelected();
        }
    }
}

