/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.TestPlayerContainer;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.ProjectSettingsEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JClicProjectEditor
extends Editor {
    protected static ImageIcon icon;
    ActivityBagEditor abe;
    ActivitySequenceEditor ase;
    MediaBagEditor mbe;
    ProjectSettingsEditor pse;
    TestPlayerContainer testPlayerContainer;

    public JClicProjectEditor(JClicProject project) {
        super(project);
    }

    @Override
    protected void createChildren() {
        JClicProject jcp = this.getProject();
        jcp.mediaBag.addListener(jcp.activityBag);
        this.abe = (ActivityBagEditor)jcp.activityBag.getEditor(this);
        this.ase = (ActivitySequenceEditor)jcp.activitySequence.getEditor(this);
        this.mbe = (MediaBagEditor)jcp.mediaBag.getEditor(this);
        this.pse = (ProjectSettingsEditor)jcp.settings.getEditor(this);
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return null;
    }

    @Override
    public Class getEditorPanelClass() {
        return null;
    }

    public JClicProject getProject() {
        return (JClicProject)this.getFirstObject(JClicProject.class);
    }

    public ActivityBagEditor getActivityBagEditor() {
        return this.abe;
    }

    public ActivitySequenceEditor getActivitySequenceEditor() {
        return this.ase;
    }

    public MediaBagEditor getMediaBagEditor() {
        return this.mbe;
    }

    public ProjectSettingsEditor getProjectSettingsEditor() {
        return this.pse;
    }

    public void setTestPlayerContainer(TestPlayerContainer tpc) {
        this.testPlayerContainer = tpc;
    }

    public TestPlayerContainer getTestPlayerContainer() {
        return this.testPlayerContainer;
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = this.getActivityBagEditor().nameChanged(type, oldName, newName) | this.getActivitySequenceEditor().nameChanged(type, oldName, newName) | this.getMediaBagEditor().nameChanged(type, oldName, newName);
        return result;
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/project_settings.gif");
        }
        return icon;
    }

    public void saveProject(String fileName) throws Exception {
        this.collectData();
        this.getProject().setName(fileName);
        this.getProject().saveProject(fileName);
        this.setModified(false);
    }

    public boolean checkProject(Options options, Component parent, boolean prompt) {
        this.collectData();
        return this.getActivityBagEditor().checkOrphanElements(options, parent, prompt) != 5 && this.getMediaBagEditor().checkOrphanElements(options, parent, prompt) != 5;
    }
}

