/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewProjectDlg
extends JPanel {
    ResourceBridge rb;
    Options options;
    public String name;
    public String fileName;
    public String folder;
    String baseFolder;
    private JFileChooser chooser;
    DocumentListener dl = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changeName(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changeName(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changeName(e);
        }

        protected void changeName(DocumentEvent e) {
            String s;
            boolean fromName = false;
            if (NewProjectDlg.this.nameText.getDocument() == e.getDocument()) {
                s = NewProjectDlg.this.nameText.getText();
                fromName = true;
            } else {
                s = NewProjectDlg.this.fileNameText.getText();
            }
            s = FileSystem.getValidFileName(s.trim());
            if (fromName) {
                NewProjectDlg.this.fileNameText.setText(s);
            }
            if (s.length() > 0) {
                StringBuilder sb = new StringBuilder(NewProjectDlg.this.baseFolder);
                if (!NewProjectDlg.this.baseFolder.endsWith(File.separator)) {
                    sb.append(File.separatorChar);
                }
                sb.append(s);
                NewProjectDlg.this.folderText.setText(sb.substring(0));
            }
        }
    };
    private JLabel extLb;
    private JLabel fileNameLb;
    private JTextField fileNameText;
    private JButton folderBtn;
    private JLabel folderLb;
    private JTextField folderText;
    private JLabel nameLb;
    private JTextField nameText;
    private JLabel spacer;

    public NewProjectDlg(ResourceBridge rb, String baseFolder) {
        this.rb = rb;
        this.options = rb.getOptions();
        this.baseFolder = baseFolder.replace('/', File.separatorChar);
        this.folder = baseFolder;
        this.initComponents();
    }

    private void initComponents() {
        this.nameLb = new JLabel();
        this.nameText = new JTextField();
        this.nameText.getDocument().addDocumentListener(this.dl);
        this.spacer = new JLabel();
        this.fileNameLb = new JLabel();
        this.fileNameText = new JTextField();
        this.fileNameText.getDocument().addDocumentListener(this.dl);
        this.extLb = new JLabel();
        this.folderLb = new JLabel();
        this.folderText = new JTextField();
        this.folderBtn = new JButton();
        this.setLayout(new GridBagLayout());
        this.nameLb.setLabelFor(this.nameText);
        this.nameLb.setText(this.options.getMsg("edit_new_project_name"));
        this.nameLb.setToolTipText(this.options.getMsg("edit_new_project_name_tooltip"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.nameLb, gridBagConstraints);
        this.nameText.setToolTipText(this.options.getMsg("edit_new_project_name_tooltip"));
        this.nameText.setPreferredSize(new Dimension(100, 20));
        this.nameText.setMinimumSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 1);
        this.add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.spacer, gridBagConstraints);
        this.fileNameLb.setText(this.options.getMsg("edit_new_project_filename"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.fileNameLb, gridBagConstraints);
        this.fileNameText.setToolTipText(this.options.getMsg("edit_new_project_filename_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 1);
        this.add((Component)this.fileNameText, gridBagConstraints);
        this.extLb.setText(".jclic.zip");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 1, 4, 4);
        this.add((Component)this.extLb, gridBagConstraints);
        this.folderLb.setLabelFor(this.folderText);
        this.folderLb.setText(this.options.getMsg("edit_new_project_folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.folderLb, gridBagConstraints);
        this.folderText.setToolTipText(this.options.getMsg("edit_new_project_folder_tooltip"));
        this.folderText.setPreferredSize(new Dimension(280, 21));
        this.folderText.setMinimumSize(new Dimension(280, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.folderText, gridBagConstraints);
        this.folderBtn.setText(this.options.getMsg("edit_new_project_folder_browse"));
        this.folderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewProjectDlg.this.folderBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.folderBtn, gridBagConstraints);
    }

    private void folderBtnActionPerformed(ActionEvent evt) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.baseFolder);
            this.chooser.setDialogType(1);
        }
        if (this.chooser.showOpenDialog(this) == 0) {
            this.baseFolder = this.chooser.getCurrentDirectory().getAbsolutePath();
            this.folderText.setText(this.baseFolder);
        }
    }

    public void fillData() {
        this.nameText.setText(this.name == null ? "" : this.name);
        this.fileNameText.setText(this.fileName == null ? "" : this.fileName);
        this.folderText.setText(this.folder == null ? "" : this.folder);
    }

    public void getData() {
        this.name = StrUtils.nullableString(this.nameText.getText());
        this.fileName = StrUtils.nullableString(this.fileNameText.getText());
        this.folder = StrUtils.nullableString(this.folderText.getText());
    }

    public static JClicProject prompt(ResourceBridge rb, Component parent, FileSystem baseFS) {
        JClicProject result = null;
        NewProjectDlg prjDlg = new NewProjectDlg(rb, baseFS.root);
        Messages msg = rb.getOptions().getMessages();
        prjDlg.fillData();
        while (result == null && msg.showInputDlg(parent, prjDlg, "edit_new_project_title")) {
            prjDlg.getData();
            if (prjDlg.name == null || prjDlg.fileName == null || prjDlg.folder == null) {
                msg.showErrorWarning(parent, "edit_new_project_err_empty", null);
                continue;
            }
            try {
                File projectFile;
                boolean folderOk = true;
                File folderFile = new File(prjDlg.folder);
                if (folderFile.exists() && folderFile.isDirectory()) {
                    FilenameFilter ff = Utils.getFileFilter(6, msg).getFilenameFilter();
                    if (folderFile.list(ff).length > 0) {
                        folderOk = msg.showQuestionDlg(parent, "edit_new_project_warning_noEmptyFolder", null, "yn") == 1;
                    }
                } else if (!folderFile.mkdirs()) {
                    msg.showErrorWarning(parent, "edit_new_project_err_folderCreation", null);
                    folderOk = false;
                }
                if (!folderOk || msg.confirmOverwriteFile(parent, projectFile = new File(folderFile, prjDlg.fileName + ".jclic.zip"), "yn") != 1) continue;
                result = new JClicProject(rb, new FileSystem(folderFile.getAbsolutePath(), rb), projectFile.getAbsolutePath());
                result.settings.title = prjDlg.name;
                result.setName(prjDlg.fileName);
                result.saveProject(projectFile.getAbsolutePath());
            }
            catch (Exception ex) {
                msg.showErrorWarning(parent, "ERROR", ex);
            }
        }
        return result;
    }
}

