/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.JigSaw;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JigSawEditorPanel
extends JPanel {
    Options options;
    JigSaw shaper;
    Image img;
    Rectangle previewArea;
    BoxBase previewBb;
    boolean modified;
    static final int MARGIN = 40;
    private JCheckBox randomChk;
    private JSlider toothHeightSlider;
    private JPanel controlPanel;
    private JPanel previewPanel;
    private JSlider toothWidthSlider;

    public JigSawEditorPanel(Options options, JigSaw shaper, Dimension previewDim, Image img, BoxBase previewBb) {
        this.options = options;
        this.shaper = shaper;
        this.img = img;
        this.previewArea = new Rectangle(img == null ? previewDim : new Dimension(img.getWidth(this), img.getHeight(this)));
        this.previewBb = previewBb;
        this.initComponents();
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        JLabel toothHeightLb = new JLabel();
        this.toothHeightSlider = new JSlider();
        JLabel toothWidthLb = new JLabel();
        this.toothWidthSlider = new JSlider();
        this.randomChk = new JCheckBox();
        this.previewPanel = new PreviewPanel();
        this.setLayout(new BorderLayout());
        this.controlPanel.setLayout(new GridBagLayout());
        toothHeightLb.setText(this.options.getMsg("edit_act_toothHeightFactor"));
        toothHeightLb.setLabelFor(this.toothHeightSlider);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)toothHeightLb, gridBagConstraints);
        this.toothHeightSlider.setMinorTickSpacing(5);
        this.toothHeightSlider.setPaintLabels(true);
        this.toothHeightSlider.setPaintTicks(true);
        this.toothHeightSlider.setMajorTickSpacing(25);
        this.toothHeightSlider.setMaximum(50);
        this.toothHeightSlider.setValue((int)(this.shaper.toothHeightFactor * 50.0 / (double)this.shaper.getBaseFactor() * 100.0));
        this.toothHeightSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JigSawEditorPanel.this.toothHeightSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.toothHeightSlider, gridBagConstraints);
        toothWidthLb.setText(this.options.getMsg("edit_act_toothWidthFactor"));
        toothWidthLb.setLabelFor(this.toothWidthSlider);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)toothWidthLb, gridBagConstraints);
        this.toothWidthSlider.setMinorTickSpacing(5);
        this.toothWidthSlider.setPaintLabels(true);
        this.toothWidthSlider.setPaintTicks(true);
        this.toothWidthSlider.setMajorTickSpacing(25);
        this.toothWidthSlider.setValue((int)(this.shaper.baseWidthFactor * 100.0));
        this.toothWidthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JigSawEditorPanel.this.toothWidthSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.toothWidthSlider, gridBagConstraints);
        this.randomChk.setSelected(this.shaper.randomLines);
        this.randomChk.setText(this.options.getMsg("edit_act_toothRandom"));
        this.randomChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JigSawEditorPanel.this.randomChkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.randomChk, gridBagConstraints);
        this.add((Component)this.controlPanel, "North");
        this.previewPanel.setBorder(new TitledBorder(this.options.getMsg("edit_act_preview")));
        this.previewPanel.setPreferredSize(new Dimension(this.previewArea.width + 40, this.previewArea.height + 40));
        this.add((Component)this.previewPanel, "Center");
    }

    private void toothHeightSliderStateChanged(ChangeEvent evt) {
        this.shaper.toothHeightFactor = (double)this.toothHeightSlider.getValue() * (double)this.shaper.getBaseFactor() / 50.0 / 100.0;
        ((PreviewPanel)this.previewPanel).updateView();
    }

    private void toothWidthSliderStateChanged(ChangeEvent evt) {
        this.shaper.baseWidthFactor = (double)this.toothWidthSlider.getValue() / 100.0;
        ((PreviewPanel)this.previewPanel).updateView();
    }

    private void randomChkActionPerformed(ActionEvent evt) {
        this.shaper.randomLines = this.randomChk.isSelected();
        ((PreviewPanel)this.previewPanel).updateView();
    }

    public static Shaper getShaper(Shaper initialShaper, Component parent, Options options, Dimension dim, Image img, BoxBase bb) {
        JigSaw sh;
        Messages msg = options.getMessages();
        if (initialShaper == null || !(initialShaper instanceof JigSaw)) {
            return null;
        }
        try {
            sh = (JigSaw)initialShaper.clone();
        }
        catch (CloneNotSupportedException ex) {
            msg.showErrorWarning(parent, "edit_act_shaper_err", ex);
            return null;
        }
        JigSawEditorPanel jse = new JigSawEditorPanel(options, sh, dim, img, bb);
        boolean b = msg.showInputDlg(parent, jse, "edit_act_shaper_properties");
        return b ? sh : null;
    }

    class PreviewPanel
    extends JPanel {
        List<Shape> shapes = new ArrayList<Shape>();

        PreviewPanel() {
        }

        public void updateView() {
            this.shapes.clear();
            JigSawEditorPanel.this.shaper.reset();
            for (int i = 0; i < JigSawEditorPanel.this.shaper.getNumCells(); ++i) {
                this.shapes.add(JigSawEditorPanel.this.shaper.getShape(i, JigSawEditorPanel.this.previewArea));
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            Color defaultBgColor = g2.getBackground();
            Color defaultColor = g2.getColor();
            g2.setColor(JigSawEditorPanel.this.previewBb.backColor);
            g2.fill(JigSawEditorPanel.this.previewArea);
            g2.setBackground(JigSawEditorPanel.this.previewBb.backColor);
            g2.setColor(JigSawEditorPanel.this.previewBb.borderColor);
            Stroke defaultStroke = g2.getStroke();
            g2.setStroke(JigSawEditorPanel.this.previewBb.getBorder());
            if (JigSawEditorPanel.this.img != null) {
                g2.drawImage(JigSawEditorPanel.this.img, JigSawEditorPanel.this.previewArea.x, JigSawEditorPanel.this.previewArea.y, this);
            }
            for (int i = 0; i < this.shapes.size(); ++i) {
                g2.draw(this.shapes.get(i));
            }
            g2.setStroke(defaultStroke);
            g2.setColor(defaultColor);
            g2.setBackground(defaultBgColor);
            g2.setRenderingHints(rh);
        }

        @Override
        public void doLayout() {
            JigSawEditorPanel.this.previewArea.x = (this.getBounds().width - JigSawEditorPanel.this.previewArea.width) / 2;
            JigSawEditorPanel.this.previewArea.y = (this.getBounds().height - JigSawEditorPanel.this.previewArea.height) / 2;
            this.updateView();
        }
    }
}

