/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdom.Element;

public abstract class Activity
implements Constants,
Editable,
Domable {
    protected JClicProject project;
    public String name = "---";
    public String code;
    public String description;
    public int margin = 8;
    public Color bgColor = DEFAULT_BG_COLOR;
    public Gradient bgGradient;
    public boolean tiledBgImg;
    public String bgImageFile;
    public boolean border = true;
    public boolean absolutePositioned;
    public Point absolutePosition;
    public boolean includeInReports = true;
    public boolean reportActions;
    public boolean helpWindow;
    public boolean showSolution;
    public String helpMsg;
    public EventSounds eventSounds = new EventSounds(null);
    public boolean useOrder;
    public boolean dragCells;
    public String skinFileName;
    public int maxTime;
    public boolean countDownTime;
    public int maxActions;
    public boolean countDownActions;
    public String infoUrl;
    public String infoCmd;
    public static final String[] MSG_TYPE = new String[]{"previous", "initial", "final", "finalError"};
    public static final int PREVIOUS = 0;
    public static final int MAIN = 1;
    public static final int END = 2;
    public static final int END_ERROR = 3;
    public static final int NUM_MSG = 4;
    protected ActiveBoxContent[] messages = new ActiveBoxContent[4];
    protected Dimension windowSize = new Dimension(400, 300);
    protected boolean transparentBg;
    protected Color activityBgColor = DEFAULT_BG_COLOR;
    protected Gradient activityBgGradient;
    protected boolean bTimeCounter = true;
    protected boolean bScoreCounter = true;
    protected boolean bActionsCounter = true;
    protected int shuffles = 31;
    protected AutoContentProvider acp;
    public ActiveBagContent[] abc;
    public TextGridContent tgc;
    public int boxGridPos;
    public boolean[] scramble = new boolean[2];
    public boolean invAss;
    public static final int AB = 0;
    public static final int BA = 1;
    public static final int AUB = 2;
    public static final int BUA = 3;
    public static final String[] LAYOUT_NAMES = new String[]{"AB", "BA", "AUB", "BUA"};
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 300;
    public static final int MINIMUM_WIDTH = 40;
    public static final int MINIMUM_HEIGHT = 40;
    public static final String DEFAULT_NAME = "---";
    public static final int DEFAULT_MARGIN = 8;
    public static final int DEFAULT_SHUFFLES = 31;
    public static final int DEFAULT_GRID_ELEMENT_SIZE = 20;
    public static final Color DEFAULT_BG_COLOR = Color.lightGray;
    public static final String ACTION_MATCH = "MATCH";
    public static final String ACTION_PLACE = "PLACE";
    public static final String ACTION_WRITE = "WRITE";
    public static final String ACTION_SELECT = "SELECT";
    public static final String ACTION_HELP = "HELP";
    public static final String ELEMENT_NAME = "activity";
    public static final String NAME = "name";
    public static final String BASE_CLASS = "edu.xtec.jclic.activities.";
    public static final String BASE_CLASS_TAG = "@";
    public static final String CODE = "code";
    public static final String DESCRIPTION = "description";
    public static final String MESSAGES = "messages";
    public static final String TYPE = "type";
    public static final String SETTINGS = "settings";
    public static final String LAYOUT = "layout";
    public static final String MARGIN = "margin";
    public static final String CONTAINER = "container";
    public static final String BGCOLOR = "bgColor";
    public static final String IMAGE = "image";
    public static final String TILED = "tiled";
    public static final String COUNTERS = "counters";
    public static final String TIME = "time";
    public static final String ACTIONS = "actions";
    public static final String SCORE = "score";
    public static final String WINDOW = "window";
    public static final String TRANSPARENT = "transparent";
    public static final String BORDER = "border";
    public static final String POSITION = "position";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String SIZE = "size";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    public static final String SOLVED_PRIMARY = "solvedPrimary";
    public static final String SOLVED_SECONDARY = "solved_secondary";
    public static final String GRID = "grid";
    public static final String ROW = "row";
    public static final String CLUES = "clues";
    public static final String CLUE = "clue";
    public static final String RANDOM_CHARS = "random_chars";
    public static final String SCRAMBLE = "scramble";
    public static final String TIMES = "times";
    public static final String REPORT = "report";
    public static final String REPORT_ACTIONS = "reportActions";
    public static final String HELP_WINDOW = "helpWindow";
    public static final String HELP_SHOW_SOLUTION = "showSolution";
    public static final String USE_ORDER = "useOrder";
    public static final String DRAG_CELLS = "dragCells";
    public static final String FILE = "file";
    public static final String MAX_TIME = "maxTime";
    public static final String COUNT_DOWN_TIME = "countDownTime";
    public static final String MAX_ACTIONS = "maxActions";
    public static final String COUNT_DOWN_ACTIONS = "countDownActions";
    public static final String INFO_URL = "infoUrl";
    public static final String INFO_CMD = "infoCmd";
    public static final String[][] COMPATIBLE_ACTIVITIES = new String[][]{{"@puzzles.DoublePuzzle", "@puzzles.ExchangePuzzle", "@puzzles.HolePuzzle", "@memory.MemoryGame", "@associations.SimpleAssociation", "@associations.ComplexAssociation", "@panels.Explore", "@panels.Identify", "@panels.InformationScreen", "@text.WrittenAnswer"}, {"@text.FillInBlanks", "@text.Identify", "@text.Order", "@text.Complete"}};

    public Activity(JClicProject project) {
        this.project = project;
    }

    public void initNew() {
        this.name = this.project.getBridge().getMsg("UNNAMED");
    }

    public String getPublicName() {
        return this.name;
    }

    public JClicProject getProject() {
        return this.project;
    }

    @Override
    public Editor getEditor(Editor parent) {
        Object result = null;
        String s = this.getClass().getName() + "Editor";
        try {
            Class.forName(s);
        }
        catch (ClassNotFoundException ex) {
            s = "edu.xtec.jclic.ActivityEditor";
        }
        return Editor.createEditor(s, this, parent);
    }

    public String getShortClassName() {
        String s = this.getClass().getName();
        if (s.startsWith(BASE_CLASS)) {
            s = BASE_CLASS_TAG + s.substring(BASE_CLASS.length());
        }
        return s;
    }

    public String[] getSimilarActivityClasses() {
        String[] result = null;
        String cl = this.getShortClassName();
        String[][] stringArray = COMPATIBLE_ACTIVITIES;
        int n = stringArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String[] classGroup;
            for (String s : classGroup = stringArray[i]) {
                if (!cl.equals(s)) continue;
                result = classGroup;
                continue block0;
            }
        }
        if (result == null) {
            result = new String[]{cl};
        }
        return result;
    }

    @Override
    public Element getJDomElement() {
        Element child3;
        Element child2;
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute("class", this.getShortClassName());
        e.setAttribute(NAME, this.name);
        if (this.code != null) {
            e.setAttribute(CODE, this.code);
        }
        if (this.description != null) {
            JDomUtility.addParagraphs(e, DESCRIPTION, this.description);
        }
        Element child = new Element(MESSAGES);
        for (int i = 0; i < 4; ++i) {
            if (this.messages[i] == null) continue;
            child.addContent(this.messages[i].getJDomElement().setAttribute(TYPE, MSG_TYPE[i]));
        }
        e.addContent(child);
        child = new Element(SETTINGS);
        child.setAttribute(MARGIN, Integer.toString(this.margin));
        if (this.infoUrl != null && this.infoUrl.length() > 0) {
            child.setAttribute(INFO_URL, this.infoUrl);
        } else if (this.infoCmd != null && this.infoCmd.length() > 0) {
            child.setAttribute(INFO_CMD, this.infoCmd);
        }
        if (this.useOrder) {
            child.setAttribute(USE_ORDER, JDomUtility.boolString(this.useOrder));
        }
        if (this.dragCells) {
            child.setAttribute(DRAG_CELLS, JDomUtility.boolString(this.dragCells));
        }
        if (this.maxTime > 0) {
            child.setAttribute(MAX_TIME, Integer.toString(this.maxTime));
            child.setAttribute(COUNT_DOWN_TIME, JDomUtility.boolString(this.countDownTime));
        }
        if (this.maxActions > 0) {
            child.setAttribute(MAX_ACTIONS, Integer.toString(this.maxActions));
            child.setAttribute(COUNT_DOWN_ACTIONS, JDomUtility.boolString(this.countDownActions));
        }
        child.setAttribute(REPORT, JDomUtility.boolString(this.includeInReports));
        if (this.includeInReports) {
            child.setAttribute(REPORT_ACTIONS, JDomUtility.boolString(this.reportActions));
        }
        if (this.helpWindow) {
            child2 = new Element(HELP_WINDOW);
            boolean hsa = this.helpSolutionAllowed();
            if (hsa) {
                child2.setAttribute(HELP_SHOW_SOLUTION, JDomUtility.boolString(this.showSolution));
            }
            if (!(this.helpMsg == null || hsa && this.showSolution)) {
                JDomUtility.setParagraphs(child2, this.helpMsg);
            }
            child.addContent(child2);
        }
        child2 = new Element(CONTAINER);
        child2.setAttribute(BGCOLOR, JDomUtility.colorToString(this.bgColor));
        if (this.bgGradient != null) {
            child2.addContent(this.bgGradient.getJDomElement());
        }
        if (this.bgImageFile != null && this.bgImageFile.length() > 0) {
            child3 = new Element(IMAGE);
            child3.setAttribute(NAME, this.bgImageFile);
            child3.setAttribute(TILED, JDomUtility.boolString(this.tiledBgImg));
            child2.addContent(child3);
        }
        child3 = new Element(COUNTERS);
        child3.setAttribute(TIME, JDomUtility.boolString(this.bTimeCounter));
        child3.setAttribute(ACTIONS, JDomUtility.boolString(this.bActionsCounter));
        child3.setAttribute(SCORE, JDomUtility.boolString(this.bScoreCounter));
        child2.addContent(child3);
        child.addContent(child2);
        child2 = new Element(WINDOW);
        child2.setAttribute(BGCOLOR, JDomUtility.colorToString(this.activityBgColor));
        if (this.activityBgGradient != null) {
            child2.addContent(this.activityBgGradient.getJDomElement());
        }
        if (this.transparentBg) {
            child2.setAttribute(TRANSPARENT, JDomUtility.boolString(this.transparentBg));
        }
        child2.setAttribute(BORDER, JDomUtility.boolString(this.border));
        if (this.absolutePositioned && this.absolutePosition != null) {
            child3 = new Element(POSITION);
            child3.setAttribute(X, Integer.toString(this.absolutePosition.x));
            child3.setAttribute(Y, Integer.toString(this.absolutePosition.y));
            child2.addContent(child3);
        }
        if (this.windowSize.width != 400 || this.windowSize.height != 300) {
            child3 = new Element(SIZE);
            child3.setAttribute(WIDTH, Integer.toString(this.windowSize.width));
            child3.setAttribute(HEIGHT, Integer.toString(this.windowSize.height));
            child2.addContent(child3);
        }
        child.addContent(child2);
        child2 = this.eventSounds.getJDomElement();
        if (child2 != null) {
            child.addContent(child2);
        }
        if (this.skinFileName != null) {
            child2 = new Element("skin");
            child2.setAttribute(FILE, this.skinFileName);
            child.addContent(child2);
        }
        e.addContent(child);
        if (this.acp != null) {
            e.addContent(this.acp.getJDomElement());
        }
        return e;
    }

    public static Activity getActivity(Object o, JClicProject project) throws Exception {
        String className;
        Element e = null;
        Clic3Activity c3a = null;
        if (o instanceof Element) {
            e = (Element)o;
            JDomUtility.checkName(e, ELEMENT_NAME);
            className = JDomUtility.getClassName(e);
        } else if (o instanceof Clic3Activity) {
            c3a = (Clic3Activity)o;
            className = c3a.className;
        } else if (o instanceof String) {
            className = (String)o;
        } else {
            throw new Exception("unknown data!!");
        }
        Class[] cparams = new Class[]{JClicProject.class};
        Object[] initArgs = new Object[]{project};
        if (className.startsWith(BASE_CLASS_TAG)) {
            className = BASE_CLASS + className.substring(1);
        }
        Class<?> activityClass = Class.forName(className);
        Constructor<?> con = activityClass.getConstructor(cparams);
        Activity act = (Activity)con.newInstance(initArgs);
        if (e != null) {
            act.setProperties(e, null);
        } else if (c3a != null) {
            act.setProperties(c3a);
        } else {
            act.initNew();
        }
        return act;
    }

    public Activity duplicate() throws Exception {
        return Activity.getActivity(this.getJDomElement(), this.project);
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(e, NAME, this.name, false);
        this.code = JDomUtility.getStringAttr(e, CODE, this.code, false);
        Element child = e.getChild(DESCRIPTION);
        if (child != null) {
            this.description = JDomUtility.getParagraphs(child);
        }
        if ((child = e.getChild(MESSAGES)) != null) {
            for (Element child2 : child.getChildren("cell")) {
                int i = JDomUtility.getStrIndexAttr(child2, TYPE, MSG_TYPE, -1);
                if (i < 0) continue;
                this.messages[i] = ActiveBoxContent.getActiveBoxContent(child2, this.project.mediaBag);
            }
        }
        if ((child = e.getChild(SETTINGS)) != null) {
            Element child3;
            Element child2;
            this.margin = JDomUtility.getIntAttr(child, MARGIN, this.margin);
            this.infoUrl = JDomUtility.getStringAttr(child, INFO_URL, this.infoUrl, false);
            if (this.infoUrl == null) {
                this.infoCmd = JDomUtility.getStringAttr(child, INFO_CMD, this.infoCmd, false);
            }
            this.useOrder = JDomUtility.getBoolAttr(child, USE_ORDER, this.useOrder);
            this.dragCells = JDomUtility.getBoolAttr(child, DRAG_CELLS, this.dragCells);
            this.maxTime = JDomUtility.getIntAttr(child, MAX_TIME, this.maxTime);
            if (this.maxTime > 0) {
                this.countDownTime = JDomUtility.getBoolAttr(child, COUNT_DOWN_TIME, this.countDownTime);
            }
            this.maxActions = JDomUtility.getIntAttr(child, MAX_ACTIONS, this.maxActions);
            if (this.maxActions > 0) {
                this.countDownActions = JDomUtility.getBoolAttr(child, COUNT_DOWN_ACTIONS, this.countDownActions);
            }
            this.includeInReports = JDomUtility.getBoolAttr(child, REPORT, this.includeInReports);
            this.reportActions = this.includeInReports ? JDomUtility.getBoolAttr(child, REPORT_ACTIONS, this.reportActions) : false;
            child2 = child.getChild(HELP_WINDOW);
            if (child2 != null) {
                if (this.helpSolutionAllowed()) {
                    this.showSolution = JDomUtility.getBoolAttr(child2, HELP_SHOW_SOLUTION, this.showSolution);
                }
                if (!this.showSolution) {
                    this.helpMsg = JDomUtility.getParagraphs(child2);
                }
                boolean bl = this.helpWindow = this.helpMsg != null || this.showSolution;
            }
            if ((child2 = child.getChild(CONTAINER)) != null) {
                this.bgColor = JDomUtility.getColorAttr(child2, BGCOLOR, this.bgColor);
                child3 = child2.getChild("gradient");
                if (child3 != null) {
                    this.bgGradient = Gradient.getGradient(child3);
                }
                if ((child3 = child2.getChild(IMAGE)) != null) {
                    this.bgImageFile = child3.getAttributeValue(NAME);
                    this.tiledBgImg = JDomUtility.getBoolAttr(child3, TILED, this.tiledBgImg);
                }
                if ((child3 = child2.getChild(COUNTERS)) != null) {
                    this.bTimeCounter = JDomUtility.getBoolAttr(child3, TIME, this.bTimeCounter);
                    this.bActionsCounter = JDomUtility.getBoolAttr(child3, ACTIONS, this.bActionsCounter);
                    this.bScoreCounter = JDomUtility.getBoolAttr(child3, SCORE, this.bScoreCounter);
                    String v = this.project.version;
                    if (v != null && v.compareTo("0.1.1") <= 0) {
                        boolean b = this.bScoreCounter;
                        this.bScoreCounter = this.bTimeCounter;
                        this.bTimeCounter = this.bActionsCounter;
                        this.bActionsCounter = b;
                    }
                }
            }
            if ((child2 = child.getChild(WINDOW)) != null) {
                this.activityBgColor = JDomUtility.getColorAttr(child2, BGCOLOR, this.activityBgColor);
                child3 = child2.getChild("gradient");
                if (child3 != null) {
                    this.activityBgGradient = Gradient.getGradient(child3);
                }
                this.transparentBg = JDomUtility.getBoolAttr(child2, TRANSPARENT, this.transparentBg);
                this.border = JDomUtility.getBoolAttr(child2, BORDER, this.border);
                child3 = child2.getChild(POSITION);
                if (child3 != null) {
                    this.absolutePositioned = true;
                    this.absolutePosition = JDomUtility.getPointAttr(child3, X, Y, this.absolutePosition);
                }
                if ((child3 = child2.getChild(SIZE)) != null) {
                    this.windowSize = JDomUtility.getDimensionAttr(child3, WIDTH, HEIGHT, this.windowSize);
                }
            }
            if ((child2 = child.getChild("eventSounds")) != null) {
                this.eventSounds = EventSounds.getEventSounds(child2);
            }
            if ((child2 = child.getChild("skin")) != null) {
                this.skinFileName = JDomUtility.getStringAttr(child2, FILE, this.skinFileName, false);
            }
        }
        if ((child = e.getChild("automation")) != null) {
            this.acp = AutoContentProvider.getAutoContentProvider(child);
        }
    }

    public void setProperties(Clic3Activity c3a) throws Exception {
        this.name = c3a.fileName;
        if (c3a.fileDesc.length() > 0) {
            this.description = c3a.fileDesc;
        }
        BoxBase bbMessage = c3a.getBoxBase(2);
        for (int i = 1; i < 3; ++i) {
            this.messages[i] = new ActiveBoxContent();
            this.messages[i].setBoxBase(bbMessage);
            c3a.setActiveBoxTextContent(this.messages[i], i == 1 ? c3a.initMess : c3a.endMess);
            if (this.messages[i].mediaContent == null) continue;
            this.messages[i].mediaContent.level = 2;
        }
        this.absolutePositioned = c3a.pwrp;
        this.absolutePosition = new Point(c3a.pwrx, c3a.pwry);
        this.transparentBg = c3a.pwTransp;
        this.activityBgColor = c3a.colorFons[1];
        this.border = c3a.marcs;
        this.bgImageFile = c3a.bmpFons;
        if (this.bgImageFile != null && this.bgImageFile.length() > 0) {
            this.project.mediaBag.getImageElement(this.bgImageFile);
        }
        this.tiledBgImg = c3a.tileBmp;
        this.bgColor = c3a.colorFons[0];
        this.bTimeCounter = c3a.comptadors[0];
        this.bScoreCounter = c3a.comptadors[1];
        this.bActionsCounter = c3a.comptadors[2];
        boolean bl = this.includeInReports = !c3a.noAv;
        if (c3a.custHlp && c3a.custHelpFile != null && c3a.custHelpFile.length() > 0) {
            String s;
            StringBuilder sb = new StringBuilder();
            sb.append(c3a.custHelpFile);
            if (c3a.hlpTopic != null && c3a.hlpTopic.length() > 0) {
                sb.append(" ").append(c3a.hlpTopic);
            }
            if ((s = sb.substring(0)).indexOf(".htm") > 0) {
                StringTokenizer st = new StringTokenizer(s, " ");
                while (st.hasMoreTokens()) {
                    String r = st.nextToken();
                    if (r.indexOf(".htm") <= 0) continue;
                    this.infoUrl = r;
                    break;
                }
            } else {
                this.infoCmd = c3a.custHelpFile.toLowerCase().indexOf(".hlp") > 0 ? "winhelp.exe " + c3a.custHelpFile : s;
            }
        }
        if (this.helpSolutionAllowed()) {
            this.showSolution = c3a.shHelp;
        }
        if (this.showSolution) {
            this.helpWindow = true;
        }
        if (c3a.useDLL && c3a.rgDLL.equalsIgnoreCase("arith2.dll")) {
            Element e = new Element("automation");
            e.setAttribute("class", "edu.xtec.jclic.automation.arith.Arith");
            try {
                this.acp = AutoContentProvider.getAutoContentProvider(e);
                if (this.acp != null) {
                    this.acp.setClic3Properties(c3a.dllOptions);
                }
            }
            catch (Exception ex) {
                System.err.println("Unable to start arith2:\n" + ex);
            }
        }
    }

    public static void listReferences(Element e, Map<String, String> map) {
        Iterator itr;
        Element child = e.getChild(MESSAGES);
        if (child != null) {
            itr = child.getChildren("cell").iterator();
            while (itr.hasNext()) {
                ActiveBoxContent.listReferences((Element)itr.next(), map);
            }
        }
        if ((child = e.getChild(SETTINGS)) != null) {
            String skfn;
            Element child3;
            Element child2 = child.getChild(CONTAINER);
            if (child2 != null && (child3 = child2.getChild(IMAGE)) != null) {
                map.put(child3.getAttributeValue(NAME), "media");
            }
            if ((child2 = child.getChild("eventSounds")) != null) {
                EventSounds.listReferences(child2, map);
            }
            if ((child2 = child.getChild("skin")) != null && (skfn = JDomUtility.getStringAttr(child2, FILE, null, false)) != null && !skfn.startsWith(BASE_CLASS_TAG)) {
                map.put(skfn, "skin");
            }
        }
        itr = e.getChildren("cells").iterator();
        while (itr.hasNext()) {
            ActiveBagContent.listReferences((Element)itr.next(), map);
        }
        child = e.getChild("document");
        if (child != null) {
            Activity.innerListReferences(child, map);
        }
        if ((child = e.getChild("automation")) != null) {
            try {
                AutoContentProvider.listReferences(child, map);
            }
            catch (Exception ex) {
                System.err.println("Error checking AutoContentProvider: " + ex);
            }
        }
    }

    public static void innerListReferences(Element e, Map<String, String> map) {
        Iterator it = e.getChildren("cell").iterator();
        while (it.hasNext()) {
            ActiveBoxContent.listReferences((Element)it.next(), map);
        }
        for (Element child : e.getChildren()) {
            if ("cell".equals(child.getName())) continue;
            Activity.innerListReferences(child, map);
        }
    }

    public ActiveBoxContent[] getMessages() {
        return this.messages;
    }

    public String toHtmlString(ResourceBridge rb) {
        Html html = new Html(1000);
        html.doubleCell(rb.getMsg("about_window_lb_activity"), true, this.name, true);
        if (this.description != null) {
            html.doubleCell(rb.getMsg("about_window_lb_description"), true, this.description, false);
        }
        return Html.table(html.toString(), null, 1, 5, -1, null, false);
    }

    public void initAutoContentProvider() {
        if (this.acp != null) {
            this.acp.init(this.project.getBridge(), this.project.getFileSystem());
        }
    }

    public boolean prepareMedia(PlayStation ps) {
        if (this.eventSounds != null) {
            this.eventSounds.realize(ps.getOptions(), this.project.mediaBag);
        }
        for (ActiveBoxContent activeBoxContent : this.messages) {
            if (activeBoxContent == null) continue;
            activeBoxContent.prepareMedia(ps);
        }
        if (this.abc != null) {
            for (Domable domable : this.abc) {
                if (domable == null) continue;
                ((ActiveBagContent)domable).prepareMedia(ps);
            }
        }
        return true;
    }

    protected Activity getActivity() {
        return this;
    }

    public abstract Panel getActivityPanel(PlayStation var1);

    public boolean helpSolutionAllowed() {
        return false;
    }

    public boolean helpWindowAllowed() {
        return this.helpWindow && (this.helpSolutionAllowed() && this.showSolution || this.helpMsg != null);
    }

    public abstract int getMinNumActions();

    public boolean mustPauseSequence() {
        return this.getMinNumActions() != 0;
    }

    public boolean canReinit() {
        return true;
    }

    public boolean hasInfo() {
        return this.infoUrl != null && this.infoUrl.length() > 0 || this.infoCmd != null && this.infoCmd.length() > 0;
    }

    public boolean hasRandom() {
        return false;
    }

    public boolean shuffleAlways() {
        return false;
    }

    public boolean needsKeyboard() {
        return false;
    }

    public void end() {
        if (this.eventSounds != null) {
            this.eventSounds.close();
            this.eventSounds = null;
        }
        this.clear();
    }

    public void clear() {
    }

    public void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }

    public Dimension getWindowSize() {
        return new Dimension(this.windowSize);
    }

    public void setWindowSize(Dimension windowSize) {
        this.windowSize = new Dimension(windowSize);
    }

    public abstract class Panel
    extends JPanel {
        public Skin skin = null;
        public boolean solved = false;
        public Image bgImage = null;
        protected boolean playing = false;
        protected boolean firstRun = true;
        protected int currentItem = 0;
        protected BoxConnector bc = null;
        public PlayStation ps;

        protected Panel(PlayStation ps) {
            this.ps = ps;
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(500, 400));
            this.enableEvents(56L);
            Activity.this.initAutoContentProvider();
        }

        public Activity getActivity() {
            return Activity.this;
        }

        public PlayStation getPs() {
            return this.ps;
        }

        public void buildVisualComponents() throws Exception {
            this.playing = false;
            this.skin = null;
            if (Activity.this.skinFileName != null && Activity.this.skinFileName.length() > 0) {
                this.skin = Activity.this.project.mediaBag.getSkinElement(Activity.this.skinFileName, this.ps);
            }
            this.bgImage = null;
            if (Activity.this.bgImageFile != null && Activity.this.bgImageFile.length() > 0) {
                MediaBagElement mbe = Activity.this.project.mediaBag.getImageElement(Activity.this.bgImageFile);
                this.bgImage = mbe.getImage();
                Activity.this.bgImageFile = mbe.getName();
            }
            this.setBackground(Activity.this.activityBgColor);
            if (Activity.this.transparentBg) {
                this.setOpaque(false);
            }
            this.setBorder(Activity.this.border ? BorderFactory.createBevelBorder(0) : BorderFactory.createEmptyBorder());
            this.invalidate();
        }

        protected void playEvent(int event) {
            if (Activity.this.eventSounds != null) {
                Activity.this.eventSounds.play(event);
            }
        }

        public void initActivity() throws Exception {
            if (this.playing) {
                this.playing = false;
                this.ps.reportEndActivity(Activity.this, this.solved);
            }
            this.solved = false;
            this.ps.reportNewActivity(Activity.this, 0);
            this.enableCounters();
        }

        public void startActivity() throws Exception {
        }

        public void showHelp() {
        }

        public abstract void render(Graphics2D var1, Rectangle var2);

        public abstract Dimension setDimension(Dimension var1);

        public void processMouse(MouseEvent e) {
        }

        public void processKey(KeyEvent e) {
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public final void fitTo(Rectangle proposed, Rectangle bounds) {
            Point origin = new Point(0, 0);
            if (Activity.this.absolutePositioned && Activity.this.absolutePosition != null) {
                origin.x = Math.max(0, Activity.this.absolutePosition.x + proposed.x);
                origin.y = Math.max(0, Activity.this.absolutePosition.y + proposed.y);
                proposed.width -= Activity.this.absolutePosition.x;
                proposed.height -= Activity.this.absolutePosition.y;
            }
            Dimension d = this.setDimension(new Dimension(Math.max(2 * Activity.this.margin + 40, proposed.width), Math.max(2 * Activity.this.margin + 40, proposed.height)));
            if (!Activity.this.absolutePositioned) {
                origin.setLocation(Math.max(0, proposed.x + (proposed.width - d.width) / 2), Math.max(0, proposed.y + (proposed.height - d.height) / 2));
            }
            if (origin.x + d.width > bounds.width) {
                origin.x = Math.max(0, bounds.width - d.width);
            }
            if (origin.y + d.height > bounds.height) {
                origin.y = Math.max(0, bounds.height - d.height);
            }
            this.setBounds(origin.x, origin.y, d.width, d.height);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            if (!Activity.this.transparentBg) {
                if (Activity.this.activityBgGradient == null || Activity.this.activityBgGradient.hasTransparency()) {
                    super.paintComponent(g2);
                }
                if (Activity.this.activityBgGradient != null) {
                    Activity.this.activityBgGradient.paint(g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                }
            }
            do {
                BoxBase.flagFontReduced = false;
                this.render(g2, g2.getClipBounds());
            } while (BoxBase.flagFontReduced);
            g2.setRenderingHints(rh);
        }

        public void forceFinishActivity() {
        }

        public void finishActivity(boolean result) {
            this.playing = false;
            this.solved = result;
            if (this.bc != null) {
                this.bc.end();
            }
            if (result) {
                this.setAndPlayMsg(2, 5);
            } else {
                this.setAndPlayMsg(3, 4);
            }
            this.ps.activityFinished(this.solved);
            this.ps.reportEndActivity(Activity.this, this.solved);
        }

        protected void setAndPlayMsg(int msgCode, int eventSoundsCode) {
            this.ps.setMsg(Activity.this.messages[msgCode]);
            if (Activity.this.messages[msgCode] == null || Activity.this.messages[msgCode].mediaContent == null) {
                this.playEvent(eventSoundsCode);
            } else {
                this.ps.playMsg();
            }
        }

        public void end() {
            this.forceFinishActivity();
            if (this.playing) {
                if (this.bc != null) {
                    this.bc.end();
                }
                this.ps.reportEndActivity(Activity.this, this.solved);
                this.playing = false;
                this.solved = false;
            }
            this.clear();
        }

        public abstract void clear();

        public void finalize() throws Throwable {
            try {
                this.end();
            }
            finally {
                super.finalize();
            }
        }

        protected void enableCounters() {
            this.enableCounters(Activity.this.bTimeCounter, Activity.this.bScoreCounter, Activity.this.bActionsCounter);
        }

        protected void enableCounters(boolean eTime, boolean eScore, boolean eActions) {
            this.ps.setCounterEnabled(2, eTime);
            if (Activity.this.countDownTime) {
                this.ps.setCountDown(2, Activity.this.maxTime);
            }
            this.ps.setCounterEnabled(0, eScore);
            this.ps.setCounterEnabled(1, eActions);
            if (Activity.this.countDownActions) {
                this.ps.setCountDown(1, Activity.this.maxActions);
            }
        }

        @Override
        public void doLayout() {
        }

        protected void shuffle(ActiveBoxBag[] bg, boolean visible, boolean fitInArea) {
            int steps = Activity.this.shuffles;
            for (int i = Activity.this.shuffles; i > 0; i -= steps) {
                int k = i > steps ? steps : i;
                for (ActiveBoxBag abb : bg) {
                    if (abb == null) continue;
                    abb.scrambleCells(k, fitInArea);
                }
            }
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (this.playing && e instanceof MouseEvent) {
                if (e.getID() == 501 && !this.hasFocus()) {
                    this.requestFocus();
                }
                if (e.getID() != 3 || this.ps.getFressa() == null) {
                    this.processMouse((MouseEvent)e);
                }
            } else if (this.playing && e instanceof KeyEvent) {
                this.processKey((KeyEvent)e);
            }
            super.processEvent(e);
        }

        public void calcScanPoints() {
            if (this.ps.getFressa() != null) {
                this.ps.getFressa().calcScanPoints();
            }
        }

        public void calcInactivePoints() {
        }

        public void nextScanPosition() {
            if (this.ps.getFressa() != null) {
                this.ps.getFressa().nextScanPosition();
            }
        }

        public void clickLeftButton() {
            if (this.ps.getFressa() != null) {
                this.ps.getFressa().clickLeftButton();
                if (this.ps.getFressa().jumpWellPlaced) {
                    this.calcInactivePoints();
                }
            }
        }
    }
}

