/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.accessibility;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.accessibility.TFormExchange;
import edu.xtec.jclic.accessibility.TFormKeyboard;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class FressaFunctions {
    public static final String BUNDLE = "messages.AccessibilityMessages";
    public static final String FRESSA_VERSION = "v: alfa 99 - 23/07/2010";
    public static final int DEFAULT_TIMER_SPAN = 12;
    public static final int MAX_SCANNING_ZONES = 3;
    public static final int BUTTONS_ZONE = 0;
    public static final int PUZZLE_ZONE = 1;
    public static final int ASSOCIATION_ZONE = 2;
    public static final int MAX_POINTS_PER_ZONE = 1000;
    public static final Rectangle INITIAL_FORM_EXCHANGE_POS = new Rectangle(100, 100, 45, 30);
    public static final int SCAN_ACTIVATION_DELAY = 5000;
    public static final int SCAN_ACTIVATION_CHECK_SPAN = 1000;
    public static final int SWAYING_ACTIVATION_DELAY = 400;
    public static final int SWAYING_SPAN = 100;
    public static final int SWAYING_AMOUNT = 2;
    public static boolean noHandCursor = false;
    public static boolean forceRectangularShapes = false;
    public boolean scanIncludingArrowButtons = true;
    public boolean withChangeZoneButton = false;
    public boolean scanArrowsAtEndOfActivity = false;
    public boolean scanFlagButton = false;
    public boolean jumpWellPlaced = true;
    public boolean showKeyboard = true;
    public boolean changeZoneIfNoClick = false;
    public boolean autoScanOnStart = false;
    public boolean directedScanOnStart = false;
    public boolean autoAutoScan = false;
    public boolean weAreAtTheStart = true;
    public int scanTimerSpan = 12;
    public boolean mustDisableScanTimer = false;
    public boolean isScanning = false;
    public boolean isAutoScanning = false;
    public boolean isDirectedScanning = false;
    Skin skin;
    Activity.Panel actPanel;
    String activityType;
    boolean isFirstScreen = false;
    int place;
    int numberOfZones;
    int currentZone;
    int[][] px = new int[3][1000];
    int[][] py = new int[3][1000];
    int[] zonePoints = new int[3];
    public String[][] sll = new String[3][1000];
    int clickNumber = 1;
    boolean activityFinished = false;
    TFormExchange formExchange;
    TFormKeyboard formKeyboard;
    boolean activityWithKeyboard = false;
    Rectangle actPanelRectangle;
    Rectangle oldActPanelRectangle;
    Point actPanelRectangleMiddleBottom;
    boolean withVoice = true;
    boolean readLabels = false;
    Timer scanTimer;
    Timer autoScanActivationTimer;
    long tickCountTime;
    int cursorPosX;
    int cursorPosY;
    boolean withSwaying = false;
    int swayingCounter = 0;
    int swayingCursorX;
    int swayingCursorY;
    Timer swayingTimer;
    Timer directedScanStartSwayingTimer;
    Robot robot;
    Messages msg;
    public static final String SCAN_TIMER_SPAN = "scanTimerSpan";
    public static final String SCAN_INCLUDING_ARROWS = "scanIncludingArrows";
    public static final String CHANGE_ZONE_BUTTON = "changeZoneButton";
    public static final String SCAN_ARROWS_AT_END = "scanArrowsAtEnd";
    public static final String SCAN_FLAG = "scanFlag";
    public static final String JUMP_WELL_PLACED = "jumpWellPlaced";
    public static final String SHOW_KEYBOARD = "showKeyboard";
    public static final String CHANGE_ZONE_IF_NO_CLICK = "changeZoneIfNoClick";
    public static final String AUTO_SCAN_ON_START = "autoScanOnStart";
    public static final String DIRECTED_SCAN_ON_START = "directedScanOnStart";
    public static final String AUTO_AUTO_SCAN = "autoAutoScan";
    public static final String SWAYING = "swaying";
    public static final String NO_HAND_CURSOR = "noHandCursor";
    public static final String FORCE_RECTANGLES = "forceRectangles";
    public static final String READ_LABELS = "readLabels";
    public static final String WITH_VOICE = "withVoice";
    private AWTEventListener autoScanMouseListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            if (FressaFunctions.this.isAutoScanning && event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                if (me.getButton() == 1) {
                    if (FressaFunctions.this.withSwaying) {
                        FressaFunctions.this.stopSwayingTimer();
                    }
                } else if (me.getButton() == 3) {
                    if (FressaFunctions.this.withSwaying) {
                        FressaFunctions.this.stopSwayingTimer();
                    }
                    FressaFunctions.this.stopScanning();
                    FressaFunctions.this.stopScanTimer();
                    Toolkit.getDefaultToolkit().removeAWTEventListener(FressaFunctions.this.autoScanMouseListener);
                }
            }
        }
    };
    private AWTEventListener mouseDirectedScanListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            if (FressaFunctions.this.isDirectedScanning) {
                MouseEvent me = (MouseEvent)event;
                if (me.getButton() == 1) {
                    if (me.getID() == 502) {
                        if (FressaFunctions.this.withSwaying) {
                            FressaFunctions.this.stopSwayingTimer();
                        }
                        FressaFunctions.this.actPanel.clickLeftButton();
                        if (FressaFunctions.this.withSwaying) {
                            FressaFunctions.this.startDirectedScanSwayingTimer();
                        }
                    }
                } else if (me.getButton() == 3 && event.getID() == 502) {
                    if (FressaFunctions.this.withSwaying) {
                        FressaFunctions.this.stopSwayingTimer();
                    }
                    FressaFunctions.this.actPanel.nextScanPosition();
                    if (FressaFunctions.this.withSwaying) {
                        FressaFunctions.this.startSwayingTimer();
                    }
                }
            }
        }
    };
    private AWTEventListener directedScanKeyboardListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            KeyEvent ke = (KeyEvent)event;
            if (ke.getID() == 400 && ke.getKeyChar() == '\u001b') {
                FressaFunctions.this.disableScanning();
            }
        }
    };

    public FressaFunctions(Options options) {
        this.msg = options.getMessages(BUNDLE);
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            System.err.println("Unable to create java.awt.Robot: " + ex.getMessage());
        }
        this.formExchange = new TFormExchange(INITIAL_FORM_EXCHANGE_POS, this.msg.get("acc_exchangeBtnChar"));
        this.formKeyboard = new TFormKeyboard(options, this);
        noHandCursor = options.getBoolean(NO_HAND_CURSOR, false);
        forceRectangularShapes = options.getBoolean(FORCE_RECTANGLES, false);
        this.scanTimerSpan = options.getInt(SCAN_TIMER_SPAN, 12);
        this.scanIncludingArrowButtons = options.getBoolean(SCAN_INCLUDING_ARROWS, true);
        this.withChangeZoneButton = options.getBoolean(CHANGE_ZONE_BUTTON, false);
        this.scanArrowsAtEndOfActivity = options.getBoolean(SCAN_ARROWS_AT_END, false);
        this.scanFlagButton = options.getBoolean(SCAN_FLAG, false);
        this.jumpWellPlaced = options.getBoolean(JUMP_WELL_PLACED, true);
        this.showKeyboard = options.getBoolean(SHOW_KEYBOARD, true);
        this.changeZoneIfNoClick = options.getBoolean(CHANGE_ZONE_IF_NO_CLICK, false);
        this.autoScanOnStart = options.getBoolean(AUTO_SCAN_ON_START, false);
        this.directedScanOnStart = options.getBoolean(DIRECTED_SCAN_ON_START, false);
        this.autoAutoScan = options.getBoolean(AUTO_AUTO_SCAN, false);
        this.withSwaying = options.getBoolean(SWAYING, false);
        this.readLabels = options.getBoolean(READ_LABELS, false);
        this.withVoice = options.getBoolean(WITH_VOICE, false);
        if (this.withVoice) {
            // empty if block
        }
    }

    public void startScanning() {
        if (this.actPanel != null) {
            this.zonePoints[0] = -1;
            this.zonePoints[1] = -1;
            this.zonePoints[2] = -1;
            if (this.withChangeZoneButton && this.formExchange != null) {
                this.formExchange.setVisible(true);
            }
            this.place = 0;
            this.isFirstScreen = true;
            this.isScanning = true;
            this.isAutoScanning = false;
            this.isDirectedScanning = false;
            this.actPanel.calcScanPoints();
            if (this.formKeyboard != null && this.activityWithKeyboard && this.showKeyboard && this.isScanning) {
                this.formKeyboard.isHorizontalScanning = false;
                this.formKeyboard.xPos = 0;
                this.formKeyboard.yPos = -1;
                this.formKeyboard.setVisible(true);
                this.formKeyboard.calcFrameSize();
                this.numberOfZones = 1;
                this.clickNumber = 1;
                this.currentZone = 1;
            }
        }
    }

    public void stopScanning() {
        this.isScanning = false;
        this.isAutoScanning = false;
        this.isDirectedScanning = false;
        if (this.formExchange != null) {
            this.formExchange.setVisible(false);
        }
        if (this.formKeyboard != null) {
            this.formKeyboard.setVisible(false);
        }
    }

    public void initActivity(Activity.Panel actPanel) {
        this.actPanel = actPanel;
        if (this.formKeyboard.isVisible()) {
            this.formKeyboard.setVisible(false);
        }
        this.activityWithKeyboard = false;
        this.activityType = actPanel.getActivity().getShortClassName();
        for (int i = 0; i < 3; ++i) {
            this.zonePoints[i] = -1;
            for (int n = 0; n < 1000; ++n) {
                this.px[i][n] = 0;
                this.py[i][n] = 0;
                this.sll[i][n] = "";
            }
        }
        this.currentZone = 0;
        this.place = 0;
        this.oldActPanelRectangle.setBounds(0, 0, 0, 0);
        this.activityFinished = false;
        this.activityWithKeyboard = actPanel.getActivity().needsKeyboard();
        if (this.formKeyboard != null && this.activityWithKeyboard && this.showKeyboard && this.isScanning) {
            this.formKeyboard.isHorizontalScanning = false;
            this.formKeyboard.xPos = 0;
            this.formKeyboard.yPos = -1;
            this.formKeyboard.setVisible(true);
            this.formKeyboard.calcFrameSize();
            this.numberOfZones = 1;
            this.clickNumber = 1;
            this.currentZone = 1;
        }
        actPanel.calcScanPoints();
        if (this.autoAutoScan) {
            if (this.autoScanActivationTimer == null) {
                this.enableAutoScanTimer();
            }
        } else if (this.weAreAtTheStart) {
            if (this.autoScanOnStart) {
                this.enableAutoScan();
            } else if (this.directedScanOnStart) {
                this.enableDirectedScan();
            }
        }
        this.weAreAtTheStart = false;
        if (this.isAutoScanning) {
            this.startScanTimer();
        }
    }

    public void startSwayingTimer() {
        if (this.swayingTimer == null) {
            this.swayingTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FressaFunctions.this.changeSwayingPos();
                }
            });
            this.swayingCounter = 0;
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.swayingCursorX = p.x;
            this.swayingCursorY = p.y;
            this.swayingTimer.start();
        }
        if (!this.swayingTimer.isRunning()) {
            this.swayingTimer.start();
        }
    }

    public void stopSwayingTimer() {
        if (this.swayingTimer != null) {
            this.swayingCounter = 0;
            this.changeSwayingPos();
            this.swayingTimer.stop();
            this.swayingTimer = null;
        }
    }

    public void changeSwayingPos() {
        int dx = 0;
        int dy = 0;
        switch (this.swayingCounter) {
            case 0: {
                dx = -1;
                dy = -1;
                break;
            }
            case 1: {
                dx = 1;
                dy = -1;
                break;
            }
            case 2: {
                dx = 1;
                dy = 1;
                break;
            }
            case 3: {
                dx = -1;
                dy = 1;
            }
        }
        ++this.swayingCounter;
        this.swayingCounter %= 4;
        if (this.robot != null) {
            this.robot.mouseMove(this.swayingCursorX + dx * 2, this.swayingCursorY + dy * 2);
        }
    }

    public void startDirectedScanSwayingTimer() {
        if (this.swayingTimer == null && this.directedScanStartSwayingTimer == null) {
            this.directedScanStartSwayingTimer = new Timer(400, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FressaFunctions.this.startSwayingTimer();
                    FressaFunctions.this.directedScanStartSwayingTimer = null;
                }
            });
            this.directedScanStartSwayingTimer.setRepeats(false);
            this.directedScanStartSwayingTimer.start();
        }
    }

    public void disableScanning() {
        if (this.withSwaying) {
            this.stopSwayingTimer();
        }
        this.stopScanning();
        this.stopScanTimer();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoScanMouseListener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseDirectedScanListener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.directedScanKeyboardListener);
        if (this.autoAutoScan) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.cursorPosX = p.x;
            this.cursorPosY = p.y;
            this.tickCountTime = System.currentTimeMillis();
        }
    }

    public void enableAutoScan() {
        this.disableScanning();
        this.startScanning();
        this.isAutoScanning = true;
        this.startScanTimer();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.autoScanMouseListener, 16L);
    }

    public void startScanTimer() {
        if (this.scanTimer == null) {
            this.scanTimer = new Timer(this.scanTimerSpan * 100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FressaFunctions.this.withSwaying) {
                        FressaFunctions.this.stopSwayingTimer();
                    }
                    FressaFunctions.this.actPanel.nextScanPosition();
                    if (FressaFunctions.this.withSwaying) {
                        FressaFunctions.this.startSwayingTimer();
                    }
                }
            });
            this.scanTimer.start();
        }
    }

    public void stopScanTimer() {
        if (this.scanTimer != null) {
            this.scanTimer.stop();
            this.scanTimer = null;
        }
    }

    public void enableAutoScanTimer() {
        if (this.autoAutoScan && (this.autoScanActivationTimer == null || !this.autoScanActivationTimer.isRunning())) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.cursorPosX = p.x;
            this.cursorPosY = p.y;
            this.tickCountTime = System.currentTimeMillis();
            this.autoScanActivationTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!FressaFunctions.this.isScanning) {
                        Point p = MouseInfo.getPointerInfo().getLocation();
                        int x = p.x;
                        int y = p.y;
                        if (x != FressaFunctions.this.cursorPosX || y != FressaFunctions.this.cursorPosY) {
                            FressaFunctions.this.cursorPosX = x;
                            FressaFunctions.this.cursorPosY = y;
                            FressaFunctions.this.tickCountTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - FressaFunctions.this.tickCountTime > 5000L) {
                            FressaFunctions.this.enableAutoScan();
                        }
                    }
                }
            });
            this.autoScanActivationTimer.start();
        }
    }

    public void disableAutoScanTimer() {
        if (this.autoScanActivationTimer != null) {
            this.autoScanActivationTimer.stop();
            this.autoScanActivationTimer = null;
        }
    }

    public void enableDirectedScan() {
        this.disableScanning();
        this.startScanning();
        this.isDirectedScanning = true;
        if (this.withSwaying) {
            this.stopSwayingTimer();
        }
        this.actPanel.nextScanPosition();
        if (this.withSwaying) {
            this.stopSwayingTimer();
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseDirectedScanListener, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.directedScanKeyboardListener, 8L);
    }

    public void clickLeftButton() {
        if (this.withChangeZoneButton) {
            if (this.activityWithKeyboard && this.showKeyboard && this.isScanning) {
                if (this.currentZone == 0) {
                    this.formKeyboard.isHorizontalScanning = false;
                    this.formKeyboard.xPos = 0;
                    this.formKeyboard.yPos = -1;
                    this.formKeyboard.setVisible(true);
                    this.formKeyboard.calcFrameSize();
                    this.numberOfZones = 1;
                    this.clickNumber = 1;
                    this.currentZone = 1;
                }
                this.formExchange.changeBgColor(this.currentZone);
                return;
            }
            if (this.changeZoneIfNoClick && (this.activityType.equals("@associations.SimpleAssociation") || this.activityType.equals("@associations.ComplexAssociation"))) {
                if ((this.currentZone == 0 || this.currentZone == 2) && this.place > this.zonePoints[this.currentZone]) {
                    if (this.currentZone == 0 && this.numberOfZones > 0) {
                        this.currentZone = 1;
                        this.place = 0;
                    } else if (this.currentZone == 2) {
                        this.currentZone = 0;
                        this.place = 0;
                    }
                    this.formExchange.changeBgColor(this.currentZone);
                    return;
                }
            } else if ((this.currentZone == 0 || this.currentZone == 1) && this.place > this.zonePoints[this.currentZone]) {
                if (this.currentZone == 0 && this.numberOfZones > 0) {
                    this.currentZone = 1;
                    this.place = 0;
                } else if (this.currentZone == 1) {
                    this.currentZone = 0;
                    this.place = 0;
                }
                this.formExchange.changeBgColor(this.currentZone);
                return;
            }
        }
        if (this.numberOfZones == 1) {
            if (!(this.currentZone != 1 || this.activityType.equals("@panels.InformationScreen") || this.activityType.equals("@panels.Explore") || this.activityType.equals("@panels.Identify") || this.activityType.equals("@textGrid.WordSearch"))) {
                this.place = 0;
            }
        } else if (this.numberOfZones == 2) {
            if (this.currentZone == 1) {
                this.currentZone = 2;
                this.place = 0;
            } else if (this.currentZone == 2) {
                this.currentZone = 1;
                this.place = 0;
            }
        }
    }

    public void readText(String txt) {
    }

    public void calcScanPoints() {
    }

    public void activityFinished() {
    }

    public void nextScanPosition() {
    }
}

