/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.puzzles;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.jdom.Element;

public class HolePuzzle
extends Activity
implements ActiveBagContentKit.Compatible {
    public HolePuzzle(JClicProject project) {
        super(project);
        this.abc = new ActiveBagContent[1];
        this.boxGridPos = 0;
    }

    @Override
    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    @Override
    public Element getJDomElement() {
        if (this.abc[0] == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.abc[0].getJDomElement());
        Element ex = new Element("scramble");
        ex.setAttribute("times", Integer.toString(this.shuffles));
        e.addContent(ex);
        ex = new Element("layout");
        ex.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        e.addContent(ex);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        Element child = e.getChild("cells");
        if (child != null) {
            this.abc[0] = ActiveBagContent.getActiveBagContent(child, this.project.mediaBag);
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Puzzle without content!");
        }
        child = e.getChild("scramble");
        if (child != null) {
            this.shuffles = JDomUtility.getIntAttr(child, "times", this.shuffles);
        }
        if ((child = e.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(child, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.abc[0] = c3a.createActiveBagContent(0);
        this.abc[0].setBoxBase(c3a.getBoxBase(0));
        this.boxGridPos = c3a.graPos;
    }

    @Override
    public int getMinNumActions() {
        return this.abc[0] == null ? 0 : this.abc[0].getNumCells();
    }

    @Override
    public boolean helpSolutionAllowed() {
        return true;
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public boolean shuffleAlways() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxGrid bg;
        ActiveBoxGrid parkBg;
        int hiddenBoxIndex;
        ActiveBox hiddenBox;

        protected Panel(PlayStation ps) {
            super(ps);
            this.parkBg = null;
            this.bg = null;
            this.hiddenBoxIndex = 0;
            this.hiddenBox = null;
        }

        @Override
        public void clear() {
            if (this.bg != null) {
                this.bg.end();
                this.bg = null;
            }
            if (this.parkBg != null) {
                this.parkBg.end();
                this.parkBg = null;
            }
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (HolePuzzle.this.abc[0] != null) {
                if (HolePuzzle.this.acp != null) {
                    HolePuzzle.this.acp.generateContent(new ActiveBagContentKit(HolePuzzle.this.abc[0].nch, HolePuzzle.this.abc[0].ncw, HolePuzzle.this.abc, false), this.ps);
                }
                this.bg = ActiveBoxGrid.createEmptyGrid(null, this, HolePuzzle.this.margin, HolePuzzle.this.margin, HolePuzzle.this.abc[0]);
                this.bg.setContent(HolePuzzle.this.abc[0]);
                this.bg.setVisible(true);
                this.hiddenBoxIndex = (int)(Math.random() * (double)this.bg.getNumCells());
                this.hiddenBox = this.bg.getActiveBox(this.hiddenBoxIndex);
                this.hiddenBox.setVisible(false);
                this.parkBg = new ActiveBoxGrid(null, this, HolePuzzle.this.margin, HolePuzzle.this.margin, this.hiddenBox.width, this.hiddenBox.height, new Rectangular(1, 1), HolePuzzle.this.abc[0].bb);
                this.parkBg.setContent(HolePuzzle.this.abc[0], null, this.hiddenBoxIndex, 0, 1);
                this.parkBg.setBorder(this.bg.hasBorder());
                this.parkBg.setVisible(true);
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            }
            this.firstRun = false;
            this.setAndPlayMsg(1, 0);
            if (this.bg != null) {
                Random random = new Random();
                if (HolePuzzle.this.shuffles % 2 != 1) {
                    HolePuzzle.this.shuffles++;
                }
                for (int i = 0; i < HolePuzzle.this.shuffles; ++i) {
                    ActiveBox dstBx;
                    int v;
                    Point pth = this.bg.getCoord(this.hiddenBox);
                    int n = v = random.nextBoolean() ? 1 : -1;
                    if (random.nextBoolean()) {
                        pth.x += v;
                        if (pth.x < 0 || pth.x >= this.bg.nCols) {
                            pth.x -= 2 * v;
                        }
                    } else {
                        pth.y += v;
                        if (pth.y < 0 || pth.y >= this.bg.nRows) {
                            pth.y -= 2 * v;
                        }
                    }
                    if ((dstBx = this.bg.getActiveBoxWithIdLoc(pth.y * this.bg.nCols + pth.x)) == null) continue;
                    this.hiddenBox.exchangeLocation(dstBx);
                }
                this.ps.setCounterValue(0, this.bg.countCellsAtEquivalentPlace(true));
                this.playing = true;
            }
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            if (this.bg != null) {
                this.bg.update(g2, dirtyRegion, this);
            }
            if (this.parkBg != null) {
                this.parkBg.update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            if (this.bg == null || this.parkBg == null || this.getSize().equals(preferredMaxSize)) {
                return preferredMaxSize;
            }
            return BoxBag.layoutDouble(preferredMaxSize, this.bg, this.parkBg, HolePuzzle.this.boxGridPos, HolePuzzle.this.margin);
        }

        @Override
        public void processMouse(MouseEvent e) {
            Point p = e.getPoint();
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        ActiveBox bx = this.bg.findActiveBox(p);
                        if (bx != null) {
                            if (bx.isVisible()) {
                                Point pt = this.bg.getCoordDist(bx, this.hiddenBox);
                                if (Math.abs(pt.x) + Math.abs(pt.y) == 1) {
                                    boolean m = bx.playMedia(this.ps);
                                    String src = bx.getDescription() + "(" + bx.idOrder + ")";
                                    String dest = "(" + this.hiddenBox.idLoc + ")";
                                    bx.exchangeLocation(this.hiddenBox);
                                    boolean ok = bx.idOrder == bx.idLoc;
                                    int cellsAtPlace = this.bg.countCellsAtEquivalentPlace(true);
                                    this.ps.reportNewAction(this.getActivity(), "SELECT", src, dest, ok, cellsAtPlace);
                                    if (ok && cellsAtPlace == this.bg.getNumCells()) {
                                        this.hiddenBox.setVisible(true);
                                        this.parkBg.setVisible(false);
                                        this.finishActivity(true);
                                    } else if (!m) {
                                        this.playEvent(1);
                                    }
                                }
                            } else {
                                this.playEvent(2);
                            }
                        }
                        this.repaint();
                    }
                }
            }
        }

        @Override
        public void showHelp() {
            if (!HolePuzzle.this.helpWindowAllowed() || this.bg == null) {
                return;
            }
            HelpActivityComponent hac = null;
            if (HolePuzzle.this.showSolution) {
                hac = new HelpActivityComponent(this){
                    ActiveBoxBag abb;
                    {
                        this.abb = null;
                    }

                    @Override
                    public void render(Graphics2D g2, Rectangle dirtyRegion) {
                        if (this.abb != null) {
                            this.abb.update(g2, dirtyRegion, this);
                        }
                    }

                    @Override
                    public void init() {
                        this.abb = ActiveBoxGrid.createEmptyGrid(null, this, 8.0, 8.0, HolePuzzle.this.abc[0]);
                        this.abb.setContent(HolePuzzle.this.abc[0]);
                        this.abb.setVisible(true);
                        Dimension size = Panel.this.bg.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, size.width, size.height);
                        size.width += 16;
                        size.height += 16;
                        this.setPreferredSize(size);
                        this.setMaximumSize(size);
                        this.setMinimumSize(size);
                        Point p = (Point)this.getClientProperty("prefLoc");
                        if (p != null) {
                            p.translate((int)Panel.this.bg.x - 8, (int)Panel.this.bg.y - 8);
                        }
                    }

                    @Override
                    public void processMouse(MouseEvent e) {
                    }
                };
                hac.init();
            }
            if (this.ps.showHelp(hac, HolePuzzle.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bg.countCellsAtEquivalentPlace(true));
            }
            if (hac != null) {
                hac.end();
            }
        }
    }
}

