/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import org.jdom.Element;

public class BasicEvaluator
extends Evaluator {
    public static final String CHECK_CASE = "checkCase";
    public static final String CHECK_ACCENTS = "checkAccents";
    public static final String CHECK_PUNCTUATION = "checkPunctuation";
    public static final String CHECK_DOUBLE_SPACES = "checkDoubleSpaces";
    public static final String PUNCTUATION = ".,;:";
    protected boolean checkCase = false;
    protected boolean checkAccents = true;
    protected boolean checkPunctuation = true;
    protected boolean checkDoubleSpaces = false;
    int strength;

    public BasicEvaluator(JClicProject project) {
        super(project);
        this.init();
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        if (this.checkCase) {
            e.setAttribute(CHECK_CASE, JDomUtility.boolString(this.checkCase));
        }
        if (!this.checkAccents) {
            e.setAttribute(CHECK_ACCENTS, JDomUtility.boolString(this.checkAccents));
        }
        if (!this.checkPunctuation) {
            e.setAttribute(CHECK_PUNCTUATION, JDomUtility.boolString(this.checkPunctuation));
        }
        if (this.checkDoubleSpaces) {
            e.setAttribute(CHECK_DOUBLE_SPACES, JDomUtility.boolString(this.checkDoubleSpaces));
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.checkCase = JDomUtility.getBoolAttr(e, CHECK_CASE, false);
        this.checkAccents = JDomUtility.getBoolAttr(e, CHECK_ACCENTS, true);
        this.checkPunctuation = JDomUtility.getBoolAttr(e, CHECK_PUNCTUATION, true);
        this.checkDoubleSpaces = JDomUtility.getBoolAttr(e, CHECK_DOUBLE_SPACES, false);
    }

    public void setProperties(Clic3Activity c3a) {
        this.checkCase = c3a.avMaj;
        this.checkAccents = c3a.avAcc;
        this.checkPunctuation = c3a.avPunt;
        this.checkDoubleSpaces = c3a.avDblSpc;
    }

    @Override
    protected void init() {
        super.init();
        this.strength = this.checkAccents ? (this.checkCase ? 2 : 1) : 0;
        this.collator.setStrength(this.strength);
    }

    @Override
    public boolean checkText(String text, String match) {
        return this.collator.equals(this.getClearedText(text), this.getClearedText(match));
    }

    @Override
    public byte[] evalText(String text, String[] match) {
        byte[] flags = new byte[text.length()];
        boolean result = this.checkText(text, match);
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = result ? (byte)0 : 1;
        }
        return flags;
    }

    protected String getClearedText(String src) {
        return this.getClearedText(src, null);
    }

    protected String getClearedText(String src, boolean[] skipped) {
        if (skipped == null) {
            skipped = new boolean[src.length()];
        }
        for (int i = 0; i < src.length(); ++i) {
            skipped[i] = false;
        }
        if (this.checkPunctuation && this.checkDoubleSpaces) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        boolean wasSpace = false;
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            if (PUNCTUATION.indexOf(ch) >= 0 && !this.checkPunctuation) {
                if (!wasSpace) {
                    sb.append(' ');
                } else {
                    skipped[i] = true;
                }
                wasSpace = true;
                continue;
            }
            if (ch == ' ') {
                if (this.checkDoubleSpaces || !wasSpace) {
                    sb.append(ch);
                } else {
                    skipped[i] = true;
                }
                wasSpace = true;
                continue;
            }
            wasSpace = false;
            sb.append(ch);
        }
        return sb.substring(0);
    }
}

