/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.ComplexEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.JDomUtility;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import org.jdom.Element;

public class FillInBlanks
extends TextActivityBase {
    protected boolean autoJump = false;
    protected boolean forceOkToAdvance = false;
    protected Evaluator ev;
    public static final String AUTO_JUMP = "autoJump";
    public static final String FORCE_OK_TO_ADVANCE = "forceOkToAdvance";

    public FillInBlanks(JClicProject project) {
        super(project);
        this.ev = new ComplexEvaluator(project);
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        if (this.autoJump) {
            e.setAttribute(AUTO_JUMP, JDomUtility.boolString(this.autoJump));
        }
        if (this.forceOkToAdvance) {
            e.setAttribute(FORCE_OK_TO_ADVANCE, JDomUtility.boolString(this.forceOkToAdvance));
        }
        e.addContent(this.ev.getJDomElement());
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.ev = Evaluator.getEvaluator(e.getChild("evaluator"), this.project);
        this.autoJump = JDomUtility.getBoolAttr(e, AUTO_JUMP, this.autoJump);
        this.forceOkToAdvance = JDomUtility.getBoolAttr(e, FORCE_OK_TO_ADVANCE, this.forceOkToAdvance);
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        ((ComplexEvaluator)this.ev).setProperties(c3a);
        this.forceOkToAdvance = c3a.okToNext;
        this.autoJump = !c3a.avNoSalta;
        this.hasCheckButton = !c3a.avCont;
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends TextActivityBase.Panel {
        boolean locked;
        TextActivityDocument playDoc;

        protected Panel(PlayStation ps) {
            super(FillInBlanks.this, ps);
            this.playDoc = null;
            this.locked = true;
        }

        @Override
        protected void initDocument() throws Exception {
            if (FillInBlanks.this.tad != null) {
                this.playing = false;
                FillInBlanks.this.tad.tmb.setCurrentTarget(null, this);
                FillInBlanks.this.tad.tmb.reset();
                this.playDoc = new TextActivityDocument(FillInBlanks.this.styleContext);
                FillInBlanks.this.tad.cloneDoc(this.playDoc, false, true, false);
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                FillInBlanks.this.tad.tmb.setParentPane(this.pane);
                this.pane.setEnabled(true);
                if (this.playDoc.tmb.size() > 0) {
                    this.pane.setEditable(true);
                    this.pane.requestFocus();
                    this.pane.getCaret().setVisible(true);
                    this.setCaretPos(0);
                    this.locked = false;
                } else {
                    this.locked = true;
                    this.pane.setEditable(false);
                    this.pane.getCaret().setVisible(false);
                }
            }
        }

        @Override
        protected TextActivityPane buildPane() {
            FillInBlanksPane fp = new FillInBlanksPane();
            fp.setActions();
            return fp;
        }

        protected boolean evalTarget(TargetMarker tm) {
            if (tm.target == null) {
                return false;
            }
            String src = tm.getCurrentText("fill");
            if (src == null || src.length() < 1) {
                return false;
            }
            byte[] result = FillInBlanks.this.ev.evalText(src, tm.target.answer);
            boolean ok = Evaluator.isOk(result);
            tm.target.targetStatus = ok ? 2 : 3;
            this.markTarget(tm, result);
            return ok;
        }

        protected void markTarget(TargetMarker tm, byte[] attributes) {
            if (tm.target.comboList != null) {
                tm.target.comboList.checkColors();
                tm.target.comboList.repaint();
                return;
            }
            int bgTarget = tm.begPos.getOffset();
            int endTarget = tm.endPos.getOffset();
            int p = 0;
            for (int i = bgTarget; i < endTarget && p < attributes.length; ++i) {
                if (this.playDoc.checkBooleanAttribute(i, "fill")) continue;
                this.playDoc.setCharacterAttributes(i, 1, FillInBlanks.this.styleContext.getStyle(attributes[p] == 0 ? "target" : "targetError"), false);
                ++p;
            }
        }

        protected void setCaretPos(int offset) {
            this.setCaretPos(offset, this.pane.getCaret().getDot(), true);
        }

        protected void setCaretPos(int offset, int currentOffset, boolean searchForward) {
            int check = this.checkCaretPos(offset, searchForward);
            if (check == -1) {
                this.pane.setEditable(false);
            } else if (check != currentOffset) {
                this.pane.setCaretPosition(check);
            }
        }

        protected int checkCaretPos(int offset, boolean searchForward) {
            TargetMarkerBag tmb = this.playDoc.tmb;
            TargetMarker tm = tmb.getElementByOffset(offset, true);
            int p = offset;
            if (tm == null) {
                tm = tmb.getNearestElement(offset, searchForward);
                if (tm == null) {
                    tm = tmb.getNearestElement(offset, !searchForward);
                }
                if (tm == null) {
                    this.pane.setEditable(false);
                    this.locked = true;
                    return -1;
                }
                p = searchForward ? tm.begPos.getOffset() : tm.endPos.getOffset();
            }
            if (tmb.getCurrentTarget() != tm || tm.target.comboList != null) {
                p = this.goToTarget(tm, p);
            }
            return p;
        }

        protected int goToTarget(TargetMarker tm, int offset) {
            int p = offset;
            TargetMarkerBag tmb = this.playDoc.tmb;
            if (tmb.getCurrentTarget() != null && !FillInBlanks.this.hasCheckButton) {
                TargetMarker currentTm = tmb.getCurrentTarget();
                if (!FillInBlanks.this.hasCheckButton && currentTm != null && (currentTm.target.isModified() || FillInBlanks.this.forceOkToAdvance)) {
                    boolean ok = this.evalTarget(currentTm);
                    if (!ok) {
                        currentTm.target.checkPopup(this, currentTm, false);
                    }
                    int solvedTargets = tmb.countSolvedTargets();
                    this.ps.reportNewAction(this.getActivity(), "WRITE", currentTm.getCurrentText("fill"), currentTm.target.getAnswers(), ok, solvedTargets);
                    if (ok && solvedTargets == tmb.size()) {
                        this.finishActivity(true);
                    } else {
                        this.playEvent(ok ? 3 : 2);
                    }
                    if (FillInBlanks.this.forceOkToAdvance && !ok) {
                        tm = currentTm;
                        tmb.setCurrentTarget(tm, this);
                        return tm.begPos.getOffset();
                    }
                }
            }
            if (p < 0) {
                p = tm.begPos.getOffset();
            }
            if (!tm.contains(p, true)) {
                p = tm.begOffset;
            }
            tmb.setCurrentTarget(tm, this);
            return p;
        }

        @Override
        protected void doCheck(boolean fromButton) {
            if (this.playDoc == null || this.locked) {
                return;
            }
            TargetMarkerBag tmb = this.playDoc.tmb;
            if (tmb.getCurrentTarget() != null && !FillInBlanks.this.hasCheckButton) {
                this.goToTarget(tmb.getCurrentTarget(), -1);
                return;
            }
            int solvedTargets = 0;
            for (int i = 0; i < tmb.size(); ++i) {
                TargetMarker tm = tmb.getElement(i);
                if (tm == null || tm.target.targetStatus == 0) continue;
                boolean ok = this.evalTarget(tm);
                solvedTargets = tmb.countSolvedTargets();
                this.ps.reportNewAction(this.getActivity(), "WRITE", tm.getCurrentText("fill"), tm.target.getAnswers(), ok, solvedTargets);
            }
            if (solvedTargets != tmb.size()) {
                if (fromButton) {
                    this.playEvent(4);
                    if (tmb.getCurrentTarget() != null) {
                        this.goToTarget(tmb.getCurrentTarget(), -1);
                    }
                }
            } else {
                this.finishActivity(true);
            }
        }

        @Override
        public void finishActivity(boolean result) {
            this.pane.setEditable(false);
            this.pane.setEnabled(false);
            if (this.playDoc == null || this.playDoc.tmb.getCurrentTarget() != null) {
                // empty if block
            }
            this.playDoc.tmb.getCurrentTarget().lostFocus(this);
            super.finishActivity(result);
        }

        class FillInBlanksPane
        extends TextActivityPane {
            AbstractAction defaultKeyTypedAction;
            AbstractAction forwardAction;
            AbstractAction backwardAction;
            AbstractAction nextTargetAction;
            AbstractAction prevTargetAction;
            AbstractAction insertBreakAction;
            AbstractAction insertTabAction;
            AbstractAction deletePrevCharAction;
            AbstractAction deleteNextCharAction;
            AbstractAction beginWordAction;
            AbstractAction endWordAction;
            AbstractAction beginAction;
            AbstractAction endAction;
            AbstractAction showHelpAction;
            Action kitUpAction;
            AbstractAction upAction;
            Action kitDownAction;
            AbstractAction downAction;

            protected FillInBlanksPane() {
                super(Panel.this);
                this.defaultKeyTypedAction = new AbstractAction("default-typed"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            char c;
                            String content = e.getActionCommand();
                            int mod = e.getModifiers();
                            if (content != null && content.length() > 0 && (mod & 8) == (mod & 2) && (c = content.charAt(0)) >= ' ' && c != '\u007f') {
                                FillInBlanksPane.this.insertCharCatch(FillInBlanksPane.this.getCaret().getDot(), c);
                            }
                        }
                    }
                };
                this.forwardAction = new AbstractAction("caret-forward"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            int k = FillInBlanksPane.this.getCaret().getDot();
                            Panel.this.setCaretPos(k + 1, k, true);
                        }
                    }
                };
                this.backwardAction = new AbstractAction("caret-backward"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            int k = FillInBlanksPane.this.getCaret().getDot();
                            Panel.this.setCaretPos(k - 1, k, false);
                        }
                    }
                };
                this.nextTargetAction = new AbstractAction("next-target"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.getCaret().setDot(Panel.this.goToTarget(Panel.this.playDoc.tmb.getNextTarget(null), -1));
                        }
                    }
                };
                this.prevTargetAction = new AbstractAction("prev-target"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.getCaret().setDot(Panel.this.goToTarget(Panel.this.playDoc.tmb.getPrevTarget(null), -1));
                        }
                    }
                };
                this.insertBreakAction = new AbstractAction("insert-break"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FillInBlanksPane.this.insertTabAction.actionPerformed(e);
                    }
                };
                this.insertTabAction = new AbstractAction("insert-tab"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ((e.getModifiers() & 1) != 0) {
                            FillInBlanksPane.this.prevTargetAction.actionPerformed(e);
                        } else {
                            FillInBlanksPane.this.nextTargetAction.actionPerformed(e);
                        }
                    }
                };
                this.deletePrevCharAction = new AbstractAction("delete-previous"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.removeCharCatch(FillInBlanksPane.this.getCaret().getDot() - 1);
                        }
                    }
                };
                this.deleteNextCharAction = new AbstractAction("delete-next"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.removeCharCatch(FillInBlanksPane.this.getCaret().getDot());
                        }
                    }
                };
                this.beginWordAction = new AbstractAction("caret-begin-word"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TargetMarker tm;
                        if (FillInBlanksPane.this.readyForActions() && (tm = Panel.this.playDoc.tmb.getCurrentTarget()) != null) {
                            Panel.this.setCaretPos(tm.begOffset);
                        }
                    }
                };
                this.endWordAction = new AbstractAction("caret-end-word"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TargetMarker tm;
                        if (FillInBlanksPane.this.readyForActions() && (tm = Panel.this.playDoc.tmb.getCurrentTarget()) != null) {
                            Panel.this.setCaretPos(tm.endOffset);
                        }
                    }
                };
                this.beginAction = new AbstractAction("caret-begin"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            if ((e.getModifiers() & 2) != 0) {
                                Panel.this.setCaretPos(Panel.this.goToTarget(Panel.this.playDoc.tmb.getElement(0), -1));
                            } else {
                                FillInBlanksPane.this.beginWordAction.actionPerformed(e);
                            }
                        }
                    }
                };
                this.endAction = new AbstractAction("caret-end"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            if ((e.getModifiers() & 2) != 0) {
                                Panel.this.setCaretPos(Panel.this.goToTarget(Panel.this.playDoc.tmb.getElement(Panel.this.playDoc.tmb.size() - 1), -1));
                            } else {
                                FillInBlanksPane.this.endWordAction.actionPerformed(e);
                            }
                        }
                    }
                };
                this.showHelpAction = new AbstractAction("show-help"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TargetMarker tm;
                        if (FillInBlanksPane.this.readyForActions() && (tm = Panel.this.playDoc.tmb.getCurrentTarget()) != null && tm.target != null && tm.target.popupContent != null && tm.target.infoMode == 3) {
                            tm.target.checkPopup(Panel.this, tm, true);
                        }
                    }
                };
                this.kitUpAction = null;
                this.upAction = new AbstractAction("caret-up"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.kitUpAction != null && FillInBlanksPane.this.readyForActions()) {
                            int bkPos = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.kitUpAction.actionPerformed(e);
                            int newPos = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.getCaret().setDot(bkPos);
                            Panel.this.setCaretPos(newPos, bkPos, false);
                        }
                    }
                };
                this.kitDownAction = null;
                this.downAction = new AbstractAction("caret-down"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FillInBlanksPane.this.kitDownAction != null && FillInBlanksPane.this.readyForActions()) {
                            int bkPos = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.kitDownAction.actionPerformed(e);
                            int newPos = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.getCaret().setDot(bkPos);
                            Panel.this.setCaretPos(newPos, bkPos, true);
                        }
                    }
                };
            }

            @Override
            public boolean processMouse(MouseEvent e) {
                int p;
                if (super.processMouse(e) && e.getID() == 501 && Panel.this.playing && !Panel.this.locked && (p = this.viewToModel(e.getPoint())) >= 0) {
                    Panel.this.setCaretPos(p);
                }
                return false;
            }

            protected void removeChar(int offset) throws BadLocationException {
                TargetMarker tm = Panel.this.playDoc.tmb.getCurrentTarget();
                if (tm == null || !tm.contains(offset, false)) {
                    Panel.this.playEvent(2);
                    return;
                }
                boolean lastChar = tm.getLength() == 1;
                Panel.this.playDoc.remove(offset, 1);
                tm.target.setModified(true);
                if (lastChar) {
                    Panel.this.playDoc.insertString(tm.begOffset, tm.target.getFillString(1), Panel.this.playDoc.getFillAttributeSet());
                    this.getCaret().setDot(tm.begOffset);
                } else {
                    --tm.endOffset;
                    this.getCaret().setDot(offset);
                }
                tm.setPositions();
                Panel.this.playDoc.tmb.updateOffsets();
            }

            protected void removeCharCatch(int offset) {
                try {
                    this.removeChar(offset);
                }
                catch (BadLocationException ex) {
                    System.err.println("Text activity error:\n" + ex);
                }
            }

            protected void insertChar(int offset, char ch) throws BadLocationException {
                TargetMarker tm = Panel.this.playDoc.tmb.getCurrentTarget();
                if (tm == null || !tm.contains(offset, true) || ch < ' ') {
                    return;
                }
                int firstFill = this.getFirstFillChar(tm);
                if (firstFill >= 0) {
                    Panel.this.playDoc.remove(firstFill, 1);
                    if (offset > firstFill) {
                        --offset;
                    }
                } else if (tm.getLength() >= tm.target.maxLenResp) {
                    Panel.this.playEvent(2);
                    return;
                }
                Panel.this.playDoc.insertString(offset, new String(new char[]{ch}), Panel.this.playDoc.getTargetAttributeSet());
                tm.target.setModified(true);
                if (firstFill < 0) {
                    ++tm.endOffset;
                }
                tm.setPositions();
                Panel.this.playDoc.tmb.updateOffsets();
                if (FillInBlanks.this.autoJump && tm.getCurrentText("fill").length() >= tm.target.maxLenResp) {
                    this.getCaret().setDot(Panel.this.goToTarget(Panel.this.playDoc.tmb.getNextTarget(tm), -1));
                } else {
                    this.getCaret().setDot(offset + 1);
                }
            }

            protected void insertCharCatch(int offset, char ch) {
                try {
                    this.insertChar(offset, ch);
                }
                catch (BadLocationException ex) {
                    System.err.println("Text activity error:\n" + ex);
                }
            }

            protected int getFirstFillChar(TargetMarker tm) {
                for (int i = tm.begOffset; i < tm.endOffset; ++i) {
                    if (!Panel.this.playDoc.checkBooleanAttribute(i, "fill")) continue;
                    return i;
                }
                return -1;
            }

            boolean readyForActions() {
                return Panel.this.playing && !Panel.this.locked && this.isEditable() && this.isEnabled();
            }

            protected void setActions() {
                this.kitUpAction = this.getActionMap().get("caret-up");
                this.kitDownAction = this.getActionMap().get("caret-down");
                Map<String, Object[]> actionKeys = Actions.getActionKeys(this);
                ActionMap am = new ActionMap();
                am.setParent(this.getActionMap());
                this.setActionMap(am);
                Actions.mapTraceAction(this, actionKeys, "beep");
                Actions.mapTraceAction(this, actionKeys, "requestFocus");
                Actions.mapTraceAction(this, actionKeys, "toggle-componentOrientation");
                Actions.mapAction(this, actionKeys, this.defaultKeyTypedAction);
                Actions.mapAction(this, actionKeys, this.insertBreakAction);
                Actions.mapAction(this, actionKeys, this.insertTabAction);
                Actions.mapAction(this, actionKeys, this.deletePrevCharAction);
                Actions.mapAction(this, actionKeys, this.deleteNextCharAction);
                Actions.mapAction(this, actionKeys, this.forwardAction);
                Actions.mapAction(this, actionKeys, this.backwardAction);
                Actions.mapAction(this, actionKeys, this.beginWordAction);
                Actions.mapAction(this, actionKeys, this.endWordAction);
                Actions.mapAction(this, actionKeys, this.beginAction);
                Actions.mapAction(this, actionKeys, this.endAction);
                Actions.mapAction(this, actionKeys, this.upAction);
                Actions.mapAction(this, actionKeys, this.downAction);
                Actions.mapAction(this, actionKeys, this.showHelpAction);
                Actions.mapAction(this, actionKeys, this.nextTargetAction);
                Actions.mapAction(this, actionKeys, this.prevTargetAction);
                Actions.mapAction(this, actionKeys, this.nextTargetAction, "caret-next-word");
                Actions.mapAction(this, actionKeys, this.prevTargetAction, "caret-previous-word");
                Actions.mapAction(this, actionKeys, this.nextTargetAction, "caret-end-paragraph");
                Actions.mapAction(this, actionKeys, this.prevTargetAction, "caret-begin-paragraph");
                Actions.mapAction(this, actionKeys, this.nextTargetAction, "caret-begin-line");
                Actions.mapAction(this, actionKeys, this.prevTargetAction, "caret-end-line");
                Actions.mapAction(this, actionKeys, this.nextTargetAction, "page-down");
                Actions.mapAction(this, actionKeys, this.prevTargetAction, "page-up");
                am.setParent(null);
                this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), this.insertTabAction.getValue("Name"));
                this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), this.showHelpAction.getValue("Name"));
            }

            @Override
            protected void targetChanged(TextTarget tt) {
                TargetMarker tm;
                if (this.readyForActions() && (tm = Panel.this.playDoc.tmb.getElement(tt)) != null) {
                    TargetMarker currentTm = Panel.this.playDoc.tmb.getCurrentTarget();
                    Panel.this.goToTarget(tm, -1);
                    if (currentTm != tm && !FillInBlanks.this.hasCheckButton) {
                        tm.target.setModified(true);
                        Panel.this.goToTarget(tm, -1);
                    }
                }
            }
        }
    }
}

