/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextTarget;
import java.awt.Rectangle;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TargetMarker {
    public int begOffset = 0;
    public int endOffset = 0;
    public Position begPos = null;
    public Position endPos = null;
    public TextTarget target = null;
    public TextActivityDocument doc;
    public boolean hasFocus;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("h: ").append(this.hashCode());
        sb.append(" [").append(this.begOffset).append("-").append(this.endOffset).append("]");
        sb.append(" target: ").append(this.target);
        return sb.substring(0);
    }

    public TargetMarker(TextActivityDocument document) {
        this.doc = document;
        this.hasFocus = false;
    }

    public void reset() {
        this.hasFocus = false;
        if (this.target != null) {
            this.target.reset();
        }
    }

    public void setPositions() {
        try {
            this.begPos = this.doc.createPosition(this.begOffset);
            this.endPos = this.doc.createPosition(this.endOffset);
        }
        catch (Exception e) {
            System.err.println("Target marker error:\n" + e);
        }
    }

    public void requestFocus(TextActivityBase.Panel tabp) {
        this.hasFocus = true;
        if (this.target != null) {
            this.target.requestFocus(tabp, this);
        }
    }

    public void lostFocus(TextActivityBase.Panel tabp) {
        this.hasFocus = false;
        if (this.target != null) {
            this.target.lostFocus(tabp, this);
        }
    }

    public void updateOffsets() {
        if (this.begPos != null) {
            this.begOffset = this.begPos.getOffset();
        }
        if (this.endPos != null) {
            this.endOffset = this.endPos.getOffset();
        }
    }

    public Rectangle getBegRect(JTextComponent pane) {
        if (this.begPos != null) {
            this.begOffset = this.begPos.getOffset();
            try {
                return pane.modelToView(this.begOffset);
            }
            catch (Exception ex) {
                System.err.println("Error calling modelToView:\n" + ex);
            }
        }
        return null;
    }

    public String getCurrentText() {
        String result = null;
        if (this.target != null && this.target.comboList != null) {
            result = (String)this.target.comboList.getSelectedItem();
        } else {
            try {
                result = this.doc.getText(this.begPos.getOffset(), this.endPos.getOffset() - this.begPos.getOffset());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result == null ? new String() : result;
    }

    public String getCurrentText(String boolAttrToExclude) {
        if (boolAttrToExclude == null || this.target != null && this.target.comboList != null) {
            return this.getCurrentText();
        }
        this.updateOffsets();
        StringBuilder stb = new StringBuilder();
        for (int i = this.begOffset; i < this.endOffset; ++i) {
            if (this.doc.checkBooleanAttribute(i, boolAttrToExclude)) continue;
            try {
                stb.append(this.doc.getText(i, 1));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error getting text answer:\n" + e);
                break;
            }
        }
        return stb.substring(0);
    }

    public boolean checkText(Evaluator ev) {
        if (this.target == null) {
            return false;
        }
        return this.target.checkText(this.getCurrentText(), ev);
    }

    public boolean contains(int offset, boolean includeEndPos) {
        this.updateOffsets();
        return offset >= this.begOffset && (includeEndPos ? offset <= this.endOffset : offset < this.endOffset);
    }

    public int getLength() {
        return this.endOffset - this.begOffset;
    }

    public int getParagraphBegOffset() {
        this.updateOffsets();
        return this.doc.getParagraphElement(this.begOffset).getStartOffset();
    }
}

