/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.textGrid;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.SimpleBox;
import edu.xtec.jclic.boxes.TextGrid;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.jdom.Element;

public class CrossWord
extends Activity
implements ActiveBagContentKit.Compatible {
    public static final int NO_ADVANCE = 0;
    public static final int ADVANCE_RIGHT = 1;
    public static final int ADVANCE_DOWN = 2;
    public static final int LABEL_WIDTH = 40;
    public boolean wildTransparent;
    public boolean upperCase;
    public boolean checkCase;
    public static final String ACROSS_CLUES = "acrossClues";
    public static final String DOWN_CLUES = "downClues";
    public static final String WILD_TRANSPARENT = "wildTransparent";
    public static final String UPPERCASE = "upperCase";
    public static final String CHECK_CASE = "checkCase";

    public CrossWord(JClicProject project) {
        super(project);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[2];
        this.wildTransparent = false;
        this.upperCase = true;
        this.checkCase = true;
    }

    @Override
    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 1, -1, true, true, 200, 60);
        this.abc[1] = ActiveBagContent.initNew(3, 1, -1, true, true, 200, 60);
        this.tgc = TextGridContent.initNew(3, 3, 'A');
    }

    @Override
    public Element getJDomElement() {
        if (this.tgc == null || this.abc[0] == null || this.abc[1] == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.tgc.getJDomElement());
        e.addContent(this.abc[0].getJDomElement().setAttribute("id", ACROSS_CLUES));
        e.addContent(this.abc[1].getJDomElement().setAttribute("id", DOWN_CLUES));
        Element child = new Element("layout");
        child.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        if (this.wildTransparent) {
            child.setAttribute(WILD_TRANSPARENT, JDomUtility.boolString(this.wildTransparent));
        }
        if (!this.upperCase) {
            child.setAttribute(UPPERCASE, JDomUtility.boolString(this.upperCase));
        }
        if (!this.checkCase) {
            child.setAttribute(CHECK_CASE, JDomUtility.boolString(this.checkCase));
        }
        e.addContent(child);
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        Element child2 = e.getChild("textGrid");
        if (child2 == null) {
            throw new IllegalArgumentException("CrossWord without TextGrid");
        }
        this.tgc = TextGridContent.getTextGridContent(child2);
        for (Element child2 : e.getChildren("cells")) {
            ActiveBagContent bc = ActiveBagContent.getActiveBagContent(child2, this.project.mediaBag);
            String id = JDomUtility.getStringAttr(child2, "id", null, false);
            if (ACROSS_CLUES.equals(id)) {
                this.abc[0] = bc;
                continue;
            }
            if (DOWN_CLUES.equals(id)) {
                this.abc[1] = bc;
                continue;
            }
            throw new IllegalArgumentException("Unknown clues: " + id);
        }
        if (this.abc[0] == null || this.abc[1] == null) {
            throw new IllegalArgumentException("CrossWord without H or V clues!");
        }
        child2 = e.getChild("layout");
        if (child2 != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(child2, "position", LAYOUT_NAMES, this.boxGridPos);
            this.wildTransparent = JDomUtility.getBoolAttr(child2, WILD_TRANSPARENT, this.wildTransparent);
            this.upperCase = JDomUtility.getBoolAttr(child2, UPPERCASE, this.upperCase);
            this.checkCase = JDomUtility.getBoolAttr(child2, CHECK_CASE, this.checkCase);
        }
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.boxGridPos = c3a.graPos;
        this.tgc = new TextGridContent();
        this.tgc.nch = c3a.nctxh;
        this.tgc.ncw = c3a.nctxw;
        this.tgc.w = c3a.txtCW;
        this.tgc.h = c3a.txtCH;
        this.tgc.border = true;
        this.tgc.text = c3a.graTxt;
        this.tgc.bb = c3a.getBoxBase(0);
        for (int k = 0; k < 2; ++k) {
            int i;
            this.abc[k] = new ActiveBagContent(1, 1);
            int l = 0;
            for (i = 0; i < c3a.tags[k].length; ++i) {
                int j = 0;
                StringTokenizer st = new StringTokenizer(c3a.tags[k][i], ";");
                while (st.hasMoreElements()) {
                    ActiveBoxContent bc = this.abc[k].getActiveBoxContent(l++);
                    c3a.setActiveBoxTextContent(bc, st.nextToken());
                    bc.id = i;
                    bc.item = j++;
                }
            }
            this.abc[k].bb = c3a.getBoxBase(1);
            this.abc[k].ncw = 1;
            this.abc[k].nch = i;
            this.abc[k].w = 200.0;
            this.abc[k].h = 75.0;
        }
    }

    @Override
    public int getMinNumActions() {
        return this.tgc == null ? 0 : this.tgc.getNumChars() - this.tgc.countWildChars();
    }

    @Override
    public boolean helpSolutionAllowed() {
        return false;
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    class Panel
    extends Activity.Panel
    implements ActionListener,
    FocusListener {
        TextGrid grid;
        BoxBag bb;
        int advance;
        int numLetters;
        ActiveBox hClue;
        ActiveBox vClue;
        JToggleButton hClueBtn;
        JToggleButton vClueBtn;

        protected Panel(PlayStation ps) {
            super(ps);
            this.grid = null;
            this.bb = null;
            this.advance = 0;
            this.numLetters = 0;
            this.addFocusListener(this);
        }

        @Override
        public void clear() {
            if (this.grid != null) {
                this.grid.end();
                this.grid = null;
            }
            if (this.bb != null) {
                this.bb.end();
                this.bb = null;
            }
        }

        private BoxBag createBoxBag(int n) {
            BoxBag bxb = new BoxBag(null, this, null);
            SimpleBox sb = new SimpleBox(bxb, null, null);
            sb.setBounds(0.0, 0.0, 40.0, CrossWord.this.abc[n].h);
            sb.setBorder(true);
            JToggleButton tgbtn = new JToggleButton(ResourceManager.getImageIcon(n == 0 ? "buttons/textright.png" : "buttons/textdown.png"));
            tgbtn.addActionListener(this);
            Border border = tgbtn.getBorder();
            sb.setHostedComponent(tgbtn);
            tgbtn.setBorder(border);
            bxb.addBox(sb);
            ActiveBox ab = new ActiveBox(bxb, null, n, new Rectangle2D.Double(40.0, 0.0, CrossWord.this.abc[n].w, CrossWord.this.abc[n].h), null);
            bxb.addBox(ab);
            bxb.setBoxBase(CrossWord.this.abc[n].bb);
            if (n == 0) {
                this.hClue = ab;
                this.hClueBtn = tgbtn;
            } else {
                this.vClue = ab;
                this.vClueBtn = tgbtn;
            }
            return bxb;
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (CrossWord.this.acp != null && CrossWord.this.abc != null) {
                CrossWord.this.acp.generateContent(new ActiveBagContentKit(0, 0, CrossWord.this.abc, false), this.ps);
            }
            if (CrossWord.this.tgc != null) {
                this.grid = TextGrid.createEmptyGrid(null, this, CrossWord.this.margin, CrossWord.this.margin, CrossWord.this.tgc, CrossWord.this.wildTransparent);
                this.bb = new BoxBag(null, this, null);
                BoxBag bxbh = this.createBoxBag(0);
                BoxBag bxbv = this.createBoxBag(1);
                if (CrossWord.this.boxGridPos == 2 || CrossWord.this.boxGridPos == 3) {
                    bxbv.setLocation(bxbh.getWidth() + (double)CrossWord.this.margin, 0.0);
                } else {
                    bxbv.setLocation(0.0, bxbh.getHeight() + (double)CrossWord.this.margin);
                }
                this.bb.addBox(bxbh);
                this.bb.addBox(bxbv);
                this.grid.setVisible(true);
                this.bb.setVisible(true);
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.grid != null) {
                this.grid.setChars(CrossWord.this.tgc.text);
                this.numLetters = CrossWord.this.getMinNumActions();
                this.grid.setCellAttributes(true, true);
                this.grid.setCursorEnabled(true);
                this.setCursorAt(0, 0);
                this.advance = 1;
                this.hClueBtn.setSelected(true);
                this.requestFocus();
                this.playing = true;
            }
        }

        public int getCurrentScore() {
            return this.grid == null ? 0 : this.grid.countCoincidences(CrossWord.this.checkCase);
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            if (this.grid != null) {
                this.grid.update(g2, dirtyRegion, this);
            }
            if (this.bb != null) {
                this.bb.update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            if (this.grid == null || this.bb == null || this.getSize().equals(preferredMaxSize)) {
                return preferredMaxSize;
            }
            return BoxBag.layoutDouble(preferredMaxSize, this.grid, this.bb, CrossWord.this.boxGridPos, CrossWord.this.margin);
        }

        @Override
        public void processMouse(MouseEvent e) {
            Point p = e.getPoint();
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.grid.contains(p)) {
                            Point pt = this.grid.getLogicalCoords(p);
                            if (pt == null) break;
                            this.setCursorAt(pt.x, pt.y);
                            break;
                        }
                        if (this.hClue.contains(p)) {
                            this.hClue.playMedia(this.ps);
                            break;
                        }
                        if (!this.vClue.contains(p)) break;
                        this.vClue.playMedia(this.ps);
                    }
                }
            }
        }

        protected void moveCursor(int dx, int dy) {
            if (this.grid != null) {
                this.grid.moveCursor(dx, dy, true);
                this.cursorPosChanged();
            }
        }

        protected void setCursorAt(int x, int y) {
            this.grid.setCursorAt(x, y, true);
            this.cursorPosChanged();
        }

        protected void cursorPosChanged() {
            Point items;
            Point pt = this.grid.getCursor();
            if (pt != null && this.bb != null && (items = this.grid.getItemFor(pt.x, pt.y)) != null) {
                this.hClue.setContent(CrossWord.this.abc[0].getActiveBoxContentWith(pt.y, items.x));
                this.vClue.setContent(CrossWord.this.abc[1].getActiveBoxContentWith(pt.x, items.y));
            }
        }

        @Override
        public void processKey(KeyEvent e) {
            if (this.playing && this.grid != null) {
                switch (e.getID()) {
                    case 400: {
                        Point cur = this.grid.getCursor();
                        char ch = e.getKeyChar();
                        if (ch < '\u0000' || cur == null) break;
                        if (CrossWord.this.upperCase) {
                            ch = Character.toUpperCase(ch);
                        }
                        this.grid.setCharAt(cur.x, cur.y, ch);
                        boolean ok = this.grid.isCellOk(cur.x, cur.y, CrossWord.this.checkCase);
                        int r = this.getCurrentScore();
                        this.ps.reportNewAction(this.getActivity(), "WRITE", String.copyValueOf(new char[]{ch}), "X:" + cur.x + " Y:" + cur.y, ok, r);
                        if (r == this.numLetters) {
                            this.grid.setCursorEnabled(false);
                            this.grid.stopCursorBlink();
                            this.finishActivity(true);
                            break;
                        }
                        this.playEvent(1);
                        if (this.advance == 1) {
                            this.moveCursor(1, 0);
                            break;
                        }
                        if (this.advance != 2) break;
                        this.moveCursor(0, 1);
                        break;
                    }
                    case 401: {
                        int dx = 0;
                        int dy = 0;
                        switch (e.getKeyCode()) {
                            case 39: {
                                dx = 1;
                                break;
                            }
                            case 37: {
                                dx = -1;
                                break;
                            }
                            case 40: {
                                dy = 1;
                                break;
                            }
                            case 38: {
                                dy = -1;
                            }
                        }
                        if (dx == 0 && dy == 0) break;
                        this.moveCursor(dx, dy);
                    }
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.playing && this.grid != null) {
                this.grid.startCursorBlink();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.grid != null) {
                this.grid.stopCursorBlink();
            }
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.advance = 0;
            if (ev.getSource().equals(this.hClueBtn)) {
                if (this.hClueBtn.isSelected()) {
                    this.advance = 1;
                }
                this.vClueBtn.setSelected(false);
            } else if (ev.getSource().equals(this.vClueBtn)) {
                if (this.vClueBtn.isSelected()) {
                    this.advance = 2;
                }
                this.hClueBtn.setSelected(false);
            }
            this.requestFocus();
        }
    }
}

