/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class ActivityBag
implements Editable,
Domable,
MediaBag.Listener {
    protected JClicProject project;
    private List<ActivityBagElement> elements = new ArrayList<ActivityBagElement>(20);
    public static final String ELEMENT_NAME = "activities";

    public ActivityBag(JClicProject project) {
        this.project = project;
    }

    public JClicProject getProject() {
        return this.project;
    }

    public int size() {
        return this.elements.size();
    }

    public ActivityBagElement elementAt(int index) throws ArrayIndexOutOfBoundsException {
        return this.elements.get(index);
    }

    public void insertElementAt(ActivityBagElement el, int index) throws ArrayIndexOutOfBoundsException {
        this.elements.add(index, el);
    }

    public void removeElementAt(int index) throws ArrayIndexOutOfBoundsException {
        this.elements.remove(index);
    }

    public void addElement(ActivityBagElement el) {
        this.elements.add(el);
    }

    public boolean removeElement(ActivityBagElement el) {
        return this.elements.remove(el);
    }

    public int getElementIndex(String name) {
        String s = FileSystem.stdFn(name);
        int result = -1;
        int c = 0;
        Iterator<ActivityBagElement> it = this.elements.iterator();
        while (it.hasNext()) {
            if (it.next().getName().equals(s)) {
                result = c;
                break;
            }
            ++c;
        }
        return result;
    }

    public ActivityBagElement getElementByName(String name) {
        int i = this.getElementIndex(name);
        return i >= 0 ? this.elementAt(i) : null;
    }

    public ActivityBagElement getElement(String name) throws Exception {
        ActivityBagElement abe = this.getElementByName(name);
        if (abe == null && Clic3.isClic3Extension(Clic3.getExt(name))) {
            Clic3.addActivityToBag(this.project, name);
            abe = this.getElementByName(name);
        }
        return abe;
    }

    public boolean activityExists(String name) {
        return this.getElementByName(name) != null;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        for (int i = 0; i < this.size(); ++i) {
            e.addContent(this.elementAt(i).getData().detach());
        }
        return e;
    }

    public void addActivity(Activity act) {
        if (act != null) {
            this.addJDomElement(act.getJDomElement());
        }
    }

    public void addJDomElement(Element e) {
        if (e != null) {
            ActivityBagElement abe = this.getElementByName(e.getAttributeValue("name"));
            if (abe != null) {
                abe.setData(e);
            } else {
                this.addElement(new ActivityBagElement(e));
            }
        }
    }

    public ActivityBagElement[] getElements() {
        return this.elements.toArray(new ActivityBagElement[this.size()]);
    }

    public void sortByName() {
        Collections.sort(this.elements, new Comparator<ActivityBagElement>(){

            @Override
            public int compare(ActivityBagElement o1, ActivityBagElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public void sortByClassAndName() {
        final StringBuilder sb1 = new StringBuilder(200);
        final StringBuilder sb2 = new StringBuilder(200);
        Collections.sort(this.elements, new Comparator<ActivityBagElement>(){

            @Override
            public int compare(ActivityBagElement o1, ActivityBagElement o2) {
                Element e1 = o1.getData();
                Element e2 = o2.getData();
                sb1.setLength(0);
                sb1.append(e1.getAttributeValue("class"));
                sb1.append(e1.getAttributeValue("name"));
                sb2.setLength(0);
                sb2.append(e2.getAttributeValue("class"));
                sb2.append(e2.getAttributeValue("name"));
                return sb1.substring(0).compareTo(sb2.substring(0));
            }
        });
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        List lst = e.getChildren("activity");
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            it.remove();
            this.addJDomElement((Element)child.detach());
        }
    }

    public void removeElementByName(String name) {
        ActivityBagElement abe = this.getElementByName(name);
        if (abe != null) {
            this.removeElement(abe);
        }
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    @Override
    public void listReferencesTo(String name, String type, Map<String, String> map) {
        HashMap dp;
        for (int i = 0; i < this.size(); ++i) {
            ActivityBagElement abe = this.elementAt(i);
            Map<String, String> dp2 = abe.getReferences();
            if (dp2 == null || !dp2.containsKey(name) || type != null && !type.equals(dp2.get(name))) continue;
            map.put(abe.getName(), "activity");
        }
        EventSounds evs = this.project.settings.eventSounds;
        if (evs != null && (dp = evs.getReferences()) != null && dp.containsKey(name) && (type == null || type.equals(dp.get(name)))) {
            map.put("[" + this.project.getBridge().getMsg("edit_project") + "]", "project");
        }
    }

    @Override
    public void listReferences(String type, Map<String, String> map) {
        for (int i = 0; i < this.size(); ++i) {
            Map<String, String> dp;
            ActivityBagElement abe = this.elementAt(i);
            if (type == null || type.equals("activity")) {
                map.put(abe.getName(), "activity");
            }
            if ((dp = abe.getReferences()) == null) continue;
            if (type == null) {
                map.putAll(dp);
                continue;
            }
            for (String key : dp.keySet()) {
                if (!type.equals(dp.get(key))) continue;
                map.put(key, type);
            }
        }
    }
}

