/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.report.SequenceReg;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class ActivitySequence
implements Editable,
Domable {
    private int currentAct;
    private List<ActivitySequenceElement> elements;
    protected JClicProject project;
    public static final String ELEMENT_NAME = "sequence";

    public ActivitySequence(JClicProject project) {
        this.project = project;
        this.elements = new ArrayList<ActivitySequenceElement>(20);
        this.currentAct = -1;
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    public JClicProject getProject() {
        return this.project;
    }

    public void add(ActivitySequenceElement ase) {
        this.elements.add(ase);
        if (this.elements.size() == 1) {
            this.currentAct = 0;
            if (ase.getTag() == null) {
                ase.setTag("start");
            }
        }
    }

    public void insertElementAt(ActivitySequenceElement ase, int index) {
        this.elements.add(index, ase);
    }

    public void remove(ActivitySequenceElement ase) {
        if (this.elements.contains(ase)) {
            if (this.elements.indexOf(ase) == this.currentAct) {
                this.currentAct = -1;
            }
            this.elements.remove(ase);
        }
    }

    public int getSize() {
        return this.elements.size();
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        for (int i = 0; i < this.elements.size(); ++i) {
            e.addContent(this.getElement(i, false).getJDomElement());
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        Iterator it = e.getChildren("item").iterator();
        while (it.hasNext()) {
            this.add(ActivitySequenceElement.getActivitySequenceElement((Element)it.next()));
        }
    }

    public void clear() {
        this.currentAct = -1;
        this.elements.clear();
    }

    public int getElementIndex(ActivitySequenceElement ase) {
        return ase == null ? -1 : this.elements.indexOf(ase);
    }

    public boolean checkAllElements() throws Exception {
        boolean result = true;
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.project.activityBag.getElement(this.getElement(i, false).getActivityName()) != null) continue;
            result = false;
        }
        return result;
    }

    public ActivitySequenceElement getElement(int n, boolean updateCurrentAct) {
        ActivitySequenceElement result;
        try {
            result = this.elements.get(n);
        }
        catch (Exception ex) {
            result = null;
        }
        if (result != null && updateCurrentAct) {
            this.currentAct = n;
        }
        return result;
    }

    public ActivitySequenceElement getElementByTag(String tag, boolean updateCurrentAct) {
        int i;
        int k = this.elements.size();
        if (k < 1 || tag == null) {
            return null;
        }
        String normalizedTag = FileSystem.stdFn(tag);
        ActivitySequenceElement ase = null;
        for (i = 0; !(i >= k || (ase = this.getElement(i, false)) != null && ase.getTag() != null && ase.getTag().equals(normalizedTag)); ++i) {
        }
        if (i == k) {
            ase = null;
        } else if (updateCurrentAct) {
            this.currentAct = i;
        }
        return ase;
    }

    public ActivitySequenceElement[] getElements() {
        return this.elements.toArray(new ActivitySequenceElement[this.elements.size()]);
    }

    public boolean hasNextAct(boolean hasReturn) {
        boolean result = false;
        ActivitySequenceElement ase = this.getCurrentAct();
        if (ase != null) {
            if (ase.fwdJump == null) {
                result = true;
            } else {
                switch (ase.fwdJump.action) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        result = hasReturn;
                        break;
                    }
                    default: {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public boolean hasPrevAct(boolean hasReturn) {
        boolean result = false;
        ActivitySequenceElement ase = this.getCurrentAct();
        if (ase != null) {
            if (ase.backJump == null) {
                result = true;
            } else {
                switch (ase.backJump.action) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        result = hasReturn;
                        break;
                    }
                    default: {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public int getNavButtonsFlag() {
        int flag = 0;
        ActivitySequenceElement ase = this.getCurrentAct();
        if (ase != null) {
            flag = ase.navButtons;
        }
        return flag;
    }

    public JumpInfo getJump(boolean back, Reporter rep) {
        JumpInfo result = null;
        ActivitySequenceElement ase = this.getCurrentAct();
        if (ase != null) {
            ActivitySequenceJump asj;
            ActivitySequenceJump activitySequenceJump = asj = back ? ase.backJump : ase.fwdJump;
            if (asj == null) {
                int i = this.currentAct + (back ? -1 : 1);
                if (i >= this.elements.size() || i < 0) {
                    i = 0;
                }
                result = new JumpInfo(0, i);
            } else {
                SequenceReg.Info info;
                int rating = -1;
                int time = -1;
                if (rep != null && (info = rep.getCurrentSequenceInfo()) != null) {
                    rating = (int)info.tScore;
                    time = (int)(info.tTime / 1000L);
                }
                result = asj.resolveJump(rating, time);
            }
        }
        return result;
    }

    public ActivitySequenceElement getCurrentAct() {
        return this.getElement(this.currentAct, false);
    }

    public int getCurrentActNum() {
        return this.currentAct;
    }

    public String getSequenceForElement(int e) {
        String s = null;
        if (e >= 0 && e < this.elements.size()) {
            for (int i = e; i >= 0 && (s = this.getElement(i, false).getTag()) == null; --i) {
            }
        }
        return s;
    }

    public ActivitySequenceElement getElementByActivityName(String activityName) {
        ActivitySequenceElement result = null;
        if (activityName != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ActivitySequenceElement ase = this.getElement(i, false);
                if (!ase.getActivityName().equalsIgnoreCase(activityName)) continue;
                result = ase;
                break;
            }
        }
        return result;
    }

    public boolean checkCurrentActivity(String name) {
        ActivitySequenceElement ase = this.getCurrentAct();
        if (ase == null || !ase.getActivityName().equalsIgnoreCase(name)) {
            for (int i = 0; i < this.elements.size(); ++i) {
                if (!this.getElement(i, false).getActivityName().equalsIgnoreCase(name)) continue;
                this.currentAct = i;
                return false;
            }
            ase = new ActivitySequenceElement(name, 0, 3);
            ase.fwdJump = new ActivitySequenceJump(1);
            ase.backJump = new ActivitySequenceJump(1);
            this.elements.add(ase);
            this.currentAct = this.elements.size() - 1;
            return false;
        }
        return true;
    }

    public void listReferences(String type, Map<String, String> map) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.getElement(i, false).listReferences(type, map);
        }
    }
}

