/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.StrUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class ActiveBoxGrid
extends ActiveBoxBag
implements Cloneable {
    public int nCols;
    public int nRows;

    public ActiveBoxGrid(AbstractBox parent, JComponent container, double px, double py, double setWidth, double setHeight, Shaper sh, BoxBase boxBase) {
        super(parent, container, boxBase);
        this.nCols = sh.getNumColumns();
        this.nRows = sh.getNumRows();
        Rectangle r = new Rectangle((int)px, (int)py, (int)(setWidth / (double)this.nCols) * this.nCols, (int)(setHeight / (double)this.nRows) * this.nRows);
        this.ensureCapacity(sh.getNumCells());
        for (int i = 0; i < sh.getNumCells(); ++i) {
            Shape tmpSh = sh.getShape(i, r);
            ActiveBox bx = new ActiveBox(this, null, i, tmpSh.getBounds2D(), null);
            if (!sh.rectangularShapes()) {
                bx.setShape(tmpSh);
            }
            this.addActiveBox(bx);
        }
        if (sh.hasRemainder()) {
            Shape tmpSh = sh.getRemainderShape(r);
            ActiveBox bx = new ActiveBox(this, null, 0, tmpSh.getBounds2D(), null);
            bx.setShape(tmpSh);
            this.setBackgroundBox(bx);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10 * this.nCols, 10 * this.nRows);
    }

    @Override
    public Dimension getScaledSize(double scale) {
        return new Dimension(StrUtils.roundTo(scale * this.preferredBounds.getWidth(), this.nCols), StrUtils.roundTo(scale * this.preferredBounds.getHeight(), this.nRows));
    }

    public static ActiveBoxGrid createEmptyGrid(AbstractBox parent, JComponent container, double px, double py, ActiveBagContent abc, Shaper sh, BoxBase boxBase) {
        ActiveBoxGrid result = null;
        if (abc != null) {
            result = new ActiveBoxGrid(parent, container, px, py, abc.getTotalWidth(), abc.getTotalHeight(), sh == null ? abc.getShaper() : sh, boxBase == null ? abc.bb : boxBase);
            result.setBorder(abc.border);
        }
        return result;
    }

    public static ActiveBoxGrid createEmptyGrid(ActiveBox parent, JComponent container, double px, double py, ActiveBagContent abc) {
        return ActiveBoxGrid.createEmptyGrid(parent, container, px, py, abc, null, null);
    }

    public Point getCoord(ActiveBox bx) {
        int py = bx.idLoc / this.nCols;
        int px = bx.idLoc % this.nCols;
        return new Point(px, py);
    }

    public Point getCoordDist(ActiveBox src, ActiveBox dest) {
        Point ptSrc = this.getCoord(src);
        Point ptDest = this.getCoord(dest);
        return new Point(ptDest.x - ptSrc.x, ptDest.y - ptSrc.y);
    }
}

