/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.Resizable;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import javax.swing.JComponent;

public class BoxBag
extends AbstractBox
implements Cloneable,
Resizable {
    protected ArrayList<AbstractBox> cells = new ArrayList(12);
    protected Rectangle2D preferredBounds = new Rectangle2D.Double();
    protected AbstractBox backgroundBox = null;

    public BoxBag(AbstractBox parent, JComponent container, BoxBase boxBase) {
        super(parent, container, boxBase);
        this.preferredBounds.setRect(this.getBounds());
    }

    @Override
    public Object clone() {
        BoxBag dBB = (BoxBag)super.clone();
        dBB.preferredBounds = (Rectangle2D)this.preferredBounds.clone();
        dBB.cells = new ArrayList();
        for (int i = 0; i < this.cells.size(); ++i) {
            dBB.cells.add((AbstractBox)this.getBox(i).clone());
        }
        if (this.backgroundBox != null) {
            dBB.backgroundBox = (AbstractBox)this.backgroundBox.clone();
            dBB.backgroundBox.setParent(dBB);
        }
        return dBB;
    }

    @Override
    public void setContainer(JComponent newContainer) {
        super.setContainer(newContainer);
    }

    @Override
    public void end() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).end();
        }
        if (this.backgroundBox != null) {
            this.backgroundBox.end();
            this.backgroundBox = null;
        }
        this.cells.clear();
        super.end();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredBounds.getBounds().getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = this.getPreferredSize();
        return new Dimension(Math.max(10, d.width), Math.max(10, d.height));
    }

    @Override
    public Dimension getScaledSize(double scale) {
        Dimension d = this.getPreferredSize();
        return new Dimension((int)(scale * (double)d.width), (int)(scale * (double)d.height));
    }

    public void ensureCapacity(int n) {
        this.cells.ensureCapacity(n);
    }

    public void addBox(AbstractBox bx) {
        this.cells.add(bx);
        bx.setParent(this);
        if (this.cells.size() == 1) {
            super.setBounds(bx);
        } else {
            this.add(bx);
        }
        this.preferredBounds.setRect(this.getBounds());
    }

    public int boxIndex(Object bx) {
        return bx == null ? -1 : this.cells.indexOf(bx);
    }

    public AbstractBox getBox(int id) {
        return id < 0 || id >= this.cells.size() ? null : this.cells.get(id);
    }

    public AbstractBox getBackgroundBox() {
        return this.backgroundBox;
    }

    public void setBackgroundBox(AbstractBox bx) {
        this.backgroundBox = bx;
        if (this.backgroundBox != null) {
            this.add(this.backgroundBox);
            this.backgroundBox.setParent(this);
        }
        this.preferredBounds.setRect(this.getBounds());
    }

    public void recalcSize() {
        Rectangle2D.Double r = new Rectangle2D.Double(this.x, this.y, 0.0, 0.0);
        if (this.backgroundBox != null) {
            r.add(this.backgroundBox);
        }
        for (int i = 0; i < this.cells.size(); ++i) {
            r.add(this.cells.get(i));
        }
        this.preferredBounds.setRect(r);
        this.x = ((RectangularShape)r).getX();
        this.y = ((RectangularShape)r).getY();
        this.width = ((RectangularShape)r).getWidth();
        this.height = ((RectangularShape)r).getHeight();
    }

    public int getNumCells() {
        return this.cells.size();
    }

    @Override
    public void setBorder(boolean newVal) {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).setBorder(newVal);
        }
    }

    @Override
    public void setVisible(boolean newVal) {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).setVisible(newVal);
        }
    }

    @Override
    public void setAlternative(boolean newVal) {
        super.setAlternative(newVal);
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).setAlternative(newVal);
        }
    }

    @Override
    public void setBoxBase(BoxBase setBb) {
        super.setBoxBase(setBb);
    }

    @Override
    public void setBounds(Rectangle2D r) {
        if (!r.isEmpty() && !r.equals(this)) {
            double scaleW = r.getWidth() / this.width;
            double scaleH = r.getHeight() / this.height;
            double dx = r.getX() - this.x;
            double dy = r.getY() - this.y;
            for (int i = 0; i < this.cells.size(); ++i) {
                AbstractBox bx = this.getBox(i);
                Point2D.Double p = new Point2D.Double(bx.x - this.x, bx.y - this.y);
                bx.setBounds(dx + this.x + scaleW * p.x, dy + this.y + scaleH * p.y, scaleW * bx.width, scaleH * bx.height);
            }
            if (this.backgroundBox != null) {
                AbstractBox bx = this.backgroundBox;
                Point2D.Double p = new Point2D.Double(bx.x - this.x, bx.y - this.y);
                bx.setBounds(dx + this.x + scaleW * p.x, dy + this.y + scaleH * p.y, scaleW * bx.width, scaleH * bx.height);
            }
        }
        super.setBounds(r);
    }

    @Override
    public boolean update(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        AbstractBox bx;
        int i;
        if (this.isEmpty() || !this.isVisible() || this.isTemporaryHidden()) {
            return false;
        }
        if (!this.intersects(dirtyRegion)) {
            return false;
        }
        if (this.backgroundBox != null) {
            this.backgroundBox.update(g2, dirtyRegion, io);
        }
        for (i = 0; i < this.cells.size(); ++i) {
            bx = this.getBox(i);
            if (bx.isMarked()) continue;
            bx.update(g2, dirtyRegion, io);
        }
        for (i = 0; i < this.cells.size(); ++i) {
            bx = this.getBox(i);
            if (!bx.isMarked()) continue;
            bx.update(g2, dirtyRegion, io);
        }
        return true;
    }

    @Override
    public boolean updateContent(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        return true;
    }

    public AbstractBox findBox(Point2D p) {
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            AbstractBox bx = this.getBox(i);
            if (!bx.isVisible() || !bx.contains(p)) continue;
            return bx;
        }
        return null;
    }

    public int countInactiveCells() {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getBox(i).isInactive()) continue;
            ++n;
        }
        return n;
    }

    public static Dimension layoutSingle(Dimension preferredMaxSize, Resizable rs, int margin) {
        if (rs == null) {
            return preferredMaxSize;
        }
        Dimension d = rs.getPreferredSize();
        Dimension minSize = rs.getMinimumSize();
        Dimension maxSize = preferredMaxSize;
        maxSize.width -= 2 * margin;
        maxSize.height -= 2 * margin;
        if (minSize.width > maxSize.width || minSize.height > maxSize.height) {
            maxSize = minSize;
        }
        double scale = 1.0;
        if (d.width > maxSize.width) {
            scale = (double)maxSize.width / (double)d.width;
        }
        if (scale * (double)d.height > (double)maxSize.height) {
            scale = (double)maxSize.height / (double)d.height;
        }
        d = rs.getScaledSize(scale);
        rs.setBounds(margin, margin, d.width, d.height);
        d.width += 2 * margin;
        d.height += 2 * margin;
        return d;
    }

    public static Dimension layoutDouble(Dimension desiredMaxSize, Resizable rsA, Resizable rsB, int boxGridPos, int margin) {
        boolean isHLayout = false;
        int nbh = 1;
        int nbv = 1;
        switch (boxGridPos) {
            case 0: 
            case 1: {
                nbh = 2;
                nbv = 1;
                isHLayout = true;
                break;
            }
            case 2: 
            case 3: {
                nbh = 1;
                nbv = 2;
                isHLayout = false;
            }
        }
        Rectangle2D ra = rsA.getBounds2D();
        Rectangle2D rb = rsB.getBounds2D();
        Dimension da = rsA.getPreferredSize();
        Dimension db = rsB.getPreferredSize();
        Dimension d = new Dimension(isHLayout ? da.width + db.width : Math.max(da.width, db.width), isHLayout ? Math.max(da.height, db.height) : da.height + db.height);
        Dimension minSizeA = rsA.getMinimumSize();
        Dimension minSizeB = rsB.getMinimumSize();
        Dimension minSize = new Dimension(isHLayout ? minSizeA.width + minSizeB.width : Math.max(minSizeA.width, minSizeB.width), isHLayout ? Math.max(minSizeA.height, minSizeB.height) : minSizeA.height + minSizeB.height);
        Dimension maxSize = desiredMaxSize;
        maxSize.width -= (1 + nbh) * margin;
        maxSize.height -= (1 + nbv) * margin;
        if (minSize.width > maxSize.width || minSize.height > maxSize.height) {
            maxSize.setSize(minSize);
        }
        double scale = 1.0;
        if (d.width > maxSize.width) {
            scale = (double)maxSize.width / (double)d.width;
        }
        if (scale * (double)d.height > (double)maxSize.height) {
            scale = (double)maxSize.height / (double)d.height;
        }
        da = rsA.getScaledSize(scale);
        db = rsB.getScaledSize(scale);
        int dah = db.width > da.width ? (db.width - da.width) / 2 : 0;
        int dbh = da.width > db.width ? (da.width - db.width) / 2 : 0;
        int dav = db.height > da.height ? (db.height - da.height) / 2 : 0;
        int dbv = da.height > db.height ? (da.height - db.height) / 2 : 0;
        switch (boxGridPos) {
            case 0: {
                rsA.setBounds(margin, margin + dav, da.width, da.height);
                rsB.setBounds(2 * margin + da.width, margin + dbv, db.width, db.height);
                break;
            }
            case 1: {
                rsB.setBounds(margin, margin + dbv, db.width, db.height);
                rsA.setBounds(2 * margin + db.width, margin + dav, da.width, da.height);
                break;
            }
            case 2: {
                rsA.setBounds(margin + dah, margin, da.width, da.height);
                rsB.setBounds(margin + dbh, 2 * margin + da.height, db.width, db.height);
                break;
            }
            case 3: {
                rsB.setBounds(margin + dbh, margin, db.width, db.height);
                rsA.setBounds(margin + dah, 2 * margin + db.height, da.width, da.height);
                break;
            }
            default: {
                rsA.setBounds((int)((double)margin + scale * ra.getX()), (int)((double)margin + scale * ra.getY()), da.width, da.height);
                rsB.setBounds((int)((double)margin + scale * rb.getX()), (int)((double)margin + scale * rb.getY()), da.width, da.height);
            }
        }
        Rectangle r = new Rectangle(rsA.getBounds());
        r.add(rsB.getBounds());
        d.width = r.width + 2 * margin;
        d.height = r.height + 2 * margin;
        return d;
    }
}

