/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.util.Options;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;

public class BoxConnector {
    public static final float LINE_WIDTH = 1.5f;
    public static final BasicStroke BASIC_STROKE = new BasicStroke(1.5f);
    public static final Color DEFAULT_LINE_COLOR = Color.black;
    public static final Color DEFAULT_XOR_COLOR = Color.white;
    public static final double ARROW_ANGLE = 0.5235987755982988;
    public static final double ARROW_L = 10.0;
    public static boolean USE_XOR = true;
    public static boolean GROW_BUG = false;
    public Point2D origin;
    public Point2D dest;
    public boolean arrow;
    public boolean active = false;
    public boolean linePainted = false;
    public double arrow_l = 10.0;
    public double arrow_angle = 0.5235987755982988;
    public Color lineColor = DEFAULT_LINE_COLOR;
    public Color xorColor = DEFAULT_XOR_COLOR;
    Point2D relativePos;
    ActiveBox bx;
    JComponent parent;
    public float line_width = 1.5f;

    public BoxConnector(JComponent setParent) {
        this.parent = setParent;
        this.origin = new Point2D.Double();
        this.dest = new Point2D.Double();
        this.arrow = false;
        this.active = false;
        this.linePainted = false;
        this.relativePos = new Point2D.Double();
    }

    public boolean update(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        if (!this.active) {
            return false;
        }
        if (this.bx != null) {
            this.bx.setTemporaryHidden(false);
            this.bx.update(g2, dirtyRegion, io);
            this.bx.setTemporaryHidden(true);
        } else {
            this.drawLine(g2);
            this.linePainted = true;
        }
        return true;
    }

    public void drawLine(Graphics2D g2) {
        if (this.active) {
            BoxConnector.drawLine(g2, this.origin, this.dest, this.arrow, this.lineColor, this.xorColor, this.arrow_l, this.arrow_angle, this.line_width);
        }
    }

    public void moveBy(double dx, double dy) {
        this.moveTo(new Point2D.Double(this.dest.getX() + dx, this.dest.getY() + dy));
    }

    public void moveTo(Point2D p) {
        this.moveTo(p, false);
    }

    public void moveTo(Point2D p, boolean forcePaint) {
        Rectangle clipRect;
        if (!this.active || !forcePaint && this.dest.equals(p)) {
            return;
        }
        if (this.bx != null) {
            clipRect = new Rectangle((int)(p.getX() - this.relativePos.getX()), (int)(p.getY() - this.relativePos.getY()), (int)this.bx.width, (int)this.bx.height);
            clipRect.add(this.bx);
            this.bx.setLocation(new Point2D.Double(p.getX() - this.relativePos.getX(), p.getY() - this.relativePos.getY()));
        } else if (forcePaint || !USE_XOR) {
            clipRect = new Rectangle((int)this.origin.getX(), (int)this.origin.getY(), 0, 0);
            clipRect.add(p);
            clipRect.add(this.dest);
            this.dest.setLocation(p);
        } else {
            Graphics2D g2 = (Graphics2D)this.parent.getGraphics();
            if (this.linePainted) {
                this.drawLine(g2);
            }
            this.dest.setLocation(p);
            this.drawLine(g2);
            this.linePainted = true;
            return;
        }
        BoxConnector.growRect(clipRect, this.arrow ? (int)this.arrow_l : 1, this.arrow ? (int)this.arrow_l : 1);
        this.parent.repaint(clipRect);
    }

    public void begin(Point2D p) {
        if (this.active) {
            this.end();
        }
        this.origin.setLocation(p);
        this.dest.setLocation(p);
        this.linePainted = false;
        this.active = true;
        this.parent.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void begin(Point2D p, ActiveBox setBox) {
        this.begin(p);
        this.bx = setBox;
        this.relativePos.setLocation(p.getX() - this.bx.x, p.getY() - this.bx.y);
        this.bx.setTemporaryHidden(true);
        Rectangle r = new Rectangle(this.bx.getBounds());
        BoxConnector.growRect(r, 1, 1);
        this.linePainted = false;
        this.parent.repaint(r);
    }

    public ActiveBox getBox() {
        return this.bx;
    }

    public void end() {
        if (!this.active) {
            return;
        }
        if (this.bx != null) {
            Rectangle r = new Rectangle(this.bx.getBounds());
            BoxConnector.growRect(r, 1, 1);
            this.parent.repaint(r);
            this.bx.setLocation(this.origin.getX() - this.relativePos.getX(), this.origin.getY() - this.relativePos.getY());
            this.bx.setTemporaryHidden(false);
            r.setBounds(this.bx.getBounds());
            BoxConnector.growRect(r, 1, 1);
            this.parent.repaint(r);
            this.bx = null;
            this.relativePos.setLocation(0.0, 0.0);
        } else {
            this.moveTo(this.dest, true);
        }
        this.active = false;
        this.linePainted = false;
        this.parent.setCursor(null);
    }

    public static void drawLine(Graphics2D g2, Point2D origin, Point2D dest, boolean arrow) {
        BoxConnector.drawLine(g2, origin, dest, arrow, DEFAULT_LINE_COLOR, DEFAULT_XOR_COLOR, 10.0, 0.5235987755982988, 1.5f);
    }

    public static void drawLine(Graphics2D g2, Point2D origin, Point2D dest, boolean arrow, Color color, Color xorColor, double arrow_l, double arrowAngle, float strokeWidth) {
        Stroke oldStroke = g2.getStroke();
        Object oldStrokeHint = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        g2.setColor(color);
        if (USE_XOR && xorColor != null) {
            g2.setXORMode(xorColor);
        }
        g2.setStroke(strokeWidth == 1.5f ? BASIC_STROKE : new BasicStroke(strokeWidth));
        g2.drawLine((int)origin.getX(), (int)origin.getY(), (int)dest.getX(), (int)dest.getY());
        if (arrow) {
            double beta = Math.atan2(origin.getY() - dest.getY(), dest.getX() - origin.getX());
            Point2D.Double arp = new Point2D.Double(dest.getX() - arrow_l * Math.cos(beta + arrowAngle), dest.getY() + arrow_l * Math.sin(beta + arrowAngle));
            g2.drawLine((int)dest.getX(), (int)dest.getY(), (int)((Point2D)arp).getX(), (int)((Point2D)arp).getY());
            ((Point2D)arp).setLocation(dest.getX() - arrow_l * Math.cos(beta - arrowAngle), dest.getY() + arrow_l * Math.sin(beta - arrowAngle));
            g2.drawLine((int)dest.getX(), (int)dest.getY(), (int)((Point2D)arp).getX(), (int)((Point2D)arp).getY());
        }
        if (USE_XOR && xorColor != null) {
            g2.setPaintMode();
        }
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeHint);
    }

    public static void checkOptions(Options options) {
        if (options.getBoolean("java141") && options.getBoolean("Mac")) {
            USE_XOR = false;
        }
    }

    public static void growRect(Rectangle r, int h, int w) {
        if (GROW_BUG) {
            r.x -= w;
            r.width += 2 * w;
            r.y -= h;
            r.height += 2 * h;
        } else {
            r.grow(h, w);
        }
    }

    public static Color getXORColor(Color src) {
        return BoxConnector.getXORColor(src, Color.white);
    }

    public static Color getXORColor(Color src, Color against) {
        return new Color(src.getRGB() ^ against.getRGB());
    }
}

