/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.edit;

import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class EditorAction
extends AbstractAction {
    ActionEvent ev;
    Editor editor;
    public Options options;

    public EditorAction(String nameKey, String iconKey, String toolTipKey, Options options) {
        super(options.getMsg(nameKey), ResourceManager.getImageIcon(iconKey));
        String s;
        this.options = options;
        if (toolTipKey != null) {
            this.putValue("ShortDescription", options.getMsg(toolTipKey));
        }
        if ((s = options.getMessages().get(nameKey + "_keys")) != null && s.length() >= 2 && !s.startsWith(nameKey)) {
            this.putValue("MnemonicKey", new Integer(s.charAt(0)));
            if (s.charAt(1) != '*') {
                int ch;
                int key = ch = s.charAt(1);
                int keyMod = 2;
                if (ch == 35 && s.length() > 2) {
                    try {
                        String k;
                        int sep = s.indexOf(35, 2);
                        if (sep > 0) {
                            keyMod = Integer.parseInt(s.substring(sep + 1));
                            k = s.substring(2, sep);
                        } else {
                            k = s.substring(2);
                        }
                        key = Integer.parseInt(k);
                    }
                    catch (Exception ex) {
                        System.err.println("Error initializing action keys\nBad expression: " + s);
                    }
                }
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key, keyMod));
            }
        }
        this.setEnabled(false);
    }

    @Override
    public final void actionPerformed(ActionEvent ev) {
        this.ev = ev;
        if (this.editor != null) {
            this.doAction(this.editor);
        }
    }

    protected abstract void doAction(Editor var1);

    protected Component getComponentSrc() {
        Component result = null;
        if (this.ev != null && this.ev.getSource() instanceof Component) {
            result = (Component)this.ev.getSource();
        }
        return result;
    }

    protected JComponent getJComponentSrc() {
        JComponent result = null;
        if (this.ev != null && this.ev.getSource() instanceof JComponent) {
            result = (JComponent)this.ev.getSource();
        }
        return result;
    }

    protected EditorPanel getEditorPanelSrc() {
        Component cmp;
        for (cmp = this.getComponentSrc(); cmp != null && !(cmp instanceof EditorPanel); cmp = cmp.getParent()) {
        }
        return (EditorPanel)cmp;
    }

    public void setActionOwner(Editor e) {
        this.editor = e;
        this.setEnabled(this.editor != null);
    }
}

